/*
 * Decompiled with CFR 0.152.
 */
package egovframework.bdev.imp.batch.wizards.com;

import egovframework.bdev.imp.batch.common.BatchMessages;
import egovframework.bdev.imp.batch.wizards.com.BatchJobContext;
import egovframework.bdev.imp.batch.wizards.com.SelectProjectTreeTableContentProvider;
import egovframework.bdev.imp.ide.com.natures.EgovBatchNature;
import egovframework.dev.imp.core.utils.EgovJavaElementUtil;
import egovframework.dev.imp.core.utils.NullUtil;
import egovframework.dev.imp.core.utils.StringUtil;
import java.util.ArrayList;
import org.eclipse.core.internal.resources.Folder;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.NewFolderDialog;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.part.DrillDownComposite;

public class BatchJobSelectProjectPage
extends WizardPage {
    BatchJobContext context = null;
    TreeViewer treeViewer = null;
    private Text containerNameField = null;
    private Label aboveContainerNameLabel = null;
    private Text fileNameField = null;
    private Label fileNameLabel = null;
    private String noteContent = null;
    private ArrayList<IProject> eGovProjects = null;
    private String defaultFileName = null;
    private IStructuredSelection selection = null;
    private Button createNewFolderButton = null;
    Listener validation = new Listener(){

        public void handleEvent(Event event) {
            IProject project = null;
            boolean canFlipToNextPage = false;
            String[] containerClassName = BatchJobSelectProjectPage.this.containerNameField.getText().split("/", 2);
            int i = 0;
            while (i < BatchJobSelectProjectPage.this.eGovProjects.size()) {
                project = (IProject)BatchJobSelectProjectPage.this.eGovProjects.get(i);
                if (project.getName().equals(containerClassName[0])) {
                    if (containerClassName.length == 2) {
                        if (!NullUtil.isNull((Object)project.findMember(containerClassName[1]))) {
                            canFlipToNextPage = true;
                            BatchJobSelectProjectPage.this.context.setProject((Project)project);
                            BatchJobSelectProjectPage.this.context.setFilePath(BatchJobSelectProjectPage.this.containerNameField.getText());
                            break;
                        }
                    } else {
                        canFlipToNextPage = true;
                        BatchJobSelectProjectPage.this.context.setProject((Project)project);
                        BatchJobSelectProjectPage.this.context.setFilePath(BatchJobSelectProjectPage.this.containerNameField.getText());
                        break;
                    }
                }
                ++i;
            }
            if (!canFlipToNextPage) {
                BatchJobSelectProjectPage.this.setErrorMessage(BatchMessages.BatchJobSelectProjectPage_EMPTY_PROJECT_NAME);
                return;
            }
            if (BatchJobSelectProjectPage.this.fileNameField.getText().length() < 1) {
                BatchJobSelectProjectPage.this.setErrorMessage(BatchMessages.BatchJobSelectProjectPage_EMPTY_FILE_NAME);
                return;
            }
            if (project != null && containerClassName.length == 1) {
                if (project.findMember(BatchJobSelectProjectPage.this.fileNameField.getText()) != null) {
                    BatchJobSelectProjectPage.this.setErrorMessage(BatchMessages.BatchJobSelectProjectPage_DUPLICATE_FILE_NAME);
                    canFlipToNextPage = false;
                }
            } else if (project != null && containerClassName.length == 2 && project.findMember(String.valueOf(containerClassName[1]) + "/" + BatchJobSelectProjectPage.this.fileNameField.getText()) != null) {
                BatchJobSelectProjectPage.this.setErrorMessage(BatchMessages.BatchJobSelectProjectPage_DUPLICATE_FILE_NAME);
                canFlipToNextPage = false;
            }
            if (!BatchJobSelectProjectPage.this.validateFileName(BatchJobSelectProjectPage.this.fileNameField.getText())) {
                BatchJobSelectProjectPage.this.setErrorMessage(BatchMessages.BatchJobSelectProjectPage_INVALID_FILE_NAME);
                canFlipToNextPage = false;
            }
            BatchJobSelectProjectPage.this.setPageComplete(canFlipToNextPage);
            if (canFlipToNextPage) {
                BatchJobSelectProjectPage.this.setErrorMessage(null);
            }
        }
    };

    public void setDefaultFileName(String defaultFileName) {
        this.defaultFileName = defaultFileName;
    }

    public void setNoteContent(String noteContent) {
        this.noteContent = noteContent;
    }

    public BatchJobContext getContext() {
        return this.context;
    }

    public BatchJobSelectProjectPage(String pageName, BatchJobContext context, ISelection selection) {
        super(pageName);
        this.selection = (IStructuredSelection)selection;
        this.context = context;
        this.eGovProjects = this.getEgovProjectList();
    }

    private ArrayList<IProject> getEgovProjectList() {
        IProject[] allProjects;
        ArrayList<IProject> eGovProjects = new ArrayList<IProject>();
        IProject[] iProjectArray = allProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = allProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            try {
                if (EgovJavaElementUtil.isJavaProject((IProject)project) && EgovBatchNature.isEgovNatureEnabled((IProject)project)) {
                    eGovProjects.add(project);
                }
            }
            catch (CoreException e) {
                e.getStackTrace();
            }
            ++n2;
        }
        return eGovProjects;
    }

    public void createControl(Composite parent) {
        Composite control = new Composite(parent, 0);
        control.setLayout((Layout)new GridLayout());
        control.setLayoutData((Object)new GridData(1808));
        this.createContainerNameControl(control);
        this.createTreeTableViewer(control);
        this.createNewFolderButton(control);
        this.createFileNameControl(control);
        this.createNoteControl(control);
    }

    private void createContainerNameControl(Composite control) {
        this.aboveContainerNameLabel = new Label(control, 0);
        this.aboveContainerNameLabel.setText(BatchMessages.BatchJobSelectProjectPage_ABOVE_CONTAINER_NAME_LABEL);
        this.containerNameField = new Text(control, 2048);
        this.containerNameField.setLayoutData((Object)new GridData(768));
        this.containerNameField.addListener(24, this.validation);
    }

    private void createTreeTableViewer(Composite control) {
        DrillDownComposite drillDown = new DrillDownComposite(control, 2048);
        GridData spec = new GridData(4, 4, true, true);
        spec.widthHint = 320;
        spec.heightHint = 300;
        drillDown.setLayoutData((Object)spec);
        ILabelProvider labelProvider = WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider();
        SelectProjectTreeTableContentProvider contentsProvider = new SelectProjectTreeTableContentProvider();
        this.treeViewer = new TreeViewer((Composite)drillDown, 0);
        drillDown.setChildTree(this.treeViewer);
        this.treeViewer.setContentProvider((IContentProvider)contentsProvider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.treeViewer.setComparator(new ViewerComparator());
        this.treeViewer.setUseHashlookup(true);
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                BatchJobSelectProjectPage.this.containerSelectionChanged((IContainer)selection.getFirstElement());
            }
        });
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection) {
                    Object item = ((IStructuredSelection)selection).getFirstElement();
                    if (item == null) {
                        return;
                    }
                    if (BatchJobSelectProjectPage.this.treeViewer.getExpandedState(item)) {
                        BatchJobSelectProjectPage.this.treeViewer.collapseToLevel(item, 1);
                    } else {
                        BatchJobSelectProjectPage.this.treeViewer.expandToLevel(item, 1);
                    }
                }
            }
        });
        this.treeViewer.setInput((Object)this.eGovProjects.toArray(new IProject[0]));
    }

    private void createNewFolderButton(Composite control) {
        this.createNewFolderButton = new Button(control, 8);
        this.createNewFolderButton.setText(BatchMessages.BatchJobSelectProjectPage_NEW_FOLDER_BUTTON);
        this.createNewFolderButton.setEnabled(false);
        this.createNewFolderButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                IStructuredSelection selection = (IStructuredSelection)BatchJobSelectProjectPage.this.treeViewer.getSelection();
                if (!selection.isEmpty()) {
                    IContainer selectResource = (IContainer)selection.getFirstElement();
                    NewFolderDialog dialog = new NewFolderDialog(BatchJobSelectProjectPage.this.getShell(), selectResource);
                    if (dialog.open() == 0) {
                        BatchJobSelectProjectPage.this.eGovProjects = BatchJobSelectProjectPage.this.getEgovProjectList();
                        BatchJobSelectProjectPage.this.treeViewer.setInput((Object)BatchJobSelectProjectPage.this.eGovProjects.toArray(new IProject[0]));
                        BatchJobSelectProjectPage.this.treeViewer.setSelection((ISelection)new StructuredSelection(dialog.getFirstResult()));
                    }
                }
            }
        });
    }

    private void createFileNameControl(Composite control) {
        Composite fileNameControl = new Composite(control, 0);
        fileNameControl.setLayout((Layout)new GridLayout(2, false));
        fileNameControl.setLayoutData((Object)new GridData(768));
        this.fileNameLabel = new Label(fileNameControl, 0);
        this.fileNameLabel.setText(BatchMessages.BatchJobSelectProjectPage_FILE_NAME_LABEL);
        this.fileNameField = new Text(fileNameControl, 2048);
        this.fileNameField.setLayoutData((Object)new GridData(768));
        this.fileNameField.addListener(2, this.validation);
        this.fileNameField.setText(this.defaultFileName);
        this.fileNameField.setFocus();
        this.fileNameField.selectAll();
        this.fileNameField.addListener(16, new Listener(){

            public void handleEvent(Event event) {
                if (BatchJobSelectProjectPage.this.fileNameField.getText().length() == 0) {
                    BatchJobSelectProjectPage.this.fileNameField.setText(BatchJobSelectProjectPage.this.defaultFileName);
                }
                BatchJobSelectProjectPage.this.context.setFileName(BatchJobSelectProjectPage.this.fileNameField.getText());
            }
        });
    }

    private void createNoteControl(Composite control) {
        Composite noteControl = new Composite(control, 0);
        noteControl.setLayout((Layout)new GridLayout(2, false));
        noteControl.setLayoutData((Object)new GridData());
        Label noteNameLabel = new Label(noteControl, 129);
        noteNameLabel.setText(BatchMessages.BatchJobSelectProjectPage_NOTE_HEAD);
        StringUtil.setLabelStringBold((Label)noteNameLabel);
        Label noteContentLabel = new Label(noteControl, 129);
        noteContentLabel.setText(this.noteContent);
        this.setPageComplete(false);
        this.setControl((Control)control);
    }

    private void containerSelectionChanged(IContainer container) {
        if (container == null) {
            this.containerNameField.setText("");
        } else {
            String text = TextProcessor.process((String)container.getFullPath().makeRelative().toString());
            this.containerNameField.setText(text);
            this.containerNameField.setToolTipText(text);
            if (this.isPathIncludeResourceFolder(text)) {
                this.createNewFolderButton.setEnabled(true);
            } else {
                this.createNewFolderButton.setEnabled(false);
            }
        }
    }

    private boolean isPathIncludeResourceFolder(String selectedPath) {
        Object[] splitedFolderPaths = this.getFoldersListFromPath(selectedPath);
        if (!NullUtil.isEmpty((Object[])splitedFolderPaths)) {
            Object[] objectArray = splitedFolderPaths;
            int n = splitedFolderPaths.length;
            int n2 = 0;
            while (n2 < n) {
                Object folder = objectArray[n2];
                if ("resources".equals(folder)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private String[] getFoldersListFromPath(String selectedPath) {
        String[] splitedPath = selectedPath.split("/", 2);
        if (splitedPath.length > 1) {
            String folderPath = splitedPath[1];
            return folderPath.split("/");
        }
        return new String[0];
    }

    private boolean validateFileName(String fileName) {
        return !StringUtil.hasKorean((String)fileName) && !StringUtil.hasInvalidClassFileSignal((String)fileName) && !StringUtil.hasEmptySpace((String)fileName);
    }

    private IPath getPackageExplorerSelection() {
        if (!this.selection.isEmpty()) {
            IPath selectedPath = null;
            Object object = this.selection.getFirstElement();
            if (object instanceof IJavaElement) {
                IJavaElement element = (IJavaElement)object;
                selectedPath = element.getPath();
            } else if (object instanceof Folder) {
                Folder element = (Folder)object;
                selectedPath = element.getFullPath();
            }
            return selectedPath;
        }
        return null;
    }

    private void selectTreeViewerItem(IPath selectedPath) {
        if (!NullUtil.isNull((Object)selectedPath)) {
            IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(selectedPath);
            this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)resource));
        }
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.getShell().setMinimumSize(0, 0);
            this.getShell().setSize(533, 659);
            if (NullUtil.isEmpty((String)this.context.getFilePath())) {
                IPath selectedPath = this.getPackageExplorerSelection();
                this.selectTreeViewerItem(selectedPath);
            }
        }
        super.setVisible(visible);
    }
}

