/*
 * Decompiled with CFR 0.152.
 */
package egovframework.bdev.imp.batch.wizards.com;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.jdom2.Attribute;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.output.Format;
import org.jdom2.output.support.AbstractXMLOutputProcessor;
import org.jdom2.output.support.FormatStack;
import org.jdom2.output.support.Walker;
import org.jdom2.util.NamespaceStack;

public class CustomXMLOutputProcessor
extends AbstractXMLOutputProcessor {
    protected void printNamespace(Writer out, FormatStack fstack, Namespace ns) throws IOException {
        if (ns == Namespace.NO_NAMESPACE) {
            return;
        }
        String prefix = ns.getPrefix();
        String uri = ns.getURI();
        if (prefix.equals("aop") || prefix.equals("context") || prefix.equals("p") || prefix.equals("tx") || prefix.equals("util") || prefix.equals("xsi") || uri.endsWith("beans")) {
            this.write(out, "\n\t xmlns");
        } else {
            this.write(out, " xmlns");
        }
        if (!prefix.equals("")) {
            this.write(out, ":");
            this.write(out, prefix);
        }
        this.write(out, "=\"");
        this.write(out, uri);
        this.write(out, "\"");
    }

    protected void printElement(Writer out, FormatStack fstack, NamespaceStack nstack, Element element) throws IOException {
        nstack.push(element);
        try {
            List content = element.getContent();
            this.write(out, "<");
            this.write(out, element.getQualifiedName());
            if (element.hasAttributes()) {
                for (Attribute attribute : element.getAttributes()) {
                    this.printAttribute(out, fstack, attribute);
                }
            }
            for (Namespace ns : nstack.addedForward()) {
                this.printNamespace(out, fstack, ns);
            }
            if (content.isEmpty()) {
                if (fstack.isExpandEmptyElements()) {
                    this.write(out, "></");
                    this.write(out, element.getQualifiedName());
                    this.write(out, ">");
                } else {
                    this.write(out, " />");
                }
                return;
            }
            fstack.push();
            try {
                String space = element.getAttributeValue("space", Namespace.XML_NAMESPACE);
                if ("default".equals(space)) {
                    fstack.setTextMode(fstack.getDefaultMode());
                } else if ("preserve".equals(space)) {
                    fstack.setTextMode(Format.TextMode.PRESERVE);
                }
                Walker walker = this.buildWalker(fstack, content, true);
                if (!walker.hasNext()) {
                    if (fstack.isExpandEmptyElements()) {
                        this.write(out, "></");
                        this.write(out, element.getQualifiedName());
                        this.write(out, ">");
                    } else {
                        this.write(out, " />");
                    }
                    return;
                }
                this.write(out, ">");
                if (!walker.isAllText()) {
                    this.textRaw(out, fstack.getPadBetween());
                }
                this.printContent(out, fstack, nstack, walker);
                if (!walker.isAllText()) {
                    this.textRaw(out, fstack.getPadLast());
                }
                this.write(out, "</");
                this.write(out, element.getQualifiedName());
                this.write(out, ">");
            }
            finally {
                fstack.pop();
            }
        }
        finally {
            nstack.pop();
        }
    }

    protected void printAttribute(Writer out, FormatStack fstack, Attribute attribute) throws IOException {
        if (!attribute.isSpecified() && fstack.isSpecifiedAttributesOnly()) {
            return;
        }
        this.write(out, " ");
        this.write(out, attribute.getQualifiedName());
        this.write(out, "=");
        this.write(out, "\"");
        this.attributeEscapedEntitiesFilter(out, fstack, attribute.getValue());
        this.write(out, "\"");
    }

    protected void attributeEscapedEntitiesFilter(Writer out, FormatStack fstack, String value) throws IOException {
        this.write(out, value);
    }
}

