/*
 * Decompiled with CFR 0.152.
 */
package egovframework.bdev.imp.batch.wizards.com;

import egovframework.bdev.imp.batch.common.BatchLog;
import egovframework.bdev.imp.batch.wizards.com.BatchJobContext;
import egovframework.bdev.imp.batch.wizards.com.CustomXMLOutputProcessor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.jdom2.Document;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.jdom2.output.support.XMLOutputProcessor;

public class HandlingFileOperation {
    public static IFile newXMLFile = null;

    public static IFile createFile(BatchJobContext context) {
        Path path;
        if (context.getFilePath().contains("/")) {
            path = new Path(String.valueOf(context.getFilePath()) + "/" + context.getFileName());
            newXMLFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
        } else {
            path = new Path(context.getProject().getFullPath() + "/" + context.getFileName());
            newXMLFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
        }
        String contents = " ";
        ByteArrayInputStream inputStream = new ByteArrayInputStream(contents.getBytes());
        if (!newXMLFile.exists()) {
            try {
                newXMLFile.create((InputStream)inputStream, false, null);
            }
            catch (CoreException e) {
                BatchLog.logError(e);
            }
        } else {
            Path path2;
            String[] value = context.getFileName().split(".xml");
            if (context.getFilePath().contains("/")) {
                path2 = new Path(String.valueOf(context.getFilePath()) + "/" + value[0] + "_" + "eGov" + ".xml");
                newXMLFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path2);
            } else {
                path2 = new Path(context.getProject().getFullPath() + "/" + value[0] + "_" + "eGov" + ".xml");
                newXMLFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path2);
            }
            try {
                newXMLFile.setContents((InputStream)inputStream, true, false, null);
            }
            catch (CoreException e) {
                BatchLog.logError(e);
            }
        }
        return newXMLFile;
    }

    public static void transformFiletoXMLFile(Document doc) {
        XMLOutputter xmlOut = new XMLOutputter();
        xmlOut.setXMLOutputProcessor((XMLOutputProcessor)new CustomXMLOutputProcessor());
        Format format = xmlOut.getFormat();
        format.setIndent("    ");
        format.setLineSeparator("\r\n");
        format.setTextMode(Format.TextMode.TRIM);
        xmlOut.setFormat(format);
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            xmlOut.output(doc, (OutputStream)outputStream);
            ByteArrayInputStream is = new ByteArrayInputStream(outputStream.toByteArray());
            if (!newXMLFile.exists()) {
                newXMLFile.create((InputStream)is, true, null);
            } else {
                newXMLFile.setContents((InputStream)is, 0, null);
            }
        }
        catch (IOException e) {
            BatchLog.logError(e);
        }
        catch (CoreException e) {
            BatchLog.logError(e);
        }
    }

    public static void deleteFile(IFile newXMLFile) {
        if (newXMLFile != null && newXMLFile.exists() && newXMLFile.isAccessible()) {
            try {
                newXMLFile.delete(true, null);
            }
            catch (CoreException e) {
                BatchLog.logError(e);
            }
        }
    }
}

