/*
 * Decompiled with CFR 0.152.
 */
package egovframework.bdev.imp.batch.wizards.jobcreation;

import egovframework.bdev.imp.batch.EgovBatchPlugin;
import egovframework.bdev.imp.batch.common.BatchLog;
import egovframework.bdev.imp.batch.common.BatchMessages;
import egovframework.bdev.imp.batch.wizards.com.HandlingFileOperation;
import egovframework.bdev.imp.batch.wizards.jobcreation.model.BatchJobCreationContext;
import egovframework.bdev.imp.batch.wizards.jobcreation.model.JobVo;
import egovframework.bdev.imp.batch.wizards.jobcreation.model.StepAndDecisionVo;
import egovframework.bdev.imp.batch.wizards.jobcreation.operation.CreateBatchJobXMLFileOperation;
import egovframework.bdev.imp.batch.wizards.jobcreation.pages.BatchJobCreationCustomizePage;
import egovframework.bdev.imp.batch.wizards.jobcreation.pages.BatchJobcreationSelectProjectPage;
import egovframework.dev.imp.core.utils.NullUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;

public class EgovNewBatchJobWizard
extends Wizard
implements INewWizard {
    BatchJobCreationContext context = new BatchJobCreationContext();
    BatchJobCreationCustomizePage customizePage = null;
    private ISelection selection = null;

    public EgovNewBatchJobWizard() {
        this.setWindowTitle("New eGovFrame Batch Job File");
        this.setNeedsProgressMonitor(true);
        this.setDefaultPageImageDescriptor(EgovBatchPlugin.getDefault().getImageDescriptor("batch_job_wiz_banner"));
    }

    public void addPages() {
        BatchJobcreationSelectProjectPage selectProjectPage = new BatchJobcreationSelectProjectPage("SelectProjectPage", this.context, this.selection);
        this.addPage((IWizardPage)selectProjectPage);
        this.customizePage = new BatchJobCreationCustomizePage("CustomizeCreation", this.context);
        this.addPage((IWizardPage)this.customizePage);
        if (!NullUtil.isNull((Object)this.getContainer())) {
            this.getContainer().getShell().setLocation(430, 55);
        }
    }

    public boolean canFinish() {
        if (this.getContainer().getCurrentPage().equals((Object)this.customizePage)) {
            return super.canFinish();
        }
        return false;
    }

    public boolean performFinish() {
        String message = BatchMessages.EgovNewBatchJobWizard_CONFIRM_FINISH_MESSAGE;
        if (!MessageDialog.openConfirm((Shell)this.getShell(), (String)BatchMessages.EgovNewBatchJobWizard_CONFIRM_FINISH_DIALOG_TITLE, (String)message)) {
            return false;
        }
        JobVo[] jobVos = this.customizePage.getResultBatchJobVos();
        if (jobVos.length > 0) {
            JobVo[] jobVoArray = jobVos;
            int n = jobVos.length;
            int n2 = 0;
            while (n2 < n) {
                JobVo data = jobVoArray[n2];
                StepAndDecisionVo[] dsVos = data.getStepAndDecisionVoList();
                if (dsVos.length > 0) {
                    StepAndDecisionVo[] stepAndDecisionVoArray = dsVos;
                    int n3 = dsVos.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        StepAndDecisionVo dsVo = stepAndDecisionVoArray[n4];
                        dsVo.setJobName(data.getJobName());
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        this.context.setJobVoList(jobVos);
        boolean result = true;
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(BatchMessages.EgovNewBatchJobWizard_PROGRESS_MESSAGE_1, 2);
                    CreateBatchJobXMLFileOperation jobXML = new CreateBatchJobXMLFileOperation();
                    jobXML.setContext(EgovNewBatchJobWizard.this.context);
                    monitor.subTask(BatchMessages.EgovNewBatchJobWizard_PROGRESS_MESSAGE_2);
                    monitor.worked(1);
                    jobXML.createJobXMLFile(EgovNewBatchJobWizard.this.context);
                    monitor.subTask(BatchMessages.EgovNewBatchJobWizard_PROGRESS_MESSAGE_3);
                    monitor.worked(1);
                    if (monitor.isCanceled()) {
                        HandlingFileOperation.deleteFile(HandlingFileOperation.newXMLFile);
                        throw new InterruptedException();
                    }
                    monitor.done();
                }
            });
            this.openCreatedFile(HandlingFileOperation.newXMLFile);
        }
        catch (InvocationTargetException e) {
            HandlingFileOperation.deleteFile(HandlingFileOperation.newXMLFile);
            BatchLog.logError(e);
            result = false;
        }
        catch (InterruptedException e) {
            HandlingFileOperation.deleteFile(HandlingFileOperation.newXMLFile);
            BatchLog.logError(e);
            result = false;
        }
        return result;
    }

    private void openCreatedFile(IFile file) {
        FileEditorInput editorInput = new FileEditorInput(file);
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(file.getName());
        try {
            page.openEditor((IEditorInput)editorInput, desc.getId());
        }
        catch (PartInitException partInitException) {}
    }

    private void doFinish(String containerName, String fileName, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(String.valueOf(BatchMessages.EgovNewBatchJobWizard_PROGRESS_MESSAGE_4) + fileName, 2);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember((IPath)new Path(containerName));
        if (!resource.exists() || !(resource instanceof IContainer)) {
            this.throwCoreException(String.valueOf(BatchMessages.EgovNewBatchJobWizard_PROGRESS_ERROR_MESSAGE_1) + containerName + BatchMessages.EgovNewBatchJobWizard_PROGRESS_ERROR_MESSAGE_2);
        }
        IContainer container = (IContainer)resource;
        final IFile file = container.getFile((IPath)new Path(fileName));
        try {
            InputStream stream = this.openContentStream();
            if (file.exists()) {
                file.setContents(stream, true, true, monitor);
            } else {
                file.create(stream, true, monitor);
            }
            stream.close();
        }
        catch (IOException iOException) {}
        monitor.worked(1);
        monitor.setTaskName(BatchMessages.EgovNewBatchJobWizard_PROGRESS_MESSAGE_5);
        this.getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                }
                catch (PartInitException partInitException) {}
            }
        });
        monitor.worked(1);
    }

    private InputStream openContentStream() {
        String contents = BatchMessages.EgovNewBatchJobWizard_OPEN_CONTENT_STREAM_MESSAGE;
        return new ByteArrayInputStream(contents.getBytes());
    }

    private void throwCoreException(String message) throws CoreException {
        Status status = new Status(4, "egovframework.bdev.tst", 0, message, null);
        throw new CoreException((IStatus)status);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }
}

