/*
 * Decompiled with CFR 0.152.
 */
package egovframework.bdev.imp.batch.wizards.jobcreation.model;

import egovframework.bdev.imp.batch.wizards.jobcreation.model.BatchPageBeanIDList;
import egovframework.bdev.imp.batch.wizards.jobcreation.model.DecisionVo;
import egovframework.bdev.imp.batch.wizards.jobcreation.model.JobVo;
import egovframework.bdev.imp.batch.wizards.jobcreation.model.StepVo;
import egovframework.dev.imp.core.utils.NullUtil;
import java.util.ArrayList;

public class BatchJobBeanIDList {
    private String jobID = null;
    private BatchPageBeanIDList jobPage = new BatchPageBeanIDList();
    private ArrayList<BatchPageBeanIDList> stepDecisionPages = new ArrayList();

    public BatchJobBeanIDList() {
    }

    public BatchJobBeanIDList(JobVo jobVo) {
        this();
        this.setJobBeanIDs(jobVo);
    }

    public void setJobBeanIDs(JobVo jobVo) {
        if (NullUtil.isNull((Object)jobVo)) {
            return;
        }
        this.jobID = jobVo.getJobName();
        this.jobPage.setPageID(this.jobID);
        this.jobPage.setJobInfoPageBeanIDs(jobVo);
    }

    public void updateJobBeanIDs(JobVo jobVo) {
        this.jobPage = new BatchPageBeanIDList();
        this.setJobBeanIDs(jobVo);
    }

    public boolean addStepBeanIDs(JobVo jobVo, StepVo stepVo) {
        if (NullUtil.isNull((Object)stepVo) && NullUtil.isNull((Object)jobVo)) {
            return false;
        }
        BatchPageBeanIDList stepBeanIDs = new BatchPageBeanIDList();
        stepBeanIDs.setPageID(stepVo.getName());
        stepBeanIDs.setStepInfoPageBeanIDs(stepVo);
        this.updateJobBeanIDs(jobVo);
        return this.stepDecisionPages.add(stepBeanIDs);
    }

    public boolean updateStepBeanIDs(String preStepID, JobVo jobVo, StepVo stepVo) {
        if (this.removeStepDecision(preStepID)) {
            return this.addStepBeanIDs(jobVo, stepVo);
        }
        return false;
    }

    public boolean addDecisionBeanIDs(DecisionVo decisionVo) {
        if (NullUtil.isNull((Object)decisionVo)) {
            return false;
        }
        BatchPageBeanIDList decisionBeanIDs = new BatchPageBeanIDList();
        decisionBeanIDs.setPageID(decisionVo.getName());
        decisionBeanIDs.setDecisionInfoPageBeanIDs(decisionVo);
        return this.stepDecisionPages.add(decisionBeanIDs);
    }

    public boolean updateDecisionBeanIDs(String preDecisionID, DecisionVo decisionVo) {
        if (this.removeStepDecision(preDecisionID)) {
            return this.addDecisionBeanIDs(decisionVo);
        }
        return false;
    }

    public String getJobID() {
        return this.jobID;
    }

    public boolean removeStepDecision(String id) {
        BatchPageBeanIDList searchBeanID = this.getStepDecisionBeanIDList(id);
        if (!NullUtil.isNull((Object)searchBeanID)) {
            return this.stepDecisionPages.remove(searchBeanID);
        }
        return false;
    }

    public BatchPageBeanIDList getStepDecisionBeanIDList(String id) {
        if (!NullUtil.isEmpty(this.stepDecisionPages)) {
            for (BatchPageBeanIDList pageBeanIDList : this.stepDecisionPages) {
                if (!pageBeanIDList.getPageID().equals(id)) continue;
                return pageBeanIDList;
            }
        }
        return null;
    }

    public boolean isBeanIDExist(String beanID) {
        if (this.jobPage.isBeanIDExist(beanID)) {
            return true;
        }
        int i = 0;
        while (i < this.stepDecisionPages.size()) {
            BatchPageBeanIDList beanIDList = this.stepDecisionPages.get(i);
            if (beanIDList.isBeanIDExist(beanID)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void removeJobBeanPageToAvailableList() {
        this.jobPage = new BatchPageBeanIDList();
    }

    public BatchJobBeanIDList clone() {
        BatchJobBeanIDList clone = new BatchJobBeanIDList();
        clone.setJobID(this.jobID);
        clone.setJobPage(this.jobPage.clone());
        ArrayList<BatchPageBeanIDList> cloneStepDecisionPages = new ArrayList<BatchPageBeanIDList>();
        int i = 0;
        while (i < this.stepDecisionPages.size()) {
            cloneStepDecisionPages.add(this.stepDecisionPages.get(i).clone());
            ++i;
        }
        clone.setStepDecisionPages(cloneStepDecisionPages);
        return clone;
    }

    public BatchPageBeanIDList getJobPage() {
        return this.jobPage;
    }

    public void setJobPage(BatchPageBeanIDList jobPage) {
        this.jobPage = jobPage;
    }

    public ArrayList<BatchPageBeanIDList> getStepDecisionPages() {
        return this.stepDecisionPages;
    }

    public void setStepDecisionPages(ArrayList<BatchPageBeanIDList> stepDecisionPages) {
        this.stepDecisionPages = stepDecisionPages;
    }

    public void setJobID(String jobID) {
        this.jobID = jobID;
    }
}

