/*
 * Decompiled with CFR 0.152.
 */
package egovframework.bdev.imp.batch.wizards.jobcreation.model;

import egovframework.bdev.imp.batch.wizards.jobcreation.model.DecisionVo;
import egovframework.bdev.imp.batch.wizards.jobcreation.model.JobVo;
import egovframework.bdev.imp.batch.wizards.jobcreation.model.SharedValueVo;
import egovframework.bdev.imp.batch.wizards.jobcreation.model.StepAndDecisionVo;
import egovframework.bdev.imp.batch.wizards.jobcreation.model.StepVo;
import egovframework.dev.imp.core.utils.NullUtil;
import java.util.ArrayList;

public class BatchPageBeanIDList {
    private String pageID = null;
    private ArrayList<String> beanIDList = new ArrayList();

    public BatchPageBeanIDList() {
    }

    public BatchPageBeanIDList(String id) {
        this();
        this.pageID = id;
    }

    public String getPageID() {
        return this.pageID;
    }

    public void setPageID(String pageID) {
        this.pageID = pageID;
    }

    public boolean addBeanID(String beanID) {
        if (NullUtil.isEmpty((String)beanID)) {
            return true;
        }
        if (this.beanIDList.indexOf(beanID) < 0) {
            return this.beanIDList.add(beanID);
        }
        return false;
    }

    public boolean addBeanIDWithoutValidate(String beanID) {
        if (NullUtil.isEmpty((String)beanID)) {
            return true;
        }
        return this.beanIDList.add(beanID);
    }

    public boolean removeBeanID(String beanID) {
        return this.beanIDList.remove(beanID);
    }

    public boolean removeBeanID(String[] beanIDs) {
        if (NullUtil.isEmpty((Object[])beanIDs)) {
            return false;
        }
        boolean result = true;
        String[] stringArray = beanIDs;
        int n = beanIDs.length;
        int n2 = 0;
        while (n2 < n) {
            String beanID = stringArray[n2];
            if (!this.removeBeanID(beanID)) {
                result = false;
            }
            ++n2;
        }
        return result;
    }

    public boolean changeBeanID(String preBeanID, String postBeanID) {
        if (NullUtil.isEmpty((String)preBeanID) || NullUtil.isEmpty((String)postBeanID)) {
            return false;
        }
        if (this.removeBeanID(preBeanID)) {
            this.beanIDList.add(postBeanID);
            return true;
        }
        return false;
    }

    public boolean isBeanIDExist(String beanID) {
        if (NullUtil.isEmpty((String)beanID)) {
            return false;
        }
        return this.beanIDList.indexOf(beanID) >= 0;
    }

    public ArrayList<String> getBeanIDList() {
        return (ArrayList)this.beanIDList.clone();
    }

    public void setBeanIDList(ArrayList<String> beanIDList) {
        this.beanIDList = beanIDList;
    }

    public boolean setJobInfoPageBeanIDs(JobVo jobVo) {
        if (NullUtil.isNull((Object)jobVo)) {
            return false;
        }
        this.resetList();
        return this.performJobElement(jobVo);
    }

    public boolean setStepInfoPageBeanIDs(StepVo stepVo) {
        if (NullUtil.isNull((Object)stepVo)) {
            return true;
        }
        this.resetList();
        return this.performStepElement(stepVo);
    }

    public void setDecisionInfoPageBeanIDs(DecisionVo decisionVo) {
        if (NullUtil.isNull((Object)decisionVo)) {
            return;
        }
        this.resetList();
        this.performDecisionElement(decisionVo);
    }

    public void resetList() {
        this.beanIDList = new ArrayList();
    }

    public BatchPageBeanIDList clone() {
        BatchPageBeanIDList clone = new BatchPageBeanIDList();
        if (!NullUtil.isNull((Object)this.pageID)) {
            clone.setPageID(this.pageID);
        }
        ArrayList<String> cloneArray = new ArrayList<String>(this.beanIDList);
        clone.setBeanIDList(cloneArray);
        return clone;
    }

    protected boolean performJobElement(JobVo jobVo) {
        boolean result = true;
        if (!this.addBeanID(jobVo.getJobName())) {
            result = false;
        }
        if (!this.setJobListenerBeanIDs(jobVo)) {
            result = false;
        }
        if (!this.setSharedValuesBeanIDs(jobVo)) {
            result = false;
        }
        return result;
    }

    protected void performStepAndDecisionElement(StepAndDecisionVo[] stepAndDecisionVos) {
        if (!NullUtil.isEmpty((Object[])stepAndDecisionVos)) {
            StepAndDecisionVo[] stepAndDecisionVoArray = stepAndDecisionVos;
            int n = stepAndDecisionVos.length;
            int n2 = 0;
            while (n2 < n) {
                StepAndDecisionVo stepAndDecisionVo = stepAndDecisionVoArray[n2];
                if (stepAndDecisionVo instanceof StepVo) {
                    this.performStepElement((StepVo)stepAndDecisionVo);
                } else if (stepAndDecisionVo instanceof DecisionVo) {
                    this.performDecisionElement((DecisionVo)stepAndDecisionVo);
                }
                ++n2;
            }
        }
    }

    private boolean performStepElement(StepVo stepVo) {
        boolean result = true;
        if (!this.addBeanID(stepVo.getName())) {
            result = false;
        }
        if (!this.addBeanID(stepVo.getSubStepID())) {
            result = false;
        }
        if (!this.setStepListenerBeanIDs(stepVo)) {
            result = false;
        }
        if (!this.setChunkListenerBeanIDs(stepVo)) {
            result = false;
        }
        return result;
    }

    private void performDecisionElement(DecisionVo decisionVo) {
        this.addBeanID(decisionVo.getName());
    }

    private boolean setJobListenerBeanIDs(JobVo jobVo) {
        boolean result = true;
        Object[] jobListenerList = jobVo.getJobListenerInfoList();
        if (!NullUtil.isEmpty((Object[])jobListenerList)) {
            Object[] objectArray = jobListenerList;
            int n = jobListenerList.length;
            int n2 = 0;
            while (n2 < n) {
                Object info = objectArray[n2];
                if (!this.addBeanID(info.getName())) {
                    result = false;
                }
                ++n2;
            }
        }
        return result;
    }

    private boolean setSharedValuesBeanIDs(JobVo jobVo) {
        boolean result = true;
        Object[] sharedValues = jobVo.getSharedValues();
        if (!NullUtil.isEmpty((Object[])sharedValues)) {
            Object[] objectArray = sharedValues;
            int n = sharedValues.length;
            int n2 = 0;
            while (n2 < n) {
                Object vo = objectArray[n2];
                if (!this.addBeanID(((SharedValueVo)vo).getKey())) {
                    result = false;
                }
                ++n2;
            }
        }
        return result;
    }

    public boolean addJobRWBeanID(StepVo stepVo) {
        String jobWriterFullName;
        boolean result = true;
        String jobReaderFullName = stepVo.getJobReaderFullName();
        if (!NullUtil.isEmpty((String)jobReaderFullName) && !this.addBeanID(jobReaderFullName)) {
            result = false;
        }
        if (!NullUtil.isEmpty((String)(jobWriterFullName = stepVo.getJobWriterFullName())) && !this.addBeanID(jobWriterFullName)) {
            result = false;
        }
        return result;
    }

    public boolean updateJobRWBeanID(StepVo preStepVo, StepVo newStepVo) {
        String preJobWriterFullName;
        String preJobReaderFullName = preStepVo.getJobReaderFullName();
        if (!NullUtil.isEmpty((String)preJobReaderFullName)) {
            this.removeBeanID(preJobReaderFullName);
        }
        if (!NullUtil.isEmpty((String)(preJobWriterFullName = preStepVo.getJobWriterFullName()))) {
            this.removeBeanID(preJobWriterFullName);
        }
        return this.addJobRWBeanID(newStepVo);
    }

    private boolean setStepListenerBeanIDs(StepVo stepVo) {
        boolean result = true;
        Object[] infos = stepVo.getStepListenerInfoList();
        if (!NullUtil.isEmpty((Object[])infos)) {
            Object[] objectArray = infos;
            int n = infos.length;
            int n2 = 0;
            while (n2 < n) {
                Object info = objectArray[n2];
                if (!this.addBeanID(info.getName())) {
                    result = false;
                }
                ++n2;
            }
        }
        return result;
    }

    private boolean setChunkListenerBeanIDs(StepVo stepVo) {
        boolean result = true;
        Object[] infos = stepVo.getChunkListenerInfoList();
        if (!NullUtil.isEmpty((Object[])infos)) {
            Object[] objectArray = infos;
            int n = infos.length;
            int n2 = 0;
            while (n2 < n) {
                Object info = objectArray[n2];
                if (!this.addBeanID(info.getName())) {
                    result = false;
                }
                ++n2;
            }
        }
        return result;
    }
}

