/*
 * Decompiled with CFR 0.152.
 */
package egovframework.bdev.imp.batch.wizards.jobcreation.model;

import egovframework.bdev.imp.batch.wizards.jobcreation.model.BatchJobBeanIDList;
import egovframework.bdev.imp.batch.wizards.jobcreation.model.BatchPageBeanIDList;
import egovframework.bdev.imp.batch.wizards.jobcreation.model.DecisionVo;
import egovframework.bdev.imp.batch.wizards.jobcreation.model.JobVo;
import egovframework.bdev.imp.batch.wizards.jobcreation.model.StepVo;
import egovframework.dev.imp.core.utils.NullUtil;
import java.util.ArrayList;

public class BatchXMLFileBeanIDList {
    private ArrayList<BatchJobBeanIDList> jobList = null;
    private BatchPageBeanIDList jobRWBeanIDList = null;
    private final String[] defaultInvalidBeanIDs = new String[]{"async", "datasource", "transactionManager", "jdbcTemplate", "egovDecider"};

    public BatchXMLFileBeanIDList() {
        this.jobList = new ArrayList();
        this.jobRWBeanIDList = new BatchPageBeanIDList();
    }

    private boolean addBatchJobBeanIDList(BatchJobBeanIDList jobBeanList) {
        String jobID = jobBeanList.getJobID();
        if (this.jobList.size() > 0) {
            for (BatchJobBeanIDList jobBeans : this.jobList) {
                if (!jobBeans.getJobID().equals(jobID)) continue;
                return false;
            }
        }
        return this.jobList.add(jobBeanList);
    }

    public boolean removeJobBeanIDList(String jobID) {
        int length = this.jobList.size();
        int i = 0;
        while (i < length) {
            if (jobID.equals(this.jobList.get(i).getJobID())) {
                this.jobList.remove(i);
                return true;
            }
            ++i;
        }
        return false;
    }

    public BatchJobBeanIDList getJobBeanIDList(String jobID) {
        if (!NullUtil.isEmpty((String)jobID) && this.jobList.size() > 0) {
            for (BatchJobBeanIDList jobBeans : this.jobList) {
                if (!jobBeans.getJobID().equals(jobID)) continue;
                return jobBeans;
            }
        }
        return null;
    }

    public boolean updateJobBeanIDList(BatchJobBeanIDList jobBeanList) {
        return this.updateJobBeanIDList(jobBeanList.getJobID(), jobBeanList);
    }

    public boolean updateJobBeanIDList(String jobID, BatchJobBeanIDList jobBeanList) {
        if (this.removeJobBeanIDList(jobID)) {
            this.addBatchJobBeanIDList(jobBeanList);
            return true;
        }
        return false;
    }

    public boolean isBeanIDExistIncludeJobRWBeanList(String beanID) {
        int i = 0;
        while (i < this.defaultInvalidBeanIDs.length) {
            if (beanID.equals(this.defaultInvalidBeanIDs[i])) {
                return true;
            }
            ++i;
        }
        i = 0;
        while (i < this.jobList.size()) {
            BatchJobBeanIDList jobBeanIDs = this.jobList.get(i);
            if (jobBeanIDs.isBeanIDExist(beanID)) {
                return true;
            }
            ++i;
        }
        return this.jobRWBeanIDList.isBeanIDExist(beanID);
    }

    public boolean isBeanIDExistExceptJobRWBeanList(String beanID) {
        int i = 0;
        while (i < this.defaultInvalidBeanIDs.length) {
            if (beanID.equals(this.defaultInvalidBeanIDs[i])) {
                return true;
            }
            ++i;
        }
        i = 0;
        while (i < this.jobList.size()) {
            BatchJobBeanIDList jobBeanIDs = this.jobList.get(i);
            if (jobBeanIDs.isBeanIDExist(beanID)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setBatchJobBeanIDListArray(ArrayList<BatchJobBeanIDList> jobList) {
        this.jobList = jobList;
    }

    public void setJobRWBeanIDList(BatchPageBeanIDList jobRWBeanIDList) {
        this.jobRWBeanIDList = jobRWBeanIDList;
    }

    public BatchXMLFileBeanIDList clone() {
        BatchXMLFileBeanIDList clone = new BatchXMLFileBeanIDList();
        ArrayList<BatchJobBeanIDList> cloneJobList = new ArrayList<BatchJobBeanIDList>();
        int i = 0;
        while (i < this.jobList.size()) {
            cloneJobList.add(this.jobList.get(i).clone());
            ++i;
        }
        clone.setBatchJobBeanIDListArray(cloneJobList);
        clone.setJobRWBeanIDList(this.jobRWBeanIDList.clone());
        return clone;
    }

    public boolean addNewJobVoBeanIDList(JobVo jobVo) {
        BatchJobBeanIDList jobBeanIDList = this.getJobBeanIDList(jobVo.getJobName());
        if (NullUtil.isNull((Object)jobBeanIDList)) {
            BatchJobBeanIDList newJobBeanIDList = new BatchJobBeanIDList(jobVo);
            this.addBatchJobBeanIDList(newJobBeanIDList);
            return true;
        }
        return false;
    }

    public boolean updateJobVoBeanIDList(String preJobName, JobVo newJobVo) {
        BatchJobBeanIDList jobBeanIDList = this.getJobBeanIDList(preJobName);
        if (!NullUtil.isNull((Object)jobBeanIDList)) {
            jobBeanIDList.updateJobBeanIDs(newJobVo);
            return true;
        }
        return false;
    }

    public void addStepVoBeanIDList(JobVo jobVo, StepVo newStepVo) {
        BatchJobBeanIDList jobBeanList = this.getJobBeanIDList(jobVo.getJobName());
        if (!NullUtil.isNull((Object)jobBeanList)) {
            jobBeanList.addStepBeanIDs(jobVo, newStepVo);
            this.jobRWBeanIDList.addJobRWBeanID(newStepVo);
        }
    }

    public void updateStepVoBeanIDList(StepVo preStepVo, JobVo jobVo, StepVo newStepVo) {
        BatchJobBeanIDList jobBeanList = this.getJobBeanIDList(jobVo.getJobName());
        if (!NullUtil.isNull((Object)jobBeanList)) {
            jobBeanList.updateStepBeanIDs(preStepVo.getName(), jobVo, newStepVo);
            this.jobRWBeanIDList.updateJobRWBeanID(preStepVo, newStepVo);
        }
    }

    public void addDecisionVoBeanIDList(JobVo jobVo, DecisionVo newDecisionVo) {
        BatchJobBeanIDList jobBeanList = this.getJobBeanIDList(jobVo.getJobName());
        if (!NullUtil.isNull((Object)jobBeanList)) {
            jobBeanList.addDecisionBeanIDs(newDecisionVo);
        }
    }

    public void updateDecisionVoBeanIDList(DecisionVo preDecisionVo, JobVo jobVo, DecisionVo newDecisionVo) {
        BatchJobBeanIDList jobBeanList = this.getJobBeanIDList(jobVo.getJobName());
        if (!NullUtil.isNull((Object)jobBeanList)) {
            jobBeanList.updateDecisionBeanIDs(preDecisionVo.getName(), newDecisionVo);
        }
    }
}

