/*
 * Decompiled with CFR 0.152.
 */
package egovframework.bdev.imp.batch.wizards.jobcreation.operation;

import egovframework.bdev.imp.batch.wizards.com.BatchJobContext;
import egovframework.bdev.imp.batch.wizards.com.HandlingFileOperation;
import egovframework.bdev.imp.batch.wizards.jobcreation.model.BatchJobCreationContext;
import egovframework.bdev.imp.batch.wizards.jobcreation.model.DecisionVo;
import egovframework.bdev.imp.batch.wizards.jobcreation.model.JobVo;
import egovframework.bdev.imp.batch.wizards.jobcreation.model.StepAndDecisionVo;
import egovframework.bdev.imp.batch.wizards.jobcreation.model.StepVo;
import egovframework.bdev.imp.batch.wizards.jobcreation.operation.AppendBatchReaderWriterBeanOperation;
import egovframework.dev.imp.core.utils.NullUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class CreateBatchJobXMLFileOperation {
    private HashMap<String, String> beanMap = new HashMap();
    private HashMap<String, String> orderedMap = new HashMap();
    private JobVo[] jobVOList = null;
    private StepAndDecisionVo[] stepAndDecisionVoList = null;
    private ArrayList<StepVo> stepVOList = new ArrayList();
    private ArrayList<DecisionVo> decisionVOList = new ArrayList();
    private ArrayList<String> partitionModeStep = new ArrayList();
    private int decisionDone = 0;
    private String projectName = null;

    public void setContext(BatchJobContext context) {
        if (context != null) {
            int i;
            BatchJobCreationContext jobContext = new BatchJobCreationContext();
            DecisionVo tempDecisionVo = null;
            StepVo tempStepVo = null;
            if (context instanceof BatchJobCreationContext) {
                jobContext = (BatchJobCreationContext)context;
                this.jobVOList = jobContext.getJobVoList();
            }
            if (this.jobVOList.length > 0) {
                i = 0;
                while (i < this.jobVOList.length) {
                    if (this.jobVOList[i].getStepAndDecisionVoList().length > 0) {
                        int j = 0;
                        while (j < this.jobVOList[i].getStepAndDecisionVoList().length) {
                            this.stepAndDecisionVoList = this.jobVOList[i].getStepAndDecisionVoList();
                            if (this.stepAndDecisionVoList[j] instanceof DecisionVo) {
                                tempDecisionVo = (DecisionVo)this.stepAndDecisionVoList[j];
                                this.decisionVOList.add(tempDecisionVo);
                            }
                            if (this.stepAndDecisionVoList[j] instanceof StepVo) {
                                tempStepVo = (StepVo)this.stepAndDecisionVoList[j];
                                this.stepVOList.add(tempStepVo);
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
            i = 0;
            while (i < this.stepVOList.size()) {
                if (this.stepVOList.get(i).isPartitionMode()) {
                    this.partitionModeStep.add(this.stepVOList.get(i).getPartitionerType());
                }
                ++i;
            }
            this.projectName = jobContext.getProject().getName();
        }
    }

    public void createJobXMLFile(BatchJobCreationContext context) {
        HandlingFileOperation.createFile(context);
        Element beansElement = this.appendBeansElement();
        Document doc = new Document(beansElement);
        this.appendJobElement(beansElement);
        this.appendBeanElement(beansElement);
        HandlingFileOperation.transformFiletoXMLFile(doc);
    }

    private Element appendBeansElement() {
        Element beansElement = new Element("beans");
        beansElement.setNamespace(Namespace.getNamespace((String)"http://www.springframework.org/schema/beans"));
        beansElement.addNamespaceDeclaration(Namespace.getNamespace((String)"util", (String)"http://www.springframework.org/schema/util"));
        Namespace xsi = Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance");
        String xsiSchemaLocation = "http://www.springframework.org/schema/batch \n\t http://www.springframework.org/schema/batch/spring-batch.xsd \n\t http://www.springframework.org/schema/beans \n\t http://www.springframework.org/schema/beans/spring-beans.xsd \n\t http://www.springframework.org/schema/util \n\t http://www.springframework.org/schema/util/spring-util.xsd";
        beansElement.addNamespaceDeclaration(xsi);
        beansElement.setAttribute("schemaLocation", xsiSchemaLocation, xsi);
        return beansElement;
    }

    private void appendJobElement(Element beansElement) {
        Element job = null;
        if (this.jobVOList.length > 0) {
            int i = 0;
            while (i < this.jobVOList.length) {
                String jobName = null;
                jobName = this.jobVOList[i].getJobName();
                job = new Element("job");
                beansElement.addContent((Content)job);
                job.setAttribute("id", this.jobVOList[i].getJobName());
                if (this.jobVOList[i].isRestartable()) {
                    job.setAttribute("restartable", "true");
                } else {
                    job.setAttribute("restartable", "false");
                }
                job.setNamespace(Namespace.getNamespace((String)"http://www.springframework.org/schema/batch"));
                int j = 0;
                while (j < this.stepVOList.size()) {
                    if (jobName.equals(this.stepVOList.get(j).getJobName())) {
                        if (!this.stepVOList.get(j).isPartitionMode()) {
                            this.appendStepTaskletElement(beansElement, job, this.jobVOList[i], this.stepVOList.get(j), jobName);
                        } else {
                            this.appendStepPartitionElement(beansElement, job, this.jobVOList[i], this.stepVOList.get(j));
                        }
                    }
                    ++j;
                }
                this.appendDecisionElement(beansElement, job, jobName);
                this.updateNextToAttribute(job);
                this.findStartingStep(job);
                if (this.jobVOList[i].getJobListenerInfoList() != null && this.jobVOList[i].getJobListenerInfoList().length > 0) {
                    Element listeners = new Element("listeners");
                    job.addContent((Content)listeners);
                    Element listener = null;
                    int j2 = 0;
                    while (j2 < this.jobVOList[i].getJobListenerInfoList().length) {
                        listener = new Element("listener");
                        listeners.addContent((Content)listener);
                        listener.setAttribute("ref", this.jobVOList[i].getJobListenerInfoList()[j2].getName());
                        ++j2;
                    }
                    if (this.jobVOList[i].getJobListenerInfoList().length > 0) {
                        j2 = 0;
                        while (j2 < this.jobVOList[i].getJobListenerInfoList().length) {
                            if (this.jobVOList[i].getJobListenerInfoList()[j2] != null) {
                                String tempName = this.jobVOList[i].getJobListenerInfoList()[j2].getName().toString();
                                String tempClass = this.jobVOList[i].getJobListenerInfoList()[j2].getClassValue().toString();
                                this.beanMap.put("jobListener" + tempName, String.valueOf(tempName) + "<" + tempClass);
                            }
                            ++j2;
                        }
                    }
                }
                ++i;
            }
        }
    }

    private void appendStepTaskletElement(Element beansElement, Element job, JobVo jobVO, StepVo stepVo, String jobName) {
        Element step = null;
        if (!stepVo.isPartitionMode()) {
            String tempClass;
            String tempId;
            int m;
            step = new Element("step");
            job.addContent((Content)step);
            step.setAttribute("id", stepVo.getName());
            if (stepVo.getNextStep() != null && stepVo.getNextStep().length() > 0) {
                int size = job.getChildren("decision").size();
                int i = 0;
                while (i < size) {
                    ++i;
                }
                step.setAttribute("next", stepVo.getNextStep());
            }
            Element tasklet = new Element("tasklet");
            step.addContent((Content)tasklet);
            Element chunk = new Element("chunk");
            tasklet.addContent((Content)chunk);
            String jobReaderName = stepVo.getJobReaderFullName();
            String jobReaderResourceType = stepVo.getJobReaderInfo().getResourceType();
            String jobReaderItemType = stepVo.getJobReaderInfo().getItemType();
            String jobReaderClass = stepVo.getJobReaderInfo().getClassValue();
            String sqlKeyValue = "";
            if (!NullUtil.isNull(stepVo.getJobReadersqlKeyValueVo())) {
                int i = 0;
                while (i < stepVo.getJobReadersqlKeyValueVo().size()) {
                    if (i != 0) {
                        sqlKeyValue = String.valueOf(sqlKeyValue) + "|";
                    }
                    sqlKeyValue = String.valueOf(sqlKeyValue) + stepVo.getJobReadersqlKeyValueVo().get((int)i).key;
                    sqlKeyValue = String.valueOf(sqlKeyValue) + "=";
                    sqlKeyValue = String.valueOf(sqlKeyValue) + stepVo.getJobReadersqlKeyValueVo().get((int)i).value;
                    ++i;
                }
            }
            this.beanMap.put("jobReader" + jobReaderName, String.valueOf(jobReaderName) + "<" + jobReaderClass + "<" + jobReaderResourceType + "<" + jobReaderItemType + "<normal" + "<" + stepVo.getJobReaderContext().get("Resource") + "<" + stepVo.getJobReaderContext().get("FieldName") + "<" + stepVo.getJobReaderContext().get("ColumnLength") + "<" + stepVo.getJobReaderContext().get("Delimiter") + "<" + stepVo.getJobReaderContext().get("VOClass") + "<" + stepVo.getJobReaderContext().get("FieldFormat") + "<" + stepVo.getJobReaderContext().get("FieldRange") + "<" + stepVo.getJobReaderContext().get("MaxCountperResource") + "<" + stepVo.getJobReaderContext().get("iBatisStatement") + "<" + stepVo.getJobReaderContext().get("ConfigurationFile") + "<" + stepVo.getJobReaderContext().get("Sql") + "<" + stepVo.getJobReaderContext().get("RowMapper") + "<" + stepVo.getJobReaderContext().get("PageSize") + "<" + stepVo.getJobReaderContext().get("Sql-SortColumn") + "<" + stepVo.getJobReaderContext().get("Sql-SELECT") + "<" + stepVo.getJobReaderContext().get("Sql-FROM") + "<" + stepVo.getJobReaderContext().get("Sql-WHERE") + "<" + stepVo.getJobReaderContext().get("Sql-Update") + "<" + stepVo.getJobReaderContext().get("Sql-Insert") + "<" + stepVo.getJobReaderContext().get("Params") + "<" + stepVo.getJobReaderContext().get("RowSetter") + "<" + stepVo.getJobReaderContext().get("DatabaseType") + "<" + stepVo.getJobReaderContext().get("DatasourceBeanID") + "<" + this.projectName + "<" + sqlKeyValue);
            chunk.setAttribute("reader", jobReaderName);
            String jobWriterName = stepVo.getJobWriterFullName();
            String jobWriterResourceType = stepVo.getJobWriterInfo().getResourceType();
            String jobWriterItemType = stepVo.getJobWriterInfo().getItemType();
            String jobWriterClass = stepVo.getJobWriterInfo().getClassValue();
            this.beanMap.put("jobWriter" + jobWriterName, String.valueOf(jobWriterName) + "<" + jobWriterClass + "<" + jobWriterResourceType + "<" + jobWriterItemType + "<normal" + "<" + stepVo.getJobWriterContext().get("Resource") + "<" + stepVo.getJobWriterContext().get("FieldName") + "<" + stepVo.getJobWriterContext().get("ColumnLength") + "<" + stepVo.getJobWriterContext().get("Delimiter") + "<" + stepVo.getJobWriterContext().get("VOClass") + "<" + stepVo.getJobWriterContext().get("FieldFormat") + "<" + stepVo.getJobWriterContext().get("FieldRange") + "<" + stepVo.getJobWriterContext().get("MaxCountperResource") + "<" + stepVo.getJobWriterContext().get("iBatisStatement") + "<" + stepVo.getJobWriterContext().get("ConfigurationFile") + "<" + stepVo.getJobWriterContext().get("Sql") + "<" + stepVo.getJobWriterContext().get("RowMapper") + "<" + stepVo.getJobWriterContext().get("PageSize") + "<" + stepVo.getJobWriterContext().get("Sql-SortColumn") + "<" + stepVo.getJobWriterContext().get("Sql-SELECT") + "<" + stepVo.getJobWriterContext().get("Sql-FROM") + "<" + stepVo.getJobWriterContext().get("Sql-WHERE") + "<" + stepVo.getJobWriterContext().get("Sql-Update") + "<" + stepVo.getJobWriterContext().get("Sql-Insert") + "<" + stepVo.getJobWriterContext().get("Params") + "<" + stepVo.getJobWriterContext().get("RowSetter") + "<" + stepVo.getJobWriterContext().get("DatabaseType") + "<" + stepVo.getJobWriterContext().get("DatasourceBeanID") + "<" + this.projectName);
            chunk.setAttribute("writer", jobWriterName);
            chunk.setAttribute("commit-interval", stepVo.getCommitInterval().toString());
            if (stepVo.getChunkListenerInfoList() != null && stepVo.getChunkListenerInfoList().length > 0) {
                Element listeners = new Element("listeners");
                chunk.addContent((Content)listeners);
                Element chunkListener = null;
                m = 0;
                while (m < stepVo.getChunkListenerInfoList().length) {
                    chunkListener = new Element("listener");
                    listeners.addContent((Content)chunkListener);
                    chunkListener.setAttribute("ref", stepVo.getChunkListenerInfoList()[m].getName());
                    tempId = stepVo.getChunkListenerInfoList()[m].getName();
                    tempClass = stepVo.getChunkListenerInfoList()[m].getClassValue();
                    this.beanMap.put("chunkListener" + tempId, String.valueOf(tempId) + "<" + tempClass);
                    ++m;
                }
            }
            Element stepListeners = null;
            if (stepVo.getStepListenerInfoList() != null && stepVo.getStepListenerInfoList().length > 0) {
                stepListeners = new Element("listeners");
                step.addContent((Content)stepListeners);
                Element stepListener = null;
                m = 0;
                while (m < stepVo.getStepListenerInfoList().length) {
                    stepListener = new Element("listener");
                    stepListeners.addContent((Content)stepListener);
                    stepListener.setAttribute("ref", stepVo.getStepListenerInfoList()[m].getName());
                    tempId = stepVo.getStepListenerInfoList()[m].getName();
                    tempClass = stepVo.getStepListenerInfoList()[m].getClassValue();
                    this.beanMap.put("stepListener" + tempId, String.valueOf(tempId) + "<" + tempClass);
                    ++m;
                }
            }
            if (jobVO.getJobName().equals(stepVo.getJobName()) && jobVO.getSharedValues() != null && jobVO.getSharedValues().length > 0) {
                Element sharedValueListener = null;
                Element sharedValuesListBean = null;
                int i = 0;
                while (i < jobVO.getSharedValues().length) {
                    if (stepVo.getName().equals(jobVO.getSharedValues()[i].getStepId())) {
                        if (stepListeners == null) {
                            stepListeners = new Element("listeners");
                            step.addContent((Content)stepListeners);
                        }
                        sharedValueListener = new Element("listener");
                        stepListeners.addContent((Content)sharedValueListener);
                        Element sharedValuesBean = new Element("bean");
                        sharedValueListener.addContent((Content)sharedValuesBean);
                        sharedValuesBean.setAttribute("class", "org.springframework.batch.core.listener.ExecutionContextPromotionListener");
                        sharedValuesBean.setNamespace(Namespace.getNamespace((String)"http://www.springframework.org/schema/beans"));
                        Element sharedValuesPropertyBean = new Element("property");
                        sharedValuesBean.addContent((Content)sharedValuesPropertyBean);
                        sharedValuesPropertyBean.setAttribute("name", "keys");
                        sharedValuesListBean = new Element("list");
                        sharedValuesPropertyBean.addContent((Content)sharedValuesListBean);
                        break;
                    }
                    ++i;
                }
                i = 0;
                while (i < jobVO.getSharedValues().length) {
                    if (stepVo.getName().equals(jobVO.getSharedValues()[i].getStepId()) && sharedValuesListBean != null) {
                        Element sharedValuesValueBean = new Element("value");
                        sharedValuesListBean.addContent((Content)sharedValuesValueBean);
                        sharedValuesValueBean.setText(jobVO.getSharedValues()[i].getKey());
                    }
                    ++i;
                }
            }
        }
    }

    private void appendStepPartitionElement(Element beansElement, Element job, JobVo jobVo, StepVo stepVo) {
        String prefix = String.valueOf(jobVo.getJobName()) + "." + stepVo.getName();
        Element step = new Element("step");
        job.addContent((Content)step);
        step.setAttribute("id", stepVo.getName());
        Element partition = new Element("partition");
        step.addContent((Content)partition);
        String partitionName = String.valueOf(prefix) + "." + "partitioner";
        partition.setAttribute("step", stepVo.getSubStepID());
        String partitionerType = stepVo.getPartitionerType();
        partition.setAttribute("partitioner", partitionName);
        String partitionerClass = "org.springframework.batch.core.partition.support.MultiResourcePartitioner";
        String resource = stepVo.getResource();
        if (resource.contains(this.projectName)) {
            if ((resource = resource.substring(resource.indexOf(this.projectName) + this.projectName.length())).indexOf("/") == 0) {
                resource = resource.substring(1);
            }
            resource = "file:./" + resource;
        } else {
            resource = "file:" + resource;
        }
        this.beanMap.put("partitioner" + partitionerType + prefix, String.valueOf(partitionName) + "<" + partitionerClass + "<" + resource);
        this.beanMap.put("fileNameListener" + prefix, String.valueOf(prefix) + ".fileNameListener" + "<" + "egovframework.brte.core.listener.EgovOutputFileListener" + "<" + resource);
        Element handler = new Element("handler");
        partition.addContent((Content)handler);
        handler.setAttribute("grid-size", stepVo.getGridSize().toString());
        this.appendStepOfPartitionElement(beansElement, jobVo, stepVo);
    }

    private void appendDecisionElement(Element beansElement, Element job, String jobName) {
        if (this.decisionVOList != null && this.decisionVOList.size() > 0) {
            int j = 0;
            j = 0;
            while (j < this.decisionVOList.size()) {
                j = this.decisionDone;
                if (this.decisionVOList.size() > j && jobName.equals(this.decisionVOList.get(j).getJobName())) {
                    Element decision = new Element("decision");
                    job.addContent((Content)decision);
                    decision.setAttribute("id", this.decisionVOList.get(j).getName());
                    decision.setAttribute("decider", String.valueOf(jobName) + "." + this.decisionVOList.get(j).getName() + "." + "egovDecider");
                    this.beanMap.put("decider" + j, String.valueOf(jobName) + "." + this.decisionVOList.get(j).getName() + "." + "egovDecider" + "<" + "egovframework.brte.core.job.flow.EgovDecider");
                    if (this.decisionVOList.get(j).getNextVo() != null && this.decisionVOList.get(j).getNextVo().length > 0) {
                        int i = 0;
                        while (i < this.decisionVOList.get(j).getNextVo().length) {
                            Element decisionNext = new Element("next");
                            decision.addContent((Content)decisionNext);
                            decisionNext.setAttribute("on", this.decisionVOList.get(j).getNextVo()[i].getNextOn());
                            decisionNext.setAttribute("to", this.decisionVOList.get(j).getNextVo()[i].getNextTo());
                            ++i;
                        }
                    }
                    if (this.decisionVOList.get(j).getEndOn() != null && this.decisionVOList.get(j).getEndOn().length() > 0) {
                        Element decisionEnd = new Element("end");
                        decision.addContent((Content)decisionEnd);
                        decisionEnd.setAttribute("on", this.decisionVOList.get(j).getEndOn());
                        if (this.decisionVOList.get(j).getEndExitCode() != null && this.decisionVOList.get(j).getEndExitCode().length() > 0) {
                            decisionEnd.setAttribute("exit-code", this.decisionVOList.get(j).getEndExitCode());
                        }
                    }
                    if (this.decisionVOList.get(j).getFailOn() != null && this.decisionVOList.get(j).getFailOn().length() > 0) {
                        Element decisionFail = new Element("fail");
                        decision.addContent((Content)decisionFail);
                        decisionFail.setAttribute("on", this.decisionVOList.get(j).getFailOn());
                        if (this.decisionVOList.get(j).getFailExitCode() != null && this.decisionVOList.get(j).getFailExitCode().length() > 0) {
                            decisionFail.setAttribute("exit-code", this.decisionVOList.get(j).getFailExitCode());
                        }
                    }
                    if (this.decisionVOList.get(j).getStopOn() != null && this.decisionVOList.get(j).getStopOn().length() > 0) {
                        Element decisionStop = new Element("stop");
                        decision.addContent((Content)decisionStop);
                        decisionStop.setAttribute("on", this.decisionVOList.get(j).getStopOn());
                        if (this.decisionVOList.get(j).getStopRestart() != null) {
                            decisionStop.setAttribute("restart", this.decisionVOList.get(j).getStopRestart());
                        }
                    }
                    ++this.decisionDone;
                }
                ++j;
            }
        }
    }

    private void appendStepOfPartitionElement(Element beansElement, JobVo jobVo, StepVo stepVo) {
        String prefix = String.valueOf(jobVo.getJobName()) + "." + stepVo.getName();
        Element partitionerStep = new Element("step");
        beansElement.addContent((Content)partitionerStep);
        partitionerStep.setAttribute("id", stepVo.getSubStepID());
        partitionerStep.setNamespace(Namespace.getNamespace((String)"http://www.springframework.org/schema/batch"));
        Element tasklet = new Element("tasklet");
        partitionerStep.addContent((Content)tasklet);
        Element chunk = new Element("chunk");
        tasklet.addContent((Content)chunk);
        String jobReaderName = stepVo.getJobReaderFullName();
        String jobReaderResourceType = stepVo.getJobReaderInfo().getResourceType();
        String jobReaderItemType = stepVo.getJobReaderInfo().getItemType();
        chunk.setAttribute("reader", jobReaderName);
        this.beanMap.put("jobReader" + jobReaderName, String.valueOf(jobReaderName) + "<" + stepVo.getJobReaderInfo().getClassValue() + "<" + jobReaderResourceType + "<" + jobReaderItemType + "<partition" + "<" + stepVo.getJobReaderContext().get("Resource") + "<" + stepVo.getJobReaderContext().get("FieldName") + "<" + stepVo.getJobReaderContext().get("ColumnLength") + "<" + stepVo.getJobReaderContext().get("Delimiter") + "<" + stepVo.getJobReaderContext().get("VOClass") + "<" + stepVo.getJobReaderContext().get("FieldFormat") + "<" + stepVo.getJobReaderContext().get("FieldRange") + "<" + stepVo.getJobReaderContext().get("MaxCountperResource") + "<" + stepVo.getJobReaderContext().get("iBatisStatement") + "<" + stepVo.getJobReaderContext().get("ConfigurationFile") + "<" + stepVo.getJobReaderContext().get("Sql") + "<" + stepVo.getJobReaderContext().get("RowMapper") + "<" + stepVo.getJobReaderContext().get("PageSize") + "<" + stepVo.getJobReaderContext().get("Sql-SortColumn") + "<" + stepVo.getJobReaderContext().get("Sql-SELECT") + "<" + stepVo.getJobReaderContext().get("Sql-FROM") + "<" + stepVo.getJobReaderContext().get("Sql-WHERE") + "<" + stepVo.getJobReaderContext().get("Sql-Update") + "<" + stepVo.getJobReaderContext().get("Sql-Insert") + "<" + stepVo.getJobReaderContext().get("Params") + "<" + stepVo.getJobReaderContext().get("RowSetter") + "<" + stepVo.getJobReaderContext().get("DatabaseType") + "<" + stepVo.getJobReaderContext().get("DatasourceBeanID") + "<" + this.projectName);
        String jobWriterName = stepVo.getJobWriterFullName();
        String jobWriterResourceType = stepVo.getJobWriterInfo().getResourceType();
        String jobWriterItemType = stepVo.getJobWriterInfo().getItemType();
        chunk.setAttribute("writer", jobWriterName);
        this.beanMap.put("jobWriter" + jobWriterName, String.valueOf(jobWriterName) + "<" + stepVo.getJobWriterInfo().getClassValue() + "<" + jobWriterResourceType + "<" + jobWriterItemType + "<partition" + "<" + stepVo.getJobWriterContext().get("Resource") + "<" + stepVo.getJobWriterContext().get("FieldName") + "<" + stepVo.getJobWriterContext().get("ColumnLength") + "<" + stepVo.getJobWriterContext().get("Delimiter") + "<" + stepVo.getJobWriterContext().get("VOClass") + "<" + stepVo.getJobWriterContext().get("FieldFormat") + "<" + stepVo.getJobWriterContext().get("FieldRange") + "<" + stepVo.getJobWriterContext().get("MaxCountperResource") + "<" + stepVo.getJobWriterContext().get("iBatisStatement") + "<" + stepVo.getJobWriterContext().get("ConfigurationFile") + "<" + stepVo.getJobWriterContext().get("Sql") + "<" + stepVo.getJobWriterContext().get("RowMapper") + "<" + stepVo.getJobWriterContext().get("PageSize") + "<" + stepVo.getJobWriterContext().get("Sql-SortColumn") + "<" + stepVo.getJobWriterContext().get("Sql-SELECT") + "<" + stepVo.getJobWriterContext().get("Sql-FROM") + "<" + stepVo.getJobWriterContext().get("Sql-WHERE") + "<" + stepVo.getJobWriterContext().get("Sql-Update") + "<" + stepVo.getJobWriterContext().get("Sql-Insert") + "<" + stepVo.getJobWriterContext().get("Params") + "<" + stepVo.getJobWriterContext().get("RowSetter") + "<" + stepVo.getJobWriterContext().get("DatabaseType") + "<" + stepVo.getJobWriterContext().get("DatasourceBeanID") + "<" + this.projectName);
        chunk.setAttribute("commit-interval", stepVo.getCommitInterval().toString());
        Element listeners = new Element("listeners");
        chunk.addContent((Content)listeners);
        Element fileListener = new Element("listener");
        listeners.addContent((Content)fileListener);
        fileListener.setAttribute("ref", String.valueOf(prefix) + ".fileNameListener");
        if (stepVo.getChunkListenerInfoList() != null && stepVo.getChunkListenerInfoList().length > 0) {
            Element chunkListener = null;
            int m = 0;
            while (m < stepVo.getChunkListenerInfoList().length) {
                chunkListener = new Element("listener");
                listeners.addContent((Content)chunkListener);
                chunkListener.setAttribute("ref", stepVo.getChunkListenerInfoList()[m].getName());
                String tempId = stepVo.getChunkListenerInfoList()[m].getName();
                String tempClass = stepVo.getChunkListenerInfoList()[m].getClassValue();
                this.beanMap.put("chunkListener" + tempId, String.valueOf(tempId) + "<" + tempClass);
                ++m;
            }
        }
        Element stepListeners = null;
        if (stepVo.getStepListenerInfoList() != null && stepVo.getStepListenerInfoList().length > 0) {
            stepListeners = new Element("listeners");
            partitionerStep.addContent((Content)stepListeners);
            Element stepListener = null;
            int m = 0;
            while (m < stepVo.getStepListenerInfoList().length) {
                stepListener = new Element("listener");
                stepListeners.addContent((Content)stepListener);
                stepListener.setAttribute("ref", stepVo.getStepListenerInfoList()[m].getName());
                String tempId = stepVo.getStepListenerInfoList()[m].getName();
                String tempClass = stepVo.getStepListenerInfoList()[m].getClassValue();
                this.beanMap.put("stepListener" + tempId, String.valueOf(tempId) + "<" + tempClass);
                ++m;
            }
        }
        if (jobVo.getJobName().equals(stepVo.getJobName()) && jobVo.getSharedValues().length > 0) {
            Element sharedValueListener = null;
            Element sharedValuesListBean = null;
            int i = 0;
            while (i < jobVo.getSharedValues().length) {
                if (stepVo.getName().equals(jobVo.getSharedValues()[i].getStepId())) {
                    if (stepListeners == null) {
                        stepListeners = new Element("listeners");
                        partitionerStep.addContent((Content)stepListeners);
                    }
                    sharedValueListener = new Element("listener");
                    stepListeners.addContent((Content)sharedValueListener);
                    Element sharedValuesBean = new Element("bean", Namespace.getNamespace((String)"http://www.springframework.org/schema/beans"));
                    sharedValueListener.addContent((Content)sharedValuesBean);
                    sharedValuesBean.setAttribute("class", "org.springframework.batch.core.listener.ExecutionContextPromotionListener");
                    Element sharedValuesPropertyBean = new Element("property");
                    sharedValuesBean.addContent((Content)sharedValuesPropertyBean);
                    sharedValuesPropertyBean.setAttribute("name", "keys");
                    sharedValuesListBean = new Element("list");
                    sharedValuesPropertyBean.addContent((Content)sharedValuesListBean);
                    break;
                }
                ++i;
            }
            i = 0;
            while (i < jobVo.getSharedValues().length) {
                if (stepVo.getName().equals(jobVo.getSharedValues()[i].getStepId()) && sharedValuesListBean != null) {
                    Element sharedValuesValueBean = new Element("value");
                    sharedValuesValueBean.setText(jobVo.getSharedValues()[i].getKey());
                }
                ++i;
            }
        }
    }

    private void appendBeanElement(Element beansElement) {
        this.orderedMap.putAll(this.beanMap);
        Set<String> orderedMapKey = this.orderedMap.keySet();
        Object[] keyArray = orderedMapKey.toArray();
        int i = 0;
        while (i < this.orderedMap.size()) {
            String[] value;
            String key = (String)keyArray[i];
            Element bean = new Element("bean");
            beansElement.addContent((Content)bean);
            if (key.contains("jobListener")) {
                value = this.orderedMap.get(key).split("<");
                bean.setAttribute("id", value[0]);
                bean.setAttribute("class", value[1]);
            } else if (key.contains("jobReader")) {
                this.appendJobReader(key, bean, beansElement);
            } else if (key.contains("jobWriter")) {
                this.appendJobWriter(key, bean, beansElement);
            } else if (key.contains("partitioner")) {
                value = this.orderedMap.get(key).split("<");
                bean.setAttribute("id", value[0]);
                bean.setAttribute("class", value[1]);
                Element partitionerBean = new Element("property");
                bean.addContent((Content)partitionerBean);
                if (value[1].contains("Multi")) {
                    partitionerBean.setAttribute("name", "resources");
                    partitionerBean.setAttribute("value", value[2]);
                } else {
                    partitionerBean.setAttribute("name", "dataSource");
                    partitionerBean.setAttribute("ref", "dataSource");
                }
            } else if (key.contains("fileNameListener")) {
                value = this.orderedMap.get(key).split("<");
                bean.setAttribute("id", value[0]);
                bean.setAttribute("class", value[1]);
                bean.setAttribute("scope", "step");
                Element fileNameListenerBean = new Element("property");
                bean.addContent((Content)fileNameListenerBean);
                fileNameListenerBean.setAttribute("name", "path");
                if (System.getProperty("os.name").contains("Windows")) {
                    fileNameListenerBean.setAttribute("value", "file:" + System.getProperty("user.home") + "\\");
                } else {
                    fileNameListenerBean.setAttribute("value", "file:" + System.getProperty("user.home") + "/");
                }
            } else if (key.contains("stepListener")) {
                value = this.orderedMap.get(key).split("<");
                bean.setAttribute("id", value[0]);
                bean.setAttribute("class", value[1]);
            } else if (key.contains("chunkListener")) {
                value = this.orderedMap.get(key).split("<");
                bean.setAttribute("id", value[0]);
                bean.setAttribute("class", value[1]);
            } else if (key.contains("sharedValueListener")) {
                value = this.orderedMap.get(key).split("<");
                bean.setAttribute("id", "sharedValueListener");
                bean.setAttribute("class", "org.springframework.batch.core.listener.ExecutionContextPromotionListener");
                Element property = new Element("property");
                bean.addContent((Content)property);
                property.setAttribute("name", value[0]);
                property.setAttribute("value", value[1]);
            } else if (key.contains("decider")) {
                value = this.orderedMap.get(key).split("<");
                bean.setAttribute("id", value[0]);
                bean.setAttribute("class", value[1]);
            }
            ++i;
        }
    }

    private void appendJobReader(String key, Element bean, Element beansElement) {
        String[] value = this.orderedMap.get(key).split("<");
        AppendBatchReaderWriterBeanOperation.appendReader(bean, beansElement, value);
    }

    private void appendJobWriter(String key, Element bean, Element beansElement) {
        String[] value = this.orderedMap.get(key).split("<");
        AppendBatchReaderWriterBeanOperation.appendWriter(bean, beansElement, value);
    }

    private void findStartingStep(Element job) {
        List stepList = job.getChildren("step");
        List decisionList = job.getChildren("decision");
        ArrayList<String> nextList = new ArrayList<String>();
        Element startingStep = null;
        int index = 0;
        while (index < stepList.size()) {
            if (((Element)stepList.get(index)).getAttributeValue("next") != null) {
                nextList.add(((Element)stepList.get(index)).getAttributeValue("next"));
            }
            ++index;
        }
        index = 0;
        while (index < decisionList.size()) {
            List decisionNextList = ((Element)decisionList.get(index)).getChildren("next");
            if (decisionNextList != null && decisionNextList.size() > 0) {
                int innerIndex = 0;
                while (innerIndex < decisionNextList.size()) {
                    nextList.add(((Element)decisionNextList.get(innerIndex)).getAttributeValue("to"));
                    ++innerIndex;
                }
            }
            ++index;
        }
        index = 0;
        while (index < stepList.size()) {
            if (!(nextList.contains(((Element)stepList.get(index)).getAttributeValue("id")) || ((Element)stepList.get(index)).getAttributeValue("next") == null && ((Element)stepList.get(index)).getChildren("next").size() <= 0)) {
                startingStep = ((Element)stepList.get(index)).detach();
            }
            ++index;
        }
        if (startingStep != null) {
            job.addContent(0, startingStep);
        }
    }

    private void updateNextToAttribute(Element job) {
        List stepList = job.getChildren("step");
        List decisionList = job.getChildren("decision");
        Element step = null;
        String decisionName = null;
        int index = 0;
        while (index < stepList.size()) {
            step = (Element)stepList.get(index);
            int innerIndex2 = 0;
            while (innerIndex2 < decisionList.size()) {
                decisionName = ((Element)decisionList.get(innerIndex2)).getAttributeValue("id");
                if (step.getAttributeValue("next") != null && decisionName.equals(step.getAttributeValue("next"))) {
                    ((Element)job.getChildren("step").get(index)).removeAttribute("next");
                    Element next = new Element("next");
                    ((Element)job.getChildren("step").get(index)).addContent(1, (Content)next);
                    next.setAttribute("on", "*");
                    next.setAttribute("to", decisionName);
                }
                ++innerIndex2;
            }
            ++index;
        }
    }
}

