/*
 * Decompiled with CFR 0.152.
 */
package egovframework.bdev.imp.batch.wizards.jobcreation.pages;

import egovframework.bdev.imp.batch.EgovBatchPlugin;
import egovframework.bdev.imp.batch.common.BatchMessages;
import egovframework.bdev.imp.batch.wizards.com.FindXMLFileBeanIdValueUtil;
import egovframework.bdev.imp.batch.wizards.jobcreation.model.BatchJobBeanIDList;
import egovframework.bdev.imp.batch.wizards.jobcreation.model.BatchJobCreationContext;
import egovframework.bdev.imp.batch.wizards.jobcreation.model.BatchXMLFileBeanIDList;
import egovframework.bdev.imp.batch.wizards.jobcreation.model.DecisionVo;
import egovframework.bdev.imp.batch.wizards.jobcreation.model.JobVo;
import egovframework.bdev.imp.batch.wizards.jobcreation.model.NextVo;
import egovframework.bdev.imp.batch.wizards.jobcreation.model.SharedValueVo;
import egovframework.bdev.imp.batch.wizards.jobcreation.model.StepAndDecisionVo;
import egovframework.bdev.imp.batch.wizards.jobcreation.model.StepVo;
import egovframework.bdev.imp.batch.wizards.jobcreation.pages.DecisionInfoContentsConstructor;
import egovframework.bdev.imp.batch.wizards.jobcreation.pages.JobInfoContentsConstructor;
import egovframework.bdev.imp.batch.wizards.jobcreation.pages.StepInfoContentsConstructor;
import egovframework.bdev.imp.batch.wizards.jobcreation.views.ListProvider;
import egovframework.dev.imp.core.utils.BatchTableColumn;
import egovframework.dev.imp.core.utils.NullUtil;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class BatchJobCreationCustomizePage
extends WizardPage {
    private final String DEFAULT = "\uc120\ud0dd";
    private final String STEP = "Step";
    private final String DECISION = "Decision";
    private BatchJobCreationContext context = null;
    private List<String> projectBeanIDList = null;
    private BatchXMLFileBeanIDList batchXMLFileBeanIDList = null;
    private TableViewer jobListTable = null;
    private Button jobAddButton = null;
    private Button jobRemoveButton = null;
    private TableViewer stepAndDecisionListTable = null;
    private Button stepAndDecisionAdd = null;
    private Button stepAndDecisionRemove = null;
    JobInfoContentsConstructor jobInfoControl = null;
    StepInfoContentsConstructor stepInfoControl = null;
    DecisionInfoContentsConstructor decisionInfoControl = null;
    private String currentInfo = "\uc120\ud0dd";
    private Label infoLabel = null;
    private Combo stepAndDecisionCombo = null;
    private Composite infoContents = null;
    private Button restoreDefaultsButton = null;
    private Button applyButton = null;
    Listener jobAddButtonListener = new Listener(){

        public void handleEvent(Event event) {
            BatchJobCreationCustomizePage.this.setMessage(BatchMessages.BatchJobCreationCustomizePage_SHOW_NEW_JOB_INFO);
            BatchJobCreationCustomizePage.this.jobListTable.setSelection((ISelection)new StructuredSelection());
            BatchJobCreationCustomizePage.this.stepAndDecisionListTable.setSelection((ISelection)new StructuredSelection());
            BatchJobCreationCustomizePage.this.stepAndDecisionListTable.setInput(null);
            BatchJobCreationCustomizePage.this.refreshInfoToJob(null);
            BatchJobCreationCustomizePage.this.jobAddButton.setEnabled(false);
            BatchJobCreationCustomizePage.this.jobRemoveButton.setEnabled(false);
            BatchJobCreationCustomizePage.this.stepAndDecisionAdd.setEnabled(false);
            BatchJobCreationCustomizePage.this.stepAndDecisionRemove.setEnabled(false);
            BatchJobCreationCustomizePage.this.applyButton.setEnabled(false);
        }
    };
    Listener jobRemoveButtonListener = new Listener(){

        public void handleEvent(Event event) {
            JobVo selectJobVo = BatchJobCreationCustomizePage.this.getJobListSelection();
            if (!NullUtil.isNull((Object)selectJobVo)) {
                String message;
                if (!NullUtil.isEmpty((Object[])selectJobVo.getStepAndDecisionVoList()) ? !BatchJobCreationCustomizePage.this.openConfirmDialog(BatchMessages.BatchJobCreationCustomizePage_DELETE_BUTTON_DIALOG_TITLE, message = String.valueOf(selectJobVo.getJobName()) + BatchMessages.BatchJobCreationCustomizePage_CONFIRM_DELETE_JOB_HAVING_STEP_DECISION) : !BatchJobCreationCustomizePage.this.openConfirmDialog(BatchMessages.BatchJobCreationCustomizePage_DELETE_BUTTON_DIALOG_TITLE, message = String.valueOf(selectJobVo.getJobName()) + BatchMessages.BatchJobCreationCustomizePage_CONFIRM_DELETE_JOB_WITHOUT_STEP_DECISION)) {
                    return;
                }
                BatchJobCreationCustomizePage.this.batchXMLFileBeanIDList.removeJobBeanIDList(selectJobVo.getJobName());
                BatchJobCreationCustomizePage.this.jobListTable.remove((Object)selectJobVo);
                BatchJobCreationCustomizePage.this.jobAddButton.notifyListeners(13, new Event());
                BatchJobCreationCustomizePage.this.setPageComplete(BatchJobCreationCustomizePage.this.canFinishButtonEnable());
            }
        }
    };
    Listener jobListTableListener = new Listener(){

        public void handleEvent(Event event) {
            JobVo selectJobVo = BatchJobCreationCustomizePage.this.getJobListSelection();
            BatchJobCreationCustomizePage.this.deselectStepDecisionList();
            BatchJobCreationCustomizePage.this.setMessage(BatchMessages.BatchJobCreationCustomizePage_SELECT_JOB);
            if (!NullUtil.isNull((Object)selectJobVo)) {
                BatchJobCreationCustomizePage.this.stepAndDecisionListTable.setInput((Object)selectJobVo.getStepAndDecisionVoList());
                BatchJobCreationCustomizePage.this.refreshInfoToJob(selectJobVo);
                BatchJobCreationCustomizePage.this.jobAddButton.setEnabled(true);
                BatchJobCreationCustomizePage.this.jobRemoveButton.setEnabled(true);
                BatchJobCreationCustomizePage.this.stepAndDecisionAdd.setEnabled(true);
                BatchJobCreationCustomizePage.this.stepAndDecisionRemove.setEnabled(false);
                BatchJobCreationCustomizePage.this.applyButton.setEnabled(true);
            }
            BatchJobCreationCustomizePage.this.setPageComplete(BatchJobCreationCustomizePage.this.canFinishButtonEnable());
        }
    };
    Listener jobApplyButtonListener = new Listener(){

        public void handleEvent(Event event) {
            JobVo selectJobVo = BatchJobCreationCustomizePage.this.getJobListSelection();
            JobVo newJobVo = BatchJobCreationCustomizePage.this.jobInfoControl.getJobVo();
            if (!NullUtil.isNull((Object)selectJobVo)) {
                if (BatchJobCreationCustomizePage.this.openConfirmDialog(BatchMessages.BatchJobCreationCustomizePage_APPLY_BUTTON_DIALOG_TITLE, BatchMessages.BatchJobCreationCustomizePage_CONFIRM_UPDATE)) {
                    BatchJobCreationCustomizePage.this.updateJobVoAndBeanIDList(selectJobVo, newJobVo);
                }
            } else {
                BatchJobCreationCustomizePage.this.addNewJobVoAndBeanIDList(newJobVo);
            }
            BatchJobCreationCustomizePage.this.jobListTableListener.handleEvent(new Event());
            BatchJobCreationCustomizePage.this.setPageComplete(BatchJobCreationCustomizePage.this.canFinishButtonEnable());
        }
    };
    Listener jobRestoreButtonListener = new Listener(){

        public void handleEvent(Event event) {
            String message = BatchMessages.BatchJobCreationCustomizePage_RESTORE_DEFAULT_CONFIRM_MESSAGE;
            if (BatchJobCreationCustomizePage.this.openConfirmDialog(BatchMessages.BatchJobCreationCustomizePage_RESTORE_DEFAULT_BUTTON_DIALOG_TITLE, message)) {
                if (NullUtil.isNull((Object)BatchJobCreationCustomizePage.this.getJobListSelection())) {
                    BatchJobCreationCustomizePage.this.jobAddButtonListener.handleEvent(new Event());
                } else {
                    BatchJobCreationCustomizePage.this.jobListTableListener.handleEvent(new Event());
                }
            }
        }
    };
    Listener stepAndDecisionListTableListener = new Listener(){

        public void handleEvent(Event event) {
            JobVo selectJobVo = BatchJobCreationCustomizePage.this.getJobListSelection();
            StepAndDecisionVo selectSDVo = BatchJobCreationCustomizePage.this.getStepDecisionListSelection();
            if (!NullUtil.isNull((Object)selectSDVo)) {
                if (selectSDVo instanceof StepVo) {
                    BatchJobCreationCustomizePage.this.setMessage(BatchMessages.BatchJobCreationCustomizePage_SELETE_STEP);
                    BatchJobCreationCustomizePage.this.refreshInfoToStep(selectJobVo, (StepVo)selectSDVo);
                } else if (selectSDVo instanceof DecisionVo) {
                    BatchJobCreationCustomizePage.this.setMessage(BatchMessages.BatchJobCreationCustomizePage_SELECT_DECISION);
                    BatchJobCreationCustomizePage.this.refreshInfoToDecision(selectJobVo, (DecisionVo)selectSDVo);
                }
                BatchJobCreationCustomizePage.this.stepAndDecisionCombo.setVisible(true);
                BatchJobCreationCustomizePage.this.stepAndDecisionCombo.setEnabled(false);
                BatchJobCreationCustomizePage.this.jobRemoveButton.setEnabled(false);
                BatchJobCreationCustomizePage.this.stepAndDecisionRemove.setEnabled(true);
                BatchJobCreationCustomizePage.this.restoreDefaultsButton.setEnabled(true);
            }
            BatchJobCreationCustomizePage.this.setPageComplete(BatchJobCreationCustomizePage.this.canFinishButtonEnable());
        }
    };
    Listener stepAndDecisionApplyButtonListener = new Listener(){

        public void handleEvent(Event event) {
            JobVo selectJobVo = BatchJobCreationCustomizePage.this.getJobListSelection();
            StepAndDecisionVo selectSDVo = BatchJobCreationCustomizePage.this.getStepDecisionListSelection();
            if ("Decision".equals(BatchJobCreationCustomizePage.this.stepAndDecisionCombo.getText())) {
                this.applyDecisionAndBeanIDList(selectJobVo, selectSDVo);
            } else if ("Step".equals(BatchJobCreationCustomizePage.this.stepAndDecisionCombo.getText())) {
                this.applyStepAndBeanIDList(selectJobVo, selectSDVo);
            }
            BatchJobCreationCustomizePage.this.stepAndDecisionCombo.setEnabled(false);
            BatchJobCreationCustomizePage.this.setPageComplete(BatchJobCreationCustomizePage.this.canFinishButtonEnable());
            BatchJobCreationCustomizePage.this.stepAndDecisionListTableListener.handleEvent(null);
        }

        private void applyDecisionAndBeanIDList(JobVo selectJobVo, StepAndDecisionVo selectSDVo) {
            DecisionVo newDecisionVo = BatchJobCreationCustomizePage.this.decisionInfoControl.getDecisionVo();
            if (NullUtil.isNull((Object)selectSDVo)) {
                this.openNewDecisionApplyInformDialog();
                this.addNewDecisionVOAndbeanIDList(selectJobVo, newDecisionVo);
            } else {
                this.updateDecisionVoAndBeanIDList(selectJobVo, (DecisionVo)selectSDVo, newDecisionVo);
            }
        }

        private void openNewDecisionApplyInformDialog() {
            String informMessage = BatchMessages.BatchJobCreationCustomizePage_INFORM_AFTER_ADD_DICISION;
            MessageDialog.openInformation((Shell)BatchJobCreationCustomizePage.this.getShell(), (String)BatchMessages.BatchJobCreationCustomizePage_INFORM_AFTER_ADD_DICISION_DIALOG_TITLE, (String)informMessage);
        }

        private void addNewDecisionVOAndbeanIDList(JobVo selectJobVo, DecisionVo newDecisionVo) {
            this.addNewStepAndDecisionVo(selectJobVo, newDecisionVo);
            BatchJobCreationCustomizePage.this.batchXMLFileBeanIDList.addDecisionVoBeanIDList(selectJobVo, newDecisionVo);
            BatchJobCreationCustomizePage.this.setMessage(BatchMessages.BatchJobCreationCustomizePage_ADD_DECISION);
        }

        private void addNewStepAndDecisionVo(JobVo selectJobVo, StepAndDecisionVo newSDVo) {
            BatchJobCreationCustomizePage.this.stepAndDecisionListTable.add((Object)newSDVo);
            selectJobVo.setStepAndDecisionVoList(BatchJobCreationCustomizePage.this.getStepAndDecisionList());
            BatchJobCreationCustomizePage.this.selectStepAndDecisionVo(newSDVo.getName());
        }

        private void updateDecisionVoAndBeanIDList(JobVo selectJobVo, DecisionVo selectSDVo, DecisionVo newDecisionVo) {
            String postDecisionID;
            String preDecisionID = selectSDVo.getName();
            if (preDecisionID.equals(postDecisionID = newDecisionVo.getName())) {
                if (BatchJobCreationCustomizePage.this.openConfirmDialog(BatchMessages.BatchJobCreationCustomizePage_APPLY_BUTTON_DIALOG_TITLE, BatchMessages.BatchJobCreationCustomizePage_UPDATE_MESSAGE_2)) {
                    this.updateDecisionVoAndBeanIDListWhenIDNotChanged(selectJobVo, selectSDVo, newDecisionVo);
                }
            } else {
                this.updateDecisionVoAndBeanIDListWhenIDChanged(selectJobVo, selectSDVo, newDecisionVo, preDecisionID, postDecisionID);
            }
        }

        private void updateDecisionVoAndBeanIDListWhenIDNotChanged(JobVo selectJobVo, DecisionVo selectSDVo, DecisionVo newDecisionVo) {
            DecisionVo selectDecisionVo = selectSDVo;
            BatchJobCreationCustomizePage.this.batchXMLFileBeanIDList.updateDecisionVoBeanIDList(selectDecisionVo, selectJobVo, newDecisionVo);
            selectDecisionVo.copyValues(newDecisionVo);
            BatchJobCreationCustomizePage.this.stepAndDecisionListTable.update((Object)selectDecisionVo, null);
        }

        private void updateDecisionVoAndBeanIDListWhenIDChanged(JobVo selectJobVo, DecisionVo selectSDVo, DecisionVo newDecisionVo, String preDecisionID, String postDecisionID) {
            ArrayList refList = BatchJobCreationCustomizePage.this.getReferenceList(selectJobVo, selectSDVo);
            String message = BatchJobCreationCustomizePage.this.createRefDialogModifyString(selectSDVo.getName(), refList);
            if (BatchJobCreationCustomizePage.this.openConfirmDialog(BatchMessages.BatchJobCreationCustomizePage_APPLY_BUTTON_DIALOG_TITLE, message)) {
                this.updateDecisionVoAndBeanIDListWhenIDNotChanged(selectJobVo, selectSDVo, newDecisionVo);
                this.updateStepDecisionIDToRefList(preDecisionID, postDecisionID, refList);
            }
        }

        private void updateStepDecisionIDToRefList(String preID, String newID, ArrayList<StepAndDecisionVo> refList) {
            if (!NullUtil.isEmpty(refList)) {
                for (StepAndDecisionVo vo : refList) {
                    if (vo instanceof StepVo) {
                        this.updateStepDecisionIDToStepVo(preID, newID, (StepVo)vo);
                        continue;
                    }
                    if (!(vo instanceof DecisionVo)) continue;
                    this.updateStepDecisionIDToDecisionVo(preID, newID, (DecisionVo)vo);
                }
            }
        }

        private void updateStepDecisionIDToDecisionVo(String preStepID, String newStepID, DecisionVo refDecisionVo) {
            String stopRestart;
            Object[] nextVos = refDecisionVo.getNextVo();
            if (!NullUtil.isEmpty((Object[])nextVos)) {
                Object[] objectArray = nextVos;
                int n = nextVos.length;
                int n2 = 0;
                while (n2 < n) {
                    Object nextVo = objectArray[n2];
                    if (((NextVo)nextVo).getNextTo().equals(preStepID)) {
                        ((NextVo)nextVo).setNextTo(newStepID);
                    }
                    ++n2;
                }
            }
            if (!NullUtil.isEmpty((String)(stopRestart = refDecisionVo.getStopRestart())) && stopRestart.equals(preStepID)) {
                refDecisionVo.setStopRestart(newStepID);
            }
        }

        private void updateStepDecisionIDToStepVo(String preStepID, String newStepID, StepVo refStepVo) {
            String nextStepID = refStepVo.getNextStep();
            if (!NullUtil.isEmpty((String)nextStepID) && nextStepID.equals(preStepID)) {
                refStepVo.setNextStep(newStepID);
            }
        }

        private void applyStepAndBeanIDList(JobVo selectJobVo, StepAndDecisionVo selectSDVo) {
            StepVo newStepVo = BatchJobCreationCustomizePage.this.stepInfoControl.getStepVo();
            if (NullUtil.isNull((Object)selectSDVo)) {
                if (BatchJobCreationCustomizePage.this.stepAndDecisionListTable.getTable().getItemCount() > 0) {
                    this.openMoreTwoStepApplyInformDialog();
                }
                this.addNewStepVoAndBeanIDList(selectJobVo, newStepVo);
            } else {
                this.updateStepVoAndBeanIDList(selectJobVo, (StepVo)selectSDVo, newStepVo);
            }
        }

        private void openMoreTwoStepApplyInformDialog() {
            MessageDialog.openInformation((Shell)BatchJobCreationCustomizePage.this.getShell(), (String)BatchMessages.BatchJobCreationCustomizePage_INFORM_AFTER_ADD_MORE_TWO_STEPS_DIALOG_TITLE, (String)BatchMessages.BatchJobCreationCustomizePage_INFORM_AFTER_ADD_MORE_TWO_STEPS);
        }

        private void addNewStepVoAndBeanIDList(JobVo selectJobVo, StepVo newStepVo) {
            this.addNewStepAndDecisionVo(selectJobVo, newStepVo);
            BatchJobCreationCustomizePage.this.batchXMLFileBeanIDList.addStepVoBeanIDList(selectJobVo, newStepVo);
            selectJobVo.setSharedValues(BatchJobCreationCustomizePage.this.stepInfoControl.applyStepIDToSharedVoAndGetList(newStepVo.getName()));
            BatchJobCreationCustomizePage.this.setMessage(BatchMessages.BatchJobCreationCustomizePage_ADD_STEP);
        }

        private void updateStepVoAndBeanIDList(JobVo selectJobVo, StepVo selectSDVo, StepVo newStepVo) {
            String postStepID;
            String preStepID = selectSDVo.getName();
            if (preStepID.equals(postStepID = newStepVo.getName())) {
                if (BatchJobCreationCustomizePage.this.openConfirmDialog(BatchMessages.BatchJobCreationCustomizePage_APPLY_BUTTON_DIALOG_TITLE, BatchMessages.BatchJobCreationCustomizePage_UPDATE_MESSAGE_2)) {
                    this.updateStepVoAndBeanIDListWhenIDNotChanged(selectJobVo, selectSDVo, newStepVo, preStepID, postStepID);
                }
            } else {
                this.updateStepVoAndBeanIDListWhenIDChanged(selectJobVo, selectSDVo, newStepVo, preStepID, postStepID);
            }
        }

        private void updateStepVoAndBeanIDListWhenIDNotChanged(JobVo selectJobVo, StepVo selectSDVo, StepVo newStepVo, String preStepID, String postStepID) {
            StepVo selectStepVo = selectSDVo;
            BatchJobCreationCustomizePage.this.batchXMLFileBeanIDList.updateStepVoBeanIDList(selectStepVo, selectJobVo, newStepVo);
            selectStepVo.copyValues(newStepVo);
            BatchJobCreationCustomizePage.this.stepAndDecisionListTable.update((Object)selectStepVo, null);
            selectJobVo.setSharedValues(BatchJobCreationCustomizePage.this.stepInfoControl.updateStepIDToSharedValueVoAndGetList(preStepID, postStepID));
        }

        private void updateStepVoAndBeanIDListWhenIDChanged(JobVo selectJobVo, StepVo selectSDVo, StepVo newStepVo, String preStepID, String postStepID) {
            ArrayList refList = BatchJobCreationCustomizePage.this.getReferenceList(selectJobVo, selectSDVo);
            String message = BatchJobCreationCustomizePage.this.createRefDialogModifyString(selectSDVo.getName(), refList);
            if (BatchJobCreationCustomizePage.this.openConfirmDialog(BatchMessages.BatchJobCreationCustomizePage_APPLY_BUTTON_DIALOG_TITLE, message)) {
                this.updateStepVoAndBeanIDListWhenIDNotChanged(selectJobVo, selectSDVo, newStepVo, preStepID, postStepID);
                this.updateStepDecisionIDToRefList(preStepID, newStepVo.getName(), refList);
            }
        }
    };
    Listener stepAndDecisionRestoreButtonListener = new Listener(){

        public void handleEvent(Event event) {
            String message = BatchMessages.BatchJobCreationCustomizePage_RESTORE_DEFAULT_CONFIRM_MESSAGE;
            if (!BatchJobCreationCustomizePage.this.openConfirmDialog(BatchMessages.BatchJobCreationCustomizePage_RESTORE_DEFAULT_BUTTON_DIALOG_TITLE, message)) {
                return;
            }
            StepAndDecisionVo selectSDVo = BatchJobCreationCustomizePage.this.getStepDecisionListSelection();
            if (NullUtil.isNull((Object)selectSDVo)) {
                BatchJobCreationCustomizePage.this.stepAndDecisionCombo.notifyListeners(13, new Event());
            } else {
                BatchJobCreationCustomizePage.this.stepAndDecisionListTableListener.handleEvent(new Event());
            }
        }
    };
    Listener stepAndDecisionAddButtonListener = new Listener(){

        public void handleEvent(Event event) {
            BatchJobCreationCustomizePage.this.setPageComplete(false);
            BatchJobCreationCustomizePage.this.deselectStepDecisionList();
            BatchJobCreationCustomizePage.this.setMessage(BatchMessages.BatchJobCreationCustomizePage_SHOW_NEW_STEP_DECISION_INFO, 0);
            BatchJobCreationCustomizePage.this.infoLabel.setText("");
            BatchJobCreationCustomizePage.this.clearInfoContentsAndButtonListenerAndMessage();
            BatchJobCreationCustomizePage.this.createStepDecisionAddButtonSelectInfoContents();
            BatchJobCreationCustomizePage.this.refreshInfoControl();
            BatchJobCreationCustomizePage.this.stepAndDecisionCombo.setVisible(true);
            BatchJobCreationCustomizePage.this.stepAndDecisionCombo.setEnabled(true);
            BatchJobCreationCustomizePage.this.stepAndDecisionCombo.setText("\uc120\ud0dd");
            if (BatchJobCreationCustomizePage.this.stepAndDecisionListTable.getTable().getItemCount() > 0) {
                BatchJobCreationCustomizePage.this.removeStepAndDecisionComboListener();
                BatchJobCreationCustomizePage.this.setEnableStepAndDecisionComboListener();
            } else {
                BatchJobCreationCustomizePage.this.removeStepAndDecisionComboListener();
                BatchJobCreationCustomizePage.this.atFirstStepComboListener();
            }
            BatchJobCreationCustomizePage.this.jobRemoveButton.setEnabled(false);
            BatchJobCreationCustomizePage.this.stepAndDecisionRemove.setEnabled(false);
            BatchJobCreationCustomizePage.this.applyButton.setEnabled(false);
            BatchJobCreationCustomizePage.this.restoreDefaultsButton.setEnabled(false);
            BatchJobCreationCustomizePage.this.stepAndDecisionListTable.setSelection(null);
        }
    };
    Listener stepAndDecisionRemoveTableViewerListener = new Listener(){

        public void handleEvent(Event event) {
            JobVo selectJobVo = BatchJobCreationCustomizePage.this.getJobListSelection();
            StepAndDecisionVo selectStepAndDecisionVo = BatchJobCreationCustomizePage.this.getStepDecisionListSelection();
            ArrayList refMemberList = BatchJobCreationCustomizePage.this.getReferenceList(selectJobVo, selectStepAndDecisionVo);
            String message = BatchJobCreationCustomizePage.this.createRefDialogRemoveString(selectStepAndDecisionVo.getName(), refMemberList);
            if (!BatchJobCreationCustomizePage.this.openConfirmDialog(BatchMessages.BatchJobCreationCustomizePage_REMOVE_STEP_DECISION_DIALOG_TITLE, message)) {
                return;
            }
            if (!NullUtil.isNull((Object)selectStepAndDecisionVo)) {
                BatchJobBeanIDList jobBeanList = BatchJobCreationCustomizePage.this.batchXMLFileBeanIDList.getJobBeanIDList(selectJobVo.getJobName());
                jobBeanList.removeStepDecision(selectStepAndDecisionVo.getName());
                this.removeStepDecisionIDToRefList(selectStepAndDecisionVo.getName(), refMemberList);
                BatchJobCreationCustomizePage.this.stepAndDecisionListTable.remove((Object)selectStepAndDecisionVo);
                selectJobVo.setStepAndDecisionVoList(BatchJobCreationCustomizePage.this.getStepAndDecisionList());
                BatchJobCreationCustomizePage.this.stepAndDecisionRemove.setEnabled(false);
                if (selectStepAndDecisionVo instanceof StepVo) {
                    StepVo removedStepVo = (StepVo)selectStepAndDecisionVo;
                    this.updateSharedValueVo(selectJobVo, removedStepVo.getName());
                }
                BatchJobCreationCustomizePage.this.stepAndDecisionAdd.notifyListeners(13, new Event());
            }
            BatchJobCreationCustomizePage.this.setPageComplete(BatchJobCreationCustomizePage.this.canFinishButtonEnable());
        }

        private void removeStepDecisionIDToRefList(String preID, ArrayList<StepAndDecisionVo> refList) {
            if (!NullUtil.isEmpty(refList)) {
                for (StepAndDecisionVo vo : refList) {
                    if (vo instanceof StepVo) {
                        this.updateRefStepVo(preID, (StepVo)vo);
                        continue;
                    }
                    if (!(vo instanceof DecisionVo)) continue;
                    this.updateRefDecisionVo(preID, (DecisionVo)vo);
                }
            }
        }

        private void updateRefDecisionVo(String removedID, DecisionVo refDecisionVo) {
            NextVo[] nextVosExceptRefID = this.getNextVoListExceptRefID(removedID, refDecisionVo);
            refDecisionVo.setNextVo(nextVosExceptRefID);
            this.updateStopOnTo(removedID, refDecisionVo);
        }

        private NextVo[] getNextVoListExceptRefID(String preStepID, DecisionVo refDecisionVo) {
            ArrayList<Object> updateNextVos = new ArrayList<Object>();
            Object[] nextVos = refDecisionVo.getNextVo();
            if (!NullUtil.isEmpty((Object[])nextVos)) {
                Object[] objectArray = nextVos;
                int n = nextVos.length;
                int n2 = 0;
                while (n2 < n) {
                    Object nextVo = objectArray[n2];
                    if (!((NextVo)nextVo).getNextTo().equals(preStepID)) {
                        updateNextVos.add(nextVo);
                    }
                    ++n2;
                }
            }
            return updateNextVos.toArray(new NextVo[0]);
        }

        private void updateStopOnTo(String removedID, DecisionVo refDecisionVo) {
            String stopRestart = refDecisionVo.getStopRestart();
            if (!NullUtil.isEmpty((String)stopRestart) && stopRestart.equals(removedID)) {
                refDecisionVo.setStopOn("");
                refDecisionVo.setStopRestart("");
            }
        }

        private void updateRefStepVo(String preStepID, StepVo refStepVo) {
            String nextStepID = refStepVo.getNextStep();
            if (!NullUtil.isEmpty((String)nextStepID) && nextStepID.equals(preStepID)) {
                refStepVo.setNextStep("");
            }
        }

        private void updateSharedValueVo(JobVo selectJobVo, String removedStepID) {
            Object[] sharedValueVoList = selectJobVo.getSharedValues();
            ArrayList<Object> afterRemovedSVVoList = new ArrayList<Object>();
            if (!NullUtil.isEmpty((Object[])sharedValueVoList)) {
                Object[] objectArray = sharedValueVoList;
                int n = sharedValueVoList.length;
                int n2 = 0;
                while (n2 < n) {
                    Object svVo = objectArray[n2];
                    String svVoStepID = ((SharedValueVo)svVo).getStepId();
                    if (!svVoStepID.equals(removedStepID)) {
                        afterRemovedSVVoList.add(svVo);
                    }
                    ++n2;
                }
            }
            sharedValueVoList = afterRemovedSVVoList.toArray(new SharedValueVo[0]);
            selectJobVo.setSharedValues((SharedValueVo[])sharedValueVoList);
        }
    };

    public BatchJobCreationCustomizePage(String pageName, BatchJobCreationContext context) {
        super(pageName);
        this.context = context;
        this.setTitle(BatchMessages.BatchJobCreationCustomizePage_TITLE);
        this.setDescription(BatchMessages.BatchJobCreationCustomizePage_DESCRIPTION);
    }

    public void createControl(Composite parent) {
        Group outerGroup = new Group(parent, 0);
        outerGroup.setLayout((Layout)new GridLayout(3, false));
        outerGroup.setLayoutData((Object)new GridData());
        this.removeMarginOfGridLayout((Composite)outerGroup);
        this.jobPartControl((Composite)outerGroup);
        this.stepPartControl((Composite)outerGroup);
        this.infoPartControl((Composite)outerGroup);
        this.setPageComplete(false);
        this.setControl((Control)outerGroup);
    }

    private void jobPartControl(Composite control) {
        Group innerPart = new Group(control, 0);
        innerPart.setLayout((Layout)new GridLayout());
        innerPart.setLayoutData((Object)new GridData(1040));
        innerPart.setText(BatchMessages.BatchJobCreationCustomizePage_JOB_LIST_GROUP);
        this.jobListTable = this.createAndGetListTable((Composite)innerPart, this.jobListTableListener);
        this.createJobListTableButtonsControl((Composite)innerPart);
    }

    private void stepPartControl(Composite control) {
        Group innerPart = new Group(control, 0);
        innerPart.setLayout((Layout)new GridLayout());
        innerPart.setLayoutData((Object)new GridData(1040));
        innerPart.setText(BatchMessages.BatchJobCreationCustomizePage_STEP_DECISION_LIST_GROUP);
        this.stepAndDecisionListTable = this.createAndGetListTable((Composite)innerPart, this.stepAndDecisionListTableListener);
        this.createStepDecisionListTableButtonsControl((Composite)innerPart);
    }

    private TableViewer createAndGetListTable(Composite control, Listener tableListener) {
        TableViewer tableViewer = new TableViewer(control, 68352);
        Table table = tableViewer.getTable();
        table.setHeaderVisible(false);
        table.setLinesVisible(false);
        tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        tableViewer.setLabelProvider((IBaseLabelProvider)new ListProvider());
        BatchTableColumn column = new BatchTableColumn("NO_COLUMN_NAME", 120, 16384);
        column.setColumnToTable(table);
        GridData gData = new GridData(1040);
        gData.widthHint = 105;
        tableViewer.getControl().setLayoutData((Object)gData);
        table.addListener(13, tableListener);
        return tableViewer;
    }

    private void createJobListTableButtonsControl(Composite control) {
        Composite buttonControl = new Composite(control, 0);
        buttonControl.setLayout((Layout)new GridLayout(2, true));
        buttonControl.setLayoutData((Object)new GridData());
        this.removeMarginOfGridLayout(buttonControl);
        this.jobAddButton = new Button(buttonControl, 8);
        this.jobAddButton.setLayoutData((Object)new GridData(768));
        this.jobAddButton.setText(BatchMessages.BatchJobCreationCustomizePage_ADD_BUTTON);
        this.jobAddButton.addListener(13, this.jobAddButtonListener);
        this.jobRemoveButton = new Button(buttonControl, 8);
        this.jobRemoveButton.setText(BatchMessages.BatchJobCreationCustomizePage_REMOVE_BUTTON);
        this.jobRemoveButton.addListener(13, this.jobRemoveButtonListener);
    }

    private void createStepDecisionListTableButtonsControl(Composite control) {
        Composite buttonControl = new Composite(control, 0);
        buttonControl.setLayout((Layout)new GridLayout(2, true));
        buttonControl.setLayoutData((Object)new GridData());
        this.removeMarginOfGridLayout(buttonControl);
        this.stepAndDecisionAdd = new Button(buttonControl, 8);
        this.stepAndDecisionAdd.setLayoutData((Object)new GridData(768));
        this.stepAndDecisionAdd.setText(BatchMessages.BatchJobCreationCustomizePage_ADD_BUTTON);
        this.stepAndDecisionAdd.addListener(13, this.stepAndDecisionAddButtonListener);
        this.stepAndDecisionRemove = new Button(buttonControl, 8);
        this.stepAndDecisionRemove.setText(BatchMessages.BatchJobCreationCustomizePage_REMOVE_BUTTON);
        this.stepAndDecisionRemove.addListener(13, this.stepAndDecisionRemoveTableViewerListener);
    }

    public void infoPartControl(Composite parent) {
        Group innerPart = new Group(parent, 0);
        innerPart.setLayout((Layout)new GridLayout());
        innerPart.setLayoutData((Object)new GridData(1808));
        this.removeMarginOfGridLayout((Composite)innerPart);
        innerPart.setText(BatchMessages.BatchJobCreationCustomizePage_INFO_GROUP);
        this.createInfoLabelAndDecisionComboControl((Composite)innerPart);
        this.createEmptyInfoContentsControl((Composite)innerPart);
        this.createInfoButtonsControl((Composite)innerPart);
    }

    private void createInfoLabelAndDecisionComboControl(Composite control) {
        Composite labelAndDecisionControl = new Composite(control, 0);
        labelAndDecisionControl.setLayout((Layout)new GridLayout(2, false));
        labelAndDecisionControl.setLayoutData((Object)new GridData(768));
        this.removeMarginOfGridLayout(labelAndDecisionControl);
        Composite labelControl = new Composite(labelAndDecisionControl, 0);
        labelControl.setLayout((Layout)new GridLayout());
        labelControl.setLayoutData((Object)new GridData());
        this.removeMarginOfGridLayout(labelControl);
        this.infoLabel = new Label(labelControl, 0);
        Composite decisionControl = new Composite(labelAndDecisionControl, 0);
        decisionControl.setLayout((Layout)new GridLayout());
        decisionControl.setLayoutData((Object)new GridData(896));
        this.removeMarginOfGridLayout(decisionControl);
        this.stepAndDecisionCombo = new Combo(decisionControl, 2056);
        this.stepAndDecisionCombo.setItems(new String[]{"\uc120\ud0dd", "Step", "Decision"});
    }

    private void createEmptyInfoContentsControl(Composite control) {
        Group infoContentsGroup = new Group(control, 0);
        infoContentsGroup.setLayout((Layout)new GridLayout());
        infoContentsGroup.setLayoutData((Object)new GridData(1808));
        this.removeMarginOfGridLayout((Composite)infoContentsGroup);
        this.infoContents = new Composite((Composite)infoContentsGroup, 0);
        this.infoContents.setLayout((Layout)new GridLayout());
        this.infoContents.setLayoutData((Object)new GridData(1808));
        this.removeMarginOfGridLayout(this.infoContents);
    }

    private void createInfoButtonsControl(Composite control) {
        Composite buttonControl = new Composite(control, 0);
        buttonControl.setLayout((Layout)new GridLayout(2, true));
        buttonControl.setLayoutData((Object)new GridData(896));
        this.removeMarginOfGridLayout(buttonControl);
        this.restoreDefaultsButton = new Button(buttonControl, 8);
        this.restoreDefaultsButton.setText(BatchMessages.BatchJobCreationCustomizePage_RESTORE_DEFAULT_BUTTON);
        this.restoreDefaultsButton.setLayoutData((Object)new GridData(768));
        this.applyButton = new Button(buttonControl, 8);
        this.applyButton.setText(BatchMessages.BatchJobCreationCustomizePage_APPLY_BUTTON);
        this.applyButton.setEnabled(false);
        this.applyButton.setLayoutData((Object)new GridData(768));
    }

    private void refreshInfoControl() {
        this.getControl().getParent().layout(true, true);
    }

    private void clearInfoContentsAndButtonListenerAndMessage() {
        Listener[] restoreButtonListener;
        Listener[] applyButtonListener;
        Control[] child = this.infoContents.getChildren();
        if (child != null && child.length > 0) {
            Control[] controlArray = child;
            int n = child.length;
            int n2 = 0;
            while (n2 < n) {
                Control data = controlArray[n2];
                data.dispose();
                ++n2;
            }
        }
        if ((applyButtonListener = this.applyButton.getListeners(13)) != null & (restoreButtonListener = this.restoreDefaultsButton.getListeners(13)) != null) {
            int i = 0;
            while (i < applyButtonListener.length) {
                this.applyButton.removeListener(13, applyButtonListener[i]);
                this.restoreDefaultsButton.removeListener(13, restoreButtonListener[i]);
                ++i;
            }
        }
        this.setErrorMessage(null);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            Point size = new Point(840, 785);
            this.getShell().setMinimumSize(size);
            this.getShell().setSize(size);
            this.batchXMLFileBeanIDList = new BatchXMLFileBeanIDList();
            this.projectBeanIDList = this.getProjectBeanIDList();
            this.jobInfoControl = new JobInfoContentsConstructor(this, this.infoContents, this.applyButton, this.batchXMLFileBeanIDList, this.projectBeanIDList);
            this.stepInfoControl = new StepInfoContentsConstructor(this, this.infoContents, this.applyButton, this.batchXMLFileBeanIDList, this.projectBeanIDList, this.context);
            this.decisionInfoControl = new DecisionInfoContentsConstructor(this, this.infoContents, this.applyButton, this.batchXMLFileBeanIDList, this.projectBeanIDList);
            this.refreshPage();
        }
        super.setVisible(visible);
    }

    private void refreshPage() {
        this.setMessage(null);
        this.jobAddButton.setEnabled(true);
        this.jobRemoveButton.setEnabled(false);
        this.jobListTable.setInput(null);
        this.stepAndDecisionAdd.setEnabled(false);
        this.stepAndDecisionRemove.setEnabled(false);
        this.stepAndDecisionListTable.setInput(null);
        this.infoLabel.setText("");
        this.stepAndDecisionCombo.deselectAll();
        this.stepAndDecisionCombo.setVisible(false);
        this.clearInfoContentsAndButtonListenerAndMessage();
        String message = BatchMessages.BatchJobCreationCustomizePage_INFO_INFORMATION;
        Label firstLabel = new Label(this.infoContents, 0);
        firstLabel.setText(message);
        this.createInitialInfoContents();
        this.refreshInfoControl();
    }

    private void createInitialInfoContents() {
        Label emptyLabel = new Label(this.infoContents, 0);
        emptyLabel.setText("");
        Label infoImageLabel = new Label(this.infoContents, 0x1000001);
        infoImageLabel.setImage(EgovBatchPlugin.getDefault().getImage("batch_job_add"));
    }

    private List<String> getProjectBeanIDList() {
        ArrayList<String> findingNode = new ArrayList<String>();
        findingNode.add("/beans/bean");
        findingNode.add("/beans/job");
        findingNode.add("/beans/job/step");
        return FindXMLFileBeanIdValueUtil.findXMLFiles(this.context, findingNode, "id", 3);
    }

    private boolean canFinishButtonEnable() {
        boolean canFinishButtonEnable = false;
        TableItem[] items = this.jobListTable.getTable().getItems();
        if (items.length > 0) {
            canFinishButtonEnable = true;
            int i = 0;
            while (i < items.length) {
                JobVo jobVo = (JobVo)items[i].getData();
                Object[] stepAndDecisionVo = jobVo.getStepAndDecisionVoList();
                if (NullUtil.isEmpty((Object[])stepAndDecisionVo)) {
                    canFinishButtonEnable = false;
                    break;
                }
                ++i;
            }
        }
        return canFinishButtonEnable;
    }

    public JobVo[] getResultBatchJobVos() {
        TableItem[] items = this.jobListTable.getTable().getItems();
        JobVo[] data = new JobVo[items.length];
        if (items.length > 0) {
            int i = 0;
            while (i < items.length) {
                data[i] = (JobVo)items[i].getData();
                ++i;
            }
        }
        return data;
    }

    public String[] getJobVoNameList() {
        TableItem[] data = this.jobListTable.getTable().getItems();
        String[] jobVoNameList = null;
        if (data.length > 0) {
            JobVo selectJobVo = this.getJobListSelection();
            String selectJobVoName = null;
            if (!NullUtil.isNull((Object)selectJobVo)) {
                jobVoNameList = new String[data.length - 1];
                selectJobVoName = selectJobVo.getJobName();
            } else {
                jobVoNameList = new String[data.length];
                selectJobVoName = "";
            }
            int j = 0;
            int i = 0;
            while (i < data.length) {
                JobVo vo = (JobVo)data[i].getData();
                String jobVoName = vo.getJobName();
                if (!selectJobVoName.equals(jobVoName)) {
                    jobVoNameList[j] = jobVoName;
                    ++j;
                }
                ++i;
            }
        }
        return jobVoNameList;
    }

    public void selectJobVo(String jobVoName) {
        TableItem[] data = this.jobListTable.getTable().getItems();
        if (data.length > 0) {
            TableItem[] tableItemArray = data;
            int n = data.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                JobVo jobVo = (JobVo)item.getData();
                if (jobVoName.equals(jobVo.getJobName())) {
                    this.jobListTable.setSelection((ISelection)new StructuredSelection((Object)jobVo));
                    break;
                }
                ++n2;
            }
        }
    }

    public void selectStepAndDecisionVo(String sdVoName) {
        TableItem[] data = this.stepAndDecisionListTable.getTable().getItems();
        if (data.length > 0) {
            TableItem[] tableItemArray = data;
            int n = data.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                StepAndDecisionVo sdVo = (StepAndDecisionVo)item.getData();
                if (sdVoName.equals(sdVo.getName())) {
                    this.stepAndDecisionListTable.setSelection((ISelection)new StructuredSelection((Object)sdVo));
                    break;
                }
                ++n2;
            }
        }
    }

    public void removeMarginOfGridLayout(Composite control) {
        ((GridLayout)control.getLayout()).marginHeight = 0;
    }

    private ArrayList<StepAndDecisionVo> getReferenceList(JobVo jobSelection, StepAndDecisionVo stepAndDecisionSelection) {
        Object[] list;
        ArrayList<StepAndDecisionVo> refMember = new ArrayList<StepAndDecisionVo>();
        if (!(NullUtil.isNull((Object)jobSelection) || NullUtil.isNull((Object)stepAndDecisionSelection) || NullUtil.isEmpty((Object[])(list = jobSelection.getStepAndDecisionVoList())))) {
            String standard = stepAndDecisionSelection.getName();
            Object[] objectArray = list;
            int n = list.length;
            int n2 = 0;
            while (n2 < n) {
                Object sdVo = objectArray[n2];
                if (this.isStepAndDecisionVoReference((StepAndDecisionVo)sdVo, standard)) {
                    refMember.add((StepAndDecisionVo)sdVo);
                }
                ++n2;
            }
        }
        return refMember;
    }

    private boolean isStepAndDecisionVoReference(StepAndDecisionVo sdVo, String standard) {
        if (sdVo instanceof StepVo) {
            return this.isStepVoReference((StepVo)sdVo, standard);
        }
        return this.isDecisionVoReference((DecisionVo)sdVo, standard);
    }

    private boolean isStepVoReference(StepVo stepVo, String standard) {
        String nextStepString = stepVo.getNextStep();
        return !NullUtil.isEmpty((String)nextStepString) && nextStepString.equals(standard);
    }

    private boolean isDecisionVoReference(DecisionVo decisionVo, String standard) {
        String stopRestart;
        Object[] nextVos = decisionVo.getNextVo();
        if (!NullUtil.isEmpty((Object[])nextVos)) {
            Object[] objectArray = nextVos;
            int n = nextVos.length;
            int n2 = 0;
            while (n2 < n) {
                Object nextVo = objectArray[n2];
                if (((NextVo)nextVo).getNextTo().equals(standard)) {
                    return true;
                }
                ++n2;
            }
        }
        return !NullUtil.isEmpty((String)(stopRestart = decisionVo.getStopRestart())) && stopRestart.equals(standard);
    }

    private String createReferenceMessage(ArrayList<StepAndDecisionVo> refMember) {
        int lastMemberIndex = refMember.size() - 1;
        String refMemberString = "";
        if (!NullUtil.isEmpty(refMember)) {
            int i = 0;
            while (i < lastMemberIndex) {
                StepAndDecisionVo member = refMember.get(i);
                refMemberString = String.valueOf(refMemberString) + member.getName() + ", ";
                ++i;
            }
            StepAndDecisionVo member = refMember.get(lastMemberIndex);
            refMemberString = String.valueOf(refMemberString) + member.getName();
        }
        return refMemberString;
    }

    private String createRefDialogModifyString(String preID, ArrayList<StepAndDecisionVo> refMemberList) {
        String refMemeberString = this.createReferenceMessage(refMemberList);
        if (NullUtil.isEmpty((String)refMemeberString)) {
            return BatchMessages.BatchJobCreationCustomizePage_CONFIRM_UPDATE;
        }
        String result = String.valueOf(preID) + BatchMessages.BatchJobCreationCustomizePage_UPDATE_MESSAGE_1;
        result = String.valueOf(result) + refMemeberString + "\n\n";
        result = String.valueOf(result) + BatchMessages.BatchJobCreationCustomizePage_UPDATE_MESSAGE_2;
        return result;
    }

    private String createRefDialogRemoveString(String preID, ArrayList<StepAndDecisionVo> refMemberList) {
        String refMemeberString = this.createReferenceMessage(refMemberList);
        if (NullUtil.isEmpty((String)refMemeberString)) {
            return BatchMessages.BatchJobCreationCustomizePage_CONFIRM_DELETE;
        }
        String result = String.valueOf(preID) + BatchMessages.BatchJobCreationCustomizePage_DELETE_MESSAGE_1;
        result = String.valueOf(result) + refMemeberString + "\n\n";
        result = String.valueOf(result) + preID + BatchMessages.BatchJobCreationCustomizePage_DELETE_MESSAGE_2;
        return result;
    }

    private StepAndDecisionVo[] getStepAndDecisionList() {
        TableItem[] items = this.stepAndDecisionListTable.getTable().getItems();
        StepAndDecisionVo[] dSVos = new StepAndDecisionVo[]{};
        if (items.length > 0) {
            dSVos = new StepAndDecisionVo[items.length];
            int i = 0;
            while (i < dSVos.length) {
                dSVos[i] = (StepAndDecisionVo)items[i].getData();
                ++i;
            }
        }
        return dSVos;
    }

    private void removeStepAndDecisionComboListener() {
        Object[] listeners = this.stepAndDecisionCombo.getListeners(13);
        if (!NullUtil.isEmpty((Object[])listeners)) {
            Object[] objectArray = listeners;
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                Object listener = objectArray[n2];
                this.stepAndDecisionCombo.removeListener(13, (Listener)listener);
                ++n2;
            }
        }
    }

    private void atFirstStepComboListener() {
        this.stepAndDecisionCombo.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                String postString = BatchJobCreationCustomizePage.this.stepAndDecisionCombo.getText();
                if ("\uc120\ud0dd".equals(postString)) {
                    BatchJobCreationCustomizePage.this.stepAndDecisionAddButtonListener.handleEvent(new Event());
                } else if ("Step".equals(postString)) {
                    BatchJobCreationCustomizePage.this.setMessage(BatchMessages.BatchJobCreationCustomizePage_ADD_NEW_STEP);
                    BatchJobCreationCustomizePage.this.refreshInfoToStep(BatchJobCreationCustomizePage.this.getJobListSelection(), null);
                    BatchJobCreationCustomizePage.this.restoreDefaultsButton.setEnabled(true);
                } else {
                    BatchJobCreationCustomizePage.this.setErrorMessage(BatchMessages.BatchJobCreationCustomizePage_STEP_ONLY_AT_FIRST);
                    BatchJobCreationCustomizePage.this.restoreDefaultsButton.setEnabled(false);
                    BatchJobCreationCustomizePage.this.stepAndDecisionCombo.setText(BatchJobCreationCustomizePage.this.currentInfo);
                }
            }
        });
    }

    private void setEnableStepAndDecisionComboListener() {
        this.stepAndDecisionCombo.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                JobVo selectJobVo = BatchJobCreationCustomizePage.this.getJobListSelection();
                if (BatchJobCreationCustomizePage.this.stepAndDecisionCombo.getText().equals("\uc120\ud0dd")) {
                    BatchJobCreationCustomizePage.this.stepAndDecisionAddButtonListener.handleEvent(new Event());
                } else {
                    if (BatchJobCreationCustomizePage.this.stepAndDecisionCombo.getText().equals("Decision")) {
                        BatchJobCreationCustomizePage.this.setMessage(BatchMessages.BatchJobCreationCustomizePage_ADD_NEW_DECISION);
                        BatchJobCreationCustomizePage.this.refreshInfoToDecision(selectJobVo, null);
                    } else if (BatchJobCreationCustomizePage.this.stepAndDecisionCombo.getText().equals("Step")) {
                        BatchJobCreationCustomizePage.this.setMessage(BatchMessages.BatchJobCreationCustomizePage_ADD_NEW_STEP);
                        BatchJobCreationCustomizePage.this.refreshInfoToStep(selectJobVo, null);
                    }
                    BatchJobCreationCustomizePage.this.restoreDefaultsButton.setEnabled(true);
                }
            }
        });
    }

    private void setApplyAndRestoreButtonListener(Listener applyButtonListener, Listener restoreButtonListener) {
        this.applyButton.addListener(13, applyButtonListener);
        this.restoreDefaultsButton.addListener(13, restoreButtonListener);
    }

    private void createStepDecisionAddButtonSelectInfoContents() {
        this.currentInfo = "\uc120\ud0dd";
        Label infoLabel = new Label(this.infoContents, 0);
        infoLabel.setText(BatchMessages.BatchJobCreationCustomizePage_STEP_DECISION_ADD_BUTTON_INFORMATION_MESSAGE);
        Label emptyLabel = new Label(this.infoContents, 0);
        emptyLabel.setText("");
        Label infoImageLabel = new Label(this.infoContents, 0x1000001);
        infoImageLabel.setImage(EgovBatchPlugin.getDefault().getImage("batch_stepdecision_add"));
    }

    private JobVo getJobListSelection() {
        IStructuredSelection selection = (IStructuredSelection)this.jobListTable.getSelection();
        if (!selection.isEmpty()) {
            JobVo jobVo = (JobVo)selection.getFirstElement();
            return jobVo;
        }
        return null;
    }

    private StepAndDecisionVo getStepDecisionListSelection() {
        IStructuredSelection stepAndDecisionSelection = (IStructuredSelection)this.stepAndDecisionListTable.getSelection();
        if (!stepAndDecisionSelection.isEmpty()) {
            StepAndDecisionVo selectStepAndDecisionVo = (StepAndDecisionVo)stepAndDecisionSelection.getFirstElement();
            return selectStepAndDecisionVo;
        }
        return null;
    }

    private void deselectStepDecisionList() {
        this.stepAndDecisionListTable.setSelection((ISelection)new StructuredSelection());
    }

    private void refreshInfoToJob(JobVo jobVo) {
        this.clearInfoContentsAndButtonListenerAndMessage();
        this.infoLabel.setText(BatchMessages.BatchJobCreationCustomizePage_JOB_INFO);
        this.jobInfoControl.createJobInfoContents(jobVo, this.getJobVoNameList());
        this.setApplyAndRestoreButtonListener(this.jobApplyButtonListener, this.jobRestoreButtonListener);
        this.stepAndDecisionCombo.setVisible(false);
        this.refreshInfoControl();
    }

    private void updateJobVoAndBeanIDList(JobVo selectJobVo, JobVo newJobVo) {
        this.batchXMLFileBeanIDList.updateJobVoBeanIDList(selectJobVo.getJobName(), newJobVo);
        selectJobVo.copyValues(newJobVo);
        this.jobListTable.update((Object)selectJobVo, null);
    }

    private void addNewJobVoAndBeanIDList(JobVo newJobVo) {
        this.jobListTable.add((Object)newJobVo);
        this.selectJobVo(newJobVo.getJobName());
        this.batchXMLFileBeanIDList.addNewJobVoBeanIDList(newJobVo);
        this.setMessage(BatchMessages.BatchJobCreationCustomizePage_ADD_NEW_JOB);
    }

    private void refreshInfoToStep(JobVo jobVo, StepVo stepVo) {
        this.currentInfo = "Step";
        this.clearInfoContentsAndButtonListenerAndMessage();
        this.stepAndDecisionCombo.setText("Step");
        this.infoLabel.setText(BatchMessages.BatchJobCreationCustomizePage_STEP_INFO_LABEL);
        this.stepInfoControl.createStepInfoContents(jobVo, stepVo);
        this.setApplyAndRestoreButtonListener(this.stepAndDecisionApplyButtonListener, this.stepAndDecisionRestoreButtonListener);
        this.refreshInfoControl();
    }

    private void refreshInfoToDecision(JobVo jobVo, DecisionVo decisionVo) {
        this.currentInfo = "Decision";
        this.clearInfoContentsAndButtonListenerAndMessage();
        this.stepAndDecisionCombo.setText("Decision");
        this.infoLabel.setText(BatchMessages.BatchJobCreationCustomizePage_DECISION_INFO_LABEL);
        this.decisionInfoControl.createDecisionInfoContents(jobVo, decisionVo);
        this.setApplyAndRestoreButtonListener(this.stepAndDecisionApplyButtonListener, this.stepAndDecisionRestoreButtonListener);
        this.refreshInfoControl();
    }

    private boolean openConfirmDialog(String title, String message) {
        return MessageDialog.openConfirm((Shell)this.getShell(), (String)title, (String)message);
    }
}

