/*
 * Decompiled with CFR 0.152.
 */
package egovframework.bdev.imp.batch.wizards.jobcreation.pages;

import egovframework.bdev.imp.batch.common.BatchMessages;
import egovframework.bdev.imp.batch.wizards.jobcreation.model.BatchJobBeanIDList;
import egovframework.bdev.imp.batch.wizards.jobcreation.model.BatchXMLFileBeanIDList;
import egovframework.bdev.imp.batch.wizards.jobcreation.model.DecisionVo;
import egovframework.bdev.imp.batch.wizards.jobcreation.model.JobVo;
import egovframework.bdev.imp.batch.wizards.jobcreation.model.NextVo;
import egovframework.bdev.imp.batch.wizards.jobcreation.model.StepAndDecisionVo;
import egovframework.bdev.imp.batch.wizards.jobcreation.model.StepVo;
import egovframework.bdev.imp.batch.wizards.jobcreation.pages.InfoContentsConstructor;
import egovframework.bdev.imp.batch.wizards.jobcreation.pages.NextDialog;
import egovframework.bdev.imp.batch.wizards.jobcreation.views.NextTableViewerProvider;
import egovframework.dev.imp.core.utils.BatchTableColumn;
import egovframework.dev.imp.core.utils.NullUtil;
import egovframework.dev.imp.core.utils.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class DecisionInfoContentsConstructor
extends InfoContentsConstructor {
    private DecisionVo tempDecisionVo = null;
    private Button addNextOnTo = null;
    private Button addEndOnToButton = null;
    private Button addStopOnToButton = null;
    private Button addFailOnToButton = null;
    private String[] stepAndDecisionNameList = null;

    public DecisionInfoContentsConstructor(WizardPage currentPage, Composite infoControl, Button applyButton, BatchXMLFileBeanIDList batchXMLFileBeanIDList, List<String> projectBeanIDList) {
        this.currentPage = currentPage;
        this.infoControl = infoControl;
        this.applyButton = applyButton;
        this.batchXMLFileBeanIDList = batchXMLFileBeanIDList;
        this.projectBeanIDList = projectBeanIDList;
    }

    public void createDecisionInfoContents(JobVo jobVo, DecisionVo decisionVo) {
        this.tempDecisionVo = new DecisionVo();
        this.tempDecisionVo.copyValues(decisionVo);
        this.tempDecisionVo.setJobName(jobVo.getJobName());
        this.invalidBatchXMLFileBeanIDList = this.getInvalidBeanList(this.tempDecisionVo);
        GridData gData = new GridData();
        gData.widthHint = 138;
        this.stepAndDecisionNameList = this.getStepAndDecisionNameList(jobVo, decisionVo);
        Text jobIDField = this.createJobIDField(this.infoControl, jobVo);
        jobIDField.setEnabled(false);
        this.createDecisionIDField(this.infoControl);
        this.createNextGroup(this.infoControl, decisionVo);
        this.createEndControl(this.infoControl, gData);
        this.createFailControl(this.infoControl, gData);
        this.createStopControl(this.infoControl, jobVo, gData);
        if (!NullUtil.isNull((Object)decisionVo)) {
            this.validation().handleEvent(null);
        }
    }

    public BatchXMLFileBeanIDList getInvalidBeanList(StepAndDecisionVo sdVo) {
        BatchXMLFileBeanIDList invalidList = this.batchXMLFileBeanIDList.clone();
        BatchJobBeanIDList jobBeanIDList = invalidList.getJobBeanIDList(sdVo.getJobName());
        if (!NullUtil.isNull((Object)jobBeanIDList)) {
            jobBeanIDList.removeStepDecision(sdVo.getName());
        }
        return invalidList;
    }

    public String[] getStepAndDecisionNameList(JobVo jobVo, StepAndDecisionVo sdVo) {
        Object[] data = jobVo.getStepAndDecisionVoList();
        String[] stepAndDecisionNameList = new String[]{};
        String sdVoName = "";
        if (!NullUtil.isEmpty((Object[])data)) {
            if (NullUtil.isNull((Object)sdVo)) {
                stepAndDecisionNameList = new String[data.length];
                sdVoName = "";
            } else {
                stepAndDecisionNameList = new String[data.length - 1];
                sdVoName = sdVo.getName();
            }
            int j = 0;
            int i = 0;
            while (i < data.length) {
                String dataName = ((StepAndDecisionVo)data[i]).getName();
                if (!sdVoName.equals(dataName)) {
                    stepAndDecisionNameList[j] = dataName;
                    ++j;
                }
                ++i;
            }
        }
        return stepAndDecisionNameList;
    }

    private Text createJobIDField(Composite control, JobVo jobVo) {
        Composite jobIdControl = new Composite(control, 0);
        jobIdControl.setLayout((Layout)new GridLayout(2, false));
        jobIdControl.setLayoutData((Object)new GridData(768));
        Label jobId = new Label(jobIdControl, 0);
        jobId.setText(BatchMessages.DecisionInfoContentsConstructor_JOB_ID_LABEL);
        String jobName = jobVo.getJobName();
        Text jobIDField = new Text(jobIdControl, 2048);
        jobIDField.setLayoutData((Object)new GridData(768));
        jobIDField.setText(StringUtil.returnEmptyStringIfNull((String)jobName));
        return jobIDField;
    }

    private void createDecisionIDField(Composite control) {
        Composite innerContents = new Composite(control, 0);
        innerContents.setLayout((Layout)new GridLayout(2, false));
        innerContents.setLayoutData((Object)new GridData(768));
        Label decisionId = new Label(innerContents, 0);
        decisionId.setText(BatchMessages.DecisionInfoContentsConstructor_DECISION_ID_LABEL);
        String decisionID = this.tempDecisionVo.getName();
        final Text decisionIdField = new Text(innerContents, 2048);
        decisionIdField.setLayoutData((Object)new GridData(768));
        decisionIdField.setText(StringUtil.returnEmptyStringIfNull((String)decisionID));
        decisionIdField.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                DecisionInfoContentsConstructor.this.tempDecisionVo.setName(decisionIdField.getText());
            }
        });
        decisionIdField.addListener(24, this.validation());
        decisionIdField.forceFocus();
    }

    private void createNextGroup(Composite control, final DecisionVo decisionVo) {
        Group nextGroup = new Group(control, 0);
        nextGroup.setLayout((Layout)new GridLayout(2, false));
        nextGroup.setLayoutData((Object)new GridData(1808));
        nextGroup.setText(BatchMessages.DecisionInfoContentsConstructor_NEXT_GROUP_TITLE);
        this.addNextOnTo = this.createOnToCheckBoxButton((Composite)nextGroup, BatchMessages.DecisionInfoContentsConstructor_ADD_NEXT_ON_TO_BUTTON);
        final TableViewer nextTableViewer = this.createNextTableViewer((Composite)nextGroup, decisionVo);
        Composite buttonControl = new Composite((Composite)nextGroup, 0);
        buttonControl.setLayout((Layout)new GridLayout());
        buttonControl.setLayoutData((Object)new GridData());
        final Button addButton = this.createNextTableAddButton(buttonControl, nextTableViewer);
        final Button editButton = this.createNextTableEditButton(buttonControl, nextTableViewer);
        final Button removeButton = this.createNextTableRemoveButton(buttonControl, nextTableViewer);
        removeButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                IStructuredSelection selection = DecisionInfoContentsConstructor.this.getSelection(nextTableViewer);
                if (!NullUtil.isNull((Object)selection)) {
                    nextTableViewer.remove(selection.toArray());
                    editButton.setEnabled(false);
                    removeButton.setEnabled(false);
                    DecisionInfoContentsConstructor.this.tempDecisionVo.setNextVo(DecisionInfoContentsConstructor.this.getAllNextVoFromTable(nextTableViewer));
                    DecisionInfoContentsConstructor.this.validation().handleEvent(null);
                }
            }
        });
        nextTableViewer.getTable().addListener(13, new Listener(){

            public void handleEvent(Event event) {
                IStructuredSelection selection = (IStructuredSelection)nextTableViewer.getSelection();
                if (!selection.isEmpty()) {
                    editButton.setEnabled(true);
                    removeButton.setEnabled(true);
                }
            }
        });
        this.addNextOnTo.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                boolean selection = DecisionInfoContentsConstructor.this.addNextOnTo.getSelection();
                if (selection) {
                    nextTableViewer.getTable().setEnabled(true);
                    addButton.setEnabled(true);
                    NextVo[] nextTableInput = null;
                    if (!NullUtil.isNull((Object)decisionVo) && !NullUtil.isEmpty((Object[])decisionVo.getNextVo())) {
                        nextTableInput = decisionVo.getNextVo();
                    }
                    nextTableViewer.setInput(nextTableInput);
                    DecisionInfoContentsConstructor.this.tempDecisionVo.setNextVo(nextTableInput);
                } else {
                    nextTableViewer.getTable().setEnabled(false);
                    addButton.setEnabled(false);
                    nextTableViewer.setInput(null);
                    DecisionInfoContentsConstructor.this.tempDecisionVo.setNextVo(null);
                }
                editButton.setEnabled(false);
                removeButton.setEnabled(false);
                nextTableViewer.setSelection((ISelection)new StructuredSelection());
            }
        });
        this.addNextOnTo.notifyListeners(13, null);
        this.addNextOnTo.addListener(13, this.validation());
    }

    private TableViewer createNextTableViewer(Composite control, DecisionVo decisionVo) {
        TableViewer nextTableViewer = new TableViewer(control, 68352);
        nextTableViewer.getControl().setLayoutData((Object)new GridData(1808));
        nextTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        nextTableViewer.setLabelProvider((IBaseLabelProvider)new NextTableViewerProvider());
        Table table = nextTableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        BatchTableColumn[] columns = this.createNextTableColumns();
        int i = 0;
        while (i < columns.length) {
            columns[i].setColumnToTable(table);
            ++i;
        }
        if (!NullUtil.isNull((Object)decisionVo) && !NullUtil.isEmpty((Object[])decisionVo.getNextVo())) {
            this.addNextOnTo.setSelection(true);
            nextTableViewer.setInput((Object)decisionVo.getNextVo());
        }
        return nextTableViewer;
    }

    private Button createNextTableAddButton(Composite control, TableViewer nextTableViewer) {
        Button addButton = new Button(control, 8);
        addButton.setText(BatchMessages.DecisionInfoContentsConstructor_ADD_NEXT_BUTTON);
        addButton.setLayoutData((Object)new GridData(768));
        addButton.addListener(13, this.getNextTableAddButtonListener(nextTableViewer));
        return addButton;
    }

    private Button createNextTableEditButton(Composite control, TableViewer nextTableViewer) {
        Button editButton = new Button(control, 8);
        editButton.setText(BatchMessages.DecisionInfoContentsConstructor_EDIT_NEXT_BUTTON);
        editButton.setLayoutData((Object)new GridData(768));
        editButton.setEnabled(false);
        editButton.addListener(13, this.getNextTableEditButtonListener(nextTableViewer));
        return editButton;
    }

    private Button createNextTableRemoveButton(Composite control, TableViewer nextTableViewer) {
        Button removeButton = new Button(control, 8);
        removeButton.setText(BatchMessages.DecisionInfoContentsConstructor_REMOVE_NEXT_BUTTON);
        removeButton.setLayoutData((Object)new GridData(768));
        removeButton.setEnabled(false);
        return removeButton;
    }

    private BatchTableColumn[] createNextTableColumns() {
        ArrayList<BatchTableColumn> columns = new ArrayList<BatchTableColumn>();
        columns.add(new BatchTableColumn(BatchMessages.DecisionInfoContentsConstructor_NEXT_TABLE_COLUMN_NEXT_ON, 170, 16384));
        columns.add(new BatchTableColumn(BatchMessages.DecisionInfoContentsConstructor_NEXT_TABLE_COLUMN_NEXT_TO, 170, 16384));
        return columns.toArray(new BatchTableColumn[0]);
    }

    private Listener getNextTableAddButtonListener(final TableViewer nextTableViewer) {
        return new Listener(){

            public void handleEvent(Event event) {
                NextVo[] availableNextList = DecisionInfoContentsConstructor.this.getAvailableNextVoFromTable(nextTableViewer, null);
                NextDialog dialog = new NextDialog(DecisionInfoContentsConstructor.this.infoControl.getShell(), null, DecisionInfoContentsConstructor.this.stepAndDecisionNameList, availableNextList);
                if (dialog.open() == 0) {
                    NextVo data = new NextVo();
                    data.setNextOn(dialog.getNextOn());
                    data.setNextTo(dialog.getNextTo());
                    nextTableViewer.add((Object)data);
                    DecisionInfoContentsConstructor.this.tempDecisionVo.setNextVo(DecisionInfoContentsConstructor.this.getAllNextVoFromTable(nextTableViewer));
                    DecisionInfoContentsConstructor.this.validation().handleEvent(event);
                }
            }
        };
    }

    private Listener getNextTableEditButtonListener(final TableViewer nextTableViewer) {
        return new Listener(){

            public void handleEvent(Event event) {
                IStructuredSelection selection = DecisionInfoContentsConstructor.this.getSelection(nextTableViewer);
                NextVo nextVo = (NextVo)selection.getFirstElement();
                NextVo[] availableNextList = DecisionInfoContentsConstructor.this.getAvailableNextVoFromTable(nextTableViewer, nextVo);
                NextDialog dialog = new NextDialog(DecisionInfoContentsConstructor.this.infoControl.getShell(), nextVo, DecisionInfoContentsConstructor.this.stepAndDecisionNameList, availableNextList);
                if (dialog.open() == 0) {
                    nextVo.setNextOn(dialog.getNextOn());
                    nextVo.setNextTo(dialog.getNextTo());
                    nextTableViewer.update((Object)nextVo, null);
                    DecisionInfoContentsConstructor.this.tempDecisionVo.setNextVo(DecisionInfoContentsConstructor.this.getAllNextVoFromTable(nextTableViewer));
                }
            }
        };
    }

    private IStructuredSelection getSelection(TableViewer tableViewer) {
        IStructuredSelection selection = (IStructuredSelection)tableViewer.getSelection();
        if (selection.isEmpty()) {
            return null;
        }
        return selection;
    }

    private NextVo[] getAllNextVoFromTable(TableViewer nextTableViewer) {
        return this.getAvailableNextVoFromTable(nextTableViewer, null);
    }

    private NextVo[] getAvailableNextVoFromTable(TableViewer nextTableViewer, NextVo selectedNextVo) {
        TableItem[] items = nextTableViewer.getTable().getItems();
        NextVo[] nextVos = null;
        boolean isAdd = NullUtil.isNull((Object)selectedNextVo);
        nextVos = isAdd ? new NextVo[items.length] : new NextVo[items.length - 1];
        if (items.length > 0) {
            int i = 0;
            while (i < items.length) {
                NextVo nextVo = (NextVo)items[i].getData();
                if (isAdd || !selectedNextVo.compare(nextVo)) {
                    nextVos[i] = (NextVo)items[i].getData();
                }
                ++i;
            }
        }
        return nextVos;
    }

    private void createEndControl(Composite control, GridData gData) {
        Group endOnControl = new Group(control, 0);
        endOnControl.setLayout((Layout)new GridLayout(4, false));
        endOnControl.setLayoutData((Object)new GridData(768));
        endOnControl.setText(BatchMessages.DecisionInfoContentsConstructor_END_GROUP_TITLE);
        this.addEndOnToButton = this.createOnToCheckBoxButton((Composite)endOnControl, BatchMessages.DecisionInfoContentsConstructor_ADD_END_ON_TO_BUTTON);
        Combo endOnCombo = this.createEndOnControl((Composite)endOnControl);
        Combo endExitCodeCombo = this.createEndExitCodeControl((Composite)endOnControl);
        this.setInitialState(this.addEndOnToButton, endOnCombo, endExitCodeCombo, this.tempDecisionVo.getEndOn(), this.tempDecisionVo.getEndExitCode());
        this.addOnToCheckBoxListener(this.addEndOnToButton, endOnCombo, endExitCodeCombo);
    }

    private Combo createEndOnControl(Composite control) {
        String[] endOnComboItems = new String[]{"COMPLETED", "*", BatchMessages.DecisionInfoContentsConstructor_INPUT_VALUE_BY_SELF};
        final Combo endOnCombo = this.createOnLabelAndCombo(control, BatchMessages.DecisionInfoContentsConstructor_END_ON_LABEL, endOnComboItems);
        endOnCombo.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                DecisionInfoContentsConstructor.this.tempDecisionVo.setEndOn(endOnCombo.getText());
            }
        });
        endOnCombo.addListener(24, this.validation());
        return endOnCombo;
    }

    private Combo createEndExitCodeControl(Composite control) {
        String[] endExitComboItems = new String[]{"COMPLETED", BatchMessages.DecisionInfoContentsConstructor_INPUT_VALUE_BY_SELF};
        final Combo endExitCodeCombo = this.createToLabelAndCombo(control, BatchMessages.DecisionInfoContentsConstructor_EXIT_CODE_LABEL, endExitComboItems);
        endExitCodeCombo.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                DecisionInfoContentsConstructor.this.tempDecisionVo.setEndExitCode(endExitCodeCombo.getText());
            }
        });
        endExitCodeCombo.addListener(24, this.validation());
        return endExitCodeCombo;
    }

    private Button createOnToCheckBoxButton(Composite control, String buttonString) {
        GridData gData = new GridData(768);
        gData.horizontalSpan = 4;
        Button onToButton = new Button(control, 32);
        onToButton.setText(buttonString);
        onToButton.setLayoutData((Object)gData);
        return onToButton;
    }

    private Combo createOnLabelAndCombo(Composite control, String lableString, String[] comboItems) {
        return this.createOnToLabelAndCombo(control, 50, lableString, comboItems);
    }

    private Combo createToLabelAndCombo(Composite control, String lableString, String[] comboItems) {
        return this.createOnToLabelAndCombo(control, 60, lableString, comboItems);
    }

    private Combo createOnToLabelAndCombo(Composite control, int width, String lableString, String[] comboItems) {
        GridData labelGData = new GridData();
        labelGData.widthHint = width;
        Label endOnLabel = new Label(control, 131072);
        endOnLabel.setText(lableString);
        endOnLabel.setLayoutData((Object)labelGData);
        GridData comboGData = new GridData(768);
        comboGData.grabExcessHorizontalSpace = true;
        comboGData.minimumWidth = 130;
        Combo onToCombo = new Combo(control, 2048);
        onToCombo.setItems(comboItems);
        onToCombo.setLayoutData((Object)comboGData);
        return onToCombo;
    }

    private void setInitialState(Button ontToButton, Combo onCombo, Combo toCombo, String on, String to) {
        ontToButton.setSelection(false);
        onCombo.setEnabled(false);
        toCombo.setEnabled(false);
        if (!NullUtil.isEmpty((String)on)) {
            ontToButton.setSelection(true);
            onCombo.setText(on);
            onCombo.setEnabled(true);
            toCombo.setEnabled(true);
            if (!NullUtil.isEmpty((String)to)) {
                toCombo.setText(to);
            }
        }
    }

    private void addOnToCheckBoxListener(final Button onToCheckBox, final Combo onCombo, final Combo toCombo) {
        onToCheckBox.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                boolean setEnable = onToCheckBox.getSelection();
                onCombo.setEnabled(setEnable);
                toCombo.setEnabled(setEnable);
                DecisionInfoContentsConstructor.this.validation().handleEvent(new Event());
                if (setEnable) {
                    onCombo.select(0);
                } else {
                    onCombo.deselectAll();
                    toCombo.deselectAll();
                }
            }
        });
    }

    private void createFailControl(Composite control, GridData gData) {
        Group failControl = new Group(control, 0);
        failControl.setLayout((Layout)new GridLayout(4, false));
        failControl.setLayoutData((Object)new GridData(768));
        failControl.setText(BatchMessages.DecisionInfoContentsConstructor_FAIL_GROUP_TITLE);
        this.addFailOnToButton = this.createOnToCheckBoxButton((Composite)failControl, BatchMessages.DecisionInfoContentsConstructor_ADD_FAIL_ON_TO_BUTTON);
        Combo failOnCombo = this.createFailOnControl((Composite)failControl);
        Combo failExitCodeCombo = this.createFailExitCodeControl((Composite)failControl);
        this.setInitialState(this.addFailOnToButton, failOnCombo, failExitCodeCombo, this.tempDecisionVo.getFailOn(), this.tempDecisionVo.getFailExitCode());
        this.addOnToCheckBoxListener(this.addFailOnToButton, failOnCombo, failExitCodeCombo);
    }

    private Combo createFailOnControl(Composite control) {
        String[] failOnComboItems = new String[]{"FAILED", "*", BatchMessages.DecisionInfoContentsConstructor_INPUT_VALUE_BY_SELF};
        final Combo failOnCombo = this.createOnLabelAndCombo(control, BatchMessages.DecisionInfoContentsConstructor_FAIL_ON_LABEL, failOnComboItems);
        failOnCombo.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                DecisionInfoContentsConstructor.this.tempDecisionVo.setFailOn(failOnCombo.getText());
            }
        });
        failOnCombo.addListener(24, this.validation());
        return failOnCombo;
    }

    private Combo createFailExitCodeControl(Composite control) {
        String[] failExitComboItems = new String[]{"FAILED", BatchMessages.DecisionInfoContentsConstructor_INPUT_VALUE_BY_SELF};
        final Combo failExitCodeCombo = this.createToLabelAndCombo(control, BatchMessages.DecisionInfoContentsConstructor_FAIL_EXIT_CODE_BUTTON, failExitComboItems);
        failExitCodeCombo.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                DecisionInfoContentsConstructor.this.tempDecisionVo.setFailExitCode(failExitCodeCombo.getText());
            }
        });
        failExitCodeCombo.addListener(24, this.validation());
        return failExitCodeCombo;
    }

    private void createStopControl(Composite control, JobVo jobVo, GridData gData) {
        Group stopControl = new Group(control, 0);
        stopControl.setLayout((Layout)new GridLayout(4, false));
        stopControl.setLayoutData((Object)new GridData(768));
        stopControl.setText(BatchMessages.DecisionInfoContentsConstructor_STOP_GROUP_TITLE);
        this.addStopOnToButton = this.createOnToCheckBoxButton((Composite)stopControl, BatchMessages.DecisionInfoContentsConstructor_ADD_STOP_ON_TO_BUTTON);
        Combo stopOnCombo = this.createStopOnControl((Composite)stopControl);
        Combo stopRestartCombo = this.createStopRestartControl((Composite)stopControl, jobVo);
        this.setInitialState(this.addStopOnToButton, stopOnCombo, stopRestartCombo, this.tempDecisionVo.getStopOn(), this.tempDecisionVo.getStopRestart());
        this.addOnToCheckBoxListener(this.addStopOnToButton, stopOnCombo, stopRestartCombo);
    }

    private Combo createStopOnControl(Composite control) {
        String[] stopOnComboItems = new String[]{"COMPLETED", "FAILED", "*", BatchMessages.DecisionInfoContentsConstructor_INPUT_VALUE_BY_SELF};
        final Combo stopOnCombo = this.createOnLabelAndCombo(control, BatchMessages.DecisionInfoContentsConstructor_STOP_ON_LABEL, stopOnComboItems);
        stopOnCombo.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                DecisionInfoContentsConstructor.this.tempDecisionVo.setStopOn(stopOnCombo.getText());
            }
        });
        stopOnCombo.addListener(24, this.validation());
        return stopOnCombo;
    }

    private Combo createStopRestartControl(Composite control, JobVo jobVo) {
        String[] stopRestartComboItems = this.getStepNameList(jobVo);
        final Combo stopRestartCombo = this.createStopRestartLabelAndCombo(control, BatchMessages.DecisionInfoContentsConstructor_EXIT_CODE_RESTART_LABEL, stopRestartComboItems);
        stopRestartCombo.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                DecisionInfoContentsConstructor.this.tempDecisionVo.setStopRestart(stopRestartCombo.getText());
            }
        });
        stopRestartCombo.addListener(13, this.validation());
        return stopRestartCombo;
    }

    private Combo createStopRestartLabelAndCombo(Composite control, String lableString, String[] comboItems) {
        GridData labelGData = new GridData();
        labelGData.widthHint = 61;
        Label endOnLabel = new Label(control, 131072);
        endOnLabel.setText(lableString);
        endOnLabel.setLayoutData((Object)labelGData);
        GridData comboGData = new GridData(768);
        comboGData.grabExcessHorizontalSpace = true;
        comboGData.minimumWidth = 130;
        Combo restartCombo = new Combo(control, 2056);
        restartCombo.setItems(comboItems);
        restartCombo.setLayoutData((Object)comboGData);
        return restartCombo;
    }

    public String[] getStepNameList(JobVo jobVo) {
        Object[] data = jobVo.getStepAndDecisionVoList();
        ArrayList<String> stepNameList = new ArrayList<String>();
        if (!NullUtil.isEmpty((Object[])data)) {
            Object[] objectArray = data;
            int n = data.length;
            int n2 = 0;
            while (n2 < n) {
                Object vo = objectArray[n2];
                if (vo instanceof StepVo) {
                    stepNameList.add(((StepAndDecisionVo)vo).getName());
                }
                ++n2;
            }
        }
        String[] result = new String[stepNameList.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = (String)stepNameList.get(i);
            ++i;
        }
        return result;
    }

    @Override
    protected void validateItems() throws InfoContentsConstructor.InfoValidationException {
        this.validateDecisionID();
        this.validateOnTos();
    }

    private void validateDecisionID() throws InfoContentsConstructor.InfoValidationException {
        String decisionID = this.tempDecisionVo.getName();
        if (NullUtil.isEmpty((String)decisionID)) {
            this.throwInfoValidationException(BatchMessages.DecisionInfoContentsConstructor_EMPTY_DECISION_ID_ERROR_MESSAGE);
        }
        if (!StringUtil.isBatchJobBeanIDAvailable((String)decisionID)) {
            this.throwInfoValidationException(BatchMessages.DecisionInfoContentsConstructor_INVALID_DECISION_ID_ERROR_MESSAGE);
        }
        if (this.isBeanIDDuplicate(this.invalidBatchXMLFileBeanIDList, decisionID)) {
            this.throwInfoValidationException(BatchMessages.DecisionInfoContentsConstructor_DUPLICATE_BEAN_ID_ERROR_MESSAGE);
        }
        if (!NullUtil.isEmpty((Object[])this.stepAndDecisionNameList)) {
            String[] stringArray = this.stepAndDecisionNameList;
            int n = this.stepAndDecisionNameList.length;
            int n2 = 0;
            while (n2 < n) {
                String stepAndDecisionName = stringArray[n2];
                if (decisionID.equals(stepAndDecisionName)) {
                    this.throwInfoValidationException(BatchMessages.DecisionInfoContentsConstructor_DUPLICATE_STEP_OR_DECISION_ID_ERROR_MESSAGE);
                }
                ++n2;
            }
        }
    }

    private void validateOnTos() throws InfoContentsConstructor.InfoValidationException {
        boolean atLeastOne;
        this.validateOnValuesDuplication();
        boolean isNextOnToComplete = this.validateNextOnTo();
        boolean isEndOnToComplete = this.validateEndOnTo();
        boolean isFailOnToComplete = this.validateFailOnTo();
        boolean isStopOnToComplete = this.validateStopOnTo();
        boolean bl = atLeastOne = isNextOnToComplete || isEndOnToComplete || isFailOnToComplete || isStopOnToComplete;
        if (!atLeastOne) {
            this.throwInfoValidationException(BatchMessages.DecisionInfoContentsConstructor_EMPTY_NEXT_END_FAIL_STOP_ERROR_MESSAGE);
        }
    }

    private void validateOnValuesDuplication() throws InfoContentsConstructor.InfoValidationException {
        String[] onValues;
        int n;
        ArrayList<String> onList = new ArrayList<String>();
        Object[] nextVos = this.tempDecisionVo.getNextVo();
        if (!NullUtil.isEmpty((Object[])nextVos)) {
            Object[] objectArray = nextVos;
            n = nextVos.length;
            int n2 = 0;
            while (n2 < n) {
                Object nextVo = objectArray[n2];
                onList.add(((NextVo)nextVo).getNextOn());
                ++n2;
            }
        }
        String[] stringArray = onValues = new String[]{this.tempDecisionVo.getEndOn(), this.tempDecisionVo.getFailOn(), this.tempDecisionVo.getStopOn()};
        int n3 = onValues.length;
        n = 0;
        while (n < n3) {
            String onValue = stringArray[n];
            if (this.isStringItemDuplicateInArrayList(onList, onValue)) {
                this.throwInfoValidationException(BatchMessages.DecisionInfoContentsConstructor_DUPLICATE_ON_VALUE_ERROR_MESSAGE);
            } else if (!NullUtil.isEmpty((String)onValue)) {
                onList.add(onValue);
            }
            ++n;
        }
    }

    private boolean validateNextOnTo() throws InfoContentsConstructor.InfoValidationException {
        boolean atLeastOneOn = false;
        if (this.addNextOnTo.getSelection()) {
            if (NullUtil.isEmpty((Object[])this.tempDecisionVo.getNextVo())) {
                this.throwInfoValidationException(BatchMessages.DecisionInfoContentsConstructor_EMPTY_NEXT_ITEM_ERROR_MESSAGE);
            } else {
                atLeastOneOn = true;
            }
        }
        return atLeastOneOn;
    }

    private boolean validateEndOnTo() throws InfoContentsConstructor.InfoValidationException {
        boolean atLeastOneOn = false;
        if (!this.addEndOnToButton.isDisposed() && this.addEndOnToButton.getSelection()) {
            String endOnString = this.tempDecisionVo.getEndOn();
            String endExitCodeString = this.tempDecisionVo.getEndExitCode();
            if (NullUtil.isEmpty((String)endOnString)) {
                this.throwInfoValidationException(BatchMessages.DecisionInfoContentsConstructor_EMPTY_EXIT_ON_ERROR_MESSAGE);
            } else if (!this.isDecisionElementNameAvailable(endOnString)) {
                this.throwInfoValidationException(BatchMessages.DecisionInfoContentsConstructor_INVALID_EXIT_ON_ERROR_MESSAGE);
            } else if (!NullUtil.isEmpty((String)endExitCodeString) && !this.isDecisionElementNameAvailable(endExitCodeString)) {
                this.throwInfoValidationException(BatchMessages.DecisionInfoContentsConstructor_INVALID_END_EXIT_CODE_ERROR_MESSAGE);
            } else {
                atLeastOneOn = true;
            }
        }
        return atLeastOneOn;
    }

    private boolean validateFailOnTo() throws InfoContentsConstructor.InfoValidationException {
        boolean atLeastOneOn = false;
        if (!this.addFailOnToButton.isDisposed() && this.addFailOnToButton.getSelection()) {
            String failOnString = this.tempDecisionVo.getFailOn();
            String failExitCodeString = this.tempDecisionVo.getFailExitCode();
            if (NullUtil.isEmpty((String)failOnString)) {
                this.throwInfoValidationException(BatchMessages.DecisionInfoContentsConstructor_EMPTY_FAIL_ON_ERROR_MESSAGE);
            } else if (!this.isDecisionElementNameAvailable(failOnString)) {
                this.throwInfoValidationException(BatchMessages.DecisionInfoContentsConstructor_INVALID_FAIL_ON_ERROR_MESSAGE);
            } else if (!NullUtil.isEmpty((String)failExitCodeString) && !this.isDecisionElementNameAvailable(failExitCodeString)) {
                this.throwInfoValidationException(BatchMessages.DecisionInfoContentsConstructor_INVALID_FAIL_EXIT_CODE_ERROR_MESSAGE);
            } else {
                atLeastOneOn = true;
            }
        }
        return atLeastOneOn;
    }

    private boolean validateStopOnTo() throws InfoContentsConstructor.InfoValidationException {
        boolean atLeastOneOn = false;
        if (!this.addStopOnToButton.isDisposed() && this.addStopOnToButton.getSelection()) {
            String stopOnString = this.tempDecisionVo.getStopOn();
            String stopRestartString = this.tempDecisionVo.getStopRestart();
            if (NullUtil.isEmpty((String)stopOnString)) {
                this.throwInfoValidationException(BatchMessages.DecisionInfoContentsConstructor_EMPTY_STOP_ON_ERROR_MESSAGE);
            } else if (!this.isDecisionElementNameAvailable(stopOnString)) {
                this.throwInfoValidationException(BatchMessages.DecisionInfoContentsConstructor_INVALID_EMPTY_ON_ERROR_MESSAGE);
            } else if (NullUtil.isEmpty((String)stopRestartString)) {
                this.throwInfoValidationException(BatchMessages.DecisionInfoContentsConstructor_EMPTY_STOP_RESTART_ERROR_MESSAGE);
            } else {
                atLeastOneOn = true;
            }
        }
        return atLeastOneOn;
    }

    private boolean isDecisionElementNameAvailable(String name) {
        String invalidSignals = "<>\"";
        return !StringUtil.hasKorean((String)name) && !StringUtil.hasEmptySpace((String)name) && !StringUtil.doesStringHasSignalsAtLeastOneCharacter((String)invalidSignals, (String)name);
    }

    private boolean isStringItemDuplicateInArrayList(ArrayList<String> arrayList, String string) {
        if (NullUtil.isNull(arrayList) || NullUtil.isNull((Object)string)) {
            return false;
        }
        for (String item : arrayList) {
            if (!string.equals(item)) continue;
            return true;
        }
        return false;
    }

    public DecisionVo getDecisionVo() {
        return this.tempDecisionVo;
    }
}

