/*
 * Decompiled with CFR 0.152.
 */
package egovframework.bdev.imp.batch.wizards.jobcreation.pages;

import egovframework.bdev.imp.batch.common.BatchMessages;
import egovframework.bdev.imp.batch.wizards.jobcreation.model.BatchJobBeanIDList;
import egovframework.bdev.imp.batch.wizards.jobcreation.model.BatchPageBeanIDList;
import egovframework.bdev.imp.batch.wizards.jobcreation.model.BatchXMLFileBeanIDList;
import egovframework.bdev.imp.batch.wizards.jobcreation.model.JobVo;
import egovframework.bdev.imp.batch.wizards.jobcreation.model.StepAndDecisionVo;
import egovframework.bdev.imp.batch.wizards.jobcreation.model.StepVo;
import egovframework.bdev.imp.batch.wizards.jobcreation.pages.InfoContentsConstructor;
import egovframework.bdev.imp.batch.wizards.jobcreation.pages.JobListenerDialog;
import egovframework.bdev.imp.batch.wizards.jobcreation.views.BatchListenerLabelProvider;
import egovframework.bdev.imp.confmngt.preferences.listeners.model.JobListenerInfo;
import egovframework.bdev.imp.confmngt.preferences.listeners.model.ListenerInfo;
import egovframework.bdev.imp.confmngt.preferences.readwrite.model.JobRWInfo;
import egovframework.dev.imp.core.utils.BatchTableColumn;
import egovframework.dev.imp.core.utils.NullUtil;
import egovframework.dev.imp.core.utils.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class JobInfoContentsConstructor
extends InfoContentsConstructor {
    private JobVo tempJobVo = null;
    private String[] jobVoNameLists = null;

    public JobInfoContentsConstructor(WizardPage currentPage, Composite infoControl, Button applyButton, BatchXMLFileBeanIDList batchXMLFileBeanIDList, List<String> projectBeanIDList) {
        this.currentPage = currentPage;
        this.infoControl = infoControl;
        this.applyButton = applyButton;
        this.batchXMLFileBeanIDList = batchXMLFileBeanIDList;
        this.projectBeanIDList = projectBeanIDList;
    }

    public void createJobInfoContents(JobVo jobVo, String[] jobVoNameList) {
        this.tempJobVo = new JobVo();
        this.tempJobVo.copyValues(jobVo);
        this.jobVoNameLists = jobVoNameList;
        this.invalidBatchXMLFileBeanIDList = this.getInvalidBeanList(this.tempJobVo);
        this.createJobIDControl(this.infoControl);
        this.createRestartControl(this.infoControl);
        this.createJobListenerTableViewer(this.infoControl);
    }

    protected BatchXMLFileBeanIDList getInvalidBeanList(JobVo jobVo) {
        BatchXMLFileBeanIDList invalidList = this.batchXMLFileBeanIDList.clone();
        BatchJobBeanIDList beanIDList = invalidList.getJobBeanIDList(jobVo.getJobName());
        if (!NullUtil.isNull((Object)beanIDList)) {
            beanIDList.removeJobBeanPageToAvailableList();
        }
        return invalidList;
    }

    private void createJobIDControl(Composite control) {
        final Text jobIDField = this.createJobIDField(control, this.tempJobVo);
        jobIDField.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                JobInfoContentsConstructor.this.tempJobVo.setJobName(jobIDField.getText());
            }
        });
        jobIDField.addListener(24, this.validation());
        jobIDField.forceFocus();
    }

    private void createRestartControl(Composite control) {
        Group restartableGroup = new Group(control, 0);
        restartableGroup.setLayout((Layout)new GridLayout(2, true));
        restartableGroup.setLayoutData((Object)new GridData(768));
        restartableGroup.setText(BatchMessages.JobInfoContentsConstructor_RESTART_GROUP_TITLE);
        Button restartableTrue = new Button((Composite)restartableGroup, 16);
        restartableTrue.setText(BatchMessages.JobInfoContentsConstructor_RESTART_TRUE_BUTTON_TEXT);
        restartableTrue.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                JobInfoContentsConstructor.this.tempJobVo.setRestartable(true);
            }
        });
        Button restartableFalse = new Button((Composite)restartableGroup, 16);
        restartableFalse.setText(BatchMessages.JobInfoContentsConstructor_RESTART_FALSE_BUTTON_TEXT);
        restartableFalse.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                JobInfoContentsConstructor.this.tempJobVo.setRestartable(false);
            }
        });
        restartableTrue.setSelection(this.tempJobVo.isRestartable());
        restartableFalse.setSelection(!this.tempJobVo.isRestartable());
    }

    private void createJobListenerTableViewer(Composite control) {
        Group jobListenersGroup = new Group(control, 0);
        jobListenersGroup.setLayout((Layout)new GridLayout());
        jobListenersGroup.setLayoutData((Object)new GridData(1808));
        jobListenersGroup.setText(BatchMessages.JobInfoContentsConstructor_JOB_LISTENER_GROUP_TITLE);
        TableViewer jobListenersTableViewer = new TableViewer((Composite)jobListenersGroup, 68352);
        Table table = jobListenersTableViewer.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        BatchTableColumn[] columns = this.createColumns();
        int i = 0;
        while (i < columns.length) {
            columns[i].setColumnToTable(table);
            ++i;
        }
        jobListenersTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        jobListenersTableViewer.setLabelProvider((IBaseLabelProvider)new BatchListenerLabelProvider());
        jobListenersTableViewer.setInput((Object)this.tempJobVo.getJobListenerInfoList());
        jobListenersTableViewer.getControl().setLayoutData((Object)new GridData(1808));
        this.createTableButtonControl((Composite)jobListenersGroup, jobListenersTableViewer);
    }

    private BatchTableColumn[] createColumns() {
        ArrayList<BatchTableColumn> columns = new ArrayList<BatchTableColumn>();
        columns.add(new BatchTableColumn(BatchMessages.JobInfoContentsConstructor_JOB_LISTENER_TABLE_COLUMN_NAME, 200, 16384));
        columns.add(new BatchTableColumn(BatchMessages.JobInfoContentsConstructor_JOB_LISTENER_TABLE_COLUMN_CLASS, 200, 16384));
        return columns.toArray(new BatchTableColumn[0]);
    }

    private void createTableButtonControl(Composite control, final TableViewer tableViewer) {
        Composite buttonControl = new Composite(control, 0);
        buttonControl.setLayout((Layout)new GridLayout(2, true));
        buttonControl.setLayoutData((Object)new GridData(128));
        Button addJobListenerButton = new Button(buttonControl, 8);
        addJobListenerButton.setText(BatchMessages.JobInfoContentsConstructor_JOB_LISTENER_ADD_BUTTON);
        addJobListenerButton.setLayoutData((Object)new GridData(768));
        final Button removeJobListenerButton = new Button(buttonControl, 8);
        removeJobListenerButton.setText(BatchMessages.JobInfoContentsConstructor_JOB_LISTENER_REMOVE_BUTTON);
        removeJobListenerButton.setLayoutData((Object)new GridData(768));
        removeJobListenerButton.setEnabled(false);
        removeJobListenerButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                IStructuredSelection selection = JobInfoContentsConstructor.this.getSelection(tableViewer);
                if (!NullUtil.isNull((Object)selection)) {
                    Object[] selections = selection.toArray();
                    tableViewer.remove(selections);
                    removeJobListenerButton.setEnabled(false);
                    Object[] items = tableViewer.getTable().getItems();
                    JobListenerInfo[] data = new JobListenerInfo[items.length];
                    if (!NullUtil.isEmpty((Object[])items)) {
                        int i = 0;
                        while (i < items.length) {
                            data[i] = (JobListenerInfo)items[i].getData();
                            ++i;
                        }
                    }
                    JobInfoContentsConstructor.this.tempJobVo.setJobListenerInfoList(data);
                }
            }
        });
        tableViewer.getTable().addListener(13, new Listener(){

            public void handleEvent(Event event) {
                removeJobListenerButton.setEnabled(true);
            }
        });
        addJobListenerButton.addListener(13, this.listenerTableListener(tableViewer, removeJobListenerButton));
    }

    private Text createJobIDField(Composite control, JobVo jobVo) {
        Composite jobIdControl = new Composite(control, 0);
        jobIdControl.setLayout((Layout)new GridLayout(2, false));
        jobIdControl.setLayoutData((Object)new GridData(768));
        Label jobId = new Label(jobIdControl, 0);
        jobId.setText(BatchMessages.JobInfoContentsConstructor_JOB_ID_LABEL);
        String jobName = jobVo.getJobName();
        Text jobIDField = new Text(jobIdControl, 2048);
        jobIDField.setLayoutData((Object)new GridData(768));
        jobIDField.setText(StringUtil.returnEmptyStringIfNull((String)jobName));
        return jobIDField;
    }

    @Override
    protected void validateItems() throws InfoContentsConstructor.InfoValidationException {
        this.validateDuplicationBeanID();
        this.validateJobID();
    }

    private void validateDuplicationBeanID() throws InfoContentsConstructor.InfoValidationException {
        if (!this.validateJobPageBeanID()) {
            this.throwInfoValidationException(BatchMessages.JobInfoContentsConstructor_DUPLICATE_BEAN_ID_ERROR_MESSAGE);
        }
    }

    private void validateJobID() throws InfoContentsConstructor.InfoValidationException {
        String jobName = this.tempJobVo.getJobName();
        if (NullUtil.isEmpty((String)jobName)) {
            this.throwInfoValidationException(BatchMessages.JobInfoContentsConstructor_EMPTY_JOB_ID_ERROR_MESSAGE);
        }
        if (!StringUtil.isBatchJobBeanIDAvailable((String)jobName)) {
            this.throwInfoValidationException(BatchMessages.JobInfoContentsConstructor_INVALID_JOB_ID_ERROR_MESSAGE);
        }
        if (!NullUtil.isEmpty((Object[])this.jobVoNameLists)) {
            int i = 0;
            while (i < this.jobVoNameLists.length) {
                if (jobName.equals(this.jobVoNameLists[i])) {
                    this.throwInfoValidationException(BatchMessages.JobInfoContentsConstructor_DUPLICATE_JOB_ID_ERROR_MESSAGE);
                }
                ++i;
            }
        }
        if (this.isBeanIDDuplicate(this.invalidBatchXMLFileBeanIDList, jobName)) {
            this.throwInfoValidationException(BatchMessages.JobInfoContentsConstructor_DUPLICATE_BEAN_ID_ERROR_MESSAGE);
        }
    }

    private boolean validateJobPageBeanID() {
        return this.setJobPageBeanID(new BatchPageBeanIDList());
    }

    private boolean setJobPageBeanID(BatchPageBeanIDList pageBeanIDs) {
        return pageBeanIDs.setJobInfoPageBeanIDs(this.tempJobVo);
    }

    private IStructuredSelection getSelection(TableViewer tableViewer) {
        IStructuredSelection selection = (IStructuredSelection)tableViewer.getSelection();
        if (selection.isEmpty()) {
            return null;
        }
        return selection;
    }

    private Listener listenerTableListener(final TableViewer tableviewer, final Button removeButton) {
        return new Listener(){

            public void handleEvent(Event event) {
                TableItem[] items = tableviewer.getTable().getItems();
                String[] listenerNames = JobInfoContentsConstructor.this.getListenerNameFromTableItem(items);
                BatchPageBeanIDList pageBeanIDs = new BatchPageBeanIDList();
                JobInfoContentsConstructor.this.setJobPageBeanID(pageBeanIDs);
                pageBeanIDs.removeBeanID(listenerNames);
                JobListenerDialog dialog = new JobListenerDialog(JobInfoContentsConstructor.this.infoControl.getShell(), listenerNames, JobInfoContentsConstructor.this.invalidBatchXMLFileBeanIDList, pageBeanIDs);
                if (dialog.open() == 0) {
                    ListenerInfo[] data = dialog.getInfo();
                    tableviewer.setInput((Object)data);
                    JobListenerInfo[] jobData = new JobListenerInfo[data.length];
                    int i = 0;
                    while (i < data.length) {
                        jobData[i] = (JobListenerInfo)data[i];
                        ++i;
                    }
                    JobInfoContentsConstructor.this.tempJobVo.setJobListenerInfoList(jobData);
                    removeButton.setEnabled(false);
                }
            }
        };
    }

    private String[] getListenerNameFromTableItem(TableItem[] items) {
        String[] result = new String[items.length];
        int i = 0;
        while (i < items.length) {
            result[i] = ((ListenerInfo)items[i].getData()).getName();
            ++i;
        }
        return result;
    }

    public JobVo getJobVo() {
        this.updateJobNameAndJobRWFullNameInStepDecisionVo(this.tempJobVo);
        return this.tempJobVo;
    }

    private void updateJobNameAndJobRWFullNameInStepDecisionVo(JobVo jobVo) {
        Object[] sdVos = jobVo.getStepAndDecisionVoList();
        if (!NullUtil.isEmpty((Object[])sdVos)) {
            int i = 0;
            while (i < sdVos.length) {
                ((StepAndDecisionVo)sdVos[i]).setJobName(jobVo.getJobName());
                if (sdVos[i] instanceof StepVo) {
                    StepVo stepVo = (StepVo)sdVos[i];
                    stepVo.setJobReaderFullName(this.getJobReaderFullName(stepVo));
                    stepVo.setJobWriterFullName(this.getJobWriterFullName(stepVo));
                }
                ++i;
            }
        }
    }

    private String getJobReaderFullName(StepVo stepVo) {
        return this.getJobRWFullName(stepVo.getJobName(), stepVo.getName(), (JobRWInfo)stepVo.getJobReaderInfo());
    }

    private String getJobWriterFullName(StepVo stepVo) {
        return this.getJobRWFullName(stepVo.getJobName(), stepVo.getName(), (JobRWInfo)stepVo.getJobWriterInfo());
    }

    private String getJobRWFullName(String jobID, String stepID, JobRWInfo jobRW) {
        if (!NullUtil.isNull((Object)jobRW)) {
            return String.valueOf(jobID) + "." + stepID + "." + jobRW.getName();
        }
        return null;
    }
}

