/*
 * Decompiled with CFR 0.152.
 */
package egovframework.bdev.imp.batch.wizards.jobcreation.pages;

import egovframework.bdev.imp.batch.common.BatchMessages;
import egovframework.bdev.imp.batch.wizards.jobcreation.model.BatchJobCreationContext;
import egovframework.bdev.imp.batch.wizards.jobcreation.model.TypeCSqlKeyValueVo;
import egovframework.bdev.imp.batch.wizards.jobcreation.pages.GetDatasourceBeanIDDialog;
import egovframework.bdev.imp.batch.wizards.jobcreation.pages.JobRWDetailInfoControlConstructor;
import egovframework.bdev.imp.batch.wizards.jobcreation.pages.KeyValueTableLabelProvider;
import egovframework.bdev.imp.batch.wizards.jobcreation.pages.SqlKeyValueTableDialog;
import egovframework.bdev.imp.batch.wizards.jobcreation.util.JobRWDBDetailInfoValidationUtil;
import egovframework.bdev.imp.confmngt.preferences.readwrite.model.JobRWInfo;
import egovframework.dev.imp.core.utils.BatchTableColumn;
import egovframework.dev.imp.core.utils.NullUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public class JobRWDBDetailInfoControlConstructor
extends JobRWDetailInfoControlConstructor {
    private List<TypeCSqlKeyValueVo> sqlKeyValueList = new ArrayList<TypeCSqlKeyValueVo>();
    private List<TypeCSqlKeyValueVo> preSavedSqlKeyValueList = null;
    private JobRWDBDetailInfoValidationUtil validation = new JobRWDBDetailInfoValidationUtil(this.detailContext);

    public JobRWDBDetailInfoControlConstructor(ScrolledComposite detailInfoControl, Label errorSettingLabel, BatchJobCreationContext context, Map<String, String> preSavedDetailContext, List<TypeCSqlKeyValueVo> preSavedSqlKeyValueList, boolean isPreviousSelectedJobRW) {
        super(detailInfoControl, errorSettingLabel, context, preSavedDetailContext, isPreviousSelectedJobRW);
        this.preSavedSqlKeyValueList = preSavedSqlKeyValueList;
        this.sqlKeyValueList.addAll(preSavedSqlKeyValueList);
    }

    @Override
    protected void createDetailInfoContents(Composite control, JobRWInfo jobRWInfo) {
        String resourceDetailType = jobRWInfo.getResourceDetailType();
        if ("IbatisRW".equals(resourceDetailType)) {
            this.createIbatisRWControl(control);
        } else if ("CustomizedJdbcCursorItemReader".equals(resourceDetailType)) {
            this.createCustomizedJdbcCursorItemReaderControl(control);
        } else if ("SqlPagingQueryJdbcItemReader".equals(resourceDetailType)) {
            this.createSqlPagingQueryJdbcItemReaderControl(control);
        } else if ("SqlParameterJdbcBatchItemWriter".equals(resourceDetailType)) {
            this.createSqlParameterJdbcBatchItemWriterControl(control);
        } else if ("ItemPreparedStatementJdbcBatchItemWriter".equals(resourceDetailType)) {
            this.createItemPreparedStatementJdbcBatchItemWriterControl(control);
        } else if ("EgovItemPreparedStatementJdbcBatchItemWriter".equals(resourceDetailType)) {
            this.createEgovItemPreparedStatementJdbcBatchItemWriterControl(control);
        } else if ("EgovCustomizedJdbcBatchItemWriter".equals(resourceDetailType)) {
            this.createEgovCustomizedJdbcBatchItemWriterControl(control);
        } else if ("CustomizeDB".equals(resourceDetailType)) {
            this.createCustomizeDBControl();
        }
    }

    private void createIbatisRWControl(Composite control) {
        Text iBatisStatementText = this.createIBatisStatementControl(control);
        this.addIbatisRWItemListener(iBatisStatementText);
        Text configurationFile = this.createConfigurationFileControl(control);
        this.addIbatisRWItemListener(configurationFile);
        this.createDatasourceBeanIDText(control);
        this.setMessage(this.validation.validateIbatisRWAndGetErrorMessage());
    }

    private void addIbatisRWItemListener(Text text) {
        text.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                String message = JobRWDBDetailInfoControlConstructor.this.validation.validateIbatisRWAndGetErrorMessage();
                JobRWDBDetailInfoControlConstructor.this.setMessage(message);
            }
        });
    }

    private void createCustomizedJdbcCursorItemReaderControl(Composite control) {
        Text sqlText = this.createSqlControl(control);
        this.addCustomizedJdbcCursorItemReaderItemListener(sqlText);
        Text rowMapperText = this.createRowMapperControl(control);
        this.addCustomizedJdbcCursorItemReaderItemListener(rowMapperText);
        this.createDatasourceBeanIDText(control);
        this.setMessage(this.validation.validateCustomizedJdbcCursorItemReaderAndGetErrorMessage());
    }

    private void addCustomizedJdbcCursorItemReaderItemListener(Text text) {
        text.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                String message = JobRWDBDetailInfoControlConstructor.this.validation.validateCustomizedJdbcCursorItemReaderAndGetErrorMessage();
                JobRWDBDetailInfoControlConstructor.this.setMessage(message);
            }
        });
    }

    private void createSqlPagingQueryJdbcItemReaderControl(Composite control) {
        this.resizeToFitScrollVisibleControl(control);
        Text rowMapperText = this.createRowMapperControl(control);
        this.addSqlPagingQueryJdbcItemReaderItemListener(rowMapperText);
        Text pageSizeText = this.createPageSizeControl(control);
        this.addSqlPagingQueryJdbcItemReaderItemListener(pageSizeText);
        Text sqlSortColumn = this.createSqlSortColumnControl(control);
        this.addSqlPagingQueryJdbcItemReaderItemListener(sqlSortColumn);
        Text sqlSelectText = this.createSqlSelectControl(control);
        this.addSqlPagingQueryJdbcItemReaderItemListener(sqlSelectText);
        Text sqlFromText = this.createSqlFromControl(control);
        this.addSqlPagingQueryJdbcItemReaderItemListener(sqlFromText);
        Text sqlWhereText = this.createSqlWhereControl(control);
        this.addSqlPagingQueryJdbcItemReaderItemListener(sqlWhereText);
        Combo databaseTypeCombo = this.createDatabaseType(control);
        databaseTypeCombo.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                String message = JobRWDBDetailInfoControlConstructor.this.validation.validateSqlPagingQueryJdbcItemReaderAndGetErrorMessage();
                JobRWDBDetailInfoControlConstructor.this.setMessage(message);
            }
        });
        Text datasourceBeanIDText = this.createDatasourceBeanIDText(control);
        this.addSqlPagingQueryJdbcItemReaderItemListener(datasourceBeanIDText);
        this.createSqlTableViewerControl(control);
        this.setMessage(this.validation.validateSqlPagingQueryJdbcItemReaderAndGetErrorMessage());
    }

    private void resizeToFitScrollVisibleControl(Composite control) {
        Point prePoint = control.getSize();
        int newX = prePoint.x - 13;
        int newY = prePoint.y;
        control.setSize(newX, newY);
    }

    private void addSqlPagingQueryJdbcItemReaderItemListener(Text text) {
        text.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                String message = JobRWDBDetailInfoControlConstructor.this.validation.validateSqlPagingQueryJdbcItemReaderAndGetErrorMessage();
                JobRWDBDetailInfoControlConstructor.this.setMessage(message);
            }
        });
    }

    private void createSqlParameterJdbcBatchItemWriterControl(Composite control) {
        Text sqlUpdateText = this.createSqlUpdateControl(control);
        this.addSqlParameterJdbcBatchItemWriterItemListener(sqlUpdateText);
        this.createDatasourceBeanIDText(control);
        this.setMessage(this.validation.validateSqlParameterJdbcBatchItemWriterAndGetErrorMessage());
    }

    private void addSqlParameterJdbcBatchItemWriterItemListener(Text text) {
        text.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                String message = JobRWDBDetailInfoControlConstructor.this.validation.validateSqlParameterJdbcBatchItemWriterAndGetErrorMessage();
                JobRWDBDetailInfoControlConstructor.this.setMessage(message);
            }
        });
    }

    private void createItemPreparedStatementJdbcBatchItemWriterControl(Composite control) {
        Text sqlInsertText = this.createSqlInsertControl(control);
        this.addSqlItemPreparedStatementJdbcBatchItemWriterItemListener(sqlInsertText);
        Text rowSetterText = this.createRowSetterControl(control);
        this.addSqlItemPreparedStatementJdbcBatchItemWriterItemListener(rowSetterText);
        this.createDatasourceBeanIDText(control);
        this.setMessage(this.validation.validateItemPreparedStatementJdbcBatchItemWriterAndGetErrorMessage());
    }

    private void addSqlItemPreparedStatementJdbcBatchItemWriterItemListener(Text text) {
        text.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                String message = JobRWDBDetailInfoControlConstructor.this.validation.validateItemPreparedStatementJdbcBatchItemWriterAndGetErrorMessage();
                JobRWDBDetailInfoControlConstructor.this.setMessage(message);
            }
        });
    }

    private void createEgovItemPreparedStatementJdbcBatchItemWriterControl(Composite control) {
        Text sqlInsertText = this.createSqlInsertControl(control);
        this.addEgovItemPreparedStatementJdbcBatchItemWriterItemListener(sqlInsertText);
        Text paramsText = this.createParamsControl(control);
        this.addEgovItemPreparedStatementJdbcBatchItemWriterItemListener(paramsText);
        this.createDatasourceBeanIDText(control);
        this.setMessage(this.validation.validateEgovItemPreparedStatementJdbcBatchItemWriterAndGetErrorMessage());
    }

    private void addEgovItemPreparedStatementJdbcBatchItemWriterItemListener(Text text) {
        text.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                String message = JobRWDBDetailInfoControlConstructor.this.validation.validateEgovItemPreparedStatementJdbcBatchItemWriterAndGetErrorMessage();
                JobRWDBDetailInfoControlConstructor.this.setMessage(message);
            }
        });
    }

    private void createEgovCustomizedJdbcBatchItemWriterControl(Composite control) {
        Text sqlInsertText = this.createSqlInsertControl(control);
        this.addEgovCustomizedJdbcBatchItemWriterItemListener(sqlInsertText);
        Text rowSetterText = this.createRowSetterControl(control);
        this.addEgovCustomizedJdbcBatchItemWriterItemListener(rowSetterText);
        this.createDatasourceBeanIDText(control);
        this.setMessage(this.validation.validateEgovCustomizedJdbcBatchItemWriterAndGetErrorMessage());
    }

    private void addEgovCustomizedJdbcBatchItemWriterItemListener(Text text) {
        text.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                String message = JobRWDBDetailInfoControlConstructor.this.validation.validateEgovCustomizedJdbcBatchItemWriterAndGetErrorMessage();
                JobRWDBDetailInfoControlConstructor.this.setMessage(message);
            }
        });
    }

    private void createCustomizeDBControl() {
        this.setMessageOK();
    }

    private Text createIBatisStatementControl(Composite control) {
        Text iBatisStatementText = this.createLabelText(control, BatchMessages.JobRWDBDetailInfoControlConstructor_IBATIS_STATEMENT_LABEL);
        this.setTextHorizontalFullAndSpan(iBatisStatementText, 2);
        this.addSaveValueToContextListener("iBatisStatement", iBatisStatementText);
        this.setInitialValueToText("iBatisStatement", iBatisStatementText);
        return iBatisStatementText;
    }

    private Text createConfigurationFileControl(Composite control) {
        Text configurationFileText = this.createLabelText(control, BatchMessages.JobRWDBDetailInfoControlConstructor_CONFIGURATION_FILE_LABEL);
        this.addSaveValueToContextListener("ConfigurationFile", configurationFileText);
        this.setInitialValueToText("ConfigurationFile", configurationFileText);
        Button browseButton = this.createBrowseButton(control);
        browseButton.addListener(13, this.getConfigurationButtonListener(control, configurationFileText));
        return configurationFileText;
    }

    private Listener getConfigurationButtonListener(Composite control, Text text) {
        String[] filterExt = new String[]{"*.xml"};
        return this.getFileDialogButtonListener(control, text, filterExt);
    }

    private Text createSqlControl(Composite control) {
        Text sqlText = this.createLabelText(control, BatchMessages.JobRWDBDetailInfoControlConstructor_SQL_LABEL);
        sqlText.setText(BatchMessages.JobRWDBDetailInfoControlConstructor_SQL_EXAMPLE);
        this.setTextHorizontalFullAndSpan(sqlText, 2);
        this.addSaveValueToContextListener("Sql", sqlText);
        this.setInitialValueToText("Sql", sqlText);
        return sqlText;
    }

    private Text createRowMapperControl(Composite control) {
        Text rowMapperText = this.createLabelText(control, BatchMessages.JobRWDBDetailInfoControlConstructor_ROW_MAPPER_LABEL);
        this.addSaveValueToContextListener("RowMapper", rowMapperText);
        this.setInitialValueToText("RowMapper", rowMapperText);
        Button button = this.createBrowseButton(control);
        button.addListener(13, this.getClassSearchBrowseButtonListener(rowMapperText));
        return rowMapperText;
    }

    private Text createPageSizeControl(Composite control) {
        Text pageSizeText = this.createLabelText(control, BatchMessages.JobRWDBDetailInfoControlConstructor_PAGE_SIZE_LABEL);
        this.setTextHorizontalFullAndSpan(pageSizeText, 2);
        this.addSaveValueToContextListener("PageSize", pageSizeText);
        this.setInitialValueToText("PageSize", pageSizeText);
        return pageSizeText;
    }

    private Text createSqlSortColumnControl(Composite control) {
        Text sqlSortColumn = this.createLabelText(control, BatchMessages.JobRWDBDetailInfoControlConstructor_SQL_SORT_COLUMN_LABEL);
        sqlSortColumn.setText(BatchMessages.JobRWDBDetailInfoControlConstructor_SQL_SORT_COLUMN_EXAMPLE);
        this.setTextHorizontalFullAndSpan(sqlSortColumn, 2);
        this.addSaveValueToContextListener("Sql-SortColumn", sqlSortColumn);
        this.setInitialValueToText("Sql-SortColumn", sqlSortColumn);
        return sqlSortColumn;
    }

    private Text createSqlSelectControl(Composite control) {
        Text sqlSelectText = this.createLabelText(control, BatchMessages.JobRWDBDetailInfoControlConstructor_SQL_SELECT_LABEL);
        sqlSelectText.setText(BatchMessages.JobRWDBDetailInfoControlConstructor_SQL_SELECT_EXAMPLE);
        this.setTextHorizontalFullAndSpan(sqlSelectText, 2);
        this.addSaveValueToContextListener("Sql-SELECT", sqlSelectText);
        this.setInitialValueToText("Sql-SELECT", sqlSelectText);
        return sqlSelectText;
    }

    private Text createSqlFromControl(Composite control) {
        Text sqlFromText = this.createLabelText(control, BatchMessages.JobRWDBDetailInfoControlConstructor_SQL_FROM_LABEL);
        sqlFromText.setText(BatchMessages.JobRWDBDetailInfoControlConstructor_SQL_FROM_EXAMPLE);
        this.setTextHorizontalFullAndSpan(sqlFromText, 2);
        this.addSaveValueToContextListener("Sql-FROM", sqlFromText);
        this.setInitialValueToText("Sql-FROM", sqlFromText);
        return sqlFromText;
    }

    private Text createSqlWhereControl(Composite control) {
        Text sqlWhereText = this.createLabelText(control, BatchMessages.JobRWDBDetailInfoControlConstructor_SQL_WHERE_LABEL);
        sqlWhereText.setText(BatchMessages.JobRWDBDetailInfoControlConstructor_SQL_WHERE_EXAMPLE);
        this.setTextHorizontalFullAndSpan(sqlWhereText, 2);
        this.addSaveValueToContextListener("Sql-WHERE", sqlWhereText);
        this.setInitialValueToText("Sql-WHERE", sqlWhereText);
        return sqlWhereText;
    }

    private Text createSqlUpdateControl(Composite control) {
        Text sqlUpdateText = this.createLabelText(control, BatchMessages.JobRWDBDetailInfoControlConstructor_SQL_LABEL);
        sqlUpdateText.setText(BatchMessages.JobRWDBDetailInfoControlConstructor_SQL_UPDATE_EXAMPLE);
        this.setTextHorizontalFullAndSpan(sqlUpdateText, 2);
        this.addSaveValueToContextListener("Sql-Update", sqlUpdateText);
        this.setInitialValueToText("Sql-Update", sqlUpdateText);
        return sqlUpdateText;
    }

    private Text createSqlInsertControl(Composite control) {
        Text sqlInsertText = this.createLabelText(control, BatchMessages.JobRWDBDetailInfoControlConstructor_SQL_LABEL);
        sqlInsertText.setText(BatchMessages.JobRWDBDetailInfoControlConstructor_SQL_INSERT_EXAMPLE);
        this.setTextHorizontalFullAndSpan(sqlInsertText, 2);
        this.addSaveValueToContextListener("Sql-Insert", sqlInsertText);
        this.setInitialValueToText("Sql-Insert", sqlInsertText);
        return sqlInsertText;
    }

    private Text createParamsControl(Composite control) {
        Text paramsText = this.createLabelText(control, BatchMessages.JobRWDBDetailInfoControlConstructor_PARAMS_LABEL);
        paramsText.setText(BatchMessages.JobRWDBDetailInfoControlConstructor_PARAMS_EXAMPLE);
        this.setTextHorizontalFullAndSpan(paramsText, 2);
        this.addSaveValueToContextListener("Params", paramsText);
        this.setInitialValueToText("Params", paramsText);
        return paramsText;
    }

    private Text createRowSetterControl(Composite control) {
        Text rowSetterText = this.createLabelText(control, BatchMessages.JobRWDBDetailInfoControlConstructor_ROW_SETTER_LABEL);
        this.addSaveValueToContextListener("RowSetter", rowSetterText);
        this.setInitialValueToText("RowSetter", rowSetterText);
        Button button = this.createBrowseButton(control);
        button.addListener(13, this.getClassSearchBrowseButtonListener(rowSetterText));
        return rowSetterText;
    }

    private TableViewer createSqlTableViewerControl(Composite control) {
        GridData gData = new GridData(1808);
        gData.horizontalSpan = 3;
        Composite TableViewerControl = new Composite(control, 0);
        TableViewerControl.setLayout((Layout)new GridLayout(2, false));
        TableViewerControl.setLayoutData((Object)gData);
        TableViewer tableViewer = this.createTableViewer(TableViewerControl);
        this.createTableViewerButtonControl(TableViewerControl, tableViewer);
        return tableViewer;
    }

    private TableViewer createTableViewer(Composite control) {
        TableViewer tableViewer = new TableViewer(control, 68352);
        tableViewer.getControl().setLayoutData((Object)new GridData(1808));
        tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        tableViewer.setLabelProvider((IBaseLabelProvider)new KeyValueTableLabelProvider());
        Table table = tableViewer.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        BatchTableColumn keyColumn = new BatchTableColumn(BatchMessages.JobRWDBDetailInfoControlConstructor_SQL_TABLE_COLUMN_KEY, 150);
        BatchTableColumn valueColumn = new BatchTableColumn(BatchMessages.JobRWDBDetailInfoControlConstructor_SQL_TABLE_COLUMN_VALUE, 180);
        keyColumn.setColumnToTable(table);
        valueColumn.setColumnToTable(table);
        tableViewer.setInput(this.preSavedSqlKeyValueList);
        return tableViewer;
    }

    private void createTableViewerButtonControl(Composite control, TableViewer tableViewer) {
        Composite buttonControl = new Composite(control, 0);
        buttonControl.setLayout((Layout)new GridLayout());
        buttonControl.setLayoutData((Object)new GridData(1040));
        this.createAddButton(buttonControl, tableViewer);
        this.createRemoveButton(buttonControl, tableViewer);
    }

    private void createAddButton(final Composite control, final TableViewer tableViewer) {
        Button addButton = new Button(control, 8);
        addButton.setText(BatchMessages.JobRWDBDetailInfoControlConstructor_ADD_BUTTON);
        addButton.setLayoutData((Object)new GridData(768));
        addButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                SqlKeyValueTableDialog dialog = new SqlKeyValueTableDialog(control.getShell());
                dialog.setTitle(BatchMessages.JobRWDBDetailInfoControlConstructor_SQL_TABLE_ADD_BUTTON_DIALOG_TITLE);
                if (dialog.open() == 0) {
                    TypeCSqlKeyValueVo vo = dialog.getVo();
                    tableViewer.add((Object)vo);
                    JobRWDBDetailInfoControlConstructor.this.sqlKeyValueList.add(vo);
                }
            }
        });
    }

    private void createRemoveButton(Composite control, final TableViewer tableViewer) {
        Button removeButton = new Button(control, 8);
        removeButton.setText(BatchMessages.JobRWDBDetailInfoControlConstructor_REMOVE_BUTTON);
        removeButton.setLayoutData((Object)new GridData(768));
        removeButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                IStructuredSelection selection = (IStructuredSelection)tableViewer.getSelection();
                if (!selection.isEmpty()) {
                    TypeCSqlKeyValueVo vo = (TypeCSqlKeyValueVo)selection.getFirstElement();
                    tableViewer.remove((Object)vo);
                    JobRWDBDetailInfoControlConstructor.this.removeItemFromSqlKeyValueList(vo);
                }
            }
        });
    }

    private boolean removeItemFromSqlKeyValueList(TypeCSqlKeyValueVo toRemoveVo) {
        if (!NullUtil.isEmpty(this.sqlKeyValueList)) {
            for (TypeCSqlKeyValueVo vo : this.sqlKeyValueList) {
                if (!vo.key.equals(toRemoveVo.key)) continue;
                return this.sqlKeyValueList.remove(vo);
            }
        }
        return false;
    }

    @Override
    public List<TypeCSqlKeyValueVo> getSqlKeyValueList() {
        return this.sqlKeyValueList;
    }

    private Combo createDatabaseType(Composite control) {
        Label databaseTypeLabel = new Label(control, 0);
        databaseTypeLabel.setText(BatchMessages.JobRWDBDetailInfoControlConstructor_DATABASE_TYPE_LABEL);
        GridData gData = new GridData(768);
        gData.horizontalSpan = 2;
        Combo databaseTypeCombo = new Combo(control, 2056);
        databaseTypeCombo.setItems(new String[]{"Oracle", "Hsql", "mySql", "Altibase", "Tibero"});
        databaseTypeCombo.setLayoutData((Object)gData);
        this.addSaveValueToContextListener("DatabaseType", databaseTypeCombo);
        this.setInitialValueToCombo("DatabaseType", databaseTypeCombo);
        return databaseTypeCombo;
    }

    private Text createDatasourceBeanIDText(final Composite control) {
        final Text datasourceBeanIDText = this.createLabelText(control, BatchMessages.JobRWDBDetailInfoControlConstructor_DATABASE_BEAN_ID_LABEL);
        this.addSaveValueToContextListener("DatasourceBeanID", datasourceBeanIDText);
        this.setInitialValueToText("DatasourceBeanID", datasourceBeanIDText);
        Button datasourceBrowseButton = new Button(control, 8);
        datasourceBrowseButton.setText(BatchMessages.JobRWDBDetailInfoControlConstructor_BROWSE_BUTTON);
        datasourceBrowseButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                String selectedBeanID = "";
                GetDatasourceBeanIDDialog dialog = new GetDatasourceBeanIDDialog(control.getShell(), JobRWDBDetailInfoControlConstructor.this.context, selectedBeanID);
                dialog.setTitle(BatchMessages.JobRWDBDetailInfoControlConstructor_DATASOURCE_BEAN_ID_BROWSE_BUTTON_DIALOG_TITLE);
                if (dialog.open() == 0) {
                    selectedBeanID = dialog.getRefDatasourceBeanID();
                    datasourceBeanIDText.setText(selectedBeanID);
                }
            }
        });
        return datasourceBeanIDText;
    }
}

