/*
 * Decompiled with CFR 0.152.
 */
package egovframework.bdev.imp.batch.wizards.jobcreation.pages;

import egovframework.bdev.imp.batch.common.BatchMessages;
import egovframework.bdev.imp.batch.wizards.jobcreation.model.BatchJobCreationContext;
import egovframework.bdev.imp.batch.wizards.jobcreation.model.TypeCSqlKeyValueVo;
import egovframework.bdev.imp.confmngt.preferences.readwrite.model.JobRWInfo;
import egovframework.dev.imp.core.utils.NullUtil;
import egovframework.dev.imp.core.utils.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.core.BinaryType;
import org.eclipse.jdt.internal.core.SourceType;
import org.eclipse.jdt.internal.ui.dialogs.FilteredTypesSelectionDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public abstract class JobRWDetailInfoControlConstructor {
    protected final ScrolledComposite detailInfoControl;
    protected final Label errorSettingLabel;
    protected BatchJobCreationContext context = null;
    private Map<String, String> preSavedDetailContext = null;
    protected Map<String, String> detailContext = new HashMap<String, String>();
    private boolean isPreviousSelectedJobRW;

    public JobRWDetailInfoControlConstructor(ScrolledComposite detailInfoControl, Label errorSettingLabel, BatchJobCreationContext context, Map<String, String> detailContext, boolean isPreviousSelectedJobRW) {
        this.detailInfoControl = detailInfoControl;
        this.errorSettingLabel = errorSettingLabel;
        this.context = context;
        this.preSavedDetailContext = detailContext;
        this.isPreviousSelectedJobRW = isPreviousSelectedJobRW;
    }

    public void createDetailInfoControl(JobRWInfo jobRWInfo) {
        jobRWInfo.getResourceDetailType();
        this.clearDetailInfoControl();
        Composite control = this.createColumnControl();
        this.createDetailInfoContents(control, jobRWInfo);
        this.detailInfoControl.setMinSize(control.computeSize(-1, -1));
        this.detailInfoControl.getParent().layout(true, true);
    }

    protected abstract void createDetailInfoContents(Composite var1, JobRWInfo var2);

    private Composite createColumnControl() {
        Composite control = new Composite((Composite)this.detailInfoControl, 0);
        control.setLayout((Layout)new GridLayout(3, false));
        control.setLayoutData((Object)new GridData(1808));
        control.setSize(440, -1);
        this.detailInfoControl.setContent((Control)control);
        return control;
    }

    protected void clearDetailInfoControl() {
        Object[] children = this.detailInfoControl.getChildren();
        if (!NullUtil.isEmpty((Object[])children)) {
            Object[] objectArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                child.dispose();
                ++n2;
            }
        }
    }

    protected Button createBrowseButton(Composite control) {
        Button button = new Button(control, 8);
        button.setText(BatchMessages.JobRWDetailInfoControlConstructor_BROWSE_BUTTON);
        return button;
    }

    protected Text createLabelText(Composite control, String labelContent) {
        Label label = new Label(control, 0);
        label.setText(labelContent);
        Text text = new Text(control, 2048);
        text.setLayoutData((Object)new GridData(768));
        return text;
    }

    protected void setTextHorizontalFullAndSpan(Text text, int spanNumber) {
        if (!NullUtil.isNull((Object)text)) {
            GridData gData = new GridData(768);
            gData.horizontalSpan = spanNumber;
            text.setLayoutData((Object)gData);
        }
    }

    protected void addSaveValueToContextListener(final String item, final Text text) {
        text.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                JobRWDetailInfoControlConstructor.this.saveValueToContext(item, text.getText());
            }
        });
    }

    private void saveValueToContext(String item, String value) {
        this.detailContext.put(item, value);
    }

    protected void addSaveValueToContextListener(final String item, final Combo combo) {
        combo.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                JobRWDetailInfoControlConstructor.this.saveValueToContext(item, combo.getText());
            }
        });
    }

    protected void setInitialValueToText(String item, Text text) {
        if (this.isPreviousSelectedJobRW) {
            String value = this.preSavedDetailContext.get(item);
            value = StringUtil.returnEmptyStringIfNull((String)value);
            text.setText(value);
        }
    }

    protected void setInitialValueToCombo(String item, Combo combo) {
        if (this.isPreviousSelectedJobRW) {
            String value = this.preSavedDetailContext.get(item);
            value = StringUtil.returnEmptyStringIfNull((String)value);
            combo.setText(value);
        }
    }

    protected void setMessage(String message) {
        String errorMessage = StringUtil.returnEmptyStringIfNull((String)message);
        this.errorSettingLabel.setText(errorMessage);
        this.errorSettingLabel.notifyListeners(24, null);
    }

    protected void setMessageOK() {
        this.setMessage(null);
    }

    protected Listener getClassSearchBrowseButtonListener(final Text text) {
        return new Listener(){

            public void handleEvent(Event event) {
                Object type;
                FilteredTypesSelectionDialog dialog = new FilteredTypesSelectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), false, (IRunnableContext)PlatformUI.getWorkbench().getProgressService(), SearchEngine.createWorkspaceScope(), 5);
                dialog.setTitle(BatchMessages.JobRWDetailInfoControlConstructor_BROWSE_DIALOG_TITLE);
                dialog.setMessage(BatchMessages.JobRWDetailInfoControlConstructor_BROWSE_DIALOG_DESCRIPTION);
                dialog.setInitialPattern("");
                if (dialog.open() == 0 && !NullUtil.isNull((Object)(type = dialog.getFirstResult()))) {
                    if (type instanceof BinaryType) {
                        BinaryType binaryType = (BinaryType)type;
                        text.setText(binaryType.getFullyQualifiedName());
                    } else if (type instanceof SourceType) {
                        SourceType sourceType = (SourceType)type;
                        text.setText(sourceType.getFullyQualifiedName());
                    }
                }
            }
        };
    }

    public Map<String, String> getDetailContext() {
        return this.detailContext;
    }

    public List<TypeCSqlKeyValueVo> getSqlKeyValueList() {
        return new ArrayList<TypeCSqlKeyValueVo>();
    }

    protected Listener getFileDialogButtonListener(final Composite control, final Text text, final String[] filterExt) {
        return new Listener(){

            public void handleEvent(Event event) {
                FileDialog fileDialog = new FileDialog(control.getShell(), 4096);
                fileDialog.setText(BatchMessages.StepInfoContentsConstructor_RESOURCE_BUTTON_DIALOG_TITLE);
                fileDialog.setFilterPath(JobRWDetailInfoControlConstructor.this.context.getProject().getLocation().toOSString());
                fileDialog.setFilterExtensions(filterExt);
                String selectedResource = fileDialog.open();
                if (NullUtil.isEmpty((String)selectedResource)) {
                    selectedResource = StringUtil.returnEmptyStringIfNull((String)text.getText());
                } else {
                    String[] extensions = this.getExtensions(filterExt);
                    if (!this.hasExtension(selectedResource = selectedResource.replace("\\", "/"), extensions)) {
                        int extensionIndex = fileDialog.getFilterIndex();
                        String extension = extensions[extensionIndex];
                        selectedResource = String.valueOf(selectedResource) + "." + extension;
                    }
                }
                text.setText(selectedResource);
            }

            private String[] getExtensions(String[] filteredExtensions) {
                ArrayList<String> extensions = new ArrayList<String>();
                if (!NullUtil.isEmpty((Object[])filteredExtensions)) {
                    String[] stringArray = filteredExtensions;
                    int n = filteredExtensions.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String filteredExtension = stringArray[n2];
                        int dotIndex = filteredExtension.lastIndexOf(".");
                        String extension = filteredExtension.substring(dotIndex + 1);
                        extensions.add(extension);
                        ++n2;
                    }
                }
                return extensions.toArray(new String[0]);
            }

            private boolean hasExtension(String resourceName, String[] extensions) {
                if (!NullUtil.isEmpty((Object[])extensions)) {
                    String[] stringArray = extensions;
                    int n = extensions.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String extension = stringArray[n2];
                        if (resourceName.endsWith(extension)) {
                            return true;
                        }
                        ++n2;
                    }
                }
                return false;
            }
        };
    }
}

