/*
 * Decompiled with CFR 0.152.
 */
package egovframework.bdev.imp.batch.wizards.jobcreation.pages;

import egovframework.bdev.imp.batch.common.BatchMessages;
import egovframework.bdev.imp.batch.wizards.jobcreation.model.BatchJobCreationContext;
import egovframework.bdev.imp.batch.wizards.jobcreation.model.BatchPageBeanIDList;
import egovframework.bdev.imp.batch.wizards.jobcreation.model.BatchXMLFileBeanIDList;
import egovframework.bdev.imp.batch.wizards.jobcreation.model.TypeCSqlKeyValueVo;
import egovframework.bdev.imp.batch.wizards.jobcreation.pages.JobRWDBDetailInfoControlConstructor;
import egovframework.bdev.imp.batch.wizards.jobcreation.pages.JobRWDetailInfoControlConstructor;
import egovframework.bdev.imp.batch.wizards.jobcreation.pages.JobRWFileDetailInfoControlConstructor;
import egovframework.bdev.imp.confmngt.preferences.readwrite.JobRWTabContents;
import egovframework.bdev.imp.confmngt.preferences.readwrite.model.JobRWInfo;
import egovframework.dev.imp.core.utils.NullUtil;
import egovframework.dev.imp.core.utils.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;

public abstract class JobRWDialog
extends StatusDialog {
    private JobRWInfo selectJobRWInfo = null;
    private JobRWTabContents contents = null;
    private BatchXMLFileBeanIDList batchXMLFileBeanIDList = null;
    private BatchPageBeanIDList pageBeanIDs = null;
    private String semiTitle = null;
    private String semiDescription = null;
    private String noteContent = null;
    private JobRWDetailInfoControlConstructor detailInfoControlConstructor = null;
    private final boolean isPartitionType;
    private ScrolledComposite detailInfoControl = null;
    private Label errorSettingLabel = null;
    private Map<String, String> detailContext = null;
    private List<TypeCSqlKeyValueVo> sqlKeyValueVo = new ArrayList<TypeCSqlKeyValueVo>();
    private BatchJobCreationContext context = null;
    private static final String INITAIL_DISABLE_FINISH_BUTTON = "INITAIL_DISABLE_FINISH_BUTTON";
    private final String previousSelectedJobRW;
    Listener validation = new Listener(){

        public void handleEvent(Event event) {
            IStructuredSelection selection = (IStructuredSelection)JobRWDialog.this.contents.getTableViewer().getSelection();
            StatusInfo status = new StatusInfo();
            if (selection.isEmpty()) {
                status.setError(JobRWDialog.this.getEmptyErrorMessage());
                JobRWDialog.this.updateStatus((IStatus)status);
                return;
            }
            JobRWDialog.this.selectJobRWInfo = (JobRWInfo)selection.getFirstElement();
            if (!JobRWDialog.this.validateBeanID(JobRWDialog.this.selectJobRWInfo.getName())) {
                status.setError(BatchMessages.JobRWDialog_DUPLICATE_BEAN_ID_ERROR_MESSAGE);
                JobRWDialog.this.updateStatus((IStatus)status);
                return;
            }
            String errorMessage = JobRWDialog.this.errorSettingLabel.getText();
            if (!NullUtil.isEmpty((String)errorMessage)) {
                status.setError(errorMessage);
                JobRWDialog.this.updateStatus((IStatus)status);
                return;
            }
            status.setOK();
            JobRWDialog.this.updateStatus((IStatus)status);
        }
    };
    Listener contentsListner = new Listener(){

        public void handleEvent(Event event) {
            IStructuredSelection selection = (IStructuredSelection)JobRWDialog.this.contents.getTableViewer().getSelection();
            JobRWDialog.this.selectJobRWInfo = (JobRWInfo)selection.getFirstElement();
            JobRWDialog.this.createDetailInfoControl(JobRWDialog.this.selectJobRWInfo, JobRWDialog.this.isPartitionType);
            String errorMessage = JobRWDialog.this.errorSettingLabel.getText();
            if (!NullUtil.isEmpty((String)errorMessage)) {
                JobRWDialog.this.errorSettingLabel.setText("");
                JobRWDialog.this.errorSettingLabel.notifyListeners(24, null);
                Button okButton = JobRWDialog.this.getOKButton();
                okButton.setEnabled(false);
            }
        }
    };

    public Map<String, String> getDetailContext() {
        return this.detailContext;
    }

    public List<TypeCSqlKeyValueVo> getSqlKeyValueVo() {
        return this.sqlKeyValueVo;
    }

    public void setNoteContent(String noteContent) {
        this.noteContent = noteContent;
    }

    public void setContents(JobRWTabContents contents) {
        this.contents = contents;
    }

    public void setSemiTitle(String semiTitle) {
        this.semiTitle = semiTitle;
    }

    public void setsemiDescription(String semiDescription) {
        this.semiDescription = semiDescription;
    }

    public JobRWInfo getInfo() {
        return this.selectJobRWInfo;
    }

    public JobRWDialog(Shell parent, BatchXMLFileBeanIDList batchXMLFileBeanIDList, BatchPageBeanIDList pageBeanIDs, JobRWInfo info, boolean isPartitionType, BatchJobCreationContext context, Map<String, String> detailContext, List<TypeCSqlKeyValueVo> sqlKeyValueVo) {
        super(parent);
        this.batchXMLFileBeanIDList = batchXMLFileBeanIDList;
        this.pageBeanIDs = pageBeanIDs;
        this.selectJobRWInfo = info;
        this.isPartitionType = isPartitionType;
        this.context = context;
        this.detailContext = detailContext;
        this.previousSelectedJobRW = NullUtil.isNull((Object)info) ? "" : this.selectJobRWInfo.getName();
        this.sqlKeyValueVo = sqlKeyValueVo;
    }

    protected Control createDialogArea(Composite parent) {
        GridData tableGData = new GridData(768);
        tableGData.heightHint = 450;
        Composite control = new Composite(parent, 0);
        control.setLayout((Layout)new GridLayout());
        control.setLayoutData((Object)tableGData);
        Label semiTitleLabel = new Label(control, 0);
        semiTitleLabel.setText(this.semiTitle);
        StringUtil.setLabelStringBold((Label)semiTitleLabel);
        Label semiDescriptionLabel = new Label(control, 0);
        semiDescriptionLabel.setText(this.semiDescription);
        Link link = new Link(control, 131072);
        link.setLayoutData((Object)new GridData(128));
        link.setText(BatchMessages.JobRWDialog_LINK_MESSAGE);
        link.addListener(4, new Listener(){

            public void handleEvent(Event event) {
                PreferencesUtil.createPreferenceDialogOn((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"egovframework.bdev.imp.confmngt.preferences.jobreaderwriterpreperencepage", (String[])new String[]{"egovframework.bdev.imp.confmngt.preferences.jobreaderwriterpreperencepage"}, null).open();
                JobRWDialog.this.contents.refreshInputData();
                JobRWDialog.this.setTableViewerSelection(JobRWDialog.this.selectJobRWInfo);
                if (JobRWDialog.this.isPartitionType) {
                    JobRWDialog.this.changeTableInputToPartitionTypeTableInput();
                }
            }
        });
        this.contents = this.createJobRWContents();
        this.contents.createTableViewerContents(control);
        this.contents.getTableViewer().getTable().addListener(13, this.validation);
        this.contents.getTableViewer().getTable().addListener(13, this.contentsListner);
        if (this.isPartitionType) {
            this.changeTableInputToPartitionTypeTableInput();
        }
        GridData gData = new GridData(768);
        gData.heightHint = 180;
        Group sqlContentsGroup = new Group(control, 16);
        sqlContentsGroup.setLayout((Layout)new GridLayout(3, false));
        sqlContentsGroup.setLayoutData((Object)gData);
        this.detailInfoControl = new ScrolledComposite((Composite)sqlContentsGroup, 512);
        GridData gInnerData = new GridData(768);
        gInnerData.heightHint = 160;
        this.detailInfoControl.setExpandVertical(true);
        this.detailInfoControl.setLayout((Layout)new GridLayout());
        this.detailInfoControl.setLayoutData((Object)gInnerData);
        this.createErrorSettingLabel(control);
        this.setTableViewerSelection(this.selectJobRWInfo);
        this.validation.handleEvent(null);
        return control;
    }

    protected abstract JobRWTabContents createJobRWContents();

    private void createErrorSettingLabel(Composite control) {
        this.errorSettingLabel = new Label(control, 2048);
        this.errorSettingLabel.setVisible(false);
        this.errorSettingLabel.addListener(24, this.validation);
        this.errorSettingLabel.setText(INITAIL_DISABLE_FINISH_BUTTON);
    }

    protected abstract String getEmptyErrorMessage();

    private boolean validateBeanID(String beanID) {
        if (this.pageBeanIDs.isBeanIDExist(beanID)) {
            return false;
        }
        return !this.batchXMLFileBeanIDList.isBeanIDExistExceptJobRWBeanList(beanID);
    }

    private void createDetailInfoControl(JobRWInfo info, boolean isPartitionType) {
        if (!NullUtil.isNull((Object)info)) {
            String resourceType = info.getResourceType();
            if ("DB".equals(resourceType)) {
                JobRWDBDetailInfoControlConstructor detailInfoControlConstructor = new JobRWDBDetailInfoControlConstructor(this.detailInfoControl, this.errorSettingLabel, this.context, this.detailContext, this.sqlKeyValueVo, this.isPreviousSelectedJobRW(info.getName()));
                detailInfoControlConstructor.createDetailInfoControl(info);
                this.detailInfoControlConstructor = detailInfoControlConstructor;
            } else if ("File".equals(resourceType)) {
                JobRWFileDetailInfoControlConstructor detailInfoControlConstructor = new JobRWFileDetailInfoControlConstructor(this.detailInfoControl, this.errorSettingLabel, isPartitionType, this.context, this.detailContext, this.isPreviousSelectedJobRW(info.getName()));
                detailInfoControlConstructor.createDetailInfoControl(info);
                this.detailInfoControlConstructor = detailInfoControlConstructor;
            }
        }
    }

    private boolean isPreviousSelectedJobRW(String selectedJobRWName) {
        return this.previousSelectedJobRW.equals(selectedJobRWName);
    }

    private void setTableViewerSelection(JobRWInfo info) {
        if (!NullUtil.isNull((Object)info)) {
            TableViewer tableViewer = this.contents.getTableViewer();
            TableItem[] items = tableViewer.getTable().getItems();
            int i = 0;
            while (i < items.length) {
                JobRWInfo item = (JobRWInfo)items[i].getData();
                if (info.getName().equals(item.getName())) {
                    tableViewer.setSelection((ISelection)new StructuredSelection((Object)item));
                    tableViewer.getTable().notifyListeners(13, null);
                }
                ++i;
            }
        }
    }

    private void changeTableInputToPartitionTypeTableInput() {
        TableItem[] inputItems = this.contents.getTableViewer().getTable().getItems();
        ArrayList<JobRWInfo> newInputItems = new ArrayList<JobRWInfo>();
        TableItem[] tableItemArray = inputItems;
        int n = inputItems.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            JobRWInfo jobRWInfo = (JobRWInfo)item.getData();
            if ("File".equals(jobRWInfo.getResourceType()) && !jobRWInfo.getItemType().contains("MultiResource")) {
                newInputItems.add(jobRWInfo);
            }
            ++n2;
        }
        this.contents.getTableViewer().setInput(newInputItems);
    }

    protected Point getInitialSize() {
        return new Point(487, 550);
    }

    protected void okPressed() {
        this.detailContext = this.detailInfoControlConstructor.getDetailContext();
        this.sqlKeyValueVo = this.detailInfoControlConstructor.getSqlKeyValueList();
        super.okPressed();
    }
}

