/*
 * Decompiled with CFR 0.152.
 */
package egovframework.bdev.imp.batch.wizards.jobcreation.pages;

import egovframework.bdev.imp.batch.common.BatchMessages;
import egovframework.bdev.imp.batch.wizards.jobcreation.model.BatchJobCreationContext;
import egovframework.bdev.imp.batch.wizards.jobcreation.pages.JobRWDetailInfoControlConstructor;
import egovframework.bdev.imp.batch.wizards.jobcreation.util.JobRWFileDetailInfoValidationUtil;
import egovframework.bdev.imp.confmngt.preferences.readwrite.model.JobRWInfo;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class JobRWFileDetailInfoControlConstructor
extends JobRWDetailInfoControlConstructor {
    JobRWFileDetailInfoValidationUtil validation = new JobRWFileDetailInfoValidationUtil(this.detailContext);
    private final boolean isNormalType;
    private JobRWInfo jobRWInfo = null;

    protected JobRWFileDetailInfoControlConstructor(ScrolledComposite detailInfoControl, Label errorSettingLabel, boolean isPartitionType, BatchJobCreationContext context, Map<String, String> preSavedDetailContext, boolean isPreviousSelectedJobRW) {
        super(detailInfoControl, errorSettingLabel, context, preSavedDetailContext, isPreviousSelectedJobRW);
        this.isNormalType = !isPartitionType;
    }

    @Override
    protected void createDetailInfoContents(Composite control, JobRWInfo jobRWInfo) {
        this.jobRWInfo = jobRWInfo;
        String resourceDetailType = jobRWInfo.getResourceDetailType();
        if ("FixedReader".equals(resourceDetailType)) {
            if (this.isNormalType) {
                this.createFixedReaderControl(control);
            } else {
                this.createPartitionFixedReaderControl(control);
            }
        } else if ("DelimitedReader".equals(resourceDetailType)) {
            if (this.isNormalType) {
                this.createDelimitedReaderControl(control);
            } else {
                this.createPartitionDelimitedReaderControl(control);
            }
        } else if ("DelimitedWriter".equals(resourceDetailType)) {
            if (this.isNormalType) {
                this.createDelimitedWriterControl(control);
            } else {
                this.createPartitionDelimitedWriterControl(control);
            }
        } else if ("FormatterFlatFileItemWriter".equals(resourceDetailType)) {
            if (this.isNormalType) {
                this.createFormatterFlatFileItemWriterControl(control);
            } else {
                this.createPartitionFormatterFlatFileItemWriterControl(control);
            }
        } else if ("EgoFixedFlatFileItemWriter".equals(resourceDetailType)) {
            if (this.isNormalType) {
                this.createEgovFixedFlatFileItemWriterControl(control);
            } else {
                this.createPartitionEgovFixedFlatFileItemWriterControl(control);
            }
        } else if ("DelimitedMultiWriter".equals(resourceDetailType)) {
            this.createDelimitedMultiWriterControl(control);
        } else if ("FormatterMultiResourceItemWriter".equals(resourceDetailType)) {
            this.createFormatterMultiResourceItemWriterControl(control);
        } else if ("EgovFixedMultiResourceItemWriter".equals(resourceDetailType)) {
            this.createEgovFixedMultiResourceItemWriterControl(control);
        } else if ("CustomizeFile".equals(resourceDetailType)) {
            this.createCustomizeFileControl();
        }
    }

    private void createFixedReaderControl(Composite control) {
        Text resourceText = this.createResourceControl(control);
        this.addFixedReaderItemListener(resourceText);
        this.createResouceExampleLabel(control);
        Text fieldNameText = this.createFieldNameControl(control);
        this.addFixedReaderItemListener(fieldNameText);
        Text columnLengthText = this.createColumnLengthControl(control);
        this.addFixedReaderItemListener(columnLengthText);
        Text voClassText = this.createVOClassControl(control);
        this.addFixedReaderItemListener(voClassText);
        this.setMessage(this.validation.validateFixedReaderItemAndGetErrorMessage());
    }

    private void addFixedReaderItemListener(Text text) {
        text.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                String message = JobRWFileDetailInfoControlConstructor.this.validation.validateFixedReaderItemAndGetErrorMessage();
                JobRWFileDetailInfoControlConstructor.this.setMessage(message);
            }
        });
    }

    private void createDelimitedReaderControl(Composite control) {
        Text resourceText = this.createResourceControl(control);
        this.addDelimitedReaderListener(resourceText);
        this.createResouceExampleLabel(control);
        Text fieldNameText = this.createFieldNameControl(control);
        this.addDelimitedReaderListener(fieldNameText);
        Text delimiterText = this.createDelimiterControl(control);
        this.addDelimitedReaderListener(delimiterText);
        Text voClassText = this.createVOClassControl(control);
        this.addDelimitedReaderListener(voClassText);
        this.setMessage(this.validation.validateDelimitedReaderItemAndGetErrorMessage());
    }

    private void addDelimitedReaderListener(Text text) {
        text.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                String message = JobRWFileDetailInfoControlConstructor.this.validation.validateDelimitedReaderItemAndGetErrorMessage();
                JobRWFileDetailInfoControlConstructor.this.setMessage(message);
            }
        });
    }

    private void createDelimitedWriterControl(Composite control) {
        Text resourceText = this.createResourceControl(control);
        this.addDelimitedWriterListener(resourceText);
        this.createResouceExampleLabel(control);
        Text fieldNameText = this.createFieldNameControl(control);
        this.addDelimitedWriterListener(fieldNameText);
        Text delimiterText = this.createDelimiterControl(control);
        this.addDelimitedWriterListener(delimiterText);
        this.setMessage(this.validation.validateDelimitedWriterItemAndGetErrorMessage());
    }

    private void addDelimitedWriterListener(Text text) {
        text.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                String message = JobRWFileDetailInfoControlConstructor.this.validation.validateDelimitedWriterItemAndGetErrorMessage();
                JobRWFileDetailInfoControlConstructor.this.setMessage(message);
            }
        });
    }

    private void createFormatterFlatFileItemWriterControl(Composite control) {
        Text resourceText = this.createResourceControl(control);
        this.addFormatterFlatFileItemWriterListener(resourceText);
        this.createResouceExampleLabel(control);
        Text fieldNameText = this.createFieldNameControl(control);
        this.addFormatterFlatFileItemWriterListener(fieldNameText);
        Text fieldFormatText = this.createFieldFormatControl(control);
        this.addFormatterFlatFileItemWriterListener(fieldFormatText);
        this.setMessage(this.validation.validateFormatterFlatFileItemWriterItemAndGetErrorMessage());
    }

    private void addFormatterFlatFileItemWriterListener(Text text) {
        text.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                String message = JobRWFileDetailInfoControlConstructor.this.validation.validateFormatterFlatFileItemWriterItemAndGetErrorMessage();
                JobRWFileDetailInfoControlConstructor.this.setMessage(message);
            }
        });
    }

    private void createEgovFixedFlatFileItemWriterControl(Composite control) {
        Text resourceText = this.createResourceControl(control);
        this.addEgovFixedFlatFileItemWriterListener(resourceText);
        this.createResouceExampleLabel(control);
        Text fieldNameText = this.createFieldNameControl(control);
        this.addEgovFixedFlatFileItemWriterListener(fieldNameText);
        Text fieldRangeText = this.createFieldRangeControl(control);
        this.addEgovFixedFlatFileItemWriterListener(fieldRangeText);
        this.setMessage(this.validation.validateEgovFixedFlatFileItemWriterItemAndGetErrorMessage());
    }

    private void addEgovFixedFlatFileItemWriterListener(Text text) {
        text.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                String message = JobRWFileDetailInfoControlConstructor.this.validation.validateEgovFixedFlatFileItemWriterItemAndGetErrorMessage();
                JobRWFileDetailInfoControlConstructor.this.setMessage(message);
            }
        });
    }

    private void createDelimitedMultiWriterControl(Composite control) {
        Text resourceText = this.createResourceControl(control);
        this.addDelimitedMultiWriterListener(resourceText);
        this.createResouceExampleLabel(control);
        Text fieldNameText = this.createFieldNameControl(control);
        this.addDelimitedMultiWriterListener(fieldNameText);
        Text delimiterText = this.createDelimiterControl(control);
        this.addDelimitedMultiWriterListener(delimiterText);
        Text maxCountPerResourceText = this.createMaxCountPerResourceControl(control);
        this.addDelimitedMultiWriterListener(maxCountPerResourceText);
        this.setMessage(this.validation.validateDelimitedMultiWriterItemAndGetErrorMessage());
    }

    private void addDelimitedMultiWriterListener(Text text) {
        text.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                String message = JobRWFileDetailInfoControlConstructor.this.validation.validateDelimitedMultiWriterItemAndGetErrorMessage();
                JobRWFileDetailInfoControlConstructor.this.setMessage(message);
            }
        });
    }

    private void createFormatterMultiResourceItemWriterControl(Composite control) {
        Text resourceText = this.createResourceControl(control);
        this.addFormatterMultiResourceItemWriterListener(resourceText);
        this.createResouceExampleLabel(control);
        Text fieldNameText = this.createFieldNameControl(control);
        this.addFormatterMultiResourceItemWriterListener(fieldNameText);
        Text fieldFormatText = this.createFieldFormatControl(control);
        this.addFormatterMultiResourceItemWriterListener(fieldFormatText);
        Text maxCountPerResource = this.createMaxCountPerResourceControl(control);
        this.addFormatterMultiResourceItemWriterListener(maxCountPerResource);
        this.setMessage(this.validation.validateFormatterMultiResourceItemWriterItemAndGetErrorMessage());
    }

    private void addFormatterMultiResourceItemWriterListener(Text text) {
        text.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                String message = JobRWFileDetailInfoControlConstructor.this.validation.validateFormatterMultiResourceItemWriterItemAndGetErrorMessage();
                JobRWFileDetailInfoControlConstructor.this.setMessage(message);
            }
        });
    }

    private void createEgovFixedMultiResourceItemWriterControl(Composite control) {
        Text resourceText = this.createResourceControl(control);
        this.addEgovFixedMultiResourceItemWriterListener(resourceText);
        this.createResouceExampleLabel(control);
        Text fieldNameText = this.createFieldNameControl(control);
        this.addEgovFixedMultiResourceItemWriterListener(fieldNameText);
        Text fieldRangeText = this.createFieldRangeControl(control);
        this.addEgovFixedMultiResourceItemWriterListener(fieldRangeText);
        Text maxCountPerResource = this.createMaxCountPerResourceControl(control);
        this.addEgovFixedMultiResourceItemWriterListener(maxCountPerResource);
        this.setMessage(this.validation.validateEgovFixedMultiResourceItemWriterAndGetErrorMessage());
    }

    private void addEgovFixedMultiResourceItemWriterListener(Text text) {
        text.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                String message = JobRWFileDetailInfoControlConstructor.this.validation.validateEgovFixedMultiResourceItemWriterAndGetErrorMessage();
                JobRWFileDetailInfoControlConstructor.this.setMessage(message);
            }
        });
    }

    private void createCustomizeFileControl() {
        this.setMessageOK();
    }

    private void createPartitionFixedReaderControl(Composite control) {
        Text fieldNameText = this.createFieldNameControl(control);
        this.addPartitionFixedReaderListener(fieldNameText);
        Text columnLengthText = this.createColumnLengthControl(control);
        this.addPartitionFixedReaderListener(columnLengthText);
        Text voClassText = this.createVOClassControl(control);
        this.addPartitionFixedReaderListener(voClassText);
        this.setMessage(this.validation.validatePartitionFixedReaderAndGetErrorMessage());
    }

    private void addPartitionFixedReaderListener(Text text) {
        text.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                String message = JobRWFileDetailInfoControlConstructor.this.validation.validatePartitionFixedReaderAndGetErrorMessage();
                JobRWFileDetailInfoControlConstructor.this.setMessage(message);
            }
        });
    }

    private void createPartitionDelimitedReaderControl(Composite control) {
        Text fieldNameText = this.createFieldNameControl(control);
        this.addPartitionDelimitedReaderListener(fieldNameText);
        Text delimiter = this.createDelimiterControl(control);
        this.addPartitionDelimitedReaderListener(delimiter);
        Text voClassText = this.createVOClassControl(control);
        this.addPartitionDelimitedReaderListener(voClassText);
        this.setMessage(this.validation.validatePartitionDelimitedReaderAndGetErrorMessage());
    }

    private void addPartitionDelimitedReaderListener(Text text) {
        text.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                String message = JobRWFileDetailInfoControlConstructor.this.validation.validatePartitionDelimitedReaderAndGetErrorMessage();
                JobRWFileDetailInfoControlConstructor.this.setMessage(message);
            }
        });
    }

    private void createPartitionDelimitedWriterControl(Composite control) {
        Text fieldNameText = this.createFieldNameControl(control);
        this.addPartitionDelimitedWriterListener(fieldNameText);
        Text delimiter = this.createDelimiterControl(control);
        this.addPartitionDelimitedWriterListener(delimiter);
        this.setMessage(this.validation.validatePartitionDelimitedWriterAndGetErrorMessage());
    }

    private void addPartitionDelimitedWriterListener(Text text) {
        text.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                String message = JobRWFileDetailInfoControlConstructor.this.validation.validatePartitionDelimitedWriterAndGetErrorMessage();
                JobRWFileDetailInfoControlConstructor.this.setMessage(message);
            }
        });
    }

    private void createPartitionFormatterFlatFileItemWriterControl(Composite control) {
        Text fieldNameText = this.createFieldNameControl(control);
        this.addPartitionFormatterFlatFileItemWriterListener(fieldNameText);
        Text fieldFormatText = this.createFieldFormatControl(control);
        this.addPartitionFormatterFlatFileItemWriterListener(fieldFormatText);
        this.setMessage(this.validation.validatePartitionFormatterFlatFileItemWriterAndGetErrorMessage());
    }

    private void addPartitionFormatterFlatFileItemWriterListener(Text text) {
        text.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                String message = JobRWFileDetailInfoControlConstructor.this.validation.validatePartitionFormatterFlatFileItemWriterAndGetErrorMessage();
                JobRWFileDetailInfoControlConstructor.this.setMessage(message);
            }
        });
    }

    private void createPartitionEgovFixedFlatFileItemWriterControl(Composite control) {
        Text fieldNameText = this.createFieldNameControl(control);
        this.addPartitionEgovFixedFlatFileItemWriterListener(fieldNameText);
        Text fieldRangeText = this.createFieldRangeControl(control);
        this.addPartitionEgovFixedFlatFileItemWriterListener(fieldRangeText);
        this.setMessage(this.validation.validatePartitionEgovFixedFlatFileItemWriterItemAndGetErrorMessage());
    }

    private void addPartitionEgovFixedFlatFileItemWriterListener(Text text) {
        text.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                String message = JobRWFileDetailInfoControlConstructor.this.validation.validatePartitionEgovFixedFlatFileItemWriterItemAndGetErrorMessage();
                JobRWFileDetailInfoControlConstructor.this.setMessage(message);
            }
        });
    }

    private Text createResourceControl(Composite control) {
        Text resourceText = this.createLabelText(control, BatchMessages.JobRWFileDetailInfoControlConstructor_RESOURCE_LABEL);
        this.addSaveValueToContextListener("Resource", resourceText);
        this.setInitialValueToText("Resource", resourceText);
        Button button = this.createBrowseButton(control);
        String itemType = this.jobRWInfo.getItemType();
        if (this.isFixedItemReader(itemType) || this.isFixedItemWriter(itemType) || this.isFormatterItemWriter(itemType)) {
            button.addListener(13, this.getResourceButtonTXTDefaultListeners(control, resourceText));
        } else {
            button.addListener(13, this.getResourceCSVDefaultButtonListener(control, resourceText));
        }
        return resourceText;
    }

    protected Listener getResourceCSVDefaultButtonListener(Composite control, Text text) {
        String[] filterExt = new String[]{"*.csv", "*.txt"};
        return this.getFileDialogButtonListener(control, text, filterExt);
    }

    protected Listener getResourceButtonTXTDefaultListeners(Composite control, Text text) {
        String[] filterExt = new String[]{"*.txt", "*.csv"};
        return this.getFileDialogButtonListener(control, text, filterExt);
    }

    private void createResouceExampleLabel(Composite control) {
        String itemType = this.jobRWInfo.getItemType();
        String example = "ex) batchEgovPrj/src/main/resources/example";
        if (this.isMultiResourceReader(itemType)) {
            example = example.concat("*");
        }
        example = this.isFixedItemReader(itemType) || this.isFixedItemWriter(itemType) || this.isFormatterItemWriter(itemType) ? example.concat(".txt") : example.concat(".csv");
        this.createResouceExampleLabel(control, example);
    }

    private boolean isMultiResourceReader(String itemType) {
        String pattern = ".*MultiResource.*Reader";
        return Pattern.matches(pattern, itemType);
    }

    private boolean isFixedItemReader(String itemType) {
        String pattern = ".*Fixed.*ItemReader";
        return Pattern.matches(pattern, itemType);
    }

    private boolean isFixedItemWriter(String itemType) {
        String pattern = ".*Fixed.*ItemWriter";
        return Pattern.matches(pattern, itemType);
    }

    private boolean isFormatterItemWriter(String itemType) {
        String pattern = "Formatter.*ItemWriter";
        return Pattern.matches(pattern, itemType);
    }

    private void createResouceExampleLabel(Composite control, String labelString) {
        GridData gData = new GridData(768);
        gData.horizontalSpan = 3;
        Label exampleLabel = new Label(control, 0);
        exampleLabel.setText(labelString);
        exampleLabel.setLayoutData((Object)gData);
    }

    private Text createFieldNameControl(Composite control) {
        Text fieldNameText = this.createLabelText(control, BatchMessages.JobRWFileDetailInfoControlConstructor_FIELD_NAME_LABEL);
        fieldNameText.setText(BatchMessages.JobRWFileDetailInfoControlConstructor_FIELD_NAME_EXAMPLE);
        this.setTextHorizontalFullAndSpan(fieldNameText, 2);
        this.addSaveValueToContextListener("FieldName", fieldNameText);
        this.setInitialValueToText("FieldName", fieldNameText);
        return fieldNameText;
    }

    private Text createColumnLengthControl(Composite control) {
        Text columnLength = this.createLabelText(control, BatchMessages.JobRWFileDetailInfoControlConstructor_COLUMN_LENGTH_LABEL);
        columnLength.setText(BatchMessages.JobRWFileDetailInfoControlConstructor_COLUMN_LENGTH_EXAMPLE);
        this.setTextHorizontalFullAndSpan(columnLength, 2);
        this.addSaveValueToContextListener("ColumnLength", columnLength);
        this.setInitialValueToText("ColumnLength", columnLength);
        return columnLength;
    }

    private Text createDelimiterControl(Composite control) {
        Text delimiterText = this.createLabelText(control, BatchMessages.JobRWFileDetailInfoControlConstructor_DELIMITER_LABEL);
        delimiterText.setText(BatchMessages.JobRWFileDetailInfoControlConstructor_DELIMITER_EXAMPLE);
        this.setTextHorizontalFullAndSpan(delimiterText, 2);
        this.addSaveValueToContextListener("Delimiter", delimiterText);
        this.setInitialValueToText("Delimiter", delimiterText);
        return delimiterText;
    }

    private Text createVOClassControl(Composite control) {
        Text voClassText = this.createLabelText(control, BatchMessages.JobRWFileDetailInfoControlConstructor_VO_CLASS_LABEL);
        this.addSaveValueToContextListener("VOClass", voClassText);
        this.setInitialValueToText("VOClass", voClassText);
        Button button = this.createBrowseButton(control);
        button.addListener(13, this.getClassSearchBrowseButtonListener(voClassText));
        return voClassText;
    }

    private Text createFieldFormatControl(Composite control) {
        Text fieldFormatText = this.createLabelText(control, BatchMessages.JobRWFileDetailInfoControlConstructor_FIELD_FORMAT_LABEL);
        fieldFormatText.setText(BatchMessages.JobRWFileDetailInfoControlConstructor_FIELD_FORMAT_EXAMPLE);
        this.setTextHorizontalFullAndSpan(fieldFormatText, 2);
        this.addSaveValueToContextListener("FieldFormat", fieldFormatText);
        this.setInitialValueToText("FieldFormat", fieldFormatText);
        return fieldFormatText;
    }

    private Text createFieldRangeControl(Composite control) {
        Text fieldRangeText = this.createLabelText(control, BatchMessages.JobRWFileDetailInfoControlConstructor_FIELD_RANGE_LABEL);
        fieldRangeText.setText(BatchMessages.JobRWFileDetailInfoControlConstructor_FIELD_RANGE_EXAMPLE);
        this.setTextHorizontalFullAndSpan(fieldRangeText, 2);
        this.addSaveValueToContextListener("FieldRange", fieldRangeText);
        this.setInitialValueToText("FieldRange", fieldRangeText);
        return fieldRangeText;
    }

    private Text createMaxCountPerResourceControl(Composite control) {
        GridLayout gLayout = new GridLayout(2, false);
        gLayout.marginHeight = 0;
        gLayout.marginWidth = 0;
        gLayout.horizontalSpacing = 0;
        gLayout.verticalSpacing = 0;
        GridData gData = new GridData(768);
        gData.horizontalSpan = 3;
        Composite childControl = new Composite(control, 0);
        childControl.setLayout((Layout)gLayout);
        childControl.setLayoutData((Object)gData);
        Text maxCountPerResource = this.createLabelText(childControl, BatchMessages.JobRWFileDetailInfoControlConstructor_MAX_COUNT_PER_RESOURCE_LABEL);
        this.addSaveValueToContextListener("MaxCountperResource", maxCountPerResource);
        this.setInitialValueToText("MaxCountperResource", maxCountPerResource);
        return maxCountPerResource;
    }
}

