/*
 * Decompiled with CFR 0.152.
 */
package egovframework.bdev.imp.batch.wizards.jobcreation.pages;

import egovframework.bdev.imp.batch.common.BatchMessages;
import egovframework.bdev.imp.batch.wizards.jobcreation.model.BatchPageBeanIDList;
import egovframework.bdev.imp.batch.wizards.jobcreation.model.BatchXMLFileBeanIDList;
import egovframework.bdev.imp.confmngt.preferences.listeners.ListenerTabContents;
import egovframework.bdev.imp.confmngt.preferences.listeners.model.ListenerInfo;
import egovframework.dev.imp.core.utils.BatchTableColumn;
import egovframework.dev.imp.core.utils.NullUtil;
import egovframework.dev.imp.core.utils.StringUtil;
import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class ListenerDialog
extends StatusDialog {
    private ListenerInfo[] info = null;
    private ListenerTabContents contents = null;
    private String[] items = null;
    private BatchXMLFileBeanIDList batchJobListBeanIDList = null;
    private BatchPageBeanIDList pageBeanIDs = null;
    private String descriptionOneString = null;
    private String descriptionTwoString = null;
    ISelectionChangedListener validation = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            StatusInfo status = new StatusInfo();
            CheckboxTableViewer chTableViewer = (CheckboxTableViewer)ListenerDialog.this.contents.getTableViewer();
            Object[] object = chTableViewer.getCheckedElements();
            int i = 0;
            while (i < object.length) {
                ListenerInfo info = (ListenerInfo)object[i];
                if (!ListenerDialog.this.validateBeanID(info.getName())) {
                    status.setError(String.valueOf(info.getName()) + BatchMessages.ListenerDialog_DUPLICATE_BEAN_ID_ERROR);
                    ListenerDialog.this.updateStatus((IStatus)status);
                    return;
                }
                ++i;
            }
            status.setOK();
            ListenerDialog.this.updateStatus((IStatus)status);
        }
    };
    Listener setCheckedItem = new Listener(){

        public void handleEvent(Event event) {
            ListenerInfo[] checkedItems = ListenerDialog.this.getCheckedItem();
            String[] checkedItemsName = new String[checkedItems.length];
            int i = 0;
            while (i < checkedItems.length) {
                checkedItemsName[i] = checkedItems[i].getName();
                ++i;
            }
            ListenerDialog.this.items = checkedItemsName;
        }
    };

    public void setContents(ListenerTabContents contents) {
        this.contents = contents;
    }

    public void setDescriptionOneString(String descriptionOneString) {
        this.descriptionOneString = descriptionOneString;
    }

    public void setDescriptionTwoString(String descriptionTwoString) {
        this.descriptionTwoString = descriptionTwoString;
    }

    public ListenerInfo[] getInfo() {
        return this.info;
    }

    public ListenerDialog(Shell parent, String[] items, BatchXMLFileBeanIDList batchJobListBeanIDList, BatchPageBeanIDList pageBeanIDs) {
        super(parent);
        this.items = items;
        this.batchJobListBeanIDList = batchJobListBeanIDList;
        this.pageBeanIDs = pageBeanIDs;
    }

    protected Control createDialogArea(Composite parent) {
        GridData tableGData = new GridData(768);
        tableGData.heightHint = 400;
        Composite control = new Composite(parent, 0);
        control.setLayout((Layout)new GridLayout());
        control.setLayoutData((Object)tableGData);
        Label descriptionOne = new Label(control, 0);
        descriptionOne.setText(this.descriptionOneString);
        StringUtil.setLabelStringBold((Label)descriptionOne);
        Label descriptionTwo = new Label(control, 0);
        descriptionTwo.setText(this.descriptionTwoString);
        Link link = new Link(control, 131072);
        link.setLayoutData((Object)new GridData(128));
        link.setText(BatchMessages.ListenerDialog_LINK);
        link.addListener(4, new Listener(){

            public void handleEvent(Event event) {
                PreferencesUtil.createPreferenceDialogOn((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"egovframework.bdev.imp.confmngt.preferences.listenerpreperencepage", (String[])new String[]{"egovframework.bdev.imp.confmngt.preferences.listenerpreperencepage"}, null).open();
                ListenerDialog.this.contents.refreshInputData();
                ListenerDialog.this.checkPreExistItems();
            }
        });
        BatchTableColumn[] columns = this.createColumns();
        this.contents.setTableColumnProperty(columns);
        this.contents.createTableViewerContents(control);
        this.contents.getTableViewer().addSelectionChangedListener(this.validation);
        this.contents.getTableViewer().getTable().addListener(13, this.setCheckedItem);
        Composite buttonControl = new Composite(control, 0);
        buttonControl.setLayout((Layout)new GridLayout(2, true));
        buttonControl.setLayoutData((Object)new GridData());
        Button selectAll = new Button(buttonControl, 8);
        selectAll.setText(BatchMessages.ListenerDialog_SELECT_ALL_BUTTON);
        selectAll.setLayoutData((Object)new GridData(768));
        selectAll.addListener(4, new Listener(){

            public void handleEvent(Event event) {
                CheckboxTableViewer contentsTableViewer = (CheckboxTableViewer)ListenerDialog.this.contents.getTableViewer();
                contentsTableViewer.setAllChecked(true);
                ListenerDialog.this.validation.selectionChanged(null);
            }
        });
        Button deselectAll = new Button(buttonControl, 8);
        deselectAll.setText(BatchMessages.ListenerDialog_DESELECT_ALL_BUTTON);
        deselectAll.setLayoutData((Object)new GridData(768));
        deselectAll.addListener(4, new Listener(){

            public void handleEvent(Event event) {
                CheckboxTableViewer contentsTableViewer = (CheckboxTableViewer)ListenerDialog.this.contents.getTableViewer();
                contentsTableViewer.setAllChecked(false);
                ListenerDialog.this.validation.selectionChanged(null);
            }
        });
        this.checkPreExistItems();
        return control;
    }

    private BatchTableColumn[] createColumns() {
        ArrayList<BatchTableColumn> columns = new ArrayList<BatchTableColumn>();
        columns.add(new BatchTableColumn(BatchMessages.ListenerDialog_COLUMN_NAME, 175));
        columns.add(new BatchTableColumn(BatchMessages.ListenerDialog_COLUMN_CLASS, 150, 16384));
        columns.add(new BatchTableColumn(BatchMessages.ListenerDialog_COLUMN_LISTENER_TYPE, 122));
        return columns.toArray(new BatchTableColumn[0]);
    }

    private void checkPreExistItems() {
        CheckboxTableViewer tableViewer;
        Object[] preferenceItems;
        if (!NullUtil.isEmpty((Object[])this.items) && !NullUtil.isEmpty((Object[])(preferenceItems = (tableViewer = (CheckboxTableViewer)this.contents.getTableViewer()).getTable().getItems()))) {
            int i = 0;
            while (i < this.items.length) {
                int j = 0;
                while (j < preferenceItems.length) {
                    ListenerInfo info = (ListenerInfo)preferenceItems[j].getData();
                    if (this.items[i].equals(info.getName())) {
                        tableViewer.setChecked((Object)info, true);
                        break;
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    protected void okPressed() {
        this.info = this.getCheckedItem();
        super.okPressed();
    }

    private boolean validateBeanID(String beanID) {
        if (this.pageBeanIDs.isBeanIDExist(beanID)) {
            return false;
        }
        return !this.batchJobListBeanIDList.isBeanIDExistIncludeJobRWBeanList(beanID);
    }

    private ListenerInfo[] getCheckedItem() {
        CheckboxTableViewer chTableViewer = (CheckboxTableViewer)this.contents.getTableViewer();
        Object[] object = chTableViewer.getCheckedElements();
        ListenerInfo[] infos = new ListenerInfo[object.length];
        int i = 0;
        while (i < object.length) {
            infos[i] = (ListenerInfo)object[i];
            ++i;
        }
        return infos;
    }
}

