/*
 * Decompiled with CFR 0.152.
 */
package egovframework.bdev.imp.batch.wizards.jobcreation.pages;

import egovframework.bdev.imp.batch.common.BatchMessages;
import egovframework.bdev.imp.batch.wizards.jobcreation.model.NextVo;
import egovframework.dev.imp.core.utils.NullUtil;
import egovframework.dev.imp.core.utils.StringUtil;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class NextDialog
extends StatusDialog {
    private boolean isAddButton;
    private NextVo nextVo = null;
    private NextVo[] nextVos = null;
    private Combo nextOnField = null;
    private Combo nextToField = null;
    private String nextOn = null;
    private String nextTo = null;
    private String[] stepAndDecisionNameList = null;
    Listener validation = new Listener(){

        public void handleEvent(Event event) {
            StatusInfo status = new StatusInfo();
            if (NullUtil.isEmpty((Combo)NextDialog.this.nextOnField)) {
                status.setError(BatchMessages.NextDialog_EMPTY_NEXT_ON_ERROR_MESSAGE);
                NextDialog.this.updateStatus((IStatus)status);
                return;
            }
            if (!NextDialog.this.isNextOnStringAvailable(NextDialog.this.nextOnField.getText())) {
                status.setError(BatchMessages.NextDialog_INVALID_NEXT_ON_ERROR_MESSAGE);
                NextDialog.this.updateStatus((IStatus)status);
                return;
            }
            NextVo[] nextVoArray = NextDialog.this.nextVos;
            int n = nextVoArray.length;
            int n2 = 0;
            while (n2 < n) {
                NextVo nextVo = nextVoArray[n2];
                if (nextVo.getNextOn().equals(NextDialog.this.nextOnField.getText())) {
                    status.setError(BatchMessages.NextDialog_DUPLICATE_NEXT_ON_ERROR_MESSAGE);
                    NextDialog.this.updateStatus((IStatus)status);
                    return;
                }
                ++n2;
            }
            if (NullUtil.isEmpty((Combo)NextDialog.this.nextToField)) {
                status.setError(BatchMessages.NextDialog_EMPTY_NEXT_TO_ERROR_MESSAGE);
                NextDialog.this.updateStatus((IStatus)status);
                return;
            }
            status.setOK();
            NextDialog.this.updateStatus((IStatus)status);
        }
    };

    public NextDialog(Shell parent, NextVo nextVo, String[] stepAndDecisionNameList, NextVo[] nextVos) {
        super(parent);
        this.stepAndDecisionNameList = stepAndDecisionNameList;
        this.nextVo = nextVo;
        this.nextVos = nextVos;
        boolean bl = this.isAddButton = nextVo == null;
        if (this.isAddButton) {
            this.setTitle(BatchMessages.NextDialog_NEW_TITLE);
        } else {
            this.setTitle(BatchMessages.NextDialog_EDIT_TITLE);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite control = new Composite(parent, 0);
        control.setLayout((Layout)new GridLayout(2, false));
        control.setLayoutData((Object)new GridData(768));
        Label nextOnLabel = new Label(control, 0);
        nextOnLabel.setText(BatchMessages.NextDialog_NEXT_ON_LABEL);
        this.nextOnField = new Combo(control, 2048);
        this.nextOnField.setItems(new String[]{"COMPLETED", "FAILED", "*", BatchMessages.NextDialog_INPUT_VALUE_BY_SELF});
        this.nextOnField.setLayoutData((Object)new GridData(768));
        this.nextOnField.select(0);
        this.nextOnField.addListener(24, this.validation);
        Label nextTo = new Label(control, 0);
        nextTo.setText(BatchMessages.NextDialog_NEXT_TO_LABEL);
        this.nextToField = new Combo(control, 2056);
        this.nextToField.setItems(this.stepAndDecisionNameList);
        this.nextToField.setLayoutData((Object)new GridData(768));
        this.nextToField.select(0);
        this.nextToField.addListener(24, this.validation);
        if (this.nextVo != null) {
            this.nextOnField.setText(this.nextVo.getNextOn());
            this.nextToField.setText(this.nextVo.getNextTo());
        }
        this.validation.handleEvent(new Event());
        return control;
    }

    protected void okPressed() {
        this.nextOn = this.nextOnField.getText();
        this.nextTo = this.nextToField.getText();
        super.okPressed();
    }

    public String getNextOn() {
        return this.nextOn;
    }

    public String getNextTo() {
        return this.nextTo;
    }

    private boolean isNextOnStringAvailable(String string) {
        return !StringUtil.hasKorean((String)string) && !StringUtil.hasEmptySpace((String)string);
    }
}

