/*
 * Decompiled with CFR 0.152.
 */
package egovframework.bdev.imp.batch.wizards.jobcreation.pages;

import egovframework.bdev.imp.batch.common.BatchMessages;
import egovframework.bdev.imp.batch.wizards.jobcreation.model.BatchPageBeanIDList;
import egovframework.bdev.imp.batch.wizards.jobcreation.model.BatchXMLFileBeanIDList;
import egovframework.bdev.imp.batch.wizards.jobcreation.model.SharedValueVo;
import egovframework.bdev.imp.batch.wizards.jobcreation.model.StepVo;
import egovframework.bdev.imp.confmngt.preferences.readwrite.model.JobRWInfo;
import egovframework.bdev.imp.confmngt.preferences.readwrite.model.JobReaderInfo;
import egovframework.bdev.imp.confmngt.preferences.readwrite.model.JobWriterInfo;
import egovframework.dev.imp.core.utils.NullUtil;
import egovframework.dev.imp.core.utils.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SharedValueDialog
extends StatusDialog {
    private BatchXMLFileBeanIDList batchJobListBeanIDList = null;
    private BatchPageBeanIDList pageBeanIDs = null;
    private String stepID = null;
    private JobReaderInfo readerVo = null;
    private JobWriterInfo writerVo = null;
    private SharedValueVo[] sharedValueList = null;
    private ArrayList<SharedValueVo> result = null;
    private ArrayList<SharedValueVo> checkedList = null;
    private ArrayList<SharedValueVo> elseList = null;
    private String readCountString = null;
    private Button readCount = null;
    private String writtenString = null;
    private Button written = null;
    private String currentCountString = null;
    private Button currentCount = null;
    private Button inputButton = null;
    private Text inputText = null;
    Listener inputTextValidation = new Listener(){

        public void handleEvent(Event event) {
            StatusInfo status = new StatusInfo();
            if (SharedValueDialog.this.inputButton.getSelection()) {
                if (NullUtil.isEmpty((Text)SharedValueDialog.this.inputText)) {
                    status.setError(BatchMessages.SharedValueDialog_EMPTY_KEY);
                    SharedValueDialog.this.updateStatus((IStatus)status);
                    return;
                }
                String inputKey = SharedValueDialog.this.inputText.getText();
                if (!SharedValueDialog.this.isSharedValueNameAvailable(inputKey)) {
                    status.setError(BatchMessages.SharedValueDialog_INVALID_KEY);
                    SharedValueDialog.this.updateStatus((IStatus)status);
                    return;
                }
                if (!NullUtil.isEmpty((List)SharedValueDialog.this.elseList)) {
                    for (SharedValueVo vo : SharedValueDialog.this.elseList) {
                        if (!inputKey.equals(vo.getKey())) continue;
                        status.setError(BatchMessages.SharedValueDialog_EMPTY_VALUE);
                        SharedValueDialog.this.updateStatus((IStatus)status);
                        return;
                    }
                }
                if (!SharedValueDialog.this.validateBeanID(inputKey)) {
                    status.setError(BatchMessages.SharedValueDialog_DUPLICATE_BEAN_ID);
                    SharedValueDialog.this.updateStatus((IStatus)status);
                    return;
                }
            }
            status.setOK();
            SharedValueDialog.this.updateStatus((IStatus)status);
        }
    };

    public SharedValueDialog(Shell parent, SharedValueVo[] sharedValueList, StepVo stepVo, BatchXMLFileBeanIDList batchJobListBeanIDList, BatchPageBeanIDList pageBeanIDs) {
        super(parent);
        this.stepID = stepVo.getName();
        this.readerVo = stepVo.getJobReaderInfo();
        this.writerVo = stepVo.getJobWriterInfo();
        this.setButtonString();
        this.sharedValueList = sharedValueList;
        this.batchJobListBeanIDList = batchJobListBeanIDList;
        this.pageBeanIDs = pageBeanIDs;
        this.setTitle(BatchMessages.SharedValueDialog_TITLE);
    }

    protected Point getInitialSize() {
        return new Point(350, 200);
    }

    protected Control createDialogArea(Composite parent) {
        Composite control = new Composite(parent, 0);
        control.setLayout((Layout)new GridLayout(2, false));
        control.setLayoutData((Object)new GridData(768));
        this.createSelectOptionControl(control);
        this.createInputOptionControl(control);
        this.setButtonEnable();
        this.getCheckedItem(this.sharedValueList);
        return control;
    }

    private void createSelectOptionControl(Composite control) {
        GridData gData = new GridData(768);
        gData.horizontalSpan = 2;
        this.readCount = new Button(control, 32);
        this.readCount.setLayoutData((Object)gData);
        this.readCount.setText(this.readCountString);
        this.written = new Button(control, 32);
        this.written.setLayoutData((Object)gData);
        this.written.setText(this.writtenString);
        this.currentCount = new Button(control, 32);
        this.currentCount.setLayoutData((Object)gData);
        this.currentCount.setText(this.currentCountString);
        if (NullUtil.isNull((Object)this.readerVo)) {
            this.readCount.setEnabled(false);
        }
        if (NullUtil.isNull((Object)this.writerVo)) {
            this.written.setEnabled(false);
            this.currentCount.setEnabled(false);
        }
    }

    private void createInputOptionControl(Composite control) {
        this.inputButton = new Button(control, 32);
        this.inputButton.setText(BatchMessages.SharedValueDialog_USER_INPUT_CHECK_BOX);
        this.inputText = new Text(control, 2048);
        this.inputText.setLayoutData((Object)new GridData(768));
        this.inputText.setEnabled(false);
        this.inputText.addListener(24, this.inputTextValidation);
        this.inputButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (SharedValueDialog.this.inputButton.getSelection()) {
                    SharedValueDialog.this.inputText.setEnabled(true);
                    SharedValueDialog.this.inputText.forceFocus();
                    SharedValueDialog.this.inputTextValidation.handleEvent(new Event());
                } else {
                    SharedValueDialog.this.inputText.setEnabled(false);
                    SharedValueDialog.this.inputText.setText("");
                }
            }
        });
    }

    private void setButtonString() {
        this.readCountString = this.createReadCountString(this.readerVo);
        this.writtenString = this.getWrittenString(this.writerVo);
        this.currentCountString = this.getCurrentCountString(this.writerVo);
    }

    private String createReadCountString(JobReaderInfo readerVO) {
        return String.valueOf(this.getSimpleJobRWClassName((JobRWInfo)readerVO)) + BatchMessages.SharedValueDialog_READ_COUNT_CHECK_BOX;
    }

    private String getWrittenString(JobWriterInfo writerVo) {
        return String.valueOf(this.getSimpleJobRWClassName((JobRWInfo)writerVo)) + BatchMessages.SharedValueDialog_WRITTEN_COUNT_CHECK_BOX;
    }

    private String getCurrentCountString(JobWriterInfo writerVo) {
        return String.valueOf(this.getSimpleJobRWClassName((JobRWInfo)writerVo)) + BatchMessages.SharedValueDialog_CURRENT_COUNT__CHECK_BOX;
    }

    protected String getSimpleJobRWClassName(JobRWInfo jobRWInfo) {
        if (!NullUtil.isNull((Object)jobRWInfo)) {
            String[] splitClassValue = jobRWInfo.getClassValue().split("[.]");
            return splitClassValue[splitClassValue.length - 1];
        }
        return BatchMessages.SharedValueDialog_EMPTY_JOB_RW_STRING;
    }

    private void getCheckedItem(SharedValueVo[] sharedValueList) {
        this.checkedList = new ArrayList();
        this.elseList = new ArrayList();
        if (!NullUtil.isEmpty((Object[])sharedValueList)) {
            SharedValueVo[] sharedValueVoArray = sharedValueList;
            int n = sharedValueList.length;
            int n2 = 0;
            while (n2 < n) {
                SharedValueVo vo = sharedValueVoArray[n2];
                if (NullUtil.isEmpty((String)vo.getStepId()) || vo.getStepId().equals(this.stepID)) {
                    if (vo.getKey().equals(this.readCountString)) {
                        this.checkedList.add(vo);
                        this.readCount.setSelection(true);
                    } else if (vo.getKey().equals(this.writtenString)) {
                        this.checkedList.add(vo);
                        this.written.setSelection(true);
                    } else if (vo.getKey().equals(this.currentCountString)) {
                        this.checkedList.add(vo);
                        this.currentCount.setSelection(true);
                    } else {
                        this.elseList.add(vo);
                    }
                } else {
                    this.elseList.add(vo);
                    if (vo.getKey().equals(this.readCountString)) {
                        this.readCount.setEnabled(false);
                    } else if (vo.getKey().equals(this.writtenString)) {
                        this.written.setEnabled(false);
                    } else if (vo.getKey().equals(this.currentCountString)) {
                        this.currentCount.setEnabled(false);
                    }
                }
                ++n2;
            }
        }
    }

    private void setButtonEnable() {
        if (NullUtil.isNull((Object)this.readerVo)) {
            this.readCount.setEnabled(false);
        }
        if (NullUtil.isNull((Object)this.writerVo)) {
            this.written.setEnabled(false);
            this.currentCount.setEnabled(false);
        }
    }

    protected void okPressed() {
        this.result = this.addCheckedList(this.elseList);
        super.okPressed();
    }

    private ArrayList<SharedValueVo> addCheckedList(ArrayList<SharedValueVo> sharedValueList) {
        if (this.readCount.getSelection()) {
            sharedValueList.add(new SharedValueVo(this.readCountString, this.stepID));
        }
        if (this.written.getSelection()) {
            sharedValueList.add(new SharedValueVo(this.writtenString, this.stepID));
        }
        if (this.currentCount.getSelection()) {
            sharedValueList.add(new SharedValueVo(this.currentCountString, this.stepID));
        }
        if (this.inputButton.getSelection()) {
            sharedValueList.add(new SharedValueVo(this.inputText.getText(), this.stepID));
        }
        return sharedValueList;
    }

    public ArrayList<SharedValueVo> getResult() {
        return this.result;
    }

    private boolean validateBeanID(String beanID) {
        if (this.pageBeanIDs.isBeanIDExist(beanID)) {
            return false;
        }
        return !this.batchJobListBeanIDList.isBeanIDExistIncludeJobRWBeanList(beanID);
    }

    public boolean isSharedValueNameAvailable(String name) {
        String pattern = String.valueOf(StringUtil.ENG_PATTERN) + StringUtil.NUM_PATTERN + "._-";
        return StringUtil.doesStringMatchWithPatten((String)pattern, (String)name) && !StringUtil.hasEmptySpace((String)name);
    }
}

