/*
 * Decompiled with CFR 0.152.
 */
package egovframework.bdev.imp.batch.wizards.jobcreation.pages;

import egovframework.bdev.imp.batch.common.BatchMessages;
import egovframework.bdev.imp.batch.wizards.jobcreation.model.TypeCSqlKeyValueVo;
import egovframework.dev.imp.core.utils.NullUtil;
import egovframework.dev.imp.core.utils.StringUtil;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SqlKeyValueTableDialog
extends StatusDialog {
    private Text keyText = null;
    private Text valueText = null;
    private TypeCSqlKeyValueVo vo = null;
    Listener validation = new Listener(){

        public void handleEvent(Event event) {
            if (!this.validateKey(SqlKeyValueTableDialog.this.keyText.getText())) {
                return;
            }
            if (!this.validateValue(SqlKeyValueTableDialog.this.valueText.getText())) {
                return;
            }
            StatusInfo status = new StatusInfo();
            status.setOK();
            SqlKeyValueTableDialog.this.updateStatus((IStatus)status);
        }

        protected boolean validateKey(String key) {
            StatusInfo status = new StatusInfo();
            if (NullUtil.isEmpty((String)key)) {
                status.setError("Key\ub97c \uc785\ub825\ud574 \uc8fc\uc2ed\uc2dc\uc624.");
                SqlKeyValueTableDialog.this.updateStatus((IStatus)status);
                return false;
            }
            if (!this.isSqlTableKeyValueValid(key)) {
                status.setError("Key\uac12\uc774 \uc720\ud6a8\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.");
                SqlKeyValueTableDialog.this.updateStatus((IStatus)status);
                return false;
            }
            return true;
        }

        protected boolean validateValue(String value) {
            StatusInfo status = new StatusInfo();
            if (NullUtil.isEmpty((String)value)) {
                status.setError("Value\ub97c \uc785\ub825\ud574 \uc8fc\uc2ed\uc2dc\uc624.");
                SqlKeyValueTableDialog.this.updateStatus((IStatus)status);
                return false;
            }
            if (!this.isSqlTableKeyValueValid(value)) {
                status.setError("Value\uac12\uc774 \uc720\ud6a8\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.");
                SqlKeyValueTableDialog.this.updateStatus((IStatus)status);
                return false;
            }
            return true;
        }

        private boolean isSqlTableKeyValueValid(String string) {
            char invalidChar = '\'';
            String pattern = String.valueOf(StringUtil.KOR_PATTERN) + invalidChar;
            return !StringUtil.doesCharacterOfStringBelongToPatternAtleastOne((String)pattern, (String)string);
        }
    };

    public SqlKeyValueTableDialog(Shell parent) {
        super(parent);
    }

    protected Control createDialogArea(Composite parent) {
        Composite control = new Composite(parent, 0);
        control.setLayout((Layout)new GridLayout(2, false));
        control.setLayoutData((Object)new GridData(1808));
        Label keyLabel = new Label(control, 0);
        keyLabel.setText(BatchMessages.SqlKeyValueTableDialog_KEY_LABEL);
        this.keyText = new Text(control, 2048);
        this.keyText.setLayoutData((Object)new GridData(768));
        this.keyText.addListener(24, this.validation);
        Label valueLabel = new Label(control, 0);
        valueLabel.setText(BatchMessages.SqlKeyValueTableDialog_KEY_VALUE);
        this.valueText = new Text(control, 2048);
        this.valueText.setLayoutData((Object)new GridData(768));
        this.valueText.addListener(24, this.validation);
        this.validation.handleEvent(null);
        return control;
    }

    protected void okPressed() {
        this.vo = new TypeCSqlKeyValueVo(this.keyText.getText(), this.valueText.getText());
        super.okPressed();
    }

    public TypeCSqlKeyValueVo getVo() {
        return this.vo;
    }
}

