/*
 * Decompiled with CFR 0.152.
 */
package egovframework.bdev.imp.batch.wizards.jobcreation.pages;

import egovframework.bdev.imp.batch.common.BatchMessages;
import egovframework.bdev.imp.batch.wizards.jobcreation.model.BatchJobBeanIDList;
import egovframework.bdev.imp.batch.wizards.jobcreation.model.BatchJobCreationContext;
import egovframework.bdev.imp.batch.wizards.jobcreation.model.BatchPageBeanIDList;
import egovframework.bdev.imp.batch.wizards.jobcreation.model.BatchXMLFileBeanIDList;
import egovframework.bdev.imp.batch.wizards.jobcreation.model.JobVo;
import egovframework.bdev.imp.batch.wizards.jobcreation.model.SharedValueVo;
import egovframework.bdev.imp.batch.wizards.jobcreation.model.StepAndDecisionVo;
import egovframework.bdev.imp.batch.wizards.jobcreation.model.StepVo;
import egovframework.bdev.imp.batch.wizards.jobcreation.pages.ChunkListenerDialog;
import egovframework.bdev.imp.batch.wizards.jobcreation.pages.InfoContentsConstructor;
import egovframework.bdev.imp.batch.wizards.jobcreation.pages.JobReaderDialog;
import egovframework.bdev.imp.batch.wizards.jobcreation.pages.JobWriterDialog;
import egovframework.bdev.imp.batch.wizards.jobcreation.pages.SharedValueDialog;
import egovframework.bdev.imp.batch.wizards.jobcreation.pages.StepListenerDialog;
import egovframework.bdev.imp.batch.wizards.jobcreation.views.BatchListenerLabelProvider;
import egovframework.bdev.imp.batch.wizards.jobcreation.views.SharedValuesTableProvider;
import egovframework.bdev.imp.confmngt.preferences.listeners.model.ChunkListenerInfo;
import egovframework.bdev.imp.confmngt.preferences.listeners.model.ListenerInfo;
import egovframework.bdev.imp.confmngt.preferences.listeners.model.StepListenerInfo;
import egovframework.bdev.imp.confmngt.preferences.readwrite.model.JobRWInfo;
import egovframework.bdev.imp.confmngt.preferences.readwrite.model.JobReaderInfo;
import egovframework.bdev.imp.confmngt.preferences.readwrite.model.JobWriterInfo;
import egovframework.dev.imp.core.utils.BatchTableColumn;
import egovframework.dev.imp.core.utils.NullUtil;
import egovframework.dev.imp.core.utils.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class StepInfoContentsConstructor
extends InfoContentsConstructor {
    private StepVo tempStepVo = null;
    private String gridSizeString = null;
    private String commitIntervalString = null;
    private Composite partitionTypeControl = null;
    private Button activeNext = null;
    private Text readerText = null;
    private Text writerText = null;
    private BatchJobCreationContext context = null;
    private TableViewer sharedValueTableViewer = null;
    String[] stepAndDecisionNameList = null;
    Listener selectNormalTypeListener = new Listener(){

        public void handleEvent(Event event) {
            StepInfoContentsConstructor.this.tempStepVo.setPartitionMode(false);
            StepInfoContentsConstructor.this.tempStepVo.setPartitionerType("ColumnRange Partitioner");
            StepInfoContentsConstructor.this.createNormalTypeOption();
            if (!NullUtil.isEmpty((Object[])StepInfoContentsConstructor.this.stepAndDecisionNameList)) {
                StepInfoContentsConstructor.this.activeNext.setEnabled(true);
            }
            StepInfoContentsConstructor.this.infoControl.layout(true, true);
        }
    };
    Listener selectPartitionerTypeListener = new Listener(){

        public void handleEvent(Event event) {
            StepInfoContentsConstructor.this.tempStepVo.setPartitionMode(true);
            StepInfoContentsConstructor.this.tempStepVo.setPartitionerType("MultiResource Partitioner");
            StepInfoContentsConstructor.this.cleanComposite(StepInfoContentsConstructor.this.partitionTypeControl);
            StepInfoContentsConstructor.this.infoControl.layout(true, true);
            StepInfoContentsConstructor.this.createPartitionTypeOption();
            StepInfoContentsConstructor.this.activeNext.setSelection(false);
            StepInfoContentsConstructor.this.activeNext.setEnabled(false);
            StepInfoContentsConstructor.this.activeNext.notifyListeners(13, null);
            StepInfoContentsConstructor.this.infoControl.layout(true, true);
        }
    };

    public StepInfoContentsConstructor(WizardPage currentPage, Composite infoControl, Button applyButton, BatchXMLFileBeanIDList batchXMLFileBeanIDList, List<String> projectBeanIDList, BatchJobCreationContext context) {
        this.currentPage = currentPage;
        this.infoControl = infoControl;
        this.applyButton = applyButton;
        this.batchXMLFileBeanIDList = batchXMLFileBeanIDList;
        this.selectedProject = context.getProject();
        this.projectBeanIDList = projectBeanIDList;
        this.context = context;
    }

    public void createStepInfoContents(JobVo jobVo, StepVo stepVo) {
        this.tempStepVo = new StepVo();
        this.tempStepVo.copyValues(stepVo);
        this.tempStepVo.setJobName(jobVo.getJobName());
        this.gridSizeString = this.ConvertIntegerToString(this.tempStepVo.getGridSize());
        this.commitIntervalString = this.ConvertIntegerToString(this.tempStepVo.getCommitInterval());
        this.invalidBatchXMLFileBeanIDList = this.getBatchJobsInvalidBeanList();
        this.stepAndDecisionNameList = this.getStepAndDecisionNameListWithoutThisStepVoName(jobVo);
        this.createJobIDField(jobVo.getJobName());
        this.createStepTypeControl();
        this.createStepIDAndNext();
        this.createStepTypeOptionControl();
        this.createJobRWAndCommitIntervalGroup();
        this.createAdvancedControl(jobVo);
        if (!NullUtil.isNull((Object)stepVo)) {
            this.validation().handleEvent(null);
        }
    }

    private String ConvertIntegerToString(Integer integer) {
        if (NullUtil.isNull((Object)integer)) {
            return null;
        }
        return integer.toString();
    }

    private void createJobRWAndCommitIntervalGroup() {
        Group itemModeGroup = new Group(this.infoControl, 0);
        itemModeGroup.setLayout((Layout)new GridLayout());
        itemModeGroup.setLayoutData((Object)new GridData(768));
        itemModeGroup.setText(BatchMessages.StepInfoContentsConstructor_ITEM_CONFIGURATION_GROUP);
        this.removeMarginOfGridLayout((Composite)itemModeGroup);
        this.createJobRWControl((Composite)itemModeGroup);
        this.creatCommitIntervalControl((Composite)itemModeGroup);
    }

    private void createJobRWControl(Composite control) {
        Composite readerWriterControl = new Composite(control, 0);
        readerWriterControl.setLayout((Layout)new GridLayout(3, false));
        readerWriterControl.setLayoutData((Object)new GridData(768));
        this.removeMarginOfGridLayout(readerWriterControl);
        Label readerLabel = new Label(readerWriterControl, 0);
        readerLabel.setText(BatchMessages.StepInfoContentsConstructor_READER_LABEL);
        this.readerText = this.createJobReaderText(readerWriterControl);
        this.readerText.addListener(24, this.validation());
        Label writerLabel = new Label(readerWriterControl, 0);
        writerLabel.setText(BatchMessages.StepInfoContentsConstructor_WRITER_LABEL);
        this.writerText = this.createJobWriterText(readerWriterControl);
        this.writerText.addListener(24, this.validation());
    }

    private Text createJobReaderText(Composite subControl) {
        final Text text = new Text(subControl, 2048);
        text.setLayoutData((Object)new GridData(768));
        text.setEnabled(false);
        String jobReaderFieldText = this.getJobReaderFullName(this.tempStepVo);
        text.setText(this.returnJobRWTextDefaultStringIfNull(jobReaderFieldText));
        Button button = new Button(subControl, 8);
        button.setText(BatchMessages.StepInfoContentsConstructor_ADD_BUTTON);
        button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                BatchPageBeanIDList pageBeanIDs = new BatchPageBeanIDList();
                StepInfoContentsConstructor.this.setStepPageBeanID(pageBeanIDs);
                pageBeanIDs.removeBeanID(text.getText());
                JobReaderDialog dialog = new JobReaderDialog(StepInfoContentsConstructor.this.infoControl.getShell(), StepInfoContentsConstructor.this.invalidBatchXMLFileBeanIDList, pageBeanIDs, StepInfoContentsConstructor.this.tempStepVo, StepInfoContentsConstructor.this.context);
                if (dialog.open() == 0) {
                    pageBeanIDs.removeBeanID(text.getText());
                    JobReaderInfo info = (JobReaderInfo)dialog.getInfo();
                    StepInfoContentsConstructor.this.tempStepVo.setJobReaderInfo(info);
                    text.setText(StepInfoContentsConstructor.this.getJobReaderFullName(StepInfoContentsConstructor.this.tempStepVo));
                    pageBeanIDs.addBeanID(info.getName());
                    StepInfoContentsConstructor.this.tempStepVo.setJobReaderContext(dialog.getDetailContext());
                    StepInfoContentsConstructor.this.tempStepVo.setJobReadersqlKeyValueVo(dialog.getSqlKeyValueVo());
                }
            }
        });
        return text;
    }

    private Text createJobWriterText(Composite subControl) {
        final Text text = new Text(subControl, 2048);
        text.setLayoutData((Object)new GridData(768));
        text.setEnabled(false);
        String jobWriterFieldText = this.getJobWriterFullName(this.tempStepVo);
        text.setText(this.returnJobRWTextDefaultStringIfNull(jobWriterFieldText));
        Button button = new Button(subControl, 8);
        button.setText(BatchMessages.StepInfoContentsConstructor_ADD_BUTTON);
        button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                BatchPageBeanIDList pageBeanIDs = new BatchPageBeanIDList();
                StepInfoContentsConstructor.this.setStepPageBeanID(pageBeanIDs);
                pageBeanIDs.removeBeanID(text.getText());
                JobWriterDialog dialog = new JobWriterDialog(StepInfoContentsConstructor.this.infoControl.getShell(), StepInfoContentsConstructor.this.invalidBatchXMLFileBeanIDList, pageBeanIDs, StepInfoContentsConstructor.this.tempStepVo, StepInfoContentsConstructor.this.context);
                if (dialog.open() == 0) {
                    pageBeanIDs.removeBeanID(text.getText());
                    JobWriterInfo info = (JobWriterInfo)dialog.getInfo();
                    StepInfoContentsConstructor.this.tempStepVo.setJobWriterInfo(info);
                    text.setText(StepInfoContentsConstructor.this.getJobWriterFullName(StepInfoContentsConstructor.this.tempStepVo));
                    StepInfoContentsConstructor.this.tempStepVo.setJobWriterContext(dialog.getDetailContext());
                }
            }
        });
        return text;
    }

    private String returnJobRWTextDefaultStringIfNull(String string) {
        if (NullUtil.isEmpty((String)string)) {
            return BatchMessages.StepInfoContentsConstructor_NO_JOB_RW_MESSAGE;
        }
        return string;
    }

    private String getJobReaderFullName(StepVo stepVo) {
        return this.getJobRWFullName(stepVo.getJobName(), stepVo.getName(), (JobRWInfo)stepVo.getJobReaderInfo());
    }

    private String getJobWriterFullName(StepVo stepVo) {
        return this.getJobRWFullName(stepVo.getJobName(), stepVo.getName(), (JobRWInfo)stepVo.getJobWriterInfo());
    }

    private String getJobRWFullName(String jobID, String stepID, JobRWInfo jobRW) {
        if (!NullUtil.isNull((Object)jobRW)) {
            return String.valueOf(jobID) + "." + stepID + "." + jobRW.getName();
        }
        return null;
    }

    private void creatCommitIntervalControl(Composite control) {
        Composite commitControl = new Composite(control, 0);
        commitControl.setLayout((Layout)new GridLayout(2, false));
        commitControl.setLayoutData((Object)new GridData(768));
        this.removeMarginOfGridLayout(commitControl);
        Label commitIntervalLabel = new Label(commitControl, 0);
        commitIntervalLabel.setText(BatchMessages.StepInfoContentsConstructor_COMMIT_INTERVAL_LABEL);
        Integer commitinterval = this.tempStepVo.getCommitInterval();
        final Text commitIntervalField = new Text(commitControl, 2048);
        commitIntervalField.setLayoutData((Object)new GridData(768));
        commitIntervalField.setText(this.returnEmptyStringIfNullOrConvertToString(commitinterval));
        commitIntervalField.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                try {
                    StepInfoContentsConstructor.this.commitIntervalString = commitIntervalField.getText();
                    Integer value = Integer.parseInt(StepInfoContentsConstructor.this.commitIntervalString);
                    StepInfoContentsConstructor.this.tempStepVo.setCommitInterval(value);
                }
                catch (Exception exception) {}
            }
        });
        commitIntervalField.addListener(24, this.validation());
    }

    public String returnEmptyStringIfNullOrConvertToString(Integer integer) {
        if (NullUtil.isNull((Object)integer)) {
            return "";
        }
        return integer.toString();
    }

    private void createAdvancedControl(JobVo jobVo) {
        final Button advanced = new Button(this.infoControl, 8);
        advanced.setText(BatchMessages.StepInfoContentsConstructor_DESELECT_ADVANCED_BUTTON);
        final TabFolder listenerAndSV = new TabFolder(this.infoControl, 0);
        listenerAndSV.setLayout((Layout)new GridLayout());
        listenerAndSV.setLayoutData((Object)new GridData(1808));
        listenerAndSV.setVisible(false);
        this.removeMarginOfGridLayout((Composite)listenerAndSV);
        this.createStepListenerTabItem(listenerAndSV);
        this.createChunkListenerTabItem(listenerAndSV);
        this.createSharedValuesTabItem(listenerAndSV, jobVo);
        advanced.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (!listenerAndSV.isVisible()) {
                    advanced.setText(BatchMessages.StepInfoContentsConstructor_SELECT_ADVANCED_BUTTON);
                    listenerAndSV.setVisible(true);
                } else {
                    advanced.setText(BatchMessages.StepInfoContentsConstructor_DESELECT_ADVANCED_BUTTON);
                    listenerAndSV.setVisible(false);
                }
            }
        });
    }

    private TableViewer createStepListenerTabItem(TabFolder subControl) {
        String tabItemText = BatchMessages.StepInfoContentsConstructor_STEP_LISTENER_TAB;
        StepListenerInfo[] listenerInput = this.tempStepVo.getStepListenerInfoList();
        TabItem tabItem = new TabItem(subControl, 0);
        tabItem.setText(tabItemText);
        Composite listenerControl = new Composite((Composite)subControl, 0);
        listenerControl.setLayout((Layout)new GridLayout(2, false));
        listenerControl.setLayoutData((Object)new GridData(1808));
        TableViewer tableViewer = this.createListenerTableViewer(listenerControl, (ListenerInfo[])listenerInput);
        this.createStepListenerTableButtons(listenerControl, tableViewer);
        tabItem.setControl((Control)listenerControl);
        return tableViewer;
    }

    private TableViewer createChunkListenerTabItem(TabFolder subControl) {
        String tabItemText = BatchMessages.StepInfoContentsConstructor_CHUNK_LISTENER_TAB;
        ChunkListenerInfo[] listenerInput = this.tempStepVo.getChunkListenerInfoList();
        TabItem tabItem = new TabItem(subControl, 0);
        tabItem.setText(tabItemText);
        Composite listenerControl = new Composite((Composite)subControl, 0);
        listenerControl.setLayout((Layout)new GridLayout(2, false));
        listenerControl.setLayoutData((Object)new GridData(1808));
        TableViewer tableViewer = this.createListenerTableViewer(listenerControl, (ListenerInfo[])listenerInput);
        this.createChunkListenerTableButtons(listenerControl, tableViewer);
        tabItem.setControl((Control)listenerControl);
        return tableViewer;
    }

    private TableViewer createListenerTableViewer(Composite control, ListenerInfo[] listenerInput) {
        TableViewer tableViewer = new TableViewer(control, 68352);
        Table table = tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        BatchTableColumn[] columns = this.createListenerTableColumns();
        int i = 0;
        while (i < columns.length) {
            columns[i].setColumnToTable(table);
            ++i;
        }
        tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        tableViewer.setLabelProvider((IBaseLabelProvider)new BatchListenerLabelProvider());
        tableViewer.setInput((Object)listenerInput);
        tableViewer.getControl().setLayoutData((Object)new GridData(1808));
        return tableViewer;
    }

    private BatchTableColumn[] createListenerTableColumns() {
        ArrayList<BatchTableColumn> columns = new ArrayList<BatchTableColumn>();
        columns.add(new BatchTableColumn(BatchMessages.StepInfoContentsConstructor_LISTENER_TABLE_COLUMN_NAME, 180, 16384));
        columns.add(new BatchTableColumn(BatchMessages.StepInfoContentsConstructor_LISTENER_TABLE_COLUMN_CLASS, 180, 16384));
        return columns.toArray(new BatchTableColumn[0]);
    }

    private void createChunkListenerTableButtons(Composite control, TableViewer tableViewer) {
        Composite buttonControl = new Composite(control, 0);
        buttonControl.setLayout((Layout)new GridLayout());
        buttonControl.setLayoutData((Object)new GridData());
        Button addButton = new Button(buttonControl, 8);
        addButton.setText(BatchMessages.StepInfoContentsConstructor_ADD_BUTTON);
        addButton.setLayoutData((Object)new GridData(768));
        final Button removeButton = new Button(buttonControl, 8);
        removeButton.setText(BatchMessages.StepInfoContentsConstructor_REMOVE_BUTTON);
        removeButton.setEnabled(false);
        tableViewer.getTable().addListener(13, new Listener(){

            public void handleEvent(Event event) {
                removeButton.setEnabled(true);
            }
        });
        addButton.addListener(13, this.chunkListenerTableListener(tableViewer, removeButton));
        removeButton.addListener(13, this.chunkListenerRemoveButtonListener(tableViewer, removeButton));
    }

    private void createStepListenerTableButtons(Composite control, TableViewer tableViewer) {
        Composite buttonControl = new Composite(control, 0);
        buttonControl.setLayout((Layout)new GridLayout());
        buttonControl.setLayoutData((Object)new GridData());
        Button addButton = new Button(buttonControl, 8);
        addButton.setText(BatchMessages.StepInfoContentsConstructor_ADD_BUTTON);
        addButton.setLayoutData((Object)new GridData(768));
        final Button removeButton = new Button(buttonControl, 8);
        removeButton.setText(BatchMessages.StepInfoContentsConstructor_REMOVE_BUTTON);
        removeButton.setEnabled(false);
        removeButton.addListener(13, this.stepListenerRemoveButtonListener(tableViewer, removeButton));
        tableViewer.getTable().addListener(13, new Listener(){

            public void handleEvent(Event event) {
                removeButton.setEnabled(true);
            }
        });
        addButton.addListener(13, this.stepListenerTableListener(tableViewer, removeButton));
    }

    private Listener stepListenerRemoveButtonListener(final TableViewer tableViewer, final Button removeButton) {
        return new Listener(){

            public void handleEvent(Event event) {
                IStructuredSelection selection = StepInfoContentsConstructor.this.getSelection(tableViewer);
                if (!NullUtil.isNull((Object)selection)) {
                    Object[] selections = selection.toArray();
                    tableViewer.remove(selections);
                    removeButton.setEnabled(false);
                    Object[] items = tableViewer.getTable().getItems();
                    StepListenerInfo[] stepData = new StepListenerInfo[items.length];
                    if (!NullUtil.isEmpty((Object[])items)) {
                        int i = 0;
                        while (i < items.length) {
                            stepData[i] = (StepListenerInfo)items[i].getData();
                            ++i;
                        }
                    }
                    StepInfoContentsConstructor.this.tempStepVo.setStepListenerInfoList(stepData);
                }
            }
        };
    }

    private Listener chunkListenerRemoveButtonListener(final TableViewer tableViewer, final Button removeButton) {
        return new Listener(){

            public void handleEvent(Event event) {
                IStructuredSelection selection = StepInfoContentsConstructor.this.getSelection(tableViewer);
                if (!NullUtil.isNull((Object)selection)) {
                    Object[] selections = selection.toArray();
                    tableViewer.remove(selections);
                    removeButton.setEnabled(false);
                    Object[] items = tableViewer.getTable().getItems();
                    ChunkListenerInfo[] chunkData = new ChunkListenerInfo[items.length];
                    if (!NullUtil.isEmpty((Object[])items)) {
                        int i = 0;
                        while (i < items.length) {
                            chunkData[i] = (ChunkListenerInfo)items[i].getData();
                            ++i;
                        }
                    }
                    StepInfoContentsConstructor.this.tempStepVo.setChunkListenerInfoList(chunkData);
                }
            }
        };
    }

    private IStructuredSelection getSelection(TableViewer tableViewer) {
        IStructuredSelection selection = (IStructuredSelection)tableViewer.getSelection();
        if (selection.isEmpty()) {
            return null;
        }
        return selection;
    }

    private Listener stepListenerTableListener(final TableViewer tableviewer, final Button removeButton) {
        return new Listener(){

            public void handleEvent(Event event) {
                TableItem[] items = tableviewer.getTable().getItems();
                String[] listenerNames = StepInfoContentsConstructor.this.getListenerNameFromTableItem(items);
                BatchPageBeanIDList pageBeanIDs = new BatchPageBeanIDList();
                StepInfoContentsConstructor.this.setStepPageBeanID(pageBeanIDs);
                pageBeanIDs.removeBeanID(listenerNames);
                StepListenerDialog dialog = new StepListenerDialog(StepInfoContentsConstructor.this.infoControl.getShell(), listenerNames, StepInfoContentsConstructor.this.invalidBatchXMLFileBeanIDList, pageBeanIDs);
                if (dialog.open() == 0) {
                    ListenerInfo[] data = dialog.getInfo();
                    tableviewer.setInput((Object)data);
                    StepListenerInfo[] stepData = new StepListenerInfo[data.length];
                    int i = 0;
                    while (i < data.length) {
                        stepData[i] = (StepListenerInfo)data[i];
                        ++i;
                    }
                    StepInfoContentsConstructor.this.tempStepVo.setStepListenerInfoList(stepData);
                    removeButton.setEnabled(false);
                }
            }
        };
    }

    private Listener chunkListenerTableListener(final TableViewer tableviewer, final Button removeButton) {
        return new Listener(){

            public void handleEvent(Event event) {
                TableItem[] items = tableviewer.getTable().getItems();
                String[] listenerNames = StepInfoContentsConstructor.this.getListenerNameFromTableItem(items);
                BatchPageBeanIDList pageBeanIDs = new BatchPageBeanIDList();
                StepInfoContentsConstructor.this.setStepPageBeanID(pageBeanIDs);
                pageBeanIDs.removeBeanID(listenerNames);
                ChunkListenerDialog dialog = new ChunkListenerDialog(StepInfoContentsConstructor.this.infoControl.getShell(), listenerNames, StepInfoContentsConstructor.this.invalidBatchXMLFileBeanIDList, pageBeanIDs);
                if (dialog.open() == 0) {
                    ListenerInfo[] data = dialog.getInfo();
                    tableviewer.setInput((Object)data);
                    ChunkListenerInfo[] chunkData = new ChunkListenerInfo[data.length];
                    int i = 0;
                    while (i < data.length) {
                        chunkData[i] = (ChunkListenerInfo)data[i];
                        ++i;
                    }
                    StepInfoContentsConstructor.this.tempStepVo.setChunkListenerInfoList(chunkData);
                    removeButton.setEnabled(false);
                }
            }
        };
    }

    private String[] getListenerNameFromTableItem(TableItem[] items) {
        String[] result = new String[items.length];
        int i = 0;
        while (i < items.length) {
            result[i] = ((ListenerInfo)items[i].getData()).getName();
            ++i;
        }
        return result;
    }

    private void createSharedValuesTabItem(TabFolder subControl, JobVo jobVo) {
        TabItem tabItem = new TabItem(subControl, 0);
        tabItem.setText(BatchMessages.StepInfoContentsConstructor_SHARED_VALUES_TAB);
        Composite sharedValuesControl = new Composite((Composite)subControl, 0);
        sharedValuesControl.setLayout((Layout)new GridLayout(2, false));
        sharedValuesControl.setLayoutData((Object)new GridData(1808));
        this.sharedValueTableViewer = this.createSharedValueTableViewer(sharedValuesControl, jobVo);
        tabItem.setControl((Control)sharedValuesControl);
        this.createSharedValueTableViewerButtons(sharedValuesControl);
    }

    private TableViewer createSharedValueTableViewer(Composite control, JobVo jobVo) {
        this.sharedValueTableViewer = new TableViewer(control, 68352);
        Table sharedValueTable = this.sharedValueTableViewer.getTable();
        sharedValueTable.setHeaderVisible(true);
        sharedValueTable.setLinesVisible(true);
        BatchTableColumn[] columns = this.createSharedValueTableColumns();
        int i = 0;
        while (i < columns.length) {
            columns[i].setColumnToTable(sharedValueTable);
            ++i;
        }
        this.sharedValueTableViewer.getControl().setLayoutData((Object)new GridData(1808));
        this.sharedValueTableViewer.setLabelProvider((IBaseLabelProvider)new SharedValuesTableProvider());
        this.sharedValueTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.sharedValueTableViewer.setInput((Object)jobVo.getSharedValues());
        return this.sharedValueTableViewer;
    }

    private BatchTableColumn[] createSharedValueTableColumns() {
        ArrayList<BatchTableColumn> columns = new ArrayList<BatchTableColumn>();
        columns.add(new BatchTableColumn(BatchMessages.StepInfoContentsConstructor_SHARED_VALUES_TABLE_COLUMN_KEY, 250, 16384));
        columns.add(new BatchTableColumn(BatchMessages.StepInfoContentsConstructor_SHARED_VALUES_TABLE_COLUMN_STEP_ID, 120, 16384));
        return columns.toArray(new BatchTableColumn[0]);
    }

    private void createSharedValueTableViewerButtons(Composite control) {
        Composite buttonControl = new Composite(control, 0);
        buttonControl.setLayout((Layout)new GridLayout());
        buttonControl.setLayoutData((Object)new GridData());
        Button addButton = new Button(buttonControl, 8);
        addButton.setText(BatchMessages.StepInfoContentsConstructor_SHARED_VALUES_TABLE_COLUMN_);
        addButton.setLayoutData((Object)new GridData(768));
        addButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                BatchPageBeanIDList pageBeanIDs = new BatchPageBeanIDList();
                StepInfoContentsConstructor.this.setStepPageBeanID(pageBeanIDs);
                SharedValueVo[] list = StepInfoContentsConstructor.this.getSharedValueVoFromTableViewer(StepInfoContentsConstructor.this.sharedValueTableViewer);
                SharedValueDialog dialog = new SharedValueDialog(StepInfoContentsConstructor.this.infoControl.getShell(), list, StepInfoContentsConstructor.this.tempStepVo, StepInfoContentsConstructor.this.invalidBatchXMLFileBeanIDList, pageBeanIDs);
                if (dialog.open() == 0) {
                    StepInfoContentsConstructor.this.sharedValueTableViewer.setInput(dialog.getResult());
                }
            }
        });
        final Button removeButton = new Button(buttonControl, 8);
        removeButton.setText(BatchMessages.StepInfoContentsConstructor_REMOVE_BUTTON);
        removeButton.setLayoutData((Object)new GridData(768));
        removeButton.setEnabled(false);
        removeButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                IStructuredSelection selection = StepInfoContentsConstructor.this.getSelection(StepInfoContentsConstructor.this.sharedValueTableViewer);
                if (!NullUtil.isNull((Object)selection)) {
                    StepInfoContentsConstructor.this.sharedValueTableViewer.remove(selection.toArray());
                    removeButton.setEnabled(false);
                }
                removeButton.setEnabled(false);
            }
        });
        this.sharedValueTableViewer.getTable().addListener(13, new Listener(){

            public void handleEvent(Event event) {
                removeButton.setEnabled(true);
            }
        });
    }

    private SharedValueVo[] getSharedValueVoFromTableViewer(TableViewer tableviewer) {
        TableItem[] items = tableviewer.getTable().getItems();
        SharedValueVo[] data = new SharedValueVo[items.length];
        if (items.length > 0) {
            int i = 0;
            while (i < items.length) {
                data[i] = (SharedValueVo)items[i].getData();
                ++i;
            }
        }
        return data;
    }

    private void createStepIDAndNext() {
        Composite idControl = new Composite(this.infoControl, 0);
        idControl.setLayout((Layout)new GridLayout(4, false));
        idControl.setLayoutData((Object)new GridData(768));
        this.removeMarginOfGridLayout(idControl);
        Label stepId = new Label(idControl, 0);
        stepId.setText(BatchMessages.StepInfoContentsConstructor_STEP_ID_LABEL);
        GridData stepIdFieldGD = new GridData();
        stepIdFieldGD.widthHint = 145;
        final Text stepIdField = new Text(idControl, 2048);
        stepIdField.setLayoutData((Object)stepIdFieldGD);
        stepIdField.setText(StringUtil.returnEmptyStringIfNull((String)this.tempStepVo.getName()));
        stepIdField.forceFocus();
        stepIdField.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                String writerFieldText;
                StepInfoContentsConstructor.this.tempStepVo.setName(stepIdField.getText());
                String readerFieldText = StepInfoContentsConstructor.this.getJobReaderFullName(StepInfoContentsConstructor.this.tempStepVo);
                if (!NullUtil.isEmpty((String)readerFieldText)) {
                    StepInfoContentsConstructor.this.readerText.setText(readerFieldText);
                }
                if (!NullUtil.isEmpty((String)(writerFieldText = StepInfoContentsConstructor.this.getJobWriterFullName(StepInfoContentsConstructor.this.tempStepVo)))) {
                    StepInfoContentsConstructor.this.writerText.setText(writerFieldText);
                }
            }
        });
        stepIdField.addListener(24, this.validation());
        this.activeNext = new Button(idControl, 32);
        this.activeNext.setText(BatchMessages.StepInfoContentsConstructor_NEXT_CHECK_BOX);
        this.activeNext.setSelection(false);
        this.activeNext.setEnabled(false);
        final Combo nextStep = new Combo(idControl, 2056);
        nextStep.setLayoutData((Object)stepIdFieldGD);
        nextStep.removeAll();
        nextStep.setItems(this.stepAndDecisionNameList);
        nextStep.setEnabled(false);
        nextStep.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                StepInfoContentsConstructor.this.tempStepVo.setNextStep(nextStep.getText());
            }
        });
        this.activeNext.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (StepInfoContentsConstructor.this.activeNext.getSelection()) {
                    nextStep.setEnabled(true);
                    nextStep.select(0);
                } else {
                    nextStep.setEnabled(false);
                    nextStep.deselectAll();
                }
            }
        });
        if (!NullUtil.isEmpty((String)this.tempStepVo.getNextStep())) {
            this.activeNext.setEnabled(true);
            this.activeNext.setSelection(true);
            nextStep.setEnabled(true);
            nextStep.setText(this.tempStepVo.getNextStep());
        }
        if (this.stepAndDecisionNameList.length > 0) {
            this.activeNext.setEnabled(true);
        }
    }

    public void removeMarginOfGridLayout(Composite control) {
        ((GridLayout)control.getLayout()).marginHeight = 0;
    }

    public BatchXMLFileBeanIDList getBatchJobsInvalidBeanList() {
        BatchXMLFileBeanIDList invalidList = this.batchXMLFileBeanIDList.clone();
        BatchJobBeanIDList jobBeanIDList = invalidList.getJobBeanIDList(this.tempStepVo.getJobName());
        if (!NullUtil.isNull((Object)jobBeanIDList)) {
            jobBeanIDList.removeStepDecision(this.tempStepVo.getName());
        }
        return invalidList;
    }

    public String[] getStepAndDecisionNameListWithoutThisStepVoName(JobVo jobVo) {
        Object[] data = jobVo.getStepAndDecisionVoList();
        String[] stepAndDecisionNameList = new String[]{};
        String sdVoName = StringUtil.returnEmptyStringIfNull((String)this.tempStepVo.getName());
        if (!NullUtil.isEmpty((Object[])data)) {
            stepAndDecisionNameList = NullUtil.isEmpty((String)sdVoName) ? new String[data.length] : new String[data.length - 1];
            int j = 0;
            int i = 0;
            while (i < data.length) {
                String dataName = ((StepAndDecisionVo)data[i]).getName();
                if (!sdVoName.equals(dataName)) {
                    stepAndDecisionNameList[j] = dataName;
                    ++j;
                }
                ++i;
            }
        }
        return stepAndDecisionNameList;
    }

    private void createStepTypeOptionControl() {
        this.partitionTypeControl = new Composite(this.infoControl, 0);
        this.partitionTypeControl.setLayout((Layout)new GridLayout());
        this.partitionTypeControl.setLayoutData((Object)new GridData(768));
        this.removeMarginOfGridLayout(this.partitionTypeControl);
        if (this.tempStepVo.isPartitionMode()) {
            this.createPartitionTypeOption();
        } else {
            this.createNormalTypeOption();
        }
    }

    private void createJobIDField(String jobName) {
        Composite jobIdControl = new Composite(this.infoControl, 0);
        jobIdControl.setLayout((Layout)new GridLayout(2, false));
        jobIdControl.setLayoutData((Object)new GridData(768));
        Label jobId = new Label(jobIdControl, 0);
        jobId.setText(BatchMessages.StepInfoContentsConstructor_JOB_ID_LABEL);
        Text jobIDField = new Text(jobIdControl, 2048);
        jobIDField.setLayoutData((Object)new GridData(768));
        jobIDField.setText(StringUtil.returnEmptyStringIfNull((String)jobName));
        jobIDField.setEnabled(false);
    }

    private void createStepTypeControl() {
        Group stepTypeGroup = new Group(this.infoControl, 0);
        stepTypeGroup.setLayout((Layout)new GridLayout(2, false));
        stepTypeGroup.setLayoutData((Object)new GridData(768));
        stepTypeGroup.setText(BatchMessages.StepInfoContentsConstructor_STEP_TYPE_GROUP);
        Button stepTypeNormal = new Button((Composite)stepTypeGroup, 16);
        stepTypeNormal.setLayoutData((Object)new GridData());
        stepTypeNormal.setText(BatchMessages.StepInfoContentsConstructor_NORMAL_RADIO_BUTTON);
        stepTypeNormal.addListener(13, this.selectNormalTypeListener);
        stepTypeNormal.addListener(13, this.validation());
        Button stepTypePartition = new Button((Composite)stepTypeGroup, 16);
        stepTypePartition.setText(BatchMessages.StepInfoContentsConstructor_PARTITION_RADIO_BUTTON);
        stepTypePartition.addListener(13, this.selectPartitionerTypeListener);
        stepTypePartition.addListener(13, this.validation());
        if (this.tempStepVo.isPartitionMode()) {
            stepTypePartition.setSelection(true);
        } else {
            stepTypeNormal.setSelection(true);
        }
    }

    private void createNormalTypeOption() {
        this.cleanComposite(this.partitionTypeControl);
        this.infoControl.layout(true, true);
        new Label(this.partitionTypeControl, 0);
    }

    private void cleanComposite(Composite control) {
        Control[] child = control.getChildren();
        if (child != null && child.length > 0) {
            Control[] controlArray = child;
            int n = child.length;
            int n2 = 0;
            while (n2 < n) {
                Control data = controlArray[n2];
                data.dispose();
                ++n2;
            }
        }
    }

    private void createPartitionTypeOption() {
        Composite partitionTypeOptionControl = new Composite(this.partitionTypeControl, 0);
        partitionTypeOptionControl.setLayout((Layout)new GridLayout(4, false));
        partitionTypeOptionControl.setLayoutData((Object)new GridData(768));
        this.createSubstepControl(partitionTypeOptionControl);
        this.createGridSizeControl(partitionTypeOptionControl);
        this.createResourceControl(partitionTypeOptionControl);
    }

    private void createSubstepControl(Composite control) {
        Label subStepIdLabel = new Label(control, 0);
        subStepIdLabel.setText(BatchMessages.StepInfoContentsConstructor_SUB_STEP_ID_LABEL);
        final Text subStepIdText = new Text(control, 2048);
        subStepIdText.setLayoutData((Object)new GridData(768));
        subStepIdText.setText(this.tempStepVo.getSubStepID());
        subStepIdText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                StepInfoContentsConstructor.this.tempStepVo.setSubStepID(subStepIdText.getText());
            }
        });
        subStepIdText.addListener(24, this.validation());
    }

    private void createGridSizeControl(Composite control) {
        Label gridSizeLabel = new Label(control, 131072);
        gridSizeLabel.setText(BatchMessages.StepInfoContentsConstructor_GRID_SIZE_LABEL);
        GridData gridSizeTextGData = new GridData();
        gridSizeTextGData.widthHint = 80;
        final Text gridSizeText = new Text(control, 2048);
        gridSizeText.setLayoutData((Object)gridSizeTextGData);
        gridSizeText.setText(this.returnEmptyStringIfNullOrConvertToString(this.tempStepVo.getGridSize()));
        gridSizeText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                try {
                    StepInfoContentsConstructor.this.gridSizeString = gridSizeText.getText();
                    Integer value = Integer.parseInt(StepInfoContentsConstructor.this.gridSizeString);
                    StepInfoContentsConstructor.this.tempStepVo.setGridSize(value);
                }
                catch (Exception exception) {}
            }
        });
        gridSizeText.addListener(24, this.validation());
    }

    private void createResourceControl(Composite control) {
        Label ResourceLabel = new Label(control, 0);
        ResourceLabel.setText(BatchMessages.StepInfoContentsConstructor_RESOURCE_LABEL);
        GridData resourceTextGData = new GridData(768);
        resourceTextGData.horizontalSpan = 2;
        final Text resourceText = new Text(control, 2048);
        resourceText.setLayoutData((Object)resourceTextGData);
        resourceText.setText(StringUtil.returnEmptyStringIfNull((String)this.tempStepVo.getResource()));
        resourceText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                StepInfoContentsConstructor.this.tempStepVo.setResource(resourceText.getText());
            }
        });
        resourceText.addListener(24, this.validation());
        GridData resourceGData = new GridData();
        resourceGData.widthHint = 90;
        Button resourceButton = new Button(control, 8);
        resourceButton.setText(BatchMessages.StepInfoContentsConstructor_BROWSE_BUTTON);
        resourceButton.setLayoutData((Object)resourceGData);
        resourceButton.addListener(13, this.getResourceButtonListener(resourceText));
        GridData gData = new GridData(768);
        gData.horizontalSpan = 4;
        Label exampleLabel = new Label(control, 0);
        exampleLabel.setText(BatchMessages.StepInfoContentsConstructor_RESOURCE_EXAMPLE);
        exampleLabel.setLayoutData((Object)gData);
    }

    private Listener getResourceButtonListener(final Text resourceText) {
        return new Listener(){

            public void handleEvent(Event event) {
                FileDialog fileDialog = new FileDialog(StepInfoContentsConstructor.this.partitionTypeControl.getShell(), 4096);
                fileDialog.setText(BatchMessages.StepInfoContentsConstructor_RESOURCE_BUTTON_DIALOG_TITLE);
                fileDialog.setFilterPath(StepInfoContentsConstructor.this.context.getProject().getLocation().toOSString());
                String[] filterExt = new String[]{"*.csv", "*.txt"};
                fileDialog.setFilterExtensions(filterExt);
                String selectedResource = fileDialog.open();
                if (NullUtil.isEmpty((String)selectedResource)) {
                    selectedResource = StringUtil.returnEmptyStringIfNull((String)resourceText.getText());
                } else {
                    String[] extensions = StepInfoContentsConstructor.this.getExtensions(filterExt);
                    if (!StepInfoContentsConstructor.this.hasExtension(selectedResource = selectedResource.replace("\\", "/"), extensions)) {
                        int extensionIndex = fileDialog.getFilterIndex();
                        String extension = extensions[extensionIndex];
                        selectedResource = String.valueOf(selectedResource) + "." + extension;
                    }
                }
                resourceText.setText(selectedResource);
            }
        };
    }

    private String[] getExtensions(String[] filteredExtensions) {
        ArrayList<String> extensions = new ArrayList<String>();
        if (!NullUtil.isEmpty((Object[])filteredExtensions)) {
            String[] stringArray = filteredExtensions;
            int n = filteredExtensions.length;
            int n2 = 0;
            while (n2 < n) {
                String filteredExtension = stringArray[n2];
                int dotIndex = filteredExtension.lastIndexOf(".");
                String extension = filteredExtension.substring(dotIndex + 1);
                extensions.add(extension);
                ++n2;
            }
        }
        return extensions.toArray(new String[0]);
    }

    private boolean hasExtension(String resourceName, String[] extensions) {
        if (!NullUtil.isEmpty((Object[])extensions)) {
            String[] stringArray = extensions;
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                String extension = stringArray[n2];
                if (resourceName.endsWith(extension)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    @Override
    protected void validateItems() throws InfoContentsConstructor.InfoValidationException {
        this.validateDuplicationBeanID();
        this.validateStepID();
        if (this.tempStepVo.isPartitionMode()) {
            this.validateSubStepID();
            this.validateGridSize();
            this.validateResource();
        }
        this.validateJobReader();
        this.validateJobWriter();
        this.validateCommitInterval();
    }

    private void validateDuplicationBeanID() throws InfoContentsConstructor.InfoValidationException {
        if (!this.validateStepPageBeanID()) {
            this.throwInfoValidationException(BatchMessages.StepInfoContentsConstructor_DUPLICATE_BEAN_ID);
        }
    }

    private void validateStepID() throws InfoContentsConstructor.InfoValidationException {
        String stepID = this.tempStepVo.getName();
        if (NullUtil.isEmpty((String)stepID)) {
            this.throwInfoValidationException(BatchMessages.StepInfoContentsConstructor_EMPTY_STEP_ID);
        }
        if (!NullUtil.isEmpty((Object[])this.stepAndDecisionNameList)) {
            int i = 0;
            while (i < this.stepAndDecisionNameList.length) {
                if (stepID.equals(this.stepAndDecisionNameList[i])) {
                    this.throwInfoValidationException(BatchMessages.StepInfoContentsConstructor_DUPLICATE_STEP_DECISION_ID);
                }
                ++i;
            }
        }
        if (this.isBeanIDDuplicate(this.invalidBatchXMLFileBeanIDList, stepID)) {
            this.throwInfoValidationException(BatchMessages.StepInfoContentsConstructor_DUPLICATE_BEAN_ID);
        }
        if (!StringUtil.isBatchJobBeanIDAvailable((String)stepID)) {
            this.throwInfoValidationException(BatchMessages.StepInfoContentsConstructor_INVALID_STEP_ID);
        }
    }

    private void validateSubStepID() throws InfoContentsConstructor.InfoValidationException {
        String stepID;
        String subStepID = this.tempStepVo.getSubStepID();
        if (NullUtil.isEmpty((String)subStepID)) {
            this.throwInfoValidationException(BatchMessages.StepInfoContentsConstructor_EMPTY_SUB_STEP_ID);
        }
        if (!StringUtil.isBatchJobBeanIDAvailable((String)subStepID)) {
            this.throwInfoValidationException(BatchMessages.StepInfoContentsConstructor_INVALID_SUB_STEP_ID);
        }
        if (subStepID.equals(stepID = this.tempStepVo.getName())) {
            this.throwInfoValidationException(BatchMessages.StepInfoContentsConstructor_DUPLICATE_SUB_STEP_ID_WITH_STEP_DECISION_ID);
        }
        if (!NullUtil.isEmpty((Object[])this.stepAndDecisionNameList)) {
            String[] stringArray = this.stepAndDecisionNameList;
            int n = this.stepAndDecisionNameList.length;
            int n2 = 0;
            while (n2 < n) {
                String stepAndDecisionName = stringArray[n2];
                if (subStepID.equals(stepAndDecisionName)) {
                    this.throwInfoValidationException(BatchMessages.StepInfoContentsConstructor_DUPLICATE_SUB_STEP_ID_WITH_STEP_DECISION_ID);
                }
                ++n2;
            }
        }
        if (this.isBeanIDDuplicate(this.invalidBatchXMLFileBeanIDList, subStepID)) {
            this.throwInfoValidationException(BatchMessages.StepInfoContentsConstructor_DUPLICATE_BEAN_ID);
        }
    }

    private void validateGridSize() throws InfoContentsConstructor.InfoValidationException {
        if (NullUtil.isEmpty((String)this.gridSizeString)) {
            this.throwInfoValidationException(BatchMessages.StepInfoContentsConstructor_EMPTY_GRID_SIZE);
        }
        try {
            if (Integer.parseInt(this.gridSizeString) < 1) {
                this.throwInfoValidationException(BatchMessages.StepInfoContentsConstructor_INVALID_GRID_SIZE);
            }
        }
        catch (Exception exception) {
            this.throwInfoValidationException(BatchMessages.StepInfoContentsConstructor_INVALID_GRID_SIZE);
        }
    }

    private void validateResource() throws InfoContentsConstructor.InfoValidationException {
        if (NullUtil.isEmpty((String)this.tempStepVo.getResource())) {
            this.throwInfoValidationException(BatchMessages.StepInfoContentsConstructor_EMPTY_RESOURCE);
        }
    }

    private void validateJobReader() throws InfoContentsConstructor.InfoValidationException {
        if (NullUtil.isNull((Object)this.tempStepVo.getJobReaderInfo())) {
            this.throwInfoValidationException(BatchMessages.StepInfoContentsConstructor_EMPTY_JOB_READER);
        }
    }

    private void validateJobWriter() throws InfoContentsConstructor.InfoValidationException {
        if (NullUtil.isNull((Object)this.tempStepVo.getJobWriterInfo())) {
            this.throwInfoValidationException(BatchMessages.StepInfoContentsConstructor_EMPTY_JOB_WRITER);
        }
    }

    private void validateCommitInterval() throws InfoContentsConstructor.InfoValidationException {
        if (NullUtil.isEmpty((String)this.commitIntervalString)) {
            this.throwInfoValidationException(BatchMessages.StepInfoContentsConstructor_EMPTY_COMMIT_INTERVAL);
        } else {
            try {
                if (Integer.parseInt(this.commitIntervalString) < 1) {
                    this.throwInfoValidationException(BatchMessages.StepInfoContentsConstructor_INVALID_COMMIT_INTERVAL);
                }
            }
            catch (Exception exception) {
                this.throwInfoValidationException(BatchMessages.StepInfoContentsConstructor_INVALID_COMMIT_INTERVAL);
            }
        }
    }

    private boolean validateStepPageBeanID() {
        return this.setStepPageBeanID(new BatchPageBeanIDList());
    }

    private boolean setStepPageBeanID(BatchPageBeanIDList pageBeanIDs) {
        return pageBeanIDs.setStepInfoPageBeanIDs(this.tempStepVo);
    }

    public StepVo getStepVo() {
        this.tempStepVo.setJobReaderFullName(this.getJobReaderFullName(this.tempStepVo));
        this.tempStepVo.setJobWriterFullName(this.getJobWriterFullName(this.tempStepVo));
        return this.tempStepVo;
    }

    public SharedValueVo[] applyStepIDToSharedVoAndGetList(String stepID) {
        return this.updateStepIDToSharedValueVoAndGetList(null, stepID);
    }

    public SharedValueVo[] updateStepIDToSharedValueVoAndGetList(String preStepID, String postStepID) {
        Object[] items = this.sharedValueTableViewer.getTable().getItems();
        SharedValueVo[] data = new SharedValueVo[items.length];
        if (!NullUtil.isEmpty((Object[])items)) {
            int i = 0;
            while (i < items.length) {
                SharedValueVo svVo = (SharedValueVo)items[i].getData();
                String stepID = svVo.getStepId();
                if (NullUtil.isEmpty((String)stepID) || stepID.equals(preStepID)) {
                    svVo.setStepId(postStepID);
                }
                data[i] = svVo;
                ++i;
            }
        }
        return data;
    }
}

