/*
 * Decompiled with CFR 0.152.
 */
package egovframework.bdev.imp.batch.wizards.jobcreation.util;

import egovframework.bdev.imp.batch.common.BatchMessages;
import egovframework.dev.imp.core.utils.NullUtil;
import egovframework.dev.imp.core.utils.StringUtil;
import java.util.Map;
import java.util.regex.Pattern;

public class JobRWDetailInfoValidationUtil {
    protected final String NO_ERROR_MESSAGE = "";
    protected Map<String, String> detailContext = null;

    protected JobRWDetailInfoValidationUtil(Map<String, String> detailContext) {
        this.detailContext = detailContext;
    }

    protected String validateResourceAndGetErrorMessage(String resource) {
        if (NullUtil.isEmpty((String)resource)) {
            return BatchMessages.JobRWDetailInfoValidation_EMPTY_RESOURCE;
        }
        String pattern = String.valueOf(StringUtil.ENG_PATTERN) + StringUtil.NUM_PATTERN + "\\*\\.\\/\\#\\{\\}\\[\\]\\-\\_\\:";
        if (StringUtil.doesStringMatchWithPatten((String)pattern, (String)resource) && !StringUtil.isSignalsFirstOrLast((String)"\\*\\.\\/\\#\\{\\}\\[\\]\\-\\_\\:", (String)resource)) {
            return "";
        }
        return BatchMessages.JobRWDetailInfoValidation_INVALID_RESOURCE;
    }

    protected String validateFieldNameAndGetErrorMessage(String fieldName) {
        String noEmptySpaceFieldName = this.getNoEmptySpaceString(fieldName);
        if (NullUtil.isEmpty((String)noEmptySpaceFieldName)) {
            return BatchMessages.JobRWDetailInfoValidation_EMPTY_FIELD_NAME;
        }
        String pattern = String.valueOf(StringUtil.ENG_PATTERN) + StringUtil.NUM_PATTERN + ",\\-\\_";
        if (StringUtil.doesStringMatchWithPatten((String)pattern, (String)noEmptySpaceFieldName) && !StringUtil.isSignalsFirstOrLast((String)",\\-\\_", (String)noEmptySpaceFieldName)) {
            return "";
        }
        return BatchMessages.JobRWDetailInfoValidation_INVALID_FIELD_NAME;
    }

    protected String validateFieldFormatAndGetErrorMessage(String fieldFormat) {
        if (NullUtil.isEmpty((String)fieldFormat)) {
            return BatchMessages.JobRWDetailInfoValidation_EMPTY_FIELD_FORMAT;
        }
        if (StringUtil.hasKorean((String)fieldFormat)) {
            return BatchMessages.JobRWDetailInfoValidation_INVALID_FIELD_FORMAT;
        }
        return "";
    }

    protected String validateColumnLengthAndGetErrorMessage(String columnLength) {
        String noEmptySpaceColumnLength = this.getNoEmptySpaceString(columnLength);
        if (NullUtil.isEmpty((String)noEmptySpaceColumnLength)) {
            return BatchMessages.JobRWDetailInfoValidation_EMPTY_COLUMN_LENGTH;
        }
        String pattern = "([0-9]+-[0-9]*)(,[0-9]+-[0-9]*)*";
        if (Pattern.matches(pattern, noEmptySpaceColumnLength)) {
            return "";
        }
        return BatchMessages.JobRWDetailInfoValidation_INVALID_COLUMN_LENGTH;
    }

    protected String validateVOClassAndGetErrorMessage(String voClass) {
        if (NullUtil.isEmpty((String)voClass)) {
            return BatchMessages.JobRWDetailInfoValidation_EMTPY_VO_CLASS;
        }
        if (StringUtil.hasKorean((String)voClass) || StringUtil.hasInvalidClassFileSignal((String)voClass) || StringUtil.hasEmptySpace((String)voClass)) {
            return BatchMessages.JobRWDetailInfoValidation_INVALID_VO_CLASS;
        }
        return "";
    }

    protected String validateDelimiterAndGetErrorMessage(String delimiter) {
        if (NullUtil.isEmpty((String)delimiter)) {
            return BatchMessages.JobRWDetailInfoValidation_EMPTY_DELIMITER;
        }
        String pattern = String.valueOf(StringUtil.KOR_PATTERN) + StringUtil.ENG_PATTERN + StringUtil.NUM_PATTERN;
        if (StringUtil.doesCharacterOfStringBelongToPatternAtleastOne((String)pattern, (String)delimiter) || StringUtil.hasEmptySpace((String)delimiter)) {
            return BatchMessages.JobRWDetailInfoValidation_INVALID_DELIMITER;
        }
        return "";
    }

    protected String validateFieldRangeAndGetErrorMessage(String columnRange) {
        String noEmptySpaceColumnRange = this.getNoEmptySpaceString(columnRange);
        if (NullUtil.isEmpty((String)noEmptySpaceColumnRange)) {
            return BatchMessages.JobRWDetailInfoValidation_EMPTY_FIELD_RANGE;
        }
        char signal = ',';
        String pattern = String.valueOf(StringUtil.NUM_PATTERN) + signal;
        if (StringUtil.doesStringMatchWithPatten((String)pattern, (String)noEmptySpaceColumnRange)) {
            return "";
        }
        return BatchMessages.JobRWDetailInfoValidation_INVALID_FIELD_RANGE;
    }

    protected String validateMaxCountPerResourceAndGetErrorMessage(String maxCountPerResource) {
        block4: {
            if (NullUtil.isEmpty((String)maxCountPerResource)) {
                return BatchMessages.JobRWDetailInfoValidation_EMPTY_MAX_COUNT_PER_RESOURCE;
            }
            try {
                int maxCountPerResourceInteger = Integer.parseInt(maxCountPerResource);
                if (maxCountPerResourceInteger <= 0) break block4;
                return "";
            }
            catch (Exception exception) {
                return BatchMessages.JobRWDetailInfoValidation_INVALID_MAX_COUNT_PER_RESOURCE;
            }
        }
        return BatchMessages.JobRWDetailInfoValidation_INVALID_MAX_COUNT_PER_RESOURCE;
    }

    protected String validateIBatisStatementAndGetErrorMessage(String iBatisStatement) {
        if (NullUtil.isEmpty((String)iBatisStatement)) {
            return BatchMessages.JobRWDetailInfoValidation_EMPTY_IBATIS_STATEMENT;
        }
        if (StringUtil.isBatchJobBeanIDAvailable((String)iBatisStatement)) {
            return "";
        }
        return BatchMessages.JobRWDetailInfoValidation_INVALID_IBATIS_STATEMENT;
    }

    protected String validateConfigurationFileAndGetErrorMessage(String configurationFile) {
        if (NullUtil.isEmpty((String)configurationFile)) {
            return BatchMessages.JobRWDetailInfoValidation_EMPTY_CONFIGURATION_FILE;
        }
        String pattern = String.valueOf(StringUtil.ENG_PATTERN) + StringUtil.NUM_PATTERN + "\\*\\.\\/\\#\\{\\}\\[\\]\\-\\_\\:";
        if (StringUtil.doesStringMatchWithPatten((String)pattern, (String)configurationFile) && !StringUtil.isSignalsFirstOrLast((String)"\\*\\.\\/\\#\\{\\}\\[\\]\\-\\_\\:", (String)configurationFile)) {
            return "";
        }
        return BatchMessages.JobRWDetailInfoValidation_INVALID_CONFIGURATION_FILE;
    }

    protected boolean validateSqlRelateValue(String sql) {
        String invalidSignals = "~`@$^{}[];\\";
        if (!StringUtil.doesStringHasSignalsAtLeastOneCharacter((String)invalidSignals, (String)sql)) {
            char firstCharacter = sql.charAt(0);
            int lastIndex = sql.length() - 1;
            char lastCharacter = sql.charAt(lastIndex);
            String pattern = String.valueOf(StringUtil.ENG_PATTERN) + StringUtil.KOR_PATTERN + StringUtil.NUM_PATTERN;
            if (StringUtil.doesCharacterBelongToPattern((String)pattern, (char)firstCharacter) && StringUtil.doesCharacterBelongToPattern((String)pattern, (char)lastCharacter)) {
                return true;
            }
        }
        return false;
    }

    protected String validateSqlUpdate(String sqlUpdate) {
        if (NullUtil.isEmpty((String)sqlUpdate)) {
            return BatchMessages.JobRWDBDetailInfoValidation_EMPTY_SQL_UPDATE;
        }
        if (!this.isSqlUpdateAndInsertValid(sqlUpdate)) {
            return BatchMessages.JobRWDBDetailInfoValidation_INVALID_SQL_UPDATE;
        }
        return "";
    }

    private boolean isSqlUpdateAndInsertValid(String sql) {
        String invalidSignals = "~`@$^{}[];\\";
        return !StringUtil.doesStringHasSignalsAtLeastOneCharacter((String)invalidSignals, (String)sql);
    }

    protected String validateSqlInsert(String sqlInsert) {
        if (NullUtil.isEmpty((String)sqlInsert)) {
            return BatchMessages.JobRWDBDetailInfoValidation_EMPTY_SQL_INSERT;
        }
        if (!this.isSqlUpdateAndInsertValid(sqlInsert)) {
            return BatchMessages.JobRWDBDetailInfoValidation_INVALID_SQL_INSERT;
        }
        return "";
    }

    protected String validateRowMapperAndGetErrorMessage(String rowMapper) {
        if (NullUtil.isEmpty((String)rowMapper)) {
            return BatchMessages.JobRWDetailInfoValidation_EMPTY_ROW_MAPPER;
        }
        if (StringUtil.hasInvalidClassFileSignal((String)rowMapper) || StringUtil.hasKorean((String)rowMapper) || StringUtil.hasEmptySpace((String)rowMapper)) {
            return BatchMessages.JobRWDetailInfoValidation_INVALID_ROW_MAPPER;
        }
        return "";
    }

    protected String validatePageSizeAndGetErrorMessage(String pageSize) {
        block4: {
            if (NullUtil.isEmpty((String)pageSize)) {
                return BatchMessages.JobRWDetailInfoValidation_EMPTY_PAGE_SIZE;
            }
            try {
                int maxCountPerResourceInteger = Integer.parseInt(pageSize);
                if (maxCountPerResourceInteger <= 0) break block4;
                return "";
            }
            catch (Exception exception) {
                return BatchMessages.JobRWDetailInfoValidation_INVALID_PAGE_SIZE;
            }
        }
        return BatchMessages.JobRWDetailInfoValidation_INVALID_PAGE_SIZE;
    }

    protected String validateParamsAndGetErrorMessage(String params) {
        String noEmptySpaceParams = this.getNoEmptySpaceString(params);
        if (NullUtil.isEmpty((String)noEmptySpaceParams)) {
            return BatchMessages.JobRWDetailInfoValidation_EMTPY_PARAMS;
        }
        String pattern = String.valueOf(StringUtil.ENG_PATTERN) + StringUtil.NUM_PATTERN + ",";
        if (StringUtil.doesStringMatchWithPatten((String)pattern, (String)noEmptySpaceParams) && !StringUtil.isSignalsFirstOrLast((String)",", (String)noEmptySpaceParams)) {
            return "";
        }
        return BatchMessages.JobRWDetailInfoValidation_INVALID_PARAMS;
    }

    protected String validateRowSetterAndGetErrorMessage(String rowSetter) {
        if (NullUtil.isEmpty((String)rowSetter)) {
            return BatchMessages.JobRWDetailInfoValidation_EMPTY_ROW_SETTER;
        }
        if (StringUtil.hasInvalidClassFileSignal((String)rowSetter) || StringUtil.hasKorean((String)rowSetter) || StringUtil.hasEmptySpace((String)rowSetter)) {
            return BatchMessages.JobRWDetailInfoValidation_INVALID_ROW_SETTER;
        }
        return "";
    }

    private String getNoEmptySpaceString(String originalString) {
        if (NullUtil.isEmpty((String)originalString)) {
            return originalString;
        }
        return originalString.replaceAll(" ", "");
    }
}

