/*
 * Decompiled with CFR 0.152.
 */
package egovframework.bdev.imp.batch.wizards.joblauncher;

import egovframework.bdev.imp.batch.EgovBatchPlugin;
import egovframework.bdev.imp.batch.common.BatchLog;
import egovframework.bdev.imp.batch.common.BatchMessages;
import egovframework.bdev.imp.batch.wizards.com.FindXMLFileBeanIdValueUtil;
import egovframework.bdev.imp.batch.wizards.com.HandlingFileOperation;
import egovframework.bdev.imp.batch.wizards.joblauncher.model.BatchJobLauncherContext;
import egovframework.bdev.imp.batch.wizards.joblauncher.operation.CreateBatchJobLauncherXMLFileOperation;
import egovframework.bdev.imp.batch.wizards.joblauncher.pages.BatchJobLauncherCustomizePage;
import egovframework.bdev.imp.batch.wizards.joblauncher.pages.BatchJoblauncherSelectProjectPage;
import egovframework.dev.imp.core.utils.NullUtil;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class EgovNewBatchJobLauncherWizard
extends Wizard
implements INewWizard {
    private ISelection selection;
    private BatchJobLauncherContext context = new BatchJobLauncherContext();
    private BatchJobLauncherCustomizePage customizePage;

    public EgovNewBatchJobLauncherWizard() {
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(BatchMessages.EgovNewBatchJobLauncherWizard_TITLE);
        this.setDefaultPageImageDescriptor(EgovBatchPlugin.getDefault().getImageDescriptor("batch_job_launcher_wiz_banner"));
    }

    public void addPages() {
        BatchJoblauncherSelectProjectPage selectProjectPage = new BatchJoblauncherSelectProjectPage(BatchMessages.EgovNewBatchJobLauncherWizard_1, this.context, this.selection);
        this.addPage((IWizardPage)selectProjectPage);
        this.customizePage = new BatchJobLauncherCustomizePage(BatchMessages.EgovNewBatchJobLauncherWizard_2, this.context);
        this.addPage((IWizardPage)this.customizePage);
        if (!NullUtil.isNull((Object)this.getContainer())) {
            this.getContainer().getShell().setLocation(550, 100);
        }
    }

    public boolean performFinish() {
        String duplicateBeanID = this.getDuplicateBeanID();
        if (!NullUtil.isEmpty((String)duplicateBeanID)) {
            this.customizePage.setErrorMessage(String.valueOf(BatchMessages.EgovNewBatchJobLauncherWizard_DUPLICAT_BEAN_ID_1) + duplicateBeanID + BatchMessages.EgovNewBatchJobLauncherWizard_DUPLICAT_BEAN_ID_2);
            return false;
        }
        this.checkDuplicateDBBeanID();
        this.checkDuplicateJobRepositoryBeanID();
        boolean result = true;
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(BatchMessages.EgovNewBatchJobLauncherWizard_CREATING_JOB_LAUNCHER, 3);
                    IFile newXMLFile = HandlingFileOperation.createFile(EgovNewBatchJobLauncherWizard.this.context);
                    monitor.subTask(BatchMessages.EgovNewBatchJobLauncherWizard_CREATE_JOB_LAUNCHER_FILE);
                    monitor.worked(1);
                    CreateBatchJobLauncherXMLFileOperation jobExecutionXML = new CreateBatchJobLauncherXMLFileOperation();
                    jobExecutionXML.setContext(EgovNewBatchJobLauncherWizard.this.context);
                    monitor.subTask(BatchMessages.EgovNewBatchJobLauncherWizard_SETTING_JOB_LAUNCHER_INFORMATION);
                    monitor.worked(1);
                    jobExecutionXML.createJobExecutionXMLFile(newXMLFile);
                    monitor.subTask(BatchMessages.EgovNewBatchJobLauncherWizard_APPENDING_JOB_LAUNCHER_FILE);
                    monitor.worked(1);
                    if (monitor.isCanceled()) {
                        HandlingFileOperation.deleteFile(HandlingFileOperation.newXMLFile);
                        throw new InterruptedException();
                    }
                    monitor.done();
                }
            });
            this.openCreatedFile(HandlingFileOperation.newXMLFile);
        }
        catch (InvocationTargetException e) {
            HandlingFileOperation.deleteFile(HandlingFileOperation.newXMLFile);
            BatchLog.logError(e);
            result = false;
        }
        catch (InterruptedException e) {
            HandlingFileOperation.deleteFile(HandlingFileOperation.newXMLFile);
            BatchLog.logError(e);
            result = false;
        }
        return result;
    }

    private void openCreatedFile(IFile file) {
        FileEditorInput editorInput = new FileEditorInput(file);
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(file.getName());
        try {
            page.openEditor((IEditorInput)editorInput, desc.getId());
        }
        catch (PartInitException partInitException) {}
    }

    public boolean canFinish() {
        if (this.getContainer().getCurrentPage().equals((Object)this.customizePage)) {
            return super.canFinish();
        }
        return false;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }

    private String getDuplicateBeanID() {
        ArrayList<String> findingNode = new ArrayList<String>();
        findingNode.add("/beans/bean");
        List<String> beanList = FindXMLFileBeanIdValueUtil.findXMLFiles(this.context, findingNode, "id", 1);
        this.context.setBeanList(beanList);
        HashMap<String, String> jobExecutorIDs = this.getJobExecutorIDs();
        int i = 0;
        while (i < beanList.size()) {
            String duplicateBeanID = this.returnDuplicateBeanIdIfExist(jobExecutorIDs, beanList.get(i));
            if (!NullUtil.isNull((Object)duplicateBeanID)) {
                return duplicateBeanID;
            }
            ++i;
        }
        return null;
    }

    private String returnDuplicateBeanIdIfExist(HashMap<String, String> jobExecutorIDs, String preExistBeanID) {
        String duplicateBeanID = jobExecutorIDs.get(preExistBeanID);
        if (!NullUtil.isNull((Object)duplicateBeanID)) {
            return duplicateBeanID;
        }
        return null;
    }

    private HashMap<String, String> getJobExecutorIDs() {
        HashMap<String, String> iDs = new HashMap<String, String>();
        iDs.put(this.context.getJobLauncerId(), "Launcher ID");
        iDs.put(this.context.getOperatorId(), "Operator ID");
        iDs.put(this.context.getExplorerId(), "Explorer ID");
        iDs.put(this.context.getRegisterId(), "Register ID");
        String repositoryType = this.context.getRepositoryType();
        if ("Memory".equals(repositoryType)) {
            iDs.put(this.context.getDatasourceBeanID(), "Datasource Bean ID");
        }
        return iDs;
    }

    private void checkDuplicateDBBeanID() {
        List<String> beanList = this.context.getBeanList();
        int i = 0;
        while (i < beanList.size()) {
            String beanID = beanList.get(i);
            if ("transactionManager".equals(beanID)) {
                this.context.setIsTransactionManagerExist(true);
            }
            if ("lobHandler".equals(beanID)) {
                this.context.setIsLobHandlerExist(true);
            }
            if ("jdbcTemplate".equals(beanID)) {
                this.context.setIsJdbcTemplateExist(true);
            }
            ++i;
        }
    }

    private void checkDuplicateJobRepositoryBeanID() {
        List<String> beanList = this.context.getBeanList();
        int i = 0;
        while (i < beanList.size()) {
            String beanID = beanList.get(i);
            if ("jobRepository".equals(beanID)) {
                this.context.setIsJobRepositoryExist(true);
            }
            ++i;
        }
    }
}

