/*
 * Decompiled with CFR 0.152.
 */
package egovframework.bdev.imp.batch.wizards.joblauncher.operation;

import egovframework.bdev.imp.batch.wizards.com.BatchJobContext;
import egovframework.bdev.imp.batch.wizards.com.HandlingFileOperation;
import egovframework.bdev.imp.batch.wizards.joblauncher.model.BatchJobLauncherContext;
import java.util.HashMap;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class CreateBatchJobLauncherXMLFileOperation {
    private HashMap<String, String> jobExecutionDefault = new HashMap();
    private HashMap<String, String> jobExecutionOption = new HashMap();
    private HashMap<String, String> databaseInfo = new HashMap();
    private BatchJobLauncherContext jobExecutorContext = new BatchJobLauncherContext();
    private String jobLauncherId = "";

    public void setContext(BatchJobContext context) {
        if (context != null && context instanceof BatchJobLauncherContext) {
            this.jobExecutorContext = (BatchJobLauncherContext)context;
            this.jobExecutionDefault.put("jobLauncher", this.jobExecutorContext.getJobLauncerId());
            this.jobLauncherId = this.jobExecutorContext.getJobLauncerId();
            if (!this.jobExecutorContext.isSyncMode()) {
                this.jobExecutionDefault.put("syncMode", "async<org.springframework.core.task.SimpleAsyncTaskExecutor");
            }
            if (this.jobExecutorContext.getRepositoryType() != null) {
                if (!this.jobExecutorContext.getRepositoryType().equals("Memory")) {
                    this.jobExecutionDefault.put("datasourceBeanID", this.jobExecutorContext.getDatasourceBeanID());
                    if (!this.jobExecutorContext.getIsJobRepositoryExist()) {
                        this.jobExecutionDefault.put("jobRepository", "jobRepository<org.springframework.batch.core.repository.support.JobRepositoryFactoryBean");
                    }
                    this.jobExecutionDefault.put("jobExplorer", String.valueOf(this.jobExecutorContext.getExplorerId()) + "<" + "org.springframework.batch.core.explore.support.JobExplorerFactoryBean");
                    this.jobExecutionOption.put("transactionManager", "org.springframework.jdbc.datasource.DataSourceTransactionManager");
                    if (this.jobExecutorContext.getRepositoryType().equals("DB(New)")) {
                        this.databaseInfo.put("driverClassName", "driverClassName<" + this.jobExecutorContext.getDriverClassName());
                        this.databaseInfo.put("url", "url<" + this.jobExecutorContext.getUrl());
                        this.databaseInfo.put("username", "username<" + this.jobExecutorContext.getUserName());
                        this.databaseInfo.put("password", "password<" + this.jobExecutorContext.getPasswd());
                    }
                    if (!this.jobExecutorContext.getIsJdbcTemplateExist()) {
                        this.jobExecutionOption.put("jdbcTemplate", "org.springframework.jdbc.core.JdbcTemplate");
                    }
                    this.jobExecutionOption.put("lobHandler", "org.springframework.jdbc.support.lob.DefaultLobHandler");
                } else {
                    this.jobExecutionDefault.put("jobRepository", "jobRepository<org.springframework.batch.core.repository.support.MapJobRepositoryFactoryBean");
                    this.jobExecutionDefault.put("jobExplorer", String.valueOf(this.jobExecutorContext.getExplorerId()) + "<" + "org.springframework.batch.core.explore.support.MapJobExplorerFactoryBean");
                    this.jobExecutionOption.put("transactionManager", "org.springframework.batch.support.transaction.ResourcelessTransactionManager");
                }
            } else if (!this.jobExecutorContext.getJobRepositoryClass().contains("Map")) {
                this.jobExecutionDefault.put("jobExplorer", String.valueOf(this.jobExecutorContext.getExplorerId()) + "<" + "org.springframework.batch.core.explore.support.JobExplorerFactoryBean");
            } else {
                this.jobExecutionDefault.put("jobExplorer", String.valueOf(this.jobExecutorContext.getExplorerId()) + "<" + "org.springframework.batch.core.explore.support.MapJobExplorerFactoryBean");
            }
            this.jobExecutionDefault.put("jobOperator", this.jobExecutorContext.getOperatorId());
            this.jobExecutionDefault.put("jobRegistry", this.jobExecutorContext.getRegisterId());
        }
    }

    public void createJobExecutionXMLFile(IFile newXMLFile) {
        Element beansElement = this.appendBeansElement();
        Document doc = new Document(beansElement);
        this.appendDefaultBeans(beansElement);
        this.appendOtherBeans(beansElement);
        HandlingFileOperation.transformFiletoXMLFile(doc);
    }

    private Element appendBeansElement() {
        Element beansElement = new Element("beans");
        beansElement.setNamespace(Namespace.getNamespace((String)"http://www.springframework.org/schema/beans"));
        beansElement.addNamespaceDeclaration(Namespace.getNamespace((String)"aop", (String)"http://www.springframework.org/schema/aop"));
        beansElement.addNamespaceDeclaration(Namespace.getNamespace((String)"tx", (String)"http://www.springframework.org/schema/tx"));
        beansElement.addNamespaceDeclaration(Namespace.getNamespace((String)"p", (String)"http://www.springframework.org/schema/p"));
        beansElement.addNamespaceDeclaration(Namespace.getNamespace((String)"context", (String)"http://www.springframework.org/schema/context"));
        Namespace xsi = Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance");
        String xsiSchemaLocation = "http://www.springframework.org/schema/beans \n\t http://www.springframework.org/schema/beans/spring-beans.xsd \n\t http://www.springframework.org/schema/aop \n\t http://www.springframework.org/schema/aop/spring-aop.xsd \n\t http://www.springframework.org/schema/tx \n\t http://www.springframework.org/schema/tx/spring-tx.xsd \n\t http://www.springframework.org/schema/context \n\t http://www.springframework.org/schema/context/spring-context.xsd";
        beansElement.addNamespaceDeclaration(xsi);
        beansElement.setAttribute("schemaLocation", xsiSchemaLocation, xsi);
        return beansElement;
    }

    private void appendDefaultBeans(Element beansElement) {
        String key;
        Set<String> jobExecutionDefaultKey = this.jobExecutionDefault.keySet();
        Object[] keyArray = jobExecutionDefaultKey.toArray();
        Namespace propertyNameSpace = Namespace.getNamespace((String)"p", (String)"http://www.springframework.org/schema/p");
        Element eGovBatchRunnerBean = new Element("bean");
        beansElement.addContent((Content)eGovBatchRunnerBean);
        eGovBatchRunnerBean.setAttribute(new Attribute("id", String.valueOf(this.jobExecutorContext.getFileName().split("\\.")[0]) + ".egovBatchRunner"));
        eGovBatchRunnerBean.setAttribute(new Attribute("class", "egovframework.brte.core.launch.support.EgovBatchRunner"));
        Element constructorBeanJobRepository = new Element("constructor-arg");
        eGovBatchRunnerBean.addContent((Content)constructorBeanJobRepository);
        constructorBeanJobRepository.setAttribute("ref", "jobRepository");
        int i = 0;
        while (i < this.jobExecutionDefault.size()) {
            key = (String)keyArray[i];
            if (key.equals("jobOperator") || key.equals("jobExplorer")) {
                Element constructorBean = new Element("constructor-arg");
                eGovBatchRunnerBean.addContent((Content)constructorBean);
                Attribute attrRef = null;
                attrRef = !key.equals("jobOperator") ? new Attribute("ref", this.jobExecutionDefault.get(key).split("<")[0]) : new Attribute("ref", this.jobExecutionDefault.get(key));
                constructorBean.setAttribute(attrRef);
            }
            ++i;
        }
        i = 0;
        while (i < this.jobExecutionDefault.size()) {
            String[] value;
            key = (String)keyArray[i];
            if (key.equals("jobLauncher")) {
                Element jobLauncherBean = new Element("bean");
                jobLauncherBean.removeAttribute("xmlns");
                beansElement.addContent((Content)jobLauncherBean);
                jobLauncherBean.setAttribute("id", this.jobExecutionDefault.get(key));
                jobLauncherBean.setAttribute("class", "org.springframework.batch.core.launch.support.SimpleJobLauncher");
                Element propertyBean = new Element("property");
                jobLauncherBean.addContent((Content)propertyBean);
                propertyBean.setAttribute("name", "jobRepository");
                propertyBean.setAttribute("ref", "jobRepository");
                if (!this.jobExecutorContext.isSyncMode()) {
                    Element asyncPropertyBean = new Element("property");
                    jobLauncherBean.addContent((Content)asyncPropertyBean);
                    asyncPropertyBean.setAttribute("name", "taskExecutor");
                    Element asyncClassBean = new Element("bean");
                    asyncPropertyBean.addContent((Content)asyncClassBean);
                    asyncClassBean.setAttribute("class", "org.springframework.core.task.SimpleAsyncTaskExecutor");
                }
            } else if (key.equals("jobRepository")) {
                value = this.jobExecutionDefault.get(key).split("<");
                Element jobRepositoryBean = new Element("bean");
                beansElement.addContent((Content)jobRepositoryBean);
                jobRepositoryBean.setAttribute("id", value[0]);
                jobRepositoryBean.setAttribute("class", value[1]);
                if (!value[1].contains("Map")) {
                    jobRepositoryBean.setAttribute("dataSource-ref", this.jobExecutorContext.getDatasourceBeanID(), propertyNameSpace);
                    jobRepositoryBean.setAttribute("transactionManager-ref", "transactionManager", propertyNameSpace);
                    jobRepositoryBean.setAttribute("lobHandler-ref", String.valueOf(this.jobLauncherId) + ".lobHandler", propertyNameSpace);
                } else {
                    jobRepositoryBean.setAttribute("transactionManager-ref", "transactionManager", propertyNameSpace);
                }
            } else if (key.equals("jobOperator")) {
                Element jobOperatorBean = new Element("bean");
                beansElement.addContent((Content)jobOperatorBean);
                jobOperatorBean.setAttribute("id", this.jobExecutionDefault.get(key));
                jobOperatorBean.setAttribute("class", "org.springframework.batch.core.launch.support.SimpleJobOperator");
                jobOperatorBean.setAttribute("jobLauncher-ref", this.jobExecutorContext.getJobLauncerId(), propertyNameSpace);
                jobOperatorBean.setAttribute("jobExplorer-ref", this.jobExecutorContext.getExplorerId(), propertyNameSpace);
                jobOperatorBean.setAttribute("jobRepository-ref", "jobRepository", propertyNameSpace);
                jobOperatorBean.setAttribute("jobRegistry-ref", this.jobExecutorContext.getRegisterId(), propertyNameSpace);
            } else if (key.equals("jobExplorer")) {
                value = this.jobExecutionDefault.get(key).split("<");
                Element jobExplorerBean = new Element("bean");
                beansElement.addContent((Content)jobExplorerBean);
                jobExplorerBean.setAttribute("id", value[0]);
                jobExplorerBean.setAttribute("class", value[1]);
                if (value[1].contains("Map")) {
                    jobExplorerBean.setAttribute("repositoryFactory-ref", "&amp;jobRepository", propertyNameSpace);
                } else {
                    if (this.jobExecutorContext.getDatasourceBeanID() != null) {
                        jobExplorerBean.setAttribute("dataSource-ref", this.jobExecutorContext.getDatasourceBeanID(), propertyNameSpace);
                    } else {
                        jobExplorerBean.setAttribute("dataSource-ref", this.jobExecutorContext.getDataSourceRef(), propertyNameSpace);
                    }
                    if (this.jobExecutorContext.getDatasourceBeanID() != null && this.jobExecutorContext.getRepositoryType().equals("DB(New)")) {
                        Element dataSourceBean = new Element("bean");
                        beansElement.addContent((Content)dataSourceBean);
                        dataSourceBean.setAttribute("id", this.jobExecutorContext.getDatasourceBeanID());
                        dataSourceBean.setAttribute("class", "org.apache.commons.dbcp.BasicDataSource");
                        Set<String> databaseInfoKey = this.databaseInfo.keySet();
                        Object[] databaseInfokeyArray = databaseInfoKey.toArray();
                        int j = 0;
                        while (j < this.databaseInfo.size()) {
                            String databaseKey = (String)databaseInfokeyArray[j];
                            String[] databaseValue = this.databaseInfo.get(databaseKey).split("<");
                            if (!databaseValue[0].contains("password") || databaseValue.length >= 2) {
                                Element dataSourceProperty = new Element("property");
                                dataSourceBean.addContent((Content)dataSourceProperty);
                                dataSourceProperty.setAttribute("name", databaseValue[0]);
                                dataSourceProperty.setAttribute("value", databaseValue[1]);
                            }
                            ++j;
                        }
                    }
                }
            } else if (key.equals("jobRegistry")) {
                Element jobRegistryBean = new Element("bean");
                beansElement.addContent((Content)jobRegistryBean);
                jobRegistryBean.setAttribute("id", this.jobExecutionDefault.get(key));
                jobRegistryBean.setAttribute("class", "org.springframework.batch.core.configuration.support.MapJobRegistry");
                Element jobRegistryPostProcessorBean = new Element("bean");
                beansElement.addContent((Content)jobRegistryPostProcessorBean);
                jobRegistryPostProcessorBean.setAttribute("class", "org.springframework.batch.core.configuration.support.JobRegistryBeanPostProcessor");
                Element jobRegistryPostProcessorProperty = new Element("property");
                jobRegistryPostProcessorBean.addContent((Content)jobRegistryPostProcessorProperty);
                jobRegistryPostProcessorProperty.setAttribute("name", "jobRegistry");
                jobRegistryPostProcessorProperty.setAttribute("ref", this.jobExecutionDefault.get(key));
            }
            ++i;
        }
    }

    private void appendOtherBeans(Element beansElement) {
        Set<String> jobExecutionOptionKey = this.jobExecutionOption.keySet();
        Object[] keyArray = jobExecutionOptionKey.toArray();
        int i = 0;
        while (i < this.jobExecutionOption.size()) {
            Element datasourceProperty;
            String key = (String)keyArray[i];
            Element jobLauncherOtherBean = new Element("bean");
            beansElement.addContent((Content)jobLauncherOtherBean);
            if (key.contains("transactionManager")) {
                jobLauncherOtherBean.setAttribute("id", key);
                jobLauncherOtherBean.setAttribute("class", this.jobExecutionOption.get(key));
                if (!this.jobExecutorContext.getRepositoryType().equals("Memory")) {
                    jobLauncherOtherBean.setAttribute("lazy-init", "true");
                    datasourceProperty = new Element("property");
                    jobLauncherOtherBean.addContent((Content)datasourceProperty);
                    datasourceProperty.setAttribute("name", "dataSource");
                    datasourceProperty.setAttribute("ref", this.jobExecutorContext.getDatasourceBeanID());
                }
            } else if (key.contains("lobHandler")) {
                jobLauncherOtherBean.setAttribute("id", String.valueOf(this.jobLauncherId) + "." + key);
                if (this.jobExecutorContext.getDriverClassName() != null && this.jobExecutorContext.getDriverClassName().contains("oracle")) {
                    jobLauncherOtherBean.setAttribute("class", "org.springframework.jdbc.support.lob.OracleLobHandler");
                } else {
                    jobLauncherOtherBean.setAttribute("class", this.jobExecutionOption.get(key));
                }
            } else if (key.contains("jdbcTemplate")) {
                jobLauncherOtherBean.setAttribute("id", key);
                jobLauncherOtherBean.setAttribute("class", this.jobExecutionOption.get(key));
                datasourceProperty = new Element("property");
                jobLauncherOtherBean.addContent((Content)datasourceProperty);
                datasourceProperty.setAttribute("name", "dataSource");
                datasourceProperty.setAttribute("ref", this.jobExecutorContext.getDatasourceBeanID());
            } else {
                jobLauncherOtherBean.setAttribute("id", key);
                jobLauncherOtherBean.setAttribute("class", this.jobExecutionOption.get(key));
            }
            ++i;
        }
    }
}

