/*
 * Decompiled with CFR 0.152.
 */
package egovframework.bdev.imp.batch.wizards.joblauncher.pages;

import egovframework.bdev.imp.batch.common.BatchMessages;
import egovframework.bdev.imp.batch.wizards.com.FindXMLFileBeanIdValueUtil;
import egovframework.bdev.imp.batch.wizards.joblauncher.model.BatchJobLauncherContext;
import egovframework.bdev.imp.batch.wizards.joblauncher.pages.GetRefDatasourceBeanIDDialog;
import egovframework.dev.imp.core.common.DataToolsPlatformUtil;
import egovframework.dev.imp.core.utils.NullUtil;
import egovframework.dev.imp.core.utils.StringUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class BatchJobLauncherCustomizePage
extends WizardPage {
    private static String[] dataTypes = new String[]{"mySql", "Oracle", "Altibase", "Tibero", "hsql"};
    private BatchJobLauncherContext context;
    private boolean isJobRepositoryIDExist;
    private boolean isDatasourceRefExist;
    private boolean isTransactionManagerExist;
    private boolean isDBExist;
    private Combo datasourceNameCombo;
    private Combo dbTypeCombo;
    private Text launcherIdField;
    private Text operatorIdField;
    private Text explorerIdField;
    private Text registerIdField;
    private Text driverClassNameField;
    private Text urlField;
    private Text usernameField;
    private Text passwordField;
    private Button sync;
    private Button async;
    private Button dbRefType;
    private Button dbNewType;
    private Button memoryType;
    private Composite datasourceBeanIDControl = null;
    private Text datasourceBeanIDText = null;
    private Button datasourceBrowseButton = null;
    Listener validation = new Listener(){

        public void handleEvent(Event event) {
            if (!NullUtil.isNull((Object)BatchJobLauncherCustomizePage.this.dbNewType) && BatchJobLauncherCustomizePage.this.dbNewType.getSelection() && !BatchJobLauncherCustomizePage.this.isDBExist) {
                return;
            }
            BatchJobLauncherCustomizePage.this.setPageComplete(false);
            String errorMessage = null;
            errorMessage = this.getBeanIDTextErrorMessage(BatchMessages.BatchJobLauncherCustomizePage_ERROR_LAUNCHER_ID, BatchJobLauncherCustomizePage.this.launcherIdField.getText());
            if (!NullUtil.isEmpty((String)errorMessage)) {
                BatchJobLauncherCustomizePage.this.setErrorMessage(errorMessage);
                return;
            }
            errorMessage = this.getBeanIDTextErrorMessage(BatchMessages.BatchJobLauncherCustomizePage_ERROR_OPERATOR_ID, BatchJobLauncherCustomizePage.this.operatorIdField.getText());
            if (!NullUtil.isEmpty((String)errorMessage)) {
                BatchJobLauncherCustomizePage.this.setErrorMessage(errorMessage);
                return;
            }
            errorMessage = this.getBeanIDTextErrorMessage(BatchMessages.BatchJobLauncherCustomizePage_ERROR_EXPLORER_ID, BatchJobLauncherCustomizePage.this.explorerIdField.getText());
            if (!NullUtil.isEmpty((String)errorMessage)) {
                BatchJobLauncherCustomizePage.this.setErrorMessage(errorMessage);
                return;
            }
            errorMessage = this.getBeanIDTextErrorMessage(BatchMessages.BatchJobLauncherCustomizePage_ERROR_REGISTER_ID, BatchJobLauncherCustomizePage.this.registerIdField.getText());
            if (!NullUtil.isEmpty((String)errorMessage)) {
                BatchJobLauncherCustomizePage.this.setErrorMessage(errorMessage);
                return;
            }
            if (!BatchJobLauncherCustomizePage.this.isJobRepositoryIDExist) {
                if (!BatchJobLauncherCustomizePage.this.memoryType.getSelection() && !NullUtil.isEmpty((String)(errorMessage = this.getBeanIDTextErrorMessage(BatchMessages.BatchJobLauncherCustomizePage_ERROR_DATASOURCE_BEAN_ID, BatchJobLauncherCustomizePage.this.datasourceBeanIDText.getText())))) {
                    BatchJobLauncherCustomizePage.this.setErrorMessage(errorMessage);
                    return;
                }
                if (BatchJobLauncherCustomizePage.this.isDBExist && BatchJobLauncherCustomizePage.this.dbNewType.getSelection()) {
                    if (NullUtil.isEmpty((String)BatchJobLauncherCustomizePage.this.datasourceNameCombo.getText())) {
                        BatchJobLauncherCustomizePage.this.setErrorMessage(BatchMessages.BatchJobLauncherCustomizePage_DESELECT_DB);
                        return;
                    }
                    if (NullUtil.isEmpty((Text)BatchJobLauncherCustomizePage.this.driverClassNameField)) {
                        BatchJobLauncherCustomizePage.this.setErrorMessage(BatchMessages.BatchJobLauncherCustomizePage_EMPTY_DRIVER_CLASS_NAME);
                        return;
                    }
                    if (NullUtil.isEmpty((Text)BatchJobLauncherCustomizePage.this.urlField)) {
                        BatchJobLauncherCustomizePage.this.setErrorMessage(BatchMessages.BatchJobLauncherCustomizePage_EMPTY_URL);
                        return;
                    }
                    if (NullUtil.isEmpty((Text)BatchJobLauncherCustomizePage.this.usernameField)) {
                        BatchJobLauncherCustomizePage.this.setErrorMessage(BatchMessages.BatchJobLauncherCustomizePage_EMPTY_USER_NAME);
                        return;
                    }
                }
            }
            BatchJobLauncherCustomizePage.this.saveValuesToContext();
            BatchJobLauncherCustomizePage.this.setErrorMessage(null);
            BatchJobLauncherCustomizePage.this.setPageComplete(true);
        }

        private String getBeanIDTextErrorMessage(String beanIDName, String beanIDValue) {
            if (NullUtil.isEmpty((String)beanIDValue)) {
                return String.valueOf(beanIDName) + BatchMessages.BatchJobLauncherCustomizePage_EMPTY_VALUE;
            }
            if (!StringUtil.isBatchJobBeanIDAvailable((String)beanIDValue)) {
                return String.valueOf(beanIDName) + BatchMessages.BatchJobLauncherCustomizePage_INVALID_VALUE;
            }
            String duplicateBeanID = BatchJobLauncherCustomizePage.this.getDuplicateBeanID();
            if (!NullUtil.isEmpty((String)duplicateBeanID)) {
                return String.valueOf(BatchMessages.BatchJobLauncherCustomizePage_DUPLICATE_BEAN_ID_1) + duplicateBeanID + BatchMessages.BatchJobLauncherCustomizePage_DUPLICATE_BEAN_ID_2;
            }
            return null;
        }
    };
    Listener selectDBListener = new Listener(){

        public void handleEvent(Event event) {
            Map dBProfile;
            if (!NullUtil.isEmpty((Combo)BatchJobLauncherCustomizePage.this.datasourceNameCombo) && !(dBProfile = DataToolsPlatformUtil.getProperty((String)BatchJobLauncherCustomizePage.this.datasourceNameCombo.getText())).isEmpty()) {
                BatchJobLauncherCustomizePage.this.usernameField.setText((String)dBProfile.get("username"));
                if (dBProfile.get("password") != null) {
                    BatchJobLauncherCustomizePage.this.passwordField.setText((String)dBProfile.get("password"));
                } else {
                    BatchJobLauncherCustomizePage.this.passwordField.setText("");
                }
                BatchJobLauncherCustomizePage.this.driverClassNameField.setText((String)dBProfile.get("driverClass"));
                BatchJobLauncherCustomizePage.this.urlField.setText((String)dBProfile.get("url"));
                String rawDBType = (String)dBProfile.get("driverClass");
                String[] stringArray = dataTypes;
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String item = stringArray[n2];
                    if (rawDBType.toLowerCase().indexOf(item.toLowerCase()) > -1) {
                        BatchJobLauncherCustomizePage.this.dbTypeCombo.setText(item);
                        break;
                    }
                    ++n2;
                }
            }
        }
    };
    Listener browseListener = new Listener(){

        public void handleEvent(Event event) {
            String selectedBeanID = "";
            GetRefDatasourceBeanIDDialog dialog = new GetRefDatasourceBeanIDDialog(BatchJobLauncherCustomizePage.this.getShell(), BatchJobLauncherCustomizePage.this.context, selectedBeanID);
            dialog.setTitle(BatchMessages.BatchJobLauncherCustomizePage_GET_REF_DATASOURCE_BEAN_ID_DIALOG_TITLE);
            if (dialog.open() == 0) {
                selectedBeanID = dialog.getRefDatasourceBeanID();
                BatchJobLauncherCustomizePage.this.datasourceBeanIDText.setText(selectedBeanID);
            }
        }
    };

    public BatchJobLauncherCustomizePage(String pageName, BatchJobLauncherContext context) {
        super(pageName);
        this.context = context;
        this.setTitle(BatchMessages.BatchJobLauncherCustomizePage_TITLE);
        this.setDescription(BatchMessages.BatchJobLauncherCustomizePage_DESCRIPTION);
    }

    public void createControl(Composite parent) {
        Composite control = new Composite(parent, 0);
        control.setLayout((Layout)new GridLayout(2, false));
        control.setLayoutData((Object)new GridData(768));
        this.launcherIdField = this.createIDLine(control, BatchMessages.BatchJobLauncherCustomizePage_LAUNCHER_ID_LABEL);
        this.createSyncMode(control);
        this.operatorIdField = this.createIDLine(control, BatchMessages.BatchJobLauncherCustomizePage_OPERATOR_ID_LABEL);
        this.explorerIdField = this.createIDLine(control, BatchMessages.BatchJobLauncherCustomizePage_EXPLORER_ID_LABEL);
        this.registerIdField = this.createIDLine(control, BatchMessages.BatchJobLauncherCustomizePage_REGISTER_ID_LABEL);
        this.createRepositoryType(control);
        this.setControl((Control)control);
    }

    private void createDatabaseControl(Composite parent) {
        GridData spanHorizontal = new GridData(768);
        spanHorizontal.horizontalSpan = 3;
        Group dataBaseGroup = new Group(parent, 0);
        dataBaseGroup.setLayout((Layout)new GridLayout());
        dataBaseGroup.setLayoutData((Object)spanHorizontal);
        dataBaseGroup.setText(BatchMessages.BatchJobLauncherCustomizePage_DATABASE_GROUP);
        this.datasourceBeanIDControl = new Composite((Composite)dataBaseGroup, 0);
        this.datasourceBeanIDControl.setLayout((Layout)new GridLayout(3, false));
        this.datasourceBeanIDControl.setLayoutData((Object)new GridData(768));
        this.clearAndCreateDatasourceBeanIDControlWithBrowseButton();
        this.createDatasourceGroup((Composite)dataBaseGroup);
    }

    private void clearAndCreateDatasourceBeanIDControl() {
        this.clearDatasourceBeanIDControl();
        Label beanIDLabel = new Label(this.datasourceBeanIDControl, 0);
        beanIDLabel.setText(BatchMessages.BatchJobLauncherCustomizePage_DATASOURCE_BEAN_ID_LABEL);
        this.datasourceBeanIDText = new Text(this.datasourceBeanIDControl, 2048);
        this.datasourceBeanIDText.setLayoutData((Object)new GridData(768));
        this.datasourceBeanIDText.addListener(24, this.validation);
    }

    private void clearDatasourceBeanIDControl() {
        Control[] children = this.datasourceBeanIDControl.getChildren();
        int i = 0;
        while (i < children.length) {
            children[i].dispose();
            ++i;
        }
    }

    private void clearAndCreateDatasourceBeanIDControlWithoutBrowseButton() {
        this.clearAndCreateDatasourceBeanIDControl();
        this.datasourceBeanIDControl.getParent().layout(true, true);
    }

    private void clearAndCreateDatasourceBeanIDControlWithBrowseButton() {
        this.clearAndCreateDatasourceBeanIDControl();
        this.datasourceBrowseButton = new Button(this.datasourceBeanIDControl, 8);
        this.datasourceBrowseButton.setText(BatchMessages.BatchJobLauncherCustomizePage_BROWSE_BUTTON);
        this.datasourceBrowseButton.addListener(13, this.browseListener);
        this.datasourceBeanIDControl.getParent().layout(true, true);
    }

    private void createDatasourceGroup(Composite parent) {
        Group descriptionGrp = new Group(parent, 4);
        descriptionGrp.setText(BatchMessages.BatchJobLauncherCustomizePage_DATASOURCE_GROUP);
        descriptionGrp.setLayout((Layout)new GridLayout(2, false));
        descriptionGrp.setLayoutData((Object)new GridData(768));
        GridData labelGridData = new GridData(128);
        labelGridData.widthHint = 120;
        GridData fieldGridData = new GridData(768);
        Label selectDBLabel = new Label((Composite)descriptionGrp, 131072);
        selectDBLabel.setText(BatchMessages.BatchJobLauncherCustomizePage_DATASOURCE_LABEL);
        selectDBLabel.setLayoutData((Object)labelGridData);
        this.datasourceNameCombo = new Combo((Composite)descriptionGrp, 12);
        this.datasourceNameCombo.setItems(this.getAvailableDBProfileNames());
        this.datasourceNameCombo.setLayoutData((Object)fieldGridData);
        this.datasourceNameCombo.addListener(13, this.selectDBListener);
        this.datasourceNameCombo.addListener(13, this.validation);
        Label dbTypeLabel = new Label((Composite)descriptionGrp, 131072);
        dbTypeLabel.setText(BatchMessages.BatchJobLauncherCustomizePage_DB_TYPE_LABEL);
        dbTypeLabel.setLayoutData((Object)labelGridData);
        this.dbTypeCombo = new Combo((Composite)descriptionGrp, 12);
        this.dbTypeCombo.setItems(dataTypes);
        this.dbTypeCombo.setLayoutData((Object)fieldGridData);
        this.dbTypeCombo.setEnabled(false);
        this.dbTypeCombo.addListener(13, this.validation);
        Label driverClassNameLabel = new Label((Composite)descriptionGrp, 131072);
        driverClassNameLabel.setText(BatchMessages.BatchJobLauncherCustomizePage_DRIVER_CLASS_NAME_LABEL);
        driverClassNameLabel.setLayoutData((Object)labelGridData);
        this.driverClassNameField = new Text((Composite)descriptionGrp, 2048);
        this.driverClassNameField.setLayoutData((Object)fieldGridData);
        this.driverClassNameField.setEnabled(false);
        this.driverClassNameField.addListener(24, this.validation);
        Label urlLabel = new Label((Composite)descriptionGrp, 131072);
        urlLabel.setText(BatchMessages.BatchJobLauncherCustomizePage_URL_LABEL);
        urlLabel.setLayoutData((Object)labelGridData);
        this.urlField = new Text((Composite)descriptionGrp, 2048);
        this.urlField.setLayoutData((Object)fieldGridData);
        this.urlField.setEnabled(false);
        this.urlField.addListener(24, this.validation);
        Label usernameLabel = new Label((Composite)descriptionGrp, 131072);
        usernameLabel.setText(BatchMessages.BatchJobLauncherCustomizePage_USER_NAME_LABEL);
        usernameLabel.setLayoutData((Object)labelGridData);
        this.usernameField = new Text((Composite)descriptionGrp, 2048);
        this.usernameField.setLayoutData((Object)fieldGridData);
        this.usernameField.setEnabled(false);
        this.usernameField.addListener(24, this.validation);
        Label passwordLabel = new Label((Composite)descriptionGrp, 131072);
        passwordLabel.setText(BatchMessages.BatchJobLauncherCustomizePage_PASSWORD_LABEL);
        passwordLabel.setLayoutData((Object)labelGridData);
        this.passwordField = new Text((Composite)descriptionGrp, 0x400800);
        this.passwordField.setLayoutData((Object)fieldGridData);
        this.passwordField.setEnabled(false);
        this.passwordField.addListener(24, this.validation);
    }

    private String[] getAvailableDBProfileNames() {
        String[] profileNames = DataToolsPlatformUtil.getProfileNames();
        ArrayList<String> availableNames = new ArrayList<String>();
        String dataType = null;
        String profileName = null;
        Map dBProfile = null;
        String rawDBType = null;
        int i = 0;
        while (i < profileNames.length) {
            profileName = profileNames[i];
            dBProfile = DataToolsPlatformUtil.getProperty((String)profileName);
            rawDBType = (String)dBProfile.get("driverClass");
            int j = 0;
            while (j < dataTypes.length) {
                dataType = dataTypes[j];
                if (rawDBType.toLowerCase().indexOf(dataType.toLowerCase()) > -1) {
                    availableNames.add(profileName);
                    break;
                }
                ++j;
            }
            ++i;
        }
        String[] result = availableNames.toArray(new String[0]);
        return result;
    }

    private Text createIDLine(Composite control, String iDString) {
        Label iDLabel = new Label(control, 0);
        iDLabel.setText(String.valueOf(iDString) + " : ");
        Text text = new Text(control, 2048);
        text.setLayoutData((Object)new GridData(768));
        text.addListener(24, this.validation);
        return text;
    }

    private void setIsJobRepositoryIDExist() {
        LinkedHashMap<String, String> beanValueList;
        LinkedHashMap<String, String> beanList = FindXMLFileBeanIdValueUtil.findingWantedBeanInXMLFiles(this.context, "/beans/bean", "id", "jobRepository", "class", false);
        if (beanList != null && beanList.size() != 0) {
            this.context.setJobRepositoryClass(beanList.keySet().toArray()[0].toString());
            this.isJobRepositoryIDExist = true;
        } else {
            this.isJobRepositoryIDExist = false;
        }
        if (this.isJobRepositoryIDExist) {
            LinkedHashMap<String, String> beanDataSourceRefList = FindXMLFileBeanIdValueUtil.findingWantedBeanInXMLFiles(this.context, "/beans/bean", "id", "jobRepository", "p:dataSource-ref", false);
            if (beanDataSourceRefList.size() != 0) {
                this.context.setDataSourceRef(beanDataSourceRefList.keySet().toArray()[0].toString());
            } else {
                this.context.setDataSourceRef("");
            }
        }
        this.isDatasourceRefExist = (beanValueList = FindXMLFileBeanIdValueUtil.findingWantedBeanInXMLFiles(this.context, "/beans/bean/property", "name", "driverClassName", "id", true)).size() != 0;
        LinkedHashMap<String, String> beanValueTMList = FindXMLFileBeanIdValueUtil.findingWantedBeanInXMLFiles(this.context, "/beans/bean", "id", "transactionManager", "id", false);
        this.isTransactionManagerExist = beanValueTMList.size() != 0;
        this.context.setIsTransactionManagerExist(this.isTransactionManagerExist);
    }

    private void createSyncMode(Composite control) {
        Label syncModeLabel = new Label(control, 0);
        syncModeLabel.setText(BatchMessages.BatchJobLauncherCustomizePage_EXECUTION_TYPE_LABEL);
        GridData gData = new GridData(768);
        gData.horizontalSpan = 2;
        Composite syncModeControl = new Composite(control, 0);
        syncModeControl.setLayout((Layout)new GridLayout(2, true));
        syncModeControl.setLayoutData((Object)gData);
        this.sync = new Button(syncModeControl, 16);
        this.sync.setLayoutData((Object)new GridData());
        this.sync.setText(BatchMessages.BatchJobLauncherCustomizePage_SYNCHRONOUS_RADIO_BUTTON);
        this.sync.addListener(13, this.validation);
        this.async = new Button(syncModeControl, 16);
        this.async.setLayoutData((Object)new GridData());
        this.async.setText(BatchMessages.BatchJobLauncherCustomizePage_ASYNCHRONOUS_RADIO_BUTTON);
        this.async.addListener(13, this.validation);
    }

    private void createRepositoryType(Composite control) {
        GridData gData = new GridData(768);
        gData.horizontalSpan = 3;
        GridLayout gLayout = new GridLayout(3, false);
        gLayout.horizontalSpacing = 20;
        Group repositoryTypeGroup = new Group(control, 0);
        repositoryTypeGroup.setLayout((Layout)gLayout);
        repositoryTypeGroup.setLayoutData((Object)gData);
        repositoryTypeGroup.setText(BatchMessages.BatchJobLauncherCustomizePage_REPOSITORY_TYPE_GROUP);
        this.dbRefType = new Button((Composite)repositoryTypeGroup, 16);
        this.dbRefType.setText(BatchMessages.BatchJobLauncherCustomizePage_DB_REFERENCE_RADIO_BUTTON);
        this.dbRefType.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                BatchJobLauncherCustomizePage.this.clearAndCreateDatasourceBeanIDControlWithBrowseButton();
                BatchJobLauncherCustomizePage.this.setDisableDatasourceControl();
            }
        });
        this.dbNewType = new Button((Composite)repositoryTypeGroup, 16);
        this.dbNewType.setText(BatchMessages.BatchJobLauncherCustomizePage_DB_NEW_RADIO_BUTTON);
        this.dbNewType.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                BatchJobLauncherCustomizePage.this.clearAndCreateDatasourceBeanIDControlWithoutBrowseButton();
                BatchJobLauncherCustomizePage.this.setEnableDatasourceControl();
            }
        });
        this.memoryType = new Button((Composite)repositoryTypeGroup, 16);
        this.memoryType.setText(BatchMessages.BatchJobLauncherCustomizePage_MEMORY_RADIO_BUTTON);
        this.memoryType.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                BatchJobLauncherCustomizePage.this.clearAndCreateDatasourceBeanIDControlWithoutBrowseButton();
                BatchJobLauncherCustomizePage.this.datasourceBeanIDText.setEnabled(false);
                BatchJobLauncherCustomizePage.this.setDisableDatasourceControl();
            }
        });
        this.createDatabaseControl((Composite)repositoryTypeGroup);
    }

    private BatchJobLauncherContext saveValuesToContext() {
        this.context.setJobLauncerId(this.launcherIdField.getText());
        this.context.setSyncMode(this.sync.getSelection());
        this.context.setOperatorId(this.operatorIdField.getText());
        this.context.setExplorerId(this.explorerIdField.getText());
        this.context.setRegisterId(this.registerIdField.getText());
        if (!this.isJobRepositoryIDExist) {
            if (this.dbRefType.getSelection()) {
                this.context.setRepositoryType("DB(Reference)");
                this.context.setDatasourceBeanID(this.datasourceBeanIDText.getText());
            } else if (this.dbNewType.getSelection()) {
                this.context.setRepositoryType("DB(New)");
                this.context.setDatasourceBeanID(this.datasourceBeanIDText.getText());
            } else if (this.memoryType.getSelection()) {
                this.context.setRepositoryType("Memory");
            }
            this.context.setSelectDB(this.datasourceNameCombo.getText());
            this.context.setDbType(this.dbTypeCombo.getText());
            this.context.setDriverClassName(this.driverClassNameField.getText());
            this.context.setUrl(this.urlField.getText());
            this.context.setUserName(this.usernameField.getText());
            this.context.setPasswd(this.passwordField.getText());
        }
        return this.context;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.setPageComplete(true);
            this.setIsJobRepositoryIDExist();
            Point size = null;
            size = new Point(533, 690);
            this.getShell().setMinimumSize(size);
            this.getShell().setSize(size);
            this.refreshPage();
            this.saveValuesToContext();
        }
        super.setVisible(visible);
    }

    private void refreshPage() {
        this.launcherIdField.setText("jobLauncher");
        this.sync.setSelection(true);
        this.async.setSelection(false);
        this.operatorIdField.setText("jobOperator");
        this.explorerIdField.setText("jobExplorer");
        this.registerIdField.setText("jobRegistry");
        if (!this.isJobRepositoryIDExist) {
            this.isDBExist = !NullUtil.isEmpty((Object[])this.getAvailableDBProfileNames());
            this.datasourceBeanIDText.setText("");
            if (!this.isDBExist) {
                this.removeDBNewTypeListeners();
                this.addNoDBListenerToDBNewTypeButton();
            }
            if (this.isDatasourceRefExist) {
                this.dbRefType.setEnabled(true);
                this.dbRefType.setSelection(true);
                this.dbRefType.notifyListeners(13, null);
                this.dbNewType.setSelection(false);
            } else {
                this.dbRefType.setEnabled(false);
                this.dbRefType.setSelection(false);
                this.dbNewType.setSelection(true);
                this.dbNewType.notifyListeners(13, null);
            }
            this.dbNewType.setEnabled(true);
            if (this.isTransactionManagerExist) {
                this.memoryType.setEnabled(false);
            } else {
                this.memoryType.setEnabled(true);
            }
            this.memoryType.setSelection(false);
        } else {
            this.dbRefType.setEnabled(false);
            this.dbNewType.setEnabled(false);
            this.memoryType.setEnabled(false);
            this.datasourceBeanIDText.setEnabled(false);
            this.datasourceBrowseButton.setEnabled(false);
            this.datasourceNameCombo.setEnabled(false);
        }
        this.setErrorMessage(null);
    }

    private void removeDBNewTypeListeners() {
        Listener[] listeners = this.dbNewType.getListeners(13);
        int i = 0;
        while (i < listeners.length) {
            this.dbNewType.removeListener(13, listeners[i]);
            ++i;
        }
    }

    private void addNoDBListenerToDBNewTypeButton() {
        this.dbNewType.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                BatchJobLauncherCustomizePage.this.clearAndCreateDatasourceBeanIDControlWithoutBrowseButton();
                if (BatchJobLauncherCustomizePage.this.dbNewType.getSelection()) {
                    BatchJobLauncherCustomizePage.this.datasourceBeanIDText.setEnabled(false);
                    BatchJobLauncherCustomizePage.this.datasourceNameCombo.setEnabled(false);
                    BatchJobLauncherCustomizePage.this.datasourceNameCombo.deselectAll();
                    BatchJobLauncherCustomizePage.this.setErrorMessage(null);
                    BatchJobLauncherCustomizePage.this.setMessage(BatchMessages.BatchJobLauncherCustomizePage_NO_DATABASE, 1);
                    BatchJobLauncherCustomizePage.this.setPageComplete(false);
                } else {
                    BatchJobLauncherCustomizePage.this.setMessage(null, 1);
                }
            }
        });
    }

    private String getDuplicateBeanID() {
        ArrayList<String> beanIDList = new ArrayList<String>();
        beanIDList.add("async");
        if (!this.dbRefType.getSelection()) {
            beanIDList.add("datasource");
        }
        beanIDList.add("transactionManager");
        beanIDList.add("jobHandler");
        beanIDList.add("jdbcTemplate");
        if (!this.checkAndAddBeanID(beanIDList, this.launcherIdField.getText())) {
            return BatchMessages.BatchJobLauncherCustomizePage_DUPLICATE_LAUNCHER_ID;
        }
        if (!this.checkAndAddBeanID(beanIDList, this.operatorIdField.getText())) {
            return BatchMessages.BatchJobLauncherCustomizePage_DUPLICATE_OPERATOR_ID;
        }
        if (!this.checkAndAddBeanID(beanIDList, this.explorerIdField.getText())) {
            return BatchMessages.BatchJobLauncherCustomizePage_DUPLICATE_EXPLORER_ID;
        }
        if (!this.checkAndAddBeanID(beanIDList, this.registerIdField.getText())) {
            return BatchMessages.BatchJobLauncherCustomizePage_DUPLICATE_REGISTER_ID;
        }
        if (!this.checkAndAddBeanID(beanIDList, this.datasourceBeanIDText.getText())) {
            return BatchMessages.BatchJobLauncherCustomizePage_DUPLICATE_DATASOURCE_BEAN_ID;
        }
        return "";
    }

    private boolean checkAndAddBeanID(ArrayList<String> beanIDList, String beanID) {
        if (NullUtil.isEmpty(beanIDList)) {
            beanIDList = new ArrayList();
            return beanIDList.add(beanID);
        }
        if (beanIDList.contains(beanID)) {
            return false;
        }
        return beanIDList.add(beanID);
    }

    private void setEnableDatasourceControl() {
        this.datasourceNameCombo.setEnabled(true);
        this.datasourceNameCombo.select(0);
        this.datasourceNameCombo.notifyListeners(13, new Event());
    }

    private void setDisableDatasourceControl() {
        this.datasourceNameCombo.setEnabled(false);
        this.datasourceNameCombo.deselectAll();
        this.dbTypeCombo.deselectAll();
        this.driverClassNameField.setText("");
        this.urlField.setText("");
        this.usernameField.setText("");
        this.passwordField.setText("");
    }
}

