/*
 * Decompiled with CFR 0.152.
 */
package egovframework.bdev.imp.batchnature.util;

import egovframework.bdev.imp.batchnature.EgovBatchNaturePlugin;
import egovframework.bdev.imp.batchnature.common.BatchNatureLog;
import egovframework.dev.imp.core.utils.BTextSearchUtil;
import egovframework.dev.imp.core.utils.EgovJavaElementUtil;
import egovframework.dev.imp.core.utils.XmlUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class HandlePomXMLFileUtil {
    public static boolean isPomFileExist(IProject project) {
        boolean isPomFileExist = false;
        List foundList = null;
        IFile actualFile = null;
        try {
            if (EgovJavaElementUtil.isJavaProject((IProject)project)) {
                foundList = BTextSearchUtil.findFiles((IResource[])project.members(), null, (String)"pom.xml", (boolean)false, null);
            }
        }
        catch (CoreException e) {
            BatchNatureLog.logError(e);
        }
        if (foundList != null) {
            int j = 0;
            while (j < foundList.size()) {
                Object f;
                Map map = (Map)foundList.get(j);
                if (map != null && (f = map.get("file")) instanceof IFile) {
                    actualFile = (IFile)f;
                    break;
                }
                ++j;
            }
        }
        if (actualFile != null) {
            if (actualFile.isAccessible() && actualFile.exists()) {
                isPomFileExist = true;
                HandlePomXMLFileUtil.modifyPom(actualFile, project);
            }
        } else {
            isPomFileExist = HandlePomXMLFileUtil.createPomFile(actualFile, project);
        }
        return isPomFileExist;
    }

    private static boolean createPomFile(IFile actualFile, IProject project) {
        Path path = new Path(project.getFullPath() + "/" + "pom.xml");
        actualFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
        InputStream inputStream = HandlePomXMLFileUtil.createPropertiesFileinZip(null, "examples/pomFile.zip");
        try {
            actualFile.create(inputStream, false, null);
            inputStream.close();
        }
        catch (CoreException e) {
            BatchNatureLog.logError(e);
        }
        catch (IOException e) {
            BatchNatureLog.logError(e);
        }
        return true;
    }

    private static void modifyPom(IFile actualFile, IProject project) {
        try {
            Node rootNode = XmlUtil.getRootNode((File)new File(project.getProject().getFile("pom.xml").getLocation().toOSString()));
            NodeList oriNodes = XmlUtil.getNodeList((Node)rootNode, (String)"/project/dependencies/dependency");
            if (oriNodes != null) {
                boolean eGovBatchNoExist = true;
                boolean springBatchInfraNoExist = true;
                boolean springBatchCoreNoExist = true;
                Node oriDependency = null;
                int j = 0;
                while (oriNodes.getLength() > j) {
                    oriDependency = oriNodes.item(j);
                    Node oriArtifactId = XmlUtil.getNode((Node)oriDependency, (String)"./artifactId");
                    if (oriArtifactId != null && oriArtifactId.getFirstChild().getNodeValue().equals("egovframework.rte.bat.core")) {
                        eGovBatchNoExist = false;
                        Node oriVersion = XmlUtil.getNode((Node)oriDependency, (String)"./version");
                        if (oriVersion != null && !oriVersion.getFirstChild().getNodeValue().equals("1.0.0")) {
                            oriVersion.getFirstChild().setNodeValue("1.0.0");
                        }
                    }
                    if (oriArtifactId != null && oriArtifactId.getFirstChild().getNodeValue().equals("spring-batch-infrastructure")) {
                        springBatchInfraNoExist = false;
                    }
                    if (oriArtifactId != null && oriArtifactId.getFirstChild().getNodeValue().equals("spring-batch-core")) {
                        springBatchCoreNoExist = false;
                    }
                    ++j;
                }
                if (eGovBatchNoExist) {
                    String xmlStr = "<dependency>\n\t\t\t<groupId>egovframework.rte</groupId>\n\t\t\t<artifactId>egovframework.rte.bat.core</artifactId>\n\t\t\t<version>2.6.0</version>\n\t\t</dependency>\n ";
                    XmlUtil.addFirstNode((Node)rootNode, (String)"/project/dependencies", (String)xmlStr, (String)"\n\t\t", (String)"\t");
                }
                if (springBatchInfraNoExist) {
                    String xmlStr = "<dependency>\n\t\t\t<groupId>org.springframework.batch</groupId>\n\t\t\t<artifactId>spring-batch-infrastructure</artifactId>\n\t\t\t<version>2.1.8.RELEASE</version>\n\t\t</dependency>\n ";
                    XmlUtil.addFirstNode((Node)rootNode, (String)"/project/dependencies", (String)xmlStr, (String)"\n\t\t", (String)"\t");
                }
                if (springBatchCoreNoExist) {
                    String xmlStr = "<dependency>\n\t\t\t<groupId>org.springframework.batch</groupId>\n\t\t\t<artifactId>spring-batch-core</artifactId>\n\t\t\t<version>2.1.8.RELEASE</version>\n\t\t</dependency>\n ";
                    XmlUtil.addFirstNode((Node)rootNode, (String)"/project/dependencies", (String)xmlStr, (String)"\n\t\t", (String)"\t");
                }
                ByteArrayInputStream inStream = new ByteArrayInputStream(XmlUtil.getXmlString((Node)rootNode, (String)"/").getBytes("UTF-8"));
                actualFile.setContents((InputStream)inStream, true, false, null);
                ((InputStream)inStream).close();
            }
        }
        catch (Exception e) {
            BatchNatureLog.logError(e);
        }
    }

    public static InputStream createPropertiesFileinZip(IProgressMonitor monitor, String fileName) {
        InputStream inputStream = null;
        URL insetUrl = EgovBatchNaturePlugin.getDefault().getBundle().getEntry(fileName);
        try {
            URL url = FileLocator.toFileURL((URL)insetUrl);
            URL resolvedUrl = FileLocator.resolve((URL)url);
            File inputZipFile = new File(resolvedUrl.getFile());
            ZipFile zipFile = new ZipFile(inputZipFile, "UTF-8");
            Enumeration enumeration = zipFile.getEntries();
            while (enumeration.hasMoreElements()) {
                ZipEntry entry = (ZipEntry)enumeration.nextElement();
                String name = entry.getName();
                if (entry.isDirectory() || name.indexOf("pom.xml") <= -1) continue;
                inputStream = zipFile.getInputStream(entry);
            }
            inputStream.close();
        }
        catch (IOException e) {
            BatchNatureLog.logError(e);
        }
        return inputStream;
    }
}

