/*
 * Decompiled with CFR 0.152.
 */
package egovframework.bdev.imp.batchnature.wizard;

import egovframework.bdev.imp.batchnature.EgovBatchNature;
import egovframework.bdev.imp.batchnature.common.BatchNatureLog;
import egovframework.bdev.imp.batchnature.util.HandlePomXMLFileUtil;
import egovframework.bdev.imp.batchnature.wizard.EgovBatchNatureWizardPage;
import egovframework.dev.imp.core.utils.NullUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.osgi.service.prefs.BackingStoreException;

public class EgovBatchNatureWizard
extends Wizard {
    public static final String TITLE = "Add eGovFrame Batch Nature";
    private final IProject project;
    private EgovBatchNatureWizardPage page;

    public EgovBatchNatureWizard(IProject project) {
        this.project = project;
        this.setWindowTitle(TITLE);
        this.setHelpAvailable(false);
    }

    public void addPages() {
        try {
            this.page = new EgovBatchNatureWizardPage(this.project, TITLE);
            this.addPage((IWizardPage)this.page);
            if (!NullUtil.isNull((Object)this.getContainer())) {
                this.getContainer().getShell().setLocation(550, 100);
            }
        }
        catch (Exception t) {
            BatchNatureLog.logError(t.getMessage(), t);
        }
    }

    public boolean performFinish() {
        try {
            IProjectDescription description = this.project.getDescription();
            String[] natures = description.getNatureIds();
            String[] newNatures = new String[natures.length + 1];
            System.arraycopy(natures, 0, newNatures, 0, natures.length);
            newNatures[natures.length] = EgovBatchNature.Nature_ID;
            description.setNatureIds(newNatures);
            this.project.setDescription(description, null);
            new ProjectScope(this.project).getNode("egovframework.bdev.imp.ide.natures.egovnature").flush();
            HandlePomXMLFileUtil.isPomFileExist(this.project);
            return true;
        }
        catch (BackingStoreException e) {
            BatchNatureLog.logError(e);
        }
        catch (Exception e) {
            BatchNatureLog.logError(e);
        }
        return false;
    }
}

