/*
 * Decompiled with CFR 0.152.
 */
package egovframework.bdev.imp.confmngt;

import egovframework.bdev.imp.confmngt.preferences.readwrite.model.DefaultJobRWMap;
import egovframework.bdev.imp.confmngt.preferences.readwrite.model.JobReaderInfo;
import egovframework.bdev.imp.confmngt.preferences.readwrite.model.JobWriterInfo;
import egovframework.dev.imp.core.utils.NullUtil;
import java.util.ArrayList;
import java.util.List;

class DefaultJobRWList {
    private ArrayList<JobReaderInfo> defaultJobReaderList = new ArrayList();
    private ArrayList<JobWriterInfo> defaultJobWriterList = new ArrayList();
    private DefaultJobRWMap defaultJobReaderMap = new DefaultJobRWMap();
    private DefaultJobRWMap defaultJobWriterMap = null;

    public DefaultJobRWList() {
        this.defaultJobReaderMap.resetDefaultReadType();
        this.defaultJobWriterMap = new DefaultJobRWMap();
        this.defaultJobWriterMap.resetDefaultWriterType();
    }

    public void makeAndAddDefaultJobReader(String name, String itemType) {
        JobReaderInfo defaultJobReaderInfo = this.makeDefaultJobReader(name, itemType);
        this.defaultJobReaderList.add(defaultJobReaderInfo);
    }

    private JobReaderInfo makeDefaultJobReader(String name, String itemType) {
        JobReaderInfo jobReaderInfo = new JobReaderInfo();
        jobReaderInfo.setName(name);
        if (this.defaultJobReaderMap.isFileType(itemType)) {
            jobReaderInfo.setResourceType("File");
        } else {
            jobReaderInfo.setResourceType("DB");
        }
        jobReaderInfo.setItemType(itemType);
        String classValue = this.defaultJobReaderMap.getClassValue(itemType);
        jobReaderInfo.setClassValue(classValue);
        String resourceDetailType = this.defaultJobReaderMap.getDetailType(itemType);
        jobReaderInfo.setResourceDetailType(resourceDetailType);
        return jobReaderInfo;
    }

    public void makeAndAddDefaultJobWriter(String name, String itemType) {
        JobWriterInfo defaultJobWriterInfo = this.makeDefaultJobWriter(name, itemType);
        this.defaultJobWriterList.add(defaultJobWriterInfo);
    }

    private JobWriterInfo makeDefaultJobWriter(String name, String itemType) {
        JobWriterInfo jobWriterInfo = new JobWriterInfo();
        jobWriterInfo.setName(name);
        if (this.defaultJobWriterMap.isFileType(itemType)) {
            jobWriterInfo.setResourceType("File");
        } else {
            jobWriterInfo.setResourceType("DB");
        }
        jobWriterInfo.setItemType(itemType);
        String classValue = this.defaultJobWriterMap.getClassValue(itemType);
        jobWriterInfo.setClassValue(classValue);
        String resourceDetailType = this.defaultJobWriterMap.getDetailType(itemType);
        jobWriterInfo.setResourceDetailType(resourceDetailType);
        return jobWriterInfo;
    }

    public void removeAllPreExistJobReader(List<JobReaderInfo> preExistJobReaderList) {
        if (!NullUtil.isEmpty(preExistJobReaderList)) {
            for (JobReaderInfo preExistJobReader : preExistJobReaderList) {
                this.removePreExistJobReader(preExistJobReader);
            }
        }
    }

    private void removePreExistJobReader(JobReaderInfo comparedJobReader) {
        JobReaderInfo preExistJobReaderInfo = null;
        for (JobReaderInfo jobReaderInfo : this.defaultJobReaderList) {
            String comparedJobReaderName;
            String originalJobReaderName = jobReaderInfo.getName();
            if (!originalJobReaderName.equals(comparedJobReaderName = comparedJobReader.getName())) continue;
            preExistJobReaderInfo = jobReaderInfo;
            break;
        }
        this.defaultJobReaderList.remove(preExistJobReaderInfo);
    }

    public void removeAllPreExistJobWriter(List<JobWriterInfo> preExistJobWriterList) {
        if (!NullUtil.isEmpty(preExistJobWriterList)) {
            for (JobWriterInfo preExistJobWriter : preExistJobWriterList) {
                this.removePreExistJobWriter(preExistJobWriter);
            }
        }
    }

    private void removePreExistJobWriter(JobWriterInfo comparedJobWriter) {
        JobWriterInfo preExistJobWriterInfo = null;
        for (JobWriterInfo jobWriterInfo : this.defaultJobWriterList) {
            String comparedJobWriterName;
            String originalJobWriterName = jobWriterInfo.getName();
            if (!originalJobWriterName.equals(comparedJobWriterName = comparedJobWriter.getName())) continue;
            preExistJobWriterInfo = jobWriterInfo;
            break;
        }
        this.defaultJobWriterList.remove(preExistJobWriterInfo);
    }

    public ArrayList<JobReaderInfo> getDefaultJobReaderList() {
        return this.defaultJobReaderList;
    }

    public ArrayList<JobWriterInfo> getDefaultJobWriterList() {
        return this.defaultJobWriterList;
    }
}

