/*
 * Decompiled with CFR 0.152.
 */
package egovframework.bdev.imp.confmngt;

import egovframework.bdev.imp.confmngt.DefaultJobRWList;
import egovframework.bdev.imp.confmngt.EgovBatchConfMngtPlugin;
import egovframework.bdev.imp.confmngt.preferences.readwrite.model.JobReaderInfo;
import egovframework.bdev.imp.confmngt.preferences.readwrite.model.JobWriterInfo;
import egovframework.dev.imp.core.utils.PrefrencePropertyUtil;
import java.util.ArrayList;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class PreferenceInitializer
extends AbstractPreferenceInitializer {
    private DefaultJobRWList defaultJobRWList = null;
    private final String IS_BATCH_JOB_RW_DEFAULT_SET = "IsBatchJobRWDefaultSet";

    public void initializeDefaultPreferences() {
        IPreferenceStore store = EgovBatchConfMngtPlugin.getDefault().getPreferenceStore();
        boolean isBatchJobRWDefaultSet = store.getBoolean("IsBatchJobRWDefaultSet");
        if (!isBatchJobRWDefaultSet) {
            this.defaultJobRWList = new DefaultJobRWList();
            this.setDefaultJobReaderList();
            this.addDefaultJobReaderToStore(store);
            this.setDefaultJobWriterList();
            this.addDefaultJobWriterToStore(store);
            store.setValue("IsBatchJobRWDefaultSet", true);
        }
    }

    private void setDefaultJobReaderList() {
        this.addDefaultJobReaderToList();
        this.defaultJobRWList.removeAllPreExistJobReader(this.getStoredJobReaderInfoList());
    }

    private void addDefaultJobReaderToList() {
        this.defaultJobRWList.makeAndAddDefaultJobReader("FixedFlatFileItemReader", "FixedFlatFileItemReader");
        this.defaultJobRWList.makeAndAddDefaultJobReader("DelimitedFlatFileItemReader", "DelimitedFlatFileItemReader");
        this.defaultJobRWList.makeAndAddDefaultJobReader("EgovFixedFlatFileItemReader", "EgovFixedFlatFileItemReader");
        this.defaultJobRWList.makeAndAddDefaultJobReader("EgovDelimitedFlatFileItemReader", "EgovDelimitedFlatFileItemReader");
        this.defaultJobRWList.makeAndAddDefaultJobReader("FixedMultiResourceItemReader", "FixedMultiResourceItemReader");
        this.defaultJobRWList.makeAndAddDefaultJobReader("DelimitedMultiResourceItemReader", "DelimitedMultiResourceItemReader");
        this.defaultJobRWList.makeAndAddDefaultJobReader("EgovFixedMultiResourceItemReader", "EgovFixedMultiResourceItemReader");
        this.defaultJobRWList.makeAndAddDefaultJobReader("EgovDelimitedMultiResourceItemReader", "EgovDelimitedMultiResourceItemReader");
        this.defaultJobRWList.makeAndAddDefaultJobReader("IbatisPagingItemReader", "IbatisPagingItemReader");
        this.defaultJobRWList.makeAndAddDefaultJobReader("CustomizedJdbcCursorItemReader", "CustomizedJdbcCursorItemReader");
        this.defaultJobRWList.makeAndAddDefaultJobReader("SqlPagingQueryJdbcItemReader", "SqlPagingQueryJdbcItemReader");
    }

    private ArrayList<JobReaderInfo> getStoredJobReaderInfoList() {
        ArrayList<JobReaderInfo> infoList = new ArrayList<JobReaderInfo>();
        int voCnt = EgovBatchConfMngtPlugin.getDefault().getPreferenceStore().getInt("Reader");
        int i = 0;
        while (i < voCnt) {
            JobReaderInfo storedJobReaderInfo = new JobReaderInfo();
            storedJobReaderInfo.setId("Reader", i);
            storedJobReaderInfo = (JobReaderInfo)PrefrencePropertyUtil.loadPreferences((AbstractUIPlugin)EgovBatchConfMngtPlugin.getDefault(), (Object)storedJobReaderInfo);
            infoList.add(storedJobReaderInfo);
            ++i;
        }
        return infoList;
    }

    private void setDefaultJobWriterList() {
        this.addDefaultJobWriterToList();
        this.defaultJobRWList.removeAllPreExistJobWriter(this.getStoredJobWriterInfoList());
    }

    private void addDefaultJobWriterToList() {
        this.defaultJobRWList.makeAndAddDefaultJobWriter("DelimitedFlatFileItemWriter", "DelimitedFlatFileItemWriter");
        this.defaultJobRWList.makeAndAddDefaultJobWriter("FormatterFlatFileItemWriter", "FormatterFlatFileItemWriter");
        this.defaultJobRWList.makeAndAddDefaultJobWriter("EgovDelimitedFlatFileItemWriter", "EgovDelimitedFlatFileItemWriter");
        this.defaultJobRWList.makeAndAddDefaultJobWriter("EgovFixedFlatFileItemWriter", "EgovFixedFlatFileItemWriter");
        this.defaultJobRWList.makeAndAddDefaultJobWriter("DelimitedMultiResourceItemWriter", "DelimitedMultiResourceItemWriter");
        this.defaultJobRWList.makeAndAddDefaultJobWriter("FormatterMultiResourceItemWriter", "FormatterMultiResourceItemWriter");
        this.defaultJobRWList.makeAndAddDefaultJobWriter("EgovDelimitedMultiResourceItemWriter", "EgovDelimitedMultiResourceItemWriter");
        this.defaultJobRWList.makeAndAddDefaultJobWriter("EgovFixedMultiResourceItemWriter", "EgovFixedMultiResourceItemWriter");
        this.defaultJobRWList.makeAndAddDefaultJobWriter("IbatisBatchItemWriter", "IbatisBatchItemWriter");
        this.defaultJobRWList.makeAndAddDefaultJobWriter("SqlParameterJdbcBatchItemWriter", "SqlParameterJdbcBatchItemWriter");
        this.defaultJobRWList.makeAndAddDefaultJobWriter("ItemPreparedStatementJdbcBatchItemWriter", "ItemPreparedStatementJdbcBatchItemWriter");
        this.defaultJobRWList.makeAndAddDefaultJobWriter("EgovItemPreparedStatementJdbcBatchItemWriter", "EgovItemPreparedStatementJdbcBatchItemWriter");
        this.defaultJobRWList.makeAndAddDefaultJobWriter("EgovCustomizedJdbcBatchItemWriter", "EgovCustomizedJdbcBatchItemWriter");
    }

    private ArrayList<JobWriterInfo> getStoredJobWriterInfoList() {
        ArrayList<JobWriterInfo> infoList = new ArrayList<JobWriterInfo>();
        int voCnt = EgovBatchConfMngtPlugin.getDefault().getPreferenceStore().getInt("Writer");
        int i = 0;
        while (i < voCnt) {
            JobWriterInfo storedJobWriterInfo = new JobWriterInfo();
            storedJobWriterInfo.setId("Writer", i);
            storedJobWriterInfo = (JobWriterInfo)PrefrencePropertyUtil.loadPreferences((AbstractUIPlugin)EgovBatchConfMngtPlugin.getDefault(), (Object)storedJobWriterInfo);
            infoList.add(storedJobWriterInfo);
            ++i;
        }
        return infoList;
    }

    private void addDefaultJobReaderToStore(IPreferenceStore store) {
        int currentVoCount = store.getInt("Reader");
        ArrayList<JobReaderInfo> defaultJobReaderList = this.defaultJobRWList.getDefaultJobReaderList();
        for (JobReaderInfo defaultJobRWInfo : defaultJobReaderList) {
            defaultJobRWInfo.setId("Reader", currentVoCount);
            ++currentVoCount;
            PrefrencePropertyUtil.savePreferences((AbstractUIPlugin)EgovBatchConfMngtPlugin.getDefault(), (Object)defaultJobRWInfo);
        }
        store.setValue("Reader", currentVoCount);
    }

    private void addDefaultJobWriterToStore(IPreferenceStore store) {
        int currentVoCount = store.getInt("Writer");
        ArrayList<JobWriterInfo> defaultJobWriterList = this.defaultJobRWList.getDefaultJobWriterList();
        for (JobWriterInfo defaultJobRWInfo : defaultJobWriterList) {
            defaultJobRWInfo.setId("Writer", currentVoCount);
            ++currentVoCount;
            PrefrencePropertyUtil.savePreferences((AbstractUIPlugin)EgovBatchConfMngtPlugin.getDefault(), (Object)defaultJobRWInfo);
        }
        store.setValue("Writer", currentVoCount);
    }
}

