/*
 * Decompiled with CFR 0.152.
 */
package egovframework.bdev.imp.confmngt.preferences.com;

import egovframework.bdev.imp.confmngt.EgovBatchConfMngtPlugin;
import egovframework.bdev.imp.confmngt.common.BConfMngtMessages;
import egovframework.bdev.imp.confmngt.preferences.com.model.Info;
import egovframework.dev.imp.core.utils.BatchTableColumn;
import egovframework.dev.imp.core.utils.NullUtil;
import egovframework.dev.imp.core.utils.PrefrencePropertyUtil;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public abstract class BatchContents {
    protected TableViewer tableViewer;
    private boolean isCheckBoxTableViewer;
    private Info voClassType;
    private String preferenceStoreName;
    private int voCount;
    private BatchTableColumn[] columns = null;
    private String description;
    private ITableLabelProvider labelProvider;

    public TableViewer getTableViewer() {
        return this.tableViewer;
    }

    public String getDescription() {
        return this.description;
    }

    public BatchContents(String description, Info voInfo, String preferenceStoreName, ITableLabelProvider labelProvider, boolean isCheckBoxTableViewer) {
        this.description = description;
        this.voClassType = voInfo;
        this.preferenceStoreName = preferenceStoreName;
        this.labelProvider = labelProvider;
        this.isCheckBoxTableViewer = isCheckBoxTableViewer;
    }

    private ArrayList<Info> getStoredData() {
        ArrayList<Info> infoList = new ArrayList<Info>();
        int voCnt = EgovBatchConfMngtPlugin.getDefault().getPreferenceStore().getInt(this.preferenceStoreName);
        int i = 0;
        while (i < voCnt) {
            Info insertVoInfo = this.getInfoClass();
            insertVoInfo.setId(this.preferenceStoreName, i);
            insertVoInfo = (Info)PrefrencePropertyUtil.loadPreferences((AbstractUIPlugin)EgovBatchConfMngtPlugin.getDefault(), (Object)insertVoInfo);
            infoList.add(insertVoInfo);
            ++i;
        }
        return infoList;
    }

    public void saveData() {
        this.voCount = this.tableViewer.getTable().getItemCount();
        EgovBatchConfMngtPlugin.getDefault().getPreferenceStore().setValue(this.preferenceStoreName, this.voCount);
        int i = 0;
        while (i < this.voCount) {
            Info voInfo = (Info)this.tableViewer.getTable().getItem(i).getData();
            voInfo.setId(this.preferenceStoreName, i);
            PrefrencePropertyUtil.savePreferences((AbstractUIPlugin)EgovBatchConfMngtPlugin.getDefault(), (Object)voInfo);
            ++i;
        }
    }

    public void setTableColumnProperty(BatchTableColumn[] columns) {
        this.columns = columns;
    }

    public TabItem createTabContents(TabFolder folder) {
        TabItem item = new TabItem(folder, 0);
        item.setText(this.description);
        Composite control = new Composite((Composite)folder, 0);
        control.setLayout((Layout)new GridLayout());
        control.setLayoutData((Object)new GridData(1808));
        item.setControl((Control)this.createTableViewerContents(control));
        return item;
    }

    public Composite createTableViewerContents(Composite parent) {
        this.tableViewer = this.isCheckBoxTableViewer ? CheckboxTableViewer.newCheckList((Composite)parent, (int)68352) : new TableViewer(parent, 68352);
        Table table = this.tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.tableViewer.getControl().setLayoutData((Object)new GridData(1808));
        GridData gData = new GridData();
        gData.grabExcessHorizontalSpace = true;
        int i = 0;
        while (i < this.columns.length) {
            this.columns[i].setColumnToTable(table);
            ++i;
        }
        this.tableViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableViewer.setInput(this.getStoredData());
        return parent;
    }

    public abstract Listener addButtonListener(Shell var1);

    public abstract Listener editButtonListener(Shell var1);

    public Listener removeButtonListener(Shell parent) {
        return new Listener(){

            public void handleEvent(Event event) {
                IStructuredSelection selection = (IStructuredSelection)BatchContents.this.tableViewer.getSelection();
                if (!NullUtil.isNull((Object)selection) && selection.size() > 0 && MessageDialog.openConfirm(null, (String)BConfMngtMessages.BatchContents_REMOVE_BUTTON_DIALOG_TITLE, (String)BConfMngtMessages.BatchContents_REMOVE_BUTTON_DIALOG_DESCRIPTION)) {
                    BatchContents.this.tableViewer.remove(selection.toArray());
                }
            }
        };
    }

    protected Info getInfoClass() {
        try {
            Class<?> typeClass = Class.forName(this.voClassType.getClass().getName());
            return (Info)typeClass.newInstance();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void refreshInputData() {
        this.tableViewer.setInput(this.getStoredData());
    }
}

