/*
 * Decompiled with CFR 0.152.
 */
package egovframework.bdev.imp.confmngt.preferences.listeners;

import egovframework.bdev.imp.confmngt.common.BConfMngtMessages;
import egovframework.bdev.imp.confmngt.preferences.listeners.model.ListenerInfo;
import egovframework.dev.imp.core.utils.NullUtil;
import egovframework.dev.imp.core.utils.StringUtil;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.core.BinaryType;
import org.eclipse.jdt.internal.core.SourceType;
import org.eclipse.jdt.internal.ui.dialogs.FilteredTypesSelectionDialog;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ListenerDialog
extends StatusDialog {
    private final boolean isAddButton;
    final List<String> existingIdList;
    private ListenerInfo listener = null;
    private String description;
    private Text nameText = null;
    private Text classText = null;
    private Combo typeCombo = null;
    Listener browseListener = new Listener(){

        public void handleEvent(Event event) {
            FilteredTypesSelectionDialog dialog = new FilteredTypesSelectionDialog(ListenerDialog.this.getShell(), false, (IRunnableContext)PlatformUI.getWorkbench().getProgressService(), SearchEngine.createWorkspaceScope(), 5);
            dialog.setTitle(BConfMngtMessages.ListenerDialog_BROWSE_BUTTON_DIALOG_TITLE);
            dialog.setMessage(BConfMngtMessages.ListenerDialog_BROWSE_BUTTON_DIALOG_DESCRIPTION);
            dialog.setInitialPattern("");
            if (dialog.open() == 0) {
                Object type = dialog.getFirstResult();
                if (!NullUtil.isNull((Object)type)) {
                    if (type instanceof BinaryType) {
                        ListenerDialog.this.classText.setText(((BinaryType)type).getFullyQualifiedName());
                    } else if (type instanceof SourceType) {
                        ListenerDialog.this.classText.setText(((SourceType)type).getFullyQualifiedName());
                    }
                }
                return;
            }
        }
    };
    Listener validation = new Listener(){

        public void handleEvent(Event event) {
            StatusInfo status = new StatusInfo();
            status = new StatusInfo();
            if (ListenerDialog.this.isAddButton) {
                String id = ListenerDialog.this.nameText.getText();
                if (id.length() == 0) {
                    status.setError(BConfMngtMessages.ListenerDialog_EMPTY_NAME);
                    ListenerDialog.this.updateStatus((IStatus)status);
                    return;
                }
                if (!StringUtil.isBatchJobBeanIDAvailable((String)id)) {
                    status.setError(BConfMngtMessages.ListenerDialog_INVALID_NAME);
                    ListenerDialog.this.updateStatus((IStatus)status);
                    return;
                }
                if (ListenerDialog.this.existingIdList.contains(id)) {
                    status.setError(BConfMngtMessages.ListenerDialog_DUPLICATE_NAME);
                    ListenerDialog.this.updateStatus((IStatus)status);
                    return;
                }
            }
            if (ListenerDialog.this.classText != null) {
                String classValueString = ListenerDialog.this.classText.getText();
                if (classValueString.length() < 1) {
                    status.setError(BConfMngtMessages.ListenerDialog_EMPTY_CLASS_VALUE);
                    ListenerDialog.this.updateStatus((IStatus)status);
                    return;
                }
                if (!ListenerDialog.this.isClassNameOfBatchPreferenceAvailable(classValueString)) {
                    status.setError(BConfMngtMessages.ListenerDialog_INVALID_CLASS_VALUE);
                    ListenerDialog.this.updateStatus((IStatus)status);
                    return;
                }
            }
            status.setOK();
            ListenerDialog.this.updateStatus((IStatus)status);
        }
    };

    public ListenerDialog(Shell shell, boolean isAddButton, List<String> existingIdList, ListenerInfo listener, String description) {
        super(shell);
        this.isAddButton = isAddButton;
        this.existingIdList = existingIdList;
        this.listener = listener;
        this.description = description;
        if ("Job".equals(description)) {
            if (isAddButton) {
                this.setTitle(BConfMngtMessages.ListenerDialog_NEW_JOB_TITLE);
            } else {
                this.setTitle(BConfMngtMessages.ListenerDialog_EDIT_JOB_TITLE);
            }
        } else if ("Step".equals(description)) {
            if (isAddButton) {
                this.setTitle(BConfMngtMessages.ListenerDialog_NEW_STEP_TITLE);
            } else {
                this.setTitle(BConfMngtMessages.ListenerDialog_EDIT_STEP_TITLE);
            }
        } else if ("Chunk".equals(description)) {
            if (isAddButton) {
                this.setTitle(BConfMngtMessages.ListenerDialog_NEW_CHUNK_TITLE);
            } else {
                this.setTitle(BConfMngtMessages.ListenerDialog_EDIT_CHUNK_TITLE);
            }
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite inner = new Composite(parent, 0);
        inner.setLayout((Layout)new GridLayout(3, false));
        inner.setLayoutData((Object)new GridData(768));
        this.createNameField(inner);
        this.createClassField(inner);
        if (this.isAddButton) {
            this.createTypeField(inner);
        }
        this.createNote(inner);
        this.validation.handleEvent(null);
        return inner;
    }

    private void createNameField(Composite control) {
        GridData horizontalSpanTwo = new GridData(768);
        horizontalSpanTwo.horizontalSpan = 2;
        Label nameLabel = new Label(control, 0);
        nameLabel.setText(BConfMngtMessages.ListenerDialog_NAME_LABEL);
        this.nameText = new Text(control, 2048);
        this.nameText.setText(StringUtil.returnEmptyStringIfNull((String)this.listener.getName()));
        this.nameText.addListener(24, this.validation);
        this.nameText.setLayoutData((Object)horizontalSpanTwo);
        if (!this.isAddButton) {
            this.nameText.setEnabled(false);
        }
    }

    private void createClassField(Composite control) {
        GridData horizontalSpanTwo = new GridData(768);
        horizontalSpanTwo.horizontalSpan = 2;
        Label classLabel = new Label(control, 0);
        classLabel.setText(BConfMngtMessages.ListenerDialog_CLASS_LABEL);
        this.classText = new Text(control, 2048);
        this.classText.setText(StringUtil.returnEmptyStringIfNull((String)this.listener.getClassValue()));
        this.classText.addListener(24, this.validation);
        this.classText.setLayoutData((Object)new GridData(768));
        Button browseSelectButton = new Button(control, 8);
        browseSelectButton.setText(BConfMngtMessages.ListenerDialog_BROWSE_BUTTON);
        browseSelectButton.addListener(13, this.browseListener);
    }

    private void createTypeField(Composite control) {
        GridData horizontalSpanTwo = new GridData(768);
        horizontalSpanTwo.horizontalSpan = 2;
        Label typeLabel = new Label(control, 0);
        typeLabel.setText(BConfMngtMessages.ListenerDialog_LISTENER_TYPE_LABEL);
        String[] list = new String[]{"Job", "Step", "Chunk"};
        this.typeCombo = new Combo(control, 12);
        this.typeCombo.setItems(list);
        this.typeCombo.setEnabled(false);
        this.typeCombo.setText(this.description);
        this.typeCombo.setLayoutData((Object)horizontalSpanTwo);
    }

    private void createNote(Composite control) {
        GridData horizontalSpanTwo = new GridData(768);
        horizontalSpanTwo.horizontalSpan = 3;
        Composite noteControl = new Composite(control, 0);
        noteControl.setLayout((Layout)new GridLayout(2, false));
        noteControl.setLayoutData((Object)horizontalSpanTwo);
        Label noteLabel = new Label(noteControl, 0);
        noteLabel.setText(BConfMngtMessages.ListenerDialog_NOTE);
        StringUtil.setLabelStringBold((Label)noteLabel);
        Label contentLabel = new Label(noteControl, 0);
        if (this.isAddButton) {
            contentLabel.setText(BConfMngtMessages.ListenerDialog_ADD_NOTE_CONTENTS);
        } else {
            contentLabel.setText(BConfMngtMessages.ListenerDialog_EDIT_NOTE_CONTENTS);
        }
    }

    protected void okPressed() {
        this.listener.setName(this.nameText.getText());
        this.listener.setClassValue(this.classText.getText());
        if (this.isAddButton) {
            this.listener.setListenerType(this.typeCombo.getText());
        }
        super.okPressed();
    }

    protected boolean isClassNameOfBatchPreferenceAvailable(String className) {
        return !StringUtil.hasKorean((String)className) && !StringUtil.hasInvalidClassFileSignal((String)className) && !StringUtil.hasEmptySpace((String)className);
    }

    protected Point getInitialSize() {
        Point point = this.isAddButton ? new Point(380, 245) : new Point(380, 225);
        return point;
    }

    public ListenerInfo getListener() {
        return this.listener;
    }
}

