/*
 * Decompiled with CFR 0.152.
 */
package egovframework.bdev.imp.confmngt.preferences.parameter;

import egovframework.bdev.imp.confmngt.common.BConfMngtMessages;
import egovframework.bdev.imp.confmngt.preferences.parameter.model.JobParameterInfo;
import egovframework.dev.imp.core.utils.NullUtil;
import egovframework.dev.imp.core.utils.StringUtil;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class JobParameterDialog
extends StatusDialog {
    protected final boolean isAddButton;
    protected final List<String> existingIdList;
    private JobParameterInfo jobParameter = null;
    private Text parameterNameField;
    private Text valueField;
    private Combo dataTypeField;
    private Combo dateFormatField;
    Listener validation = new Listener(){

        public void handleEvent(Event event) {
            StatusInfo status = new StatusInfo();
            String parameterName = null;
            String value = null;
            parameterName = JobParameterDialog.this.parameterNameField.getText();
            if (JobParameterDialog.this.isAddButton) {
                if (parameterName.length() == 0) {
                    status.setError(BConfMngtMessages.JobDialog_EMPTY_PARAMETER_NAME);
                    JobParameterDialog.this.updateStatus((IStatus)status);
                    return;
                }
                if (!JobParameterDialog.this.isJobParameterNameAvailable(parameterName)) {
                    status.setError(BConfMngtMessages.JobDialog_INALID_PARAMETER_NAME);
                    JobParameterDialog.this.updateStatus((IStatus)status);
                    return;
                }
                if (JobParameterDialog.this.existingIdList.contains(parameterName)) {
                    status.setError(BConfMngtMessages.JobDialog_DUPLICATE_PARAMETER_NAME);
                    JobParameterDialog.this.updateStatus((IStatus)status);
                    return;
                }
            }
            if ("\uc120\ud0dd".equals(JobParameterDialog.this.dataTypeField.getText())) {
                status.setError(BConfMngtMessages.JobParameterDialog_EMPTY_DATA_TYPE);
                JobParameterDialog.this.updateStatus((IStatus)status);
                return;
            }
            if ("Date".equals(JobParameterDialog.this.dataTypeField.getText()) && NullUtil.isEmpty((String)JobParameterDialog.this.dateFormatField.getText())) {
                status.setError(BConfMngtMessages.JobDialog_EMPTY_FORMAT);
                JobParameterDialog.this.updateStatus((IStatus)status);
                return;
            }
            if (!NullUtil.isNull((Object)JobParameterDialog.this.valueField)) {
                value = JobParameterDialog.this.valueField.getText();
                if (value.length() < 1) {
                    status.setError(BConfMngtMessages.JobDialog_EMPTY_VALUE);
                    JobParameterDialog.this.updateStatus((IStatus)status);
                    return;
                }
                if (!JobParameterDialog.this.valueValidation(value)) {
                    status.setError(BConfMngtMessages.JobDialog_VALUE_IS_NOT_MATCH_WITH_FORMAT);
                    JobParameterDialog.this.updateStatus((IStatus)status);
                    return;
                }
            }
            status.setOK();
            JobParameterDialog.this.updateStatus((IStatus)status);
        }
    };
    Listener dataTypeListener = new Listener(){

        public void handleEvent(Event event) {
            if ("Date".equals(JobParameterDialog.this.dataTypeField.getText())) {
                JobParameterDialog.this.dateFormatField.setEnabled(true);
            } else {
                JobParameterDialog.this.dateFormatField.setEnabled(false);
                JobParameterDialog.this.dateFormatField.deselectAll();
            }
        }
    };

    public JobParameterDialog(Shell shell, boolean isAddButton, List<String> existingIdList, JobParameterInfo jobParameter) {
        super(shell);
        this.jobParameter = new JobParameterInfo();
        this.isAddButton = isAddButton;
        this.existingIdList = existingIdList;
        if (!NullUtil.isNull((Object)jobParameter)) {
            this.jobParameter.copyValues(jobParameter);
        }
        if (isAddButton) {
            this.setTitle(BConfMngtMessages.JobDialog_NEW_JOB_PARAMETER_TITLE);
        } else {
            this.setTitle(BConfMngtMessages.JobDialog_EDIT_JOB_PARAMETER_TITLE);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite inner = new Composite(parent, 0);
        inner.setLayout((Layout)new GridLayout(2, false));
        inner.setLayoutData((Object)new GridData(768));
        this.createNameField(inner);
        this.createValueField(inner);
        this.createDataTypeField(inner);
        this.createFormatField(inner);
        this.createNote(inner);
        return inner;
    }

    private void createNameField(Composite control) {
        Label parameterNameLabel = new Label(control, 0);
        parameterNameLabel.setText(BConfMngtMessages.JobDialog_PARAMETER_NAME_LABEL);
        this.parameterNameField = new Text(control, 2048);
        this.parameterNameField.setText(StringUtil.returnEmptyStringIfNull((String)this.jobParameter.getParameterName()));
        this.parameterNameField.addListener(24, this.validation);
        this.parameterNameField.setLayoutData((Object)new GridData(768));
        if (!this.isAddButton) {
            this.parameterNameField.setEnabled(false);
        } else {
            this.parameterNameField.forceFocus();
        }
    }

    private void createValueField(Composite control) {
        Label valueLabel = new Label(control, 0);
        valueLabel.setText(BConfMngtMessages.JobDialog_VALUE_LABEL);
        this.valueField = new Text(control, 2048);
        this.valueField.setText(StringUtil.returnEmptyStringIfNull((String)this.jobParameter.getValue()));
        this.valueField.addListener(24, this.validation);
        this.valueField.setLayoutData((Object)new GridData(768));
    }

    private void createDataTypeField(Composite control) {
        String[] list = new String[]{"\uc120\ud0dd", "String", "Long", "Date", "Double"};
        Label dataTypeLabel = new Label(control, 0);
        dataTypeLabel.setText(BConfMngtMessages.JobDialog_DATA_TYPE_LABEL);
        this.dataTypeField = new Combo(control, 12);
        this.dataTypeField.setItems(list);
        this.dataTypeField.addListener(13, this.dataTypeListener);
        this.dataTypeField.addListener(13, this.validation);
        this.dataTypeField.setLayoutData((Object)new GridData(768));
        String dataType = this.jobParameter.getDataType();
        if (NullUtil.isEmpty((String)dataType)) {
            dataType = "\uc120\ud0dd";
        }
        this.dataTypeField.setText(dataType);
    }

    private void createFormatField(Composite control) {
        Label dateforLabel = new Label(control, 0);
        dateforLabel.setText(BConfMngtMessages.JobDialog_FORMAT_LABEL);
        this.dateFormatField = new Combo(control, 4);
        this.dateFormatField.setItems(this.getFormatList().keySet().toArray(new String[0]));
        this.dateFormatField.addListener(24, this.validation);
        this.dateFormatField.setLayoutData((Object)new GridData(768));
        if (NullUtil.isEmpty((String)this.jobParameter.getDateFormat())) {
            this.dateFormatField.setText("");
            this.dateFormatField.setEnabled(false);
        } else {
            this.dateFormatField.setText(this.jobParameter.getDateFormat());
            this.dateFormatField.setEnabled(true);
        }
    }

    private void createNote(Composite control) {
        GridData horizontalSpanTwo = new GridData(768);
        horizontalSpanTwo.horizontalSpan = 2;
        Composite noteControl = new Composite(control, 0);
        noteControl.setLayout((Layout)new GridLayout(2, false));
        noteControl.setLayoutData((Object)horizontalSpanTwo);
        Label noteLabel = new Label(noteControl, 0);
        noteLabel.setText(BConfMngtMessages.JobDialog_NOTE);
        StringUtil.setLabelStringBold((Label)noteLabel);
        Label contentLabel = new Label(noteControl, 0);
        if (this.isAddButton) {
            contentLabel.setText(BConfMngtMessages.JobDialog_ADD_NOTE_CONTENTS);
        } else {
            contentLabel.setText(BConfMngtMessages.JobDialog_EDIT_NOTE_CONTENTS);
        }
    }

    private boolean isJobParameterNameAvailable(String name) {
        if ("timestamp".equals(name)) {
            return false;
        }
        String dataType = this.dataTypeField.getText();
        if ("Date".equals(dataType)) {
            return this.isParameterNameAvailableWhenDateType(name);
        }
        return StringUtil.isBatchJobBeanIDAvailable((String)name);
    }

    private boolean isParameterNameAvailableWhenDateType(String name) {
        char validChar = '_';
        String pattern = String.valueOf(StringUtil.ENG_PATTERN) + StringUtil.NUM_PATTERN + validChar;
        return StringUtil.doesStringMatchWithPatten((String)pattern, (String)name) && !StringUtil.isStringStartWithNumber((String)name);
    }

    protected void okPressed() {
        this.jobParameter.setParameterName(this.parameterNameField.getText());
        this.jobParameter.setValue(this.valueField.getText());
        this.jobParameter.setDataType(this.dataTypeField.getText());
        this.jobParameter.setDateFormat(this.dateFormatField.getText());
        super.okPressed();
    }

    private boolean valueValidation(String value) {
        String dataTypeString = this.dataTypeField.getText();
        if ("String".equals(dataTypeString)) {
            if (value.indexOf("\\") <= -1 && value.indexOf("\"") <= -1 && !StringUtil.hasKorean((String)value) && !StringUtil.hasEmptySpace((String)value)) {
                return true;
            }
        } else if ("Long".equals(dataTypeString)) {
            try {
                Long.parseLong(value);
                return true;
            }
            catch (Exception exception) {}
        } else {
            if ("Date".equals(dataTypeString)) {
                return this.validateDateFormat(value);
            }
            if ("Double".equals(dataTypeString)) {
                try {
                    Double.parseDouble(value);
                    return true;
                }
                catch (Exception exception) {}
            }
        }
        return false;
    }

    private HashMap<String, String> getFormatList() {
        HashMap<String, String> formatList = new HashMap<String, String>();
        formatList.put("yyyy-MM-dd", "-");
        formatList.put("yyyy/MM/dd", "/");
        formatList.put("yyyy.MM.dd", "[.]");
        formatList.put("yy-MM-dd", "-");
        formatList.put("MM-dd", "-");
        formatList.put("dd", "NO_REGEX");
        return formatList;
    }

    private boolean validateDateFormat(String value) {
        boolean result = true;
        String format = this.dateFormatField.getText();
        String regex = this.getFormatList().get(format);
        String[] splitedDate = null;
        String[] splitedDateFormat = null;
        if (!NullUtil.isEmpty((String)regex) && !"NO_REGEX".equals(regex)) {
            splitedDate = value.split(regex);
            splitedDateFormat = format.split(regex);
            int i = 0;
            while (i < splitedDate.length) {
                Integer.parseInt(splitedDate[i]);
                if (splitedDate[i].length() != splitedDateFormat[i].length()) {
                    result = false;
                    break;
                }
                ++i;
            }
            if (splitedDateFormat.length != splitedDate.length) {
                result = false;
            }
        } else if ("NO_REGEX".equals(regex)) {
            Integer.parseInt(value);
            if (value.length() != format.length()) {
                result = false;
            }
        }
        return result;
    }

    public JobParameterInfo getJobParameter() {
        return this.jobParameter;
    }

    protected Point getInitialSize() {
        return new Point(380, 265);
    }
}

