/*
 * Decompiled with CFR 0.152.
 */
package egovframework.bdev.imp.confmngt.preferences.readwrite;

import egovframework.bdev.imp.confmngt.common.BConfMngtMessages;
import egovframework.bdev.imp.confmngt.preferences.readwrite.model.DefaultJobRWMap;
import egovframework.bdev.imp.confmngt.preferences.readwrite.model.JobRWInfo;
import egovframework.dev.imp.core.utils.NullUtil;
import egovframework.dev.imp.core.utils.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.core.BinaryType;
import org.eclipse.jdt.internal.core.SourceType;
import org.eclipse.jdt.internal.ui.dialogs.FilteredTypesSelectionDialog;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class JobRWDialog
extends StatusDialog {
    private final String DEFAULT = "\uc120\ud0dd";
    private final String FILE = "File";
    private final String DB = "DB";
    private DefaultJobRWMap defaultJobType = null;
    private final boolean isAddButton;
    final List<String> existingIdList;
    private JobRWInfo jobRWInfo = null;
    private Text nameText = null;
    private Combo itemTypeCombo = null;
    private Combo resourceTypeCombo = null;
    private Text classText = null;
    private Button browseSelectButton = null;
    private String description;
    Listener browseListener = new Listener(){

        public void handleEvent(Event event) {
            FilteredTypesSelectionDialog dialog = new FilteredTypesSelectionDialog(JobRWDialog.this.getShell(), false, (IRunnableContext)PlatformUI.getWorkbench().getProgressService(), SearchEngine.createWorkspaceScope(), 5);
            dialog.setTitle(BConfMngtMessages.JobRWDialog_BROWSE_BUTTON_DIALOG_TITLE);
            dialog.setMessage(BConfMngtMessages.JobRWDialog_BROWSE_BUTTON_DIALOG_DESCRIPTION);
            dialog.setInitialPattern("");
            if (dialog.open() == 0) {
                Object type = dialog.getFirstResult();
                if (!NullUtil.isNull((Object)type)) {
                    if (type instanceof BinaryType) {
                        JobRWDialog.this.classText.setText(((BinaryType)type).getFullyQualifiedName());
                    } else if (type instanceof SourceType) {
                        JobRWDialog.this.classText.setText(((SourceType)type).getFullyQualifiedName());
                    }
                }
                return;
            }
        }
    };
    Listener ResourceTypeComboListener = new Listener(){

        public void handleEvent(Event event) {
            String type = JobRWDialog.this.resourceTypeCombo.getText();
            ArrayList<String> itemTypeList = new ArrayList<String>();
            itemTypeList.add("\uc120\ud0dd");
            if ("\uc120\ud0dd".equals(type)) {
                JobRWDialog.this.classText.setText("");
                JobRWDialog.this.classText.setEnabled(false);
                JobRWDialog.this.browseSelectButton.setEnabled(false);
            } else if ("File".equals(type)) {
                itemTypeList.addAll(JobRWDialog.this.defaultJobType.getFileTypeList());
            } else if ("DB".equals(type)) {
                itemTypeList.addAll(JobRWDialog.this.defaultJobType.getDBTypeList());
            }
            JobRWDialog.this.itemTypeCombo.setItems(itemTypeList.toArray(new String[0]));
            JobRWDialog.this.itemTypeCombo.setText("\uc120\ud0dd");
        }
    };
    Listener ItemTypeComboListener = new Listener(){

        public void handleEvent(Event event) {
            String type = JobRWDialog.this.itemTypeCombo.getText();
            String classValue = JobRWDialog.this.defaultJobType.getClassValue(type);
            if ("\uc120\ud0dd".equals(type)) {
                JobRWDialog.this.classText.setText("");
                JobRWDialog.this.classText.setEnabled(false);
                JobRWDialog.this.browseSelectButton.setEnabled(false);
            } else if (JobRWDialog.this.isCustomizeType(classValue)) {
                JobRWDialog.this.classText.setText("");
                JobRWDialog.this.classText.setEnabled(true);
                JobRWDialog.this.browseSelectButton.setEnabled(true);
            } else {
                JobRWDialog.this.classText.setText(classValue);
                JobRWDialog.this.classText.setEnabled(false);
                JobRWDialog.this.browseSelectButton.setEnabled(false);
            }
        }
    };
    Listener validation = new Listener(){

        public void handleEvent(Event event) {
            String resourceType;
            StatusInfo status = new StatusInfo();
            status = new StatusInfo();
            if (JobRWDialog.this.isAddButton) {
                String id = JobRWDialog.this.nameText.getText();
                if (id.length() == 0) {
                    status.setError(BConfMngtMessages.JobRWDialog_EMPTY_NAME);
                    JobRWDialog.this.updateStatus((IStatus)status);
                    return;
                }
                if (!StringUtil.isBatchJobBeanIDAvailable((String)id)) {
                    status.setError(BConfMngtMessages.JobRWDialog_INVALID_NAME);
                    JobRWDialog.this.updateStatus((IStatus)status);
                    return;
                }
                if (JobRWDialog.this.existingIdList.contains(id)) {
                    status.setError(BConfMngtMessages.JobRWDialog_DUPLICATE_NAME);
                    JobRWDialog.this.updateStatus((IStatus)status);
                    return;
                }
            }
            if ("\uc120\ud0dd".equals(resourceType = JobRWDialog.this.resourceTypeCombo.getText())) {
                status.setError(BConfMngtMessages.JobRWDialog_EMPTY_RESOURCE_TYPE);
                JobRWDialog.this.updateStatus((IStatus)status);
                return;
            }
            String itemType = JobRWDialog.this.itemTypeCombo.getText();
            if ("\uc120\ud0dd".equals(itemType)) {
                status.setError(String.valueOf(JobRWDialog.this.description) + BConfMngtMessages.JobRWDialog_EMPTY_TYPE);
                JobRWDialog.this.updateStatus((IStatus)status);
                return;
            }
            if (JobRWDialog.this.classText != null) {
                String classValueString = JobRWDialog.this.classText.getText();
                if (classValueString.length() < 1) {
                    status.setError(BConfMngtMessages.JobRWDialog_EMPTY_CLASS);
                    JobRWDialog.this.updateStatus((IStatus)status);
                    return;
                }
                if (!JobRWDialog.this.isClassNameOfBatchPreferenceAvailable(classValueString)) {
                    status.setError(BConfMngtMessages.JobRWDialog_INVALID_CLASS_VALUE);
                    JobRWDialog.this.updateStatus((IStatus)status);
                    return;
                }
            }
            status.setOK();
            JobRWDialog.this.updateStatus((IStatus)status);
        }
    };

    protected void setDescription(String description) {
        this.description = description;
    }

    public JobRWDialog(Shell parent, boolean isAddButton, JobRWInfo jobRWInfo, List<String> existingIdList) {
        super(parent);
        this.jobRWInfo = jobRWInfo;
        this.isAddButton = isAddButton;
        this.existingIdList = existingIdList;
        this.defaultJobType = this.getDefaultJobType();
    }

    protected Control createDialogArea(Composite parent) {
        Composite inner = new Composite(parent, 0);
        inner.setLayout((Layout)new GridLayout(3, false));
        inner.setLayoutData((Object)new GridData(768));
        this.createNameField(inner);
        this.createResourceTypeField(inner);
        this.createItemTypeField(inner);
        this.createClassField(inner);
        this.createNote(inner);
        this.setValues();
        return inner;
    }

    protected DefaultJobRWMap getDefaultJobType() {
        return null;
    }

    private void setValues() {
        this.nameText.setText(StringUtil.returnEmptyStringIfNull((String)this.jobRWInfo.getName()));
        String resourceType = this.jobRWInfo.getResourceType();
        if (NullUtil.isEmpty((String)resourceType)) {
            this.resourceTypeCombo.setText("\uc120\ud0dd");
        } else {
            this.resourceTypeCombo.setText(resourceType);
        }
        this.resourceTypeCombo.notifyListeners(13, null);
        String itemType = this.jobRWInfo.getItemType();
        if (!NullUtil.isEmpty((String)itemType)) {
            this.itemTypeCombo.setText(itemType);
        }
        this.itemTypeCombo.notifyListeners(13, null);
        this.classText.setText(StringUtil.returnEmptyStringIfNull((String)this.jobRWInfo.getClassValue()));
    }

    private void createNameField(Composite control) {
        GridData horizontalSpanTwo = new GridData(768);
        horizontalSpanTwo.horizontalSpan = 2;
        Label nameLabel = new Label(control, 0);
        nameLabel.setText(BConfMngtMessages.JobRWDialog_NAME_LABEL);
        this.nameText = new Text(control, 2048);
        this.nameText.setLayoutData((Object)horizontalSpanTwo);
        if (!this.isAddButton) {
            this.nameText.setEnabled(false);
        }
        this.nameText.addListener(24, this.validation);
    }

    private void createResourceTypeField(Composite control) {
        GridData horizontalSpanTwo = new GridData(768);
        horizontalSpanTwo.horizontalSpan = 2;
        Label resourceTypeLabel = new Label(control, 0);
        resourceTypeLabel.setText(BConfMngtMessages.JobRWDialog_RESOURCE_TYPE_LABEL);
        String[] resourceItems = new String[]{"\uc120\ud0dd", "File", "DB"};
        this.resourceTypeCombo = new Combo(control, 12);
        this.resourceTypeCombo.setItems(resourceItems);
        this.resourceTypeCombo.setLayoutData((Object)horizontalSpanTwo);
        this.resourceTypeCombo.addListener(13, this.validation);
        this.resourceTypeCombo.addListener(13, this.ResourceTypeComboListener);
    }

    private void createItemTypeField(Composite control) {
        GridData horizontalSpanTwo = new GridData(768);
        horizontalSpanTwo.horizontalSpan = 2;
        Label itemTypeLabel = new Label(control, 0);
        itemTypeLabel.setText(String.valueOf(this.description) + BConfMngtMessages.JobRWDialog_ITEM_TYPE_LABEL);
        this.itemTypeCombo = new Combo(control, 12);
        this.itemTypeCombo.setLayoutData((Object)horizontalSpanTwo);
        this.itemTypeCombo.addListener(13, this.ItemTypeComboListener);
        this.itemTypeCombo.addListener(13, this.validation);
    }

    private void createClassField(Composite control) {
        Label classLabel = new Label(control, 0);
        classLabel.setText(BConfMngtMessages.JobRWDialog_CLASS_LABEL);
        this.classText = new Text(control, 2048);
        this.classText.setLayoutData((Object)new GridData(768));
        this.classText.setEnabled(false);
        this.browseSelectButton = new Button(control, 8);
        this.browseSelectButton.setText(BConfMngtMessages.JobRWDialog_BROWSE_BUTTON);
        this.browseSelectButton.addListener(13, this.browseListener);
        this.browseSelectButton.setEnabled(false);
        this.classText.addListener(24, this.validation);
    }

    protected Composite createNote(Composite control) {
        GridData horizontalSpanTwo = new GridData(768);
        horizontalSpanTwo.horizontalSpan = 3;
        Composite noteControl = new Composite(control, 0);
        noteControl.setLayout((Layout)new GridLayout(2, false));
        noteControl.setLayoutData((Object)horizontalSpanTwo);
        Label noteLabel = new Label(noteControl, 0);
        noteLabel.setText(BConfMngtMessages.JobRWDialog_NOTE_LABEL);
        StringUtil.setLabelStringBold((Label)noteLabel);
        return noteControl;
    }

    private boolean isCustomizeType(String name) {
        return NullUtil.isEmpty((String)name);
    }

    protected void okPressed() {
        this.jobRWInfo.setName(this.nameText.getText());
        this.jobRWInfo.setResourceType(this.resourceTypeCombo.getText());
        this.jobRWInfo.setItemType(this.itemTypeCombo.getText());
        this.jobRWInfo.setClassValue(this.classText.getText());
        this.jobRWInfo.setResourceDetailType(this.defaultJobType.getDetailType(this.itemTypeCombo.getText()));
        super.okPressed();
    }

    protected boolean isClassNameOfBatchPreferenceAvailable(String className) {
        return !StringUtil.hasKorean((String)className) && !StringUtil.hasInvalidClassFileSignal((String)className) && !StringUtil.hasEmptySpace((String)className);
    }

    public JobRWInfo getJobRWInfo() {
        return this.jobRWInfo;
    }

    protected Point getInitialSize() {
        return new Point(380, 250);
    }
}

