/*
 * Decompiled with CFR 0.152.
 */
package egovframework.bdev.imp.confmngt.preferences.readwrite;

import egovframework.bdev.imp.confmngt.common.BConfMngtMessages;
import egovframework.bdev.imp.confmngt.preferences.com.BatchPreferencePage;
import egovframework.bdev.imp.confmngt.preferences.readwrite.JobRWTabContents;
import egovframework.bdev.imp.confmngt.preferences.readwrite.model.DefaultJobRWMap;
import egovframework.bdev.imp.confmngt.preferences.readwrite.model.JobRWInfo;
import egovframework.bdev.imp.confmngt.preferences.readwrite.model.JobReaderInfo;
import egovframework.bdev.imp.confmngt.preferences.readwrite.model.JobWriterInfo;
import egovframework.dev.imp.core.utils.BatchTableColumn;
import egovframework.dev.imp.core.utils.NullUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TabFolder;

public class JobRWPreferencePage
extends BatchPreferencePage {
    public static final String JOB_READER_PREFERENCE_STORE_NAME = "Reader";
    public static final String JOB_WRITER_PREFERENCE_STORE_NAME = "Writer";
    private JobRWTabContents reader;
    private JobRWTabContents writer;

    public JobRWPreferencePage() {
        this.setDescription(BConfMngtMessages.JobRWPreferencePage_DESCRIPTION);
    }

    @Override
    public void createInnerPart(Composite parent) {
        GridData gData = new GridData(768);
        gData.heightHint = 500;
        final TabFolder folder = new TabFolder(parent, 0);
        folder.setLayoutData((Object)gData);
        BatchTableColumn[] readerColumns = this.createReaderColumns();
        BatchTableColumn[] writerColumns = this.createWriterColumns();
        this.reader = new JobRWTabContents(JOB_READER_PREFERENCE_STORE_NAME, new JobReaderInfo(), JOB_READER_PREFERENCE_STORE_NAME, false);
        this.reader.setTableColumnProperty(readerColumns);
        this.reader.createTabContents(folder);
        this.writer = new JobRWTabContents(JOB_WRITER_PREFERENCE_STORE_NAME, new JobWriterInfo(), JOB_WRITER_PREFERENCE_STORE_NAME, false);
        this.writer.setTableColumnProperty(writerColumns);
        this.writer.createTabContents(folder);
        this.createControlButtons(parent);
        Set<String> defaultJobReaderNameList = this.getDefaultJobReaderNameList();
        this.addJobRWTableListener(this.reader.getTableViewer(), defaultJobReaderNameList);
        Set<String> defaultJobWriterNameList = this.getDefaultJobWriterNameList();
        this.addJobRWTableListener(this.writer.getTableViewer(), defaultJobWriterNameList);
        folder.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                switch (folder.getSelectionIndex()) {
                    case 0: {
                        JobRWPreferencePage.this.setButtonListener(JobRWPreferencePage.this.reader);
                        break;
                    }
                    case 1: {
                        JobRWPreferencePage.this.setButtonListener(JobRWPreferencePage.this.writer);
                    }
                }
            }
        });
        folder.notifyListeners(13, new Event());
    }

    private BatchTableColumn[] createReaderColumns() {
        ArrayList<BatchTableColumn> columns = new ArrayList<BatchTableColumn>();
        columns.add(new BatchTableColumn(BConfMngtMessages.JobRWPreferencePage_READER_TABLE_COLUMN_NAME, 100));
        columns.add(new BatchTableColumn(BConfMngtMessages.JobRWPreferencePage_READER_TABLE_COLUMN_RESOURCE_TYPE, 90));
        columns.add(new BatchTableColumn(BConfMngtMessages.JobRWPreferencePage_READER_TABLE_COLUMN_READ_TYPE, 130));
        columns.add(new BatchTableColumn(BConfMngtMessages.JobRWPreferencePage_READER_TABLE_COLUMN_CLASS, 130));
        return columns.toArray(new BatchTableColumn[0]);
    }

    private BatchTableColumn[] createWriterColumns() {
        ArrayList<BatchTableColumn> columns = new ArrayList<BatchTableColumn>();
        columns.add(new BatchTableColumn(BConfMngtMessages.JobRWPreferencePage_WRITER_TABLE_COLUMN_NAME, 100));
        columns.add(new BatchTableColumn(BConfMngtMessages.JobRWPreferencePage_WRITER_TABLE_COLUMN_RESOURCE_TYPE, 90));
        columns.add(new BatchTableColumn(BConfMngtMessages.JobRWPreferencePage_WRITER_TABLE_COLUMN_WRITER_TYPE, 130));
        columns.add(new BatchTableColumn(BConfMngtMessages.JobRWPreferencePage_WRITER_TABLE_COLUMN_CLASS, 130));
        return columns.toArray(new BatchTableColumn[0]);
    }

    private void addJobRWTableListener(final TableViewer tableViewer, final Set<String> defaultJobRWName) {
        tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                IStructuredSelection selection = (IStructuredSelection)tableViewer.getSelection();
                if (!NullUtil.isNull((Object)selection) && selection.size() > 0) {
                    JobRWInfo jobRWInfo = (JobRWInfo)selection.getFirstElement();
                    String jobRWName = jobRWInfo.getName();
                    if (JobRWPreferencePage.this.isDefaultJobRWName(jobRWName, defaultJobRWName)) {
                        JobRWPreferencePage.this.editButton.setEnabled(false);
                        JobRWPreferencePage.this.removeButton.setEnabled(false);
                    } else {
                        JobRWPreferencePage.this.editButton.setEnabled(true);
                        JobRWPreferencePage.this.removeButton.setEnabled(true);
                    }
                } else {
                    JobRWPreferencePage.this.editButton.setEnabled(false);
                    JobRWPreferencePage.this.removeButton.setEnabled(false);
                }
            }
        });
    }

    private boolean isDefaultJobRWName(String jobRWName, Set<String> defaultJobRWName) {
        if (NullUtil.isEmpty((String)jobRWName) || NullUtil.isNull(defaultJobRWName)) {
            return false;
        }
        return defaultJobRWName.contains(jobRWName);
    }

    private Set<String> getDefaultJobReaderNameList() {
        HashSet<String> disableEditButtonJobRWList = new HashSet<String>();
        DefaultJobRWMap defaultjobRW = new DefaultJobRWMap();
        defaultjobRW.resetDefaultReadType();
        disableEditButtonJobRWList.addAll(defaultjobRW.getFileTypeList());
        disableEditButtonJobRWList.addAll(defaultjobRW.getDBTypeList());
        disableEditButtonJobRWList.remove("CustomizeDBReader");
        disableEditButtonJobRWList.remove("CustomizeFileReader");
        return disableEditButtonJobRWList;
    }

    private Set<String> getDefaultJobWriterNameList() {
        HashSet<String> disableEditButtonJobRWList = new HashSet<String>();
        DefaultJobRWMap defaultjobRW = new DefaultJobRWMap();
        defaultjobRW.resetDefaultWriterType();
        disableEditButtonJobRWList.addAll(defaultjobRW.getFileTypeList());
        disableEditButtonJobRWList.addAll(defaultjobRW.getDBTypeList());
        disableEditButtonJobRWList.remove("CustomizeDBWriter");
        disableEditButtonJobRWList.remove("CustomizeFileWriter");
        return disableEditButtonJobRWList;
    }

    @Override
    public boolean performOk() {
        this.reader.saveData();
        this.writer.saveData();
        return super.performOk();
    }
}

