/*
 * Decompiled with CFR 0.152.
 */
package egovframework.bdev.imp.confmngt.preferences.readwrite.model;

import egovframework.dev.imp.core.utils.StringUtil;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Set;

public class DefaultJobRWMap {
    private HashMap<String, String> fileType = new HashMap();
    private HashMap<String, String> dbType = new HashMap();
    private HashMap<String, String> detailType = new HashMap();

    public Set<String> getFileTypeList() {
        return this.fileType.keySet();
    }

    public Set<String> getDBTypeList() {
        return this.dbType.keySet();
    }

    public String getClassValue(String itemType) {
        String classValue = null;
        if (this.fileType.containsKey(itemType)) {
            classValue = this.fileType.get(itemType);
        } else if (this.dbType.containsKey(itemType)) {
            classValue = this.dbType.get(itemType);
        }
        return StringUtil.returnEmptyStringIfNull((String)classValue);
    }

    public String getDetailType(String itemType) {
        String classValue = this.detailType.get(itemType);
        return StringUtil.returnEmptyStringIfNull((String)classValue);
    }

    public void resetDefaultReadType() {
        this.fileType = this.getReadTypeFileMap();
        this.dbType = this.getReadTypeDBMap();
        this.detailType = this.getReadDetailType();
    }

    public void resetDefaultWriterType() {
        this.fileType = this.getWriteTypeFileMap();
        this.dbType = this.getWriteTypeDBMap();
        this.detailType = this.getWriteDetailType();
    }

    public boolean isFileType(String itemType) {
        return this.fileType.containsKey(itemType);
    }

    private LinkedHashMap<String, String> getReadTypeFileMap() {
        LinkedHashMap<String, String> readTypeFileMap = new LinkedHashMap<String, String>();
        readTypeFileMap.put("FixedFlatFileItemReader", "org.springframework.batch.item.file.FlatFileItemReader");
        readTypeFileMap.put("DelimitedFlatFileItemReader", "org.springframework.batch.item.file.FlatFileItemReader");
        readTypeFileMap.put("EgovFixedFlatFileItemReader", "org.springframework.batch.item.file.FlatFileItemReader");
        readTypeFileMap.put("EgovDelimitedFlatFileItemReader", "org.springframework.batch.item.file.FlatFileItemReader");
        readTypeFileMap.put("FixedMultiResourceItemReader", "org.springframework.batch.item.file.MultiResourceItemReader");
        readTypeFileMap.put("DelimitedMultiResourceItemReader", "org.springframework.batch.item.file.MultiResourceItemReader");
        readTypeFileMap.put("EgovFixedMultiResourceItemReader", "org.springframework.batch.item.file.MultiResourceItemReader");
        readTypeFileMap.put("EgovDelimitedMultiResourceItemReader", "org.springframework.batch.item.file.MultiResourceItemReader");
        readTypeFileMap.put("CustomizeFileReader", "");
        return readTypeFileMap;
    }

    private LinkedHashMap<String, String> getReadTypeDBMap() {
        LinkedHashMap<String, String> readTypeDBMap = new LinkedHashMap<String, String>();
        readTypeDBMap.put("IbatisPagingItemReader", "org.springframework.batch.item.database.IbatisPagingItemReader");
        readTypeDBMap.put("CustomizedJdbcCursorItemReader", "org.springframework.batch.item.database.JdbcCursorItemReader");
        readTypeDBMap.put("SqlPagingQueryJdbcItemReader", "org.springframework.batch.item.database.JdbcPagingItemReader");
        readTypeDBMap.put("CustomizeDBReader", "");
        return readTypeDBMap;
    }

    private HashMap<String, String> getReadDetailType() {
        HashMap<String, String> readDetailType = new HashMap<String, String>();
        readDetailType.put("FixedFlatFileItemReader", "FixedReader");
        readDetailType.put("DelimitedFlatFileItemReader", "DelimitedReader");
        readDetailType.put("EgovFixedFlatFileItemReader", "FixedReader");
        readDetailType.put("EgovDelimitedFlatFileItemReader", "DelimitedReader");
        readDetailType.put("FixedMultiResourceItemReader", "FixedReader");
        readDetailType.put("DelimitedMultiResourceItemReader", "DelimitedReader");
        readDetailType.put("EgovFixedMultiResourceItemReader", "FixedReader");
        readDetailType.put("EgovDelimitedMultiResourceItemReader", "DelimitedReader");
        readDetailType.put("CustomizeFileReader", "CustomizeFile");
        readDetailType.put("IbatisPagingItemReader", "IbatisRW");
        readDetailType.put("CustomizedJdbcCursorItemReader", "CustomizedJdbcCursorItemReader");
        readDetailType.put("SqlPagingQueryJdbcItemReader", "SqlPagingQueryJdbcItemReader");
        readDetailType.put("CustomizeDBReader", "CustomizeDB");
        return readDetailType;
    }

    private LinkedHashMap<String, String> getWriteTypeFileMap() {
        LinkedHashMap<String, String> writeTypeFileMap = new LinkedHashMap<String, String>();
        writeTypeFileMap.put("DelimitedFlatFileItemWriter", "org.springframework.batch.item.file.FlatFileItemWriter");
        writeTypeFileMap.put("FormatterFlatFileItemWriter", "org.springframework.batch.item.file.FlatFileItemWriter");
        writeTypeFileMap.put("EgovDelimitedFlatFileItemWriter", "org.springframework.batch.item.file.FlatFileItemWriter");
        writeTypeFileMap.put("EgovFixedFlatFileItemWriter", "org.springframework.batch.item.file.FlatFileItemWriter");
        writeTypeFileMap.put("DelimitedMultiResourceItemWriter", "org.springframework.batch.item.file.MultiResourceItemWriter");
        writeTypeFileMap.put("FormatterMultiResourceItemWriter", "org.springframework.batch.item.file.MultiResourceItemWriter");
        writeTypeFileMap.put("EgovDelimitedMultiResourceItemWriter", "org.springframework.batch.item.file.MultiResourceItemWriter");
        writeTypeFileMap.put("EgovFixedMultiResourceItemWriter", "org.springframework.batch.item.file.MultiResourceItemWriter");
        writeTypeFileMap.put("CustomizeFileWriter", "");
        return writeTypeFileMap;
    }

    private LinkedHashMap<String, String> getWriteTypeDBMap() {
        LinkedHashMap<String, String> writeTypeDBMap = new LinkedHashMap<String, String>();
        writeTypeDBMap.put("IbatisBatchItemWriter", "org.springframework.batch.item.database.IbatisBatchItemWriter");
        writeTypeDBMap.put("SqlParameterJdbcBatchItemWriter", "org.springframework.batch.item.database.JdbcBatchItemWriter");
        writeTypeDBMap.put("ItemPreparedStatementJdbcBatchItemWriter", "org.springframework.batch.item.database.JdbcBatchItemWriter");
        writeTypeDBMap.put("EgovItemPreparedStatementJdbcBatchItemWriter", "egovframework.brte.core.item.database.EgovJdbcBatchItemWriter");
        writeTypeDBMap.put("EgovCustomizedJdbcBatchItemWriter", "egovframework.brte.core.item.database.EgovJdbcBatchItemWriter");
        writeTypeDBMap.put("CustomizeDBWriter", "");
        return writeTypeDBMap;
    }

    private HashMap<String, String> getWriteDetailType() {
        HashMap<String, String> writeDetailType = new HashMap<String, String>();
        writeDetailType.put("DelimitedFlatFileItemWriter", "DelimitedWriter");
        writeDetailType.put("FormatterFlatFileItemWriter", "FormatterFlatFileItemWriter");
        writeDetailType.put("EgovDelimitedFlatFileItemWriter", "DelimitedWriter");
        writeDetailType.put("EgovFixedFlatFileItemWriter", "EgoFixedFlatFileItemWriter");
        writeDetailType.put("DelimitedMultiResourceItemWriter", "DelimitedMultiWriter");
        writeDetailType.put("FormatterMultiResourceItemWriter", "FormatterMultiResourceItemWriter");
        writeDetailType.put("EgovDelimitedMultiResourceItemWriter", "DelimitedMultiWriter");
        writeDetailType.put("EgovFixedMultiResourceItemWriter", "EgovFixedMultiResourceItemWriter");
        writeDetailType.put("CustomizeFileWriter", "CustomizeFile");
        writeDetailType.put("IbatisBatchItemWriter", "IbatisRW");
        writeDetailType.put("SqlParameterJdbcBatchItemWriter", "SqlParameterJdbcBatchItemWriter");
        writeDetailType.put("ItemPreparedStatementJdbcBatchItemWriter", "ItemPreparedStatementJdbcBatchItemWriter");
        writeDetailType.put("EgovItemPreparedStatementJdbcBatchItemWriter", "EgovItemPreparedStatementJdbcBatchItemWriter");
        writeDetailType.put("EgovCustomizedJdbcBatchItemWriter", "EgovCustomizedJdbcBatchItemWriter");
        writeDetailType.put("CustomizeDBWriter", "CustomizeDB");
        return writeDetailType;
    }
}

