/*
 * Decompiled with CFR 0.152.
 */
package egovframework.bdev.tst.util;

import egovframework.bdev.tst.common.BatchTestLog;
import egovframework.dev.imp.core.utils.XmlUtil;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FindBeanIdValueUtil {
    public static Map<String, IFile> findBeanIDList(Map<String, IFile> foundXMLfiles, String findingNode, String findingBeanID, String findingBeanAttr) {
        Node rootNode = null;
        NodeList nodeList = null;
        LinkedHashMap<String, IFile> linkedMap = new LinkedHashMap<String, IFile>();
        LinkedHashMap<String, IFile> foundBeanIDFile = new LinkedHashMap<String, IFile>();
        int i = 0;
        while (i < foundXMLfiles.size()) {
            Set<String> xmlFileKey = foundXMLfiles.keySet();
            Object[] keyArray = xmlFileKey.toArray();
            String key = (String)keyArray[i];
            try {
                rootNode = XmlUtil.getRootNode((String)foundXMLfiles.get(key).getRawLocation().toOSString());
                if (XmlUtil.existNode((Node)rootNode, (String)findingNode) && (nodeList = XmlUtil.getNodeList((Node)rootNode, (String)findingNode)) != null) {
                    int inx = 0;
                    while (inx < nodeList.getLength()) {
                        Node targetBean = nodeList.item(inx);
                        if (targetBean.getAttributes().getNamedItem(findingBeanAttr) != null) {
                            String tempID = targetBean.getAttributes().getNamedItem(findingBeanAttr).getNodeValue();
                            linkedMap.put(tempID, foundXMLfiles.get(key));
                        }
                        ++inx;
                    }
                }
            }
            catch (Exception e) {
                BatchTestLog.logError(e);
            }
            ++i;
        }
        for (String beanID : linkedMap.keySet()) {
            if (findingBeanID != null && beanID.equals(findingBeanID)) {
                foundBeanIDFile.put(beanID, (IFile)linkedMap.get(beanID));
                return foundBeanIDFile;
            }
            if (findingBeanID != null) continue;
            foundBeanIDFile.put(beanID, (IFile)linkedMap.get(beanID));
            return foundBeanIDFile;
        }
        return null;
    }

    public static Map<String, IFile> findBeanIDList(IFile foundXMLfiles, String findingNode, String findingBeanID, String findingBeanAttr) {
        Node rootNode = null;
        NodeList nodeList = null;
        LinkedHashMap<String, IFile> linkedMap = new LinkedHashMap<String, IFile>();
        LinkedHashMap<String, IFile> foundBeanIDFile = new LinkedHashMap<String, IFile>();
        try {
            rootNode = XmlUtil.getRootNode((String)foundXMLfiles.getRawLocation().toOSString());
            if (XmlUtil.existNode((Node)rootNode, (String)findingNode) && (nodeList = XmlUtil.getNodeList((Node)rootNode, (String)findingNode)) != null) {
                int inx = 0;
                while (inx < nodeList.getLength()) {
                    Node targetBean = nodeList.item(inx);
                    if (targetBean.getAttributes().getNamedItem(findingBeanAttr) != null) {
                        String tempID = targetBean.getAttributes().getNamedItem(findingBeanAttr).getNodeValue();
                        linkedMap.put(tempID, foundXMLfiles);
                    }
                    ++inx;
                }
            }
        }
        catch (Exception e) {
            BatchTestLog.logError(e);
        }
        for (String beanID : linkedMap.keySet()) {
            if (findingBeanID != null && beanID.equals(findingBeanID)) {
                foundBeanIDFile.put(beanID, (IFile)linkedMap.get(beanID));
                return foundBeanIDFile;
            }
            if (findingBeanID != null) continue;
            foundBeanIDFile.put(beanID, (IFile)linkedMap.get(beanID));
            return foundBeanIDFile;
        }
        return null;
    }

    public static Map<String, IFile> findBeanIDList(IFile foundXMLfiles, String findingNode, String findingAttrValue, String findingBeanAttr, String getBeanIDOfThisAttr) {
        Iterator keyLinked;
        Node rootNode = null;
        NodeList nodeList = null;
        LinkedHashMap<String, IFile> linkedMap = new LinkedHashMap<String, IFile>();
        LinkedHashMap<String, IFile> foundBeanIDFile = new LinkedHashMap<String, IFile>();
        try {
            rootNode = XmlUtil.getRootNode((String)foundXMLfiles.getRawLocation().toOSString());
            if (XmlUtil.existNode((Node)rootNode, (String)findingNode) && (nodeList = XmlUtil.getNodeList((Node)rootNode, (String)findingNode)) != null) {
                int inx = 0;
                while (inx < nodeList.getLength()) {
                    Node targetBean = nodeList.item(inx);
                    if (targetBean.getAttributes().getNamedItem(findingBeanAttr) != null && targetBean.getAttributes().getNamedItem(findingBeanAttr).getNodeValue().contains(findingAttrValue)) {
                        String tempID = targetBean.getAttributes().getNamedItem(getBeanIDOfThisAttr).getNodeValue();
                        linkedMap.put(tempID, foundXMLfiles);
                    }
                    ++inx;
                }
            }
        }
        catch (Exception e) {
            BatchTestLog.logError(e);
        }
        if ((keyLinked = linkedMap.keySet().iterator()).hasNext()) {
            String beanID = (String)keyLinked.next();
            foundBeanIDFile.put(beanID, (IFile)linkedMap.get(beanID));
            return foundBeanIDFile;
        }
        return null;
    }
}

