/*
 * Decompiled with CFR 0.152.
 */
package egovframework.bdev.tst.util;

import egovframework.bdev.tst.common.BatchTestLog;
import egovframework.bdev.tst.util.FindBeanIdValueUtil;
import egovframework.bdev.tst.wizards.model.BatchJobTestContext;
import egovframework.dev.imp.core.utils.NullUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class GenerateJobTestFileUtil {
    public static Boolean GenerateJobTestFile(BatchJobTestContext context, LinkedHashMap<String, String> jobIDExistFileList) {
        String transactionManagerFoundPath;
        Boolean isFileCreateSucccess = false;
        String fileName = context.getFileName().split(".java")[0];
        Path path = new Path(String.valueOf(context.getFolderPath()) + "/" + context.getFileName());
        String jobFilePath = null;
        String jobExecFilePath = null;
        jobFilePath = GenerateJobTestFileUtil.getJobFilePath(jobIDExistFileList, context, jobFilePath);
        jobExecFilePath = GenerateJobTestFileUtil.getJobLauncherFilePath(context, jobExecFilePath);
        String jobRepositoryFilePath = null;
        String datasourceFilePath = null;
        String transactionManagerFilePath = null;
        String[] jobRepoAndDate = GenerateJobTestFileUtil.getJobRepositoryAndDatasourceFilePath(jobRepositoryFilePath, datasourceFilePath, context).split(">");
        if (jobRepoAndDate != null) {
            jobRepositoryFilePath = jobRepoAndDate[0];
            if (jobRepoAndDate.length == 2) {
                datasourceFilePath = jobRepoAndDate[1];
            }
            if (NullUtil.isNull((Object)jobRepositoryFilePath)) {
                jobRepositoryFilePath = "";
            }
            if (NullUtil.isNull((Object)datasourceFilePath)) {
                datasourceFilePath = "";
            }
        }
        transactionManagerFilePath = !NullUtil.isNull((Object)(transactionManagerFoundPath = GenerateJobTestFileUtil.getTransactionManagerFilePath(transactionManagerFilePath, context))) ? transactionManagerFoundPath : "";
        if (jobFilePath.equals(jobRepositoryFilePath)) {
            jobRepositoryFilePath = "";
        }
        if (jobFilePath.equals(datasourceFilePath)) {
            datasourceFilePath = "";
        }
        if (jobExecFilePath.equals(jobRepositoryFilePath)) {
            jobRepositoryFilePath = "";
        }
        if (jobExecFilePath.equals(datasourceFilePath)) {
            datasourceFilePath = "";
        }
        if (jobRepositoryFilePath.equals(datasourceFilePath)) {
            datasourceFilePath = "";
        }
        if (jobFilePath.equals(transactionManagerFilePath)) {
            transactionManagerFilePath = "";
        }
        if (jobExecFilePath.equals(transactionManagerFilePath)) {
            transactionManagerFilePath = "";
        }
        if (jobRepositoryFilePath.equals(transactionManagerFilePath)) {
            transactionManagerFilePath = "";
        }
        if (datasourceFilePath.equals(transactionManagerFilePath)) {
            transactionManagerFilePath = "";
        }
        String packageName = "";
        IFile newJunitTestFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
        packageName = newJunitTestFile.toString();
        packageName = packageName.substring(packageName.indexOf("java") + 4, packageName.lastIndexOf("/"));
        String egovBatchRunnerID = GenerateJobTestFileUtil.getEgovBatchRunnerID(context, jobExecFilePath);
        String partOne = "";
        if (packageName.length() > 0) {
            packageName = packageName.substring(1, packageName.length());
            packageName = packageName.replaceAll("/", ".");
            partOne = "package " + packageName + ";\n" + "import static org.junit.Assert.assertEquals;\n" + "import java.util.Date;\n";
        } else {
            partOne = "import static org.junit.Assert.assertEquals;\nimport java.util.Date;\n";
        }
        String simpleDateFormat = "";
        if (context.getJobParameterList() != null) {
            int i = 0;
            while (i < context.getJobParameterList().length) {
                if (context.getJobParameterList()[i].getDataType().equalsIgnoreCase("date")) {
                    simpleDateFormat = "import java.text.SimpleDateFormat;\n";
                }
                ++i;
            }
        }
        String partTwo = "import org.junit.Test;\nimport org.junit.runner.RunWith;\nimport org.springframework.batch.core.BatchStatus;\nimport org.springframework.batch.core.JobParametersBuilder;\nimport org.springframework.beans.factory.annotation.Autowired;\nimport org.springframework.beans.factory.annotation.Qualifier;\nimport org.springframework.test.context.ContextConfiguration;\nimport org.springframework.test.context.junit4.SpringJUnit4ClassRunner;\nimport egovframework.rte.bat.core.launch.support.EgovBatchRunner;\n@RunWith(SpringJUnit4ClassRunner.class)\n\n";
        String annotation = "/** \n * Test File Information \n * Job:: " + jobFilePath + "\n" + " * Job Launcher:: " + jobExecFilePath + "\n" + " * job Parameters:: " + GenerateJobTestFileUtil.jobParametersContent(context) + "\n" + " */ \n\n";
        String contextConfigAndFileName = "@ContextConfiguration(locations = { \"" + jobExecFilePath + "\", \"" + jobFilePath + "\"";
        if (jobRepositoryFilePath != "" && !jobRepositoryFilePath.equalsIgnoreCase("null") && jobRepositoryFilePath != null) {
            contextConfigAndFileName = String.valueOf(contextConfigAndFileName) + ", \"" + jobRepositoryFilePath + "\"";
        }
        if (datasourceFilePath != "" && !datasourceFilePath.equalsIgnoreCase("null") && datasourceFilePath != null) {
            contextConfigAndFileName = String.valueOf(contextConfigAndFileName) + ", \"" + datasourceFilePath + "\"";
        }
        if (transactionManagerFilePath != "" && !transactionManagerFilePath.equalsIgnoreCase("null") && transactionManagerFilePath != null) {
            contextConfigAndFileName = String.valueOf(contextConfigAndFileName) + ", \"" + transactionManagerFilePath + "\"";
        }
        contextConfigAndFileName = String.valueOf(contextConfigAndFileName) + " })\npublic class " + fileName + "{\n\n\t";
        String autowired = "@Autowired\n\t";
        String egovBatchRunnerQualifier = "";
        egovBatchRunnerQualifier = egovBatchRunnerID != "" || egovBatchRunnerID.length() > 0 ? "@Qualifier(\"" + egovBatchRunnerID + "\")\n\t" + "private EgovBatchRunner egovBatchRunner;\n\n\t" : "private EgovBatchRunner egovBatchRunner;\n\n\t";
        String dateFormat = "";
        if (context.getJobParameterList() != null) {
            int i = 0;
            while (i < context.getJobParameterList().length) {
                if (context.getJobParameterList()[i].getDataType().equalsIgnoreCase("date")) {
                    dateFormat = String.valueOf(dateFormat) + "private SimpleDateFormat " + context.getJobParameterList()[i].getParameterName() + "= new SimpleDateFormat(\"" + context.getJobParameterList()[i].getDateFormat() + "\");\n\n\t";
                }
                ++i;
            }
        }
        String partThree = "@Test\n\tpublic void testJobRun() throws Exception {\n\n\t\tString jobName = \"" + context.getJobVo().getJobName() + "\";\n\n\t\t" + "JobParametersBuilder jobParametersBuilder = new JobParametersBuilder();\n\t\t";
        String timeStamp = "";
        timeStamp = "jobParametersBuilder.addLong(\"timestamp\", new Date().getTime());\n\t\t";
        String partFour = String.valueOf(GenerateJobTestFileUtil.AddJobParametersBuilder(context)) + "\n\n\t\t" + "String jobParameters = egovBatchRunner.convertJobParametersToString(jobParametersBuilder.toJobParameters());\n\n\t\t" + "long executionId = egovBatchRunner.start(jobName, jobParameters);\n\n\t\t";
        String threadSleep = "";
        if (context.getIsAsync().booleanValue()) {
            threadSleep = "if(egovBatchRunner.getJobExecution(executionId).getExitStatus().toString().contains(\"UNKNOWN\")){\n\t\t\tThread.sleep(10000);\n\t\t}\n\n\t\t";
        }
        String partFive = "assertEquals(BatchStatus.COMPLETED, egovBatchRunner.getJobExecution(executionId).getStatus());\n\n\t}\n}";
        String content = String.valueOf(partOne) + simpleDateFormat + partTwo + annotation + contextConfigAndFileName + autowired + egovBatchRunnerQualifier + dateFormat + partThree + timeStamp + partFour + threadSleep + partFive;
        isFileCreateSucccess = GenerateJobTestFileUtil.createTestFile(content, newJunitTestFile, context, isFileCreateSucccess);
        return isFileCreateSucccess;
    }

    private static String getJobFilePath(LinkedHashMap<String, String> jobIDExistFileList, BatchJobTestContext context, String jobFilePath) {
        Set<String> foundJobkey = jobIDExistFileList.keySet();
        Object[] jobkeyArray = foundJobkey.toArray();
        Set<String> foundJobXMLKey = context.getFoundJobXMLfiles().keySet();
        Object[] jobXMLKeyArray = foundJobXMLKey.toArray();
        int i = 0;
        while (i < jobIDExistFileList.size()) {
            String key = (String)jobkeyArray[i];
            if (key.equals(context.getJobVo().getJobName())) {
                if (jobIDExistFileList.get(key).contains("main/resources") || jobIDExistFileList.get(key).contains("test/resources")) {
                    jobFilePath = jobIDExistFileList.get(key).split("resources")[1];
                    break;
                }
                IFile jobXmlFile = null;
                int j = 0;
                while (j < context.getFoundJobXMLfiles().size()) {
                    String jobKey = (String)jobXMLKeyArray[j];
                    if (jobKey.contains(jobIDExistFileList.get(key))) {
                        jobXmlFile = context.getFoundJobXMLfiles().get(jobKey);
                        break;
                    }
                    ++j;
                }
                if (NullUtil.isNull((Object)jobXmlFile.getLocation())) break;
                jobFilePath = "file:" + jobXmlFile.getLocation();
                break;
            }
            ++i;
        }
        return jobFilePath;
    }

    private static String getJobLauncherFilePath(BatchJobTestContext context, String jobExecFilePath) {
        Set<String> foundJobExeckey = context.getFoundJobExecXMLfiles().keySet();
        Object[] jobExeckeyArray = foundJobExeckey.toArray();
        Set<String> foundJobExecXMLKey = context.getFoundJobExecXMLfiles().keySet();
        Object[] jobExecXMLKeyArray = foundJobExecXMLKey.toArray();
        int i = 0;
        while (i < context.getFoundJobExecXMLfiles().size()) {
            String key = (String)jobExeckeyArray[i];
            if (key.contains(context.getJobExecName())) {
                if (key.contains("main/resources") || key.contains("test/resources")) {
                    jobExecFilePath = key.split("resources")[1];
                    break;
                }
                IFile jobExecXmlFile = null;
                int j = 0;
                while (j < context.getFoundJobExecXMLfiles().size()) {
                    String jobExecKey = (String)jobExecXMLKeyArray[j];
                    if (jobExecKey.contains(context.getJobExecName())) {
                        jobExecXmlFile = context.getFoundJobExecXMLfiles().get(jobExecKey);
                        break;
                    }
                    ++j;
                }
                if (NullUtil.isNull((Object)jobExecXmlFile.getLocation())) break;
                jobExecFilePath = "file:" + jobExecXmlFile.getLocation();
                break;
            }
            ++i;
        }
        return jobExecFilePath;
    }

    private static String getJobRepositoryAndDatasourceFilePath(String jobRepositoryFilePath, String datasourceFilePath, BatchJobTestContext context) {
        String jobRepoAndDate = null;
        if (context.getJobRepositoryXMLFile() != null) {
            jobRepositoryFilePath = context.getJobRepositoryXMLFile().getRawLocation().toString().contains("main/resources") || context.getJobRepositoryXMLFile().getRawLocation().toString().contains("test/resources") ? context.getJobRepositoryXMLFile().getRawLocation().toString().split("resources")[1] : "file:" + context.getJobRepositoryXMLFile().getRawLocation().toString();
            if (context.getDatasourceXMLFile() != null) {
                datasourceFilePath = context.getDatasourceXMLFile().getRawLocation().toString().contains("main/resources") || context.getDatasourceXMLFile().getRawLocation().toString().contains("test/resources") ? context.getDatasourceXMLFile().getRawLocation().toString().split("resources")[1] : "file:" + context.getDatasourceXMLFile().getRawLocation().toString();
            }
        }
        jobRepoAndDate = String.valueOf(jobRepositoryFilePath) + ">" + datasourceFilePath;
        return jobRepoAndDate;
    }

    private static String getTransactionManagerFilePath(String transactionManagerFilePath, BatchJobTestContext context) {
        String transactionManagerFoundFilePath = null;
        if (context.getTransactionManagerXMLFile() != null) {
            transactionManagerFoundFilePath = context.getTransactionManagerXMLFile().getRawLocation().toString().contains("main/resources") || context.getTransactionManagerXMLFile().getRawLocation().toString().contains("test/resources") ? context.getTransactionManagerXMLFile().getRawLocation().toString().split("resources")[1] : "file:" + context.getTransactionManagerXMLFile().getRawLocation().toString();
        }
        transactionManagerFilePath = transactionManagerFoundFilePath;
        return transactionManagerFilePath;
    }

    private static String jobParametersContent(BatchJobTestContext context) {
        String testFileParamString = "";
        String stringContent = "String_";
        String longContent = "Long_";
        String doubleContent = "Double_";
        String dateContent = "Date_";
        if (context.getJobParameterList() != null) {
            int i = 0;
            while (i < context.getJobParameterList().length) {
                if (context.getJobParameterList()[i].getDataType().equalsIgnoreCase("string")) {
                    stringContent = String.valueOf(stringContent) + context.getJobParameterList()[i].getValue() + ",";
                } else if (context.getJobParameterList()[i].getDataType().equalsIgnoreCase("long")) {
                    longContent = String.valueOf(longContent) + context.getJobParameterList()[i].getValue() + ",";
                } else if (context.getJobParameterList()[i].getDataType().equalsIgnoreCase("double")) {
                    doubleContent = String.valueOf(doubleContent) + context.getJobParameterList()[i].getValue() + ",";
                } else if (context.getJobParameterList()[i].getDataType().equalsIgnoreCase("date")) {
                    dateContent = String.valueOf(dateContent) + context.getJobParameterList()[i].getValue() + ",";
                }
                ++i;
            }
            if (!stringContent.equals("String_")) {
                testFileParamString = String.valueOf(stringContent) + " ";
            }
            if (!stringContent.equals("Long_")) {
                testFileParamString = String.valueOf(testFileParamString) + longContent + " ";
            }
            if (!stringContent.equals("Double_")) {
                testFileParamString = String.valueOf(testFileParamString) + doubleContent + " ";
            }
            if (!stringContent.equals("Date_")) {
                testFileParamString = String.valueOf(testFileParamString) + dateContent + " ";
            }
            testFileParamString = testFileParamString.substring(0, testFileParamString.length() - 2);
        } else {
            testFileParamString = "Date_Default Timestamp";
        }
        return testFileParamString;
    }

    private static String getEgovBatchRunnerID(BatchJobTestContext context, String jobExecFilePath) {
        String egovBatchRunnerID = "";
        IFile usingLauncherFile = null;
        int i = 0;
        while (i < context.getFoundJobExecXMLfiles().keySet().toArray().length) {
            if (context.getFoundJobExecXMLfiles().keySet().toArray()[i].toString().contains(jobExecFilePath)) {
                usingLauncherFile = context.getFoundJobExecXMLfiles().get(context.getFoundJobExecXMLfiles().keySet().toArray()[i]);
            }
            if (NullUtil.isNull(usingLauncherFile) && jobExecFilePath.contains(context.getFoundJobExecXMLfiles().keySet().toArray()[i].toString().substring(2))) {
                usingLauncherFile = context.getFoundJobExecXMLfiles().get(context.getFoundJobExecXMLfiles().keySet().toArray()[i]);
            }
            if (!NullUtil.isNull(usingLauncherFile)) break;
            ++i;
        }
        Map<Object, Object> beanID = new LinkedHashMap();
        beanID = FindBeanIdValueUtil.findBeanIDList(usingLauncherFile, "/beans/bean", "EgovBatchRunner", "class", "id");
        if (!NullUtil.isNull(beanID)) {
            egovBatchRunnerID = beanID.keySet().toArray()[0].toString();
        }
        return egovBatchRunnerID;
    }

    private static String AddJobParametersBuilder(BatchJobTestContext context) {
        String testFileParamString = "";
        if (context.getJobParameterList() != null) {
            int i = 0;
            while (i < context.getJobParameterList().length) {
                if (context.getJobParameterList()[i].getDataType().equalsIgnoreCase("string")) {
                    testFileParamString = String.valueOf(testFileParamString) + "jobParametersBuilder.addString(\"" + context.getJobParameterList()[i].getParameterName() + "\", \"" + context.getJobParameterList()[i].getValue() + "\");\n\t\t";
                } else if (context.getJobParameterList()[i].getDataType().equalsIgnoreCase("long")) {
                    testFileParamString = String.valueOf(testFileParamString) + "jobParametersBuilder.addLong(\"" + context.getJobParameterList()[i].getParameterName() + "\", Long.parseLong(\"" + context.getJobParameterList()[i].getValue() + "\"));\n\t\t";
                } else if (context.getJobParameterList()[i].getDataType().equalsIgnoreCase("double")) {
                    testFileParamString = String.valueOf(testFileParamString) + "jobParametersBuilder.addDouble(\"" + context.getJobParameterList()[i].getParameterName() + "\", Double.parseDouble(\"" + context.getJobParameterList()[i].getValue() + "\"));\n\t\t";
                } else if (context.getJobParameterList()[i].getDataType().equalsIgnoreCase("date")) {
                    testFileParamString = String.valueOf(testFileParamString) + "jobParametersBuilder.addDate(\"" + context.getJobParameterList()[i].getParameterName() + "\", " + context.getJobParameterList()[i].getParameterName() + ".parse(\"" + context.getJobParameterList()[i].getValue() + "\"));\n\t\t";
                }
                ++i;
            }
        }
        return testFileParamString;
    }

    private static Boolean createTestFile(String content, IFile newJunitTestFile, BatchJobTestContext context, Boolean isFileCreateSucccess) {
        try {
            ByteArrayInputStream inStream = new ByteArrayInputStream(content.getBytes("UTF-8"));
            newJunitTestFile.create((InputStream)inStream, true, null);
            if (!newJunitTestFile.isAccessible()) {
                return isFileCreateSucccess;
            }
            isFileCreateSucccess = true;
            context.setJobTestFile(newJunitTestFile.getFullPath().toOSString());
        }
        catch (UnsupportedEncodingException e) {
            BatchTestLog.logError(e);
        }
        catch (CoreException e) {
            BatchTestLog.logError(e);
        }
        return isFileCreateSucccess;
    }
}

