/*
 * Decompiled with CFR 0.152.
 */
package egovframework.bdev.tst.wizards;

import egovframework.bdev.imp.ide.com.natures.EgovBatchNature;
import egovframework.bdev.tst.EgovBatchTestPlugin;
import egovframework.bdev.tst.common.BatchTestMessages;
import egovframework.bdev.tst.wizards.model.BatchJobTestContext;
import egovframework.bdev.tst.wizards.pages.BatchJobTestCustomizePage;
import egovframework.bdev.tst.wizards.pages.BatchJobTestSelectProjectPage;
import egovframework.dev.imp.core.utils.EgovJavaElementUtil;
import egovframework.dev.imp.core.utils.NullUtil;
import org.eclipse.core.internal.resources.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class EgovBatchJobTestWizard
extends Wizard
implements INewWizard {
    private BatchJobTestContext context = new BatchJobTestContext();
    private BatchJobTestSelectProjectPage selectionPage;
    private BatchJobTestCustomizePage customizePage;
    private IStructuredSelection selection;

    public EgovBatchJobTestWizard() {
        this.setNeedsProgressMonitor(true);
        this.setDefaultPageImageDescriptor(EgovBatchTestPlugin.getDefault().getImageDescriptor("batch_tst_wiz_banner"));
        this.setWindowTitle(BatchTestMessages.EgovBatchJobTestWizard_TITLE);
    }

    public void addPages() {
        if (this.isEgovProjectElement()) {
            IProject selectProject = this.getSelectProject();
            this.context.setSelection((IStructuredSelection)new StructuredSelection((Object)selectProject));
            this.context.setProjectName(selectProject.getName());
        } else {
            this.selectionPage = new BatchJobTestSelectProjectPage("SelectProject", this.context, this.selection);
            this.addPage((IWizardPage)this.selectionPage);
        }
        this.customizePage = new BatchJobTestCustomizePage("Customize", this.context);
        this.addPage((IWizardPage)this.customizePage);
    }

    public boolean canFinish() {
        if (this.getContainer().getCurrentPage().equals((Object)this.customizePage)) {
            return super.canFinish();
        }
        return false;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }

    public boolean performFinish() {
        if (!NullUtil.isEmpty((String)this.context.getJobTestFile())) {
            Path path = new Path(this.context.getJobTestFile());
            IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)path);
            File file = (File)resource;
            this.openCreatedFile((IFile)file);
        }
        return true;
    }

    private void openCreatedFile(IFile file) {
        FileEditorInput editorInput = new FileEditorInput(file);
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(file.getName());
        try {
            page.openEditor((IEditorInput)editorInput, desc.getId());
        }
        catch (PartInitException partInitException) {}
    }

    private boolean isEgovProjectElement() {
        if (this.isProjectElement()) {
            IProject project = this.getSelectProject();
            try {
                if (EgovJavaElementUtil.isJavaProject((IProject)project) && EgovBatchNature.isEgovNatureEnabled((IProject)project)) {
                    return true;
                }
            }
            catch (CoreException coreException) {
                return false;
            }
        }
        return false;
    }

    private boolean isProjectElement() {
        if (this.selection.isEmpty()) {
            return false;
        }
        IProject selectProject = this.getSelectProject();
        return !NullUtil.isNull((Object)selectProject);
    }

    private IProject getSelectProject() {
        Object object = this.selection.getFirstElement();
        IProject selectProject = null;
        if (object instanceof IResource) {
            IResource selectResource = (IResource)object;
            selectProject = selectResource.getProject();
        } else if (object instanceof IJavaElement) {
            IJavaElement selectElement = (IJavaElement)object;
            selectProject = selectElement.getJavaProject().getProject();
        }
        return selectProject;
    }
}

