/*
 * Decompiled with CFR 0.152.
 */
package egovframework.bdev.tst.wizards.pages;

import egovframework.bdev.imp.ide.com.natures.EgovBatchNature;
import egovframework.bdev.tst.common.BatchTestMessages;
import egovframework.bdev.tst.wizards.model.BatchJobTestContext;
import egovframework.bdev.tst.wizards.views.ClassTableViewerLabelProvider;
import egovframework.dev.imp.core.utils.EgovJavaElementUtil;
import egovframework.dev.imp.core.utils.NullUtil;
import egovframework.dev.imp.core.utils.StringUtil;
import java.util.ArrayList;
import org.eclipse.core.internal.resources.Folder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class BatchJobTestSelectProjectPage
extends WizardPage {
    BatchJobTestContext context;
    TableViewer projectTableViewer;
    private Text containerNameField;
    private Label containerNameLabel;
    private Label noteName;
    private Label noteContent;
    private ArrayList<IProject> eGovProjects;
    private IStructuredSelection selection = null;
    Listener validation = new Listener(){

        public void handleEvent(Event event) {
            IProject project = null;
            boolean canFlipToNextPage = false;
            String containerClassName = BatchJobTestSelectProjectPage.this.containerNameField.getText();
            if (!NullUtil.isEmpty((String)containerClassName)) {
                int i = 0;
                while (i < BatchJobTestSelectProjectPage.this.eGovProjects.size()) {
                    project = (IProject)BatchJobTestSelectProjectPage.this.eGovProjects.get(i);
                    if (project.getName().equals(containerClassName)) {
                        canFlipToNextPage = true;
                        break;
                    }
                    ++i;
                }
            }
            BatchJobTestSelectProjectPage.this.setPageComplete(canFlipToNextPage);
            if (canFlipToNextPage) {
                BatchJobTestSelectProjectPage.this.setErrorMessage(null);
                BatchJobTestSelectProjectPage.this.context.setProjectName(containerClassName);
            } else {
                BatchJobTestSelectProjectPage.this.setErrorMessage(BatchTestMessages.BatchJobTestSelectProjectPage_INVALID_PROJECT_NAME);
            }
        }
    };

    public BatchJobTestSelectProjectPage(String pageName, BatchJobTestContext context, IStructuredSelection selection) {
        super(pageName);
        this.context = context;
        this.selection = selection;
        this.setTitle(BatchTestMessages.BatchJobTestSelectProjectPage_TITLE);
        this.setDescription(BatchTestMessages.BatchJobTestSelectProjectPage_DESCRIPTION);
        this.eGovProjects = this.getBatchNatureProject();
    }

    public void createControl(Composite parent) {
        Composite control = new Composite(parent, 0);
        control.setLayout((Layout)new GridLayout());
        control.setLayoutData((Object)new GridData(768));
        this.containerNameLabel = new Label(control, 0);
        this.containerNameLabel.setText(BatchTestMessages.BatchJobTestSelectProjectPage_CONTAINER_NAME_LABEL);
        this.containerNameField = new Text(control, 2048);
        this.containerNameField.setLayoutData((Object)new GridData(768));
        this.containerNameField.addListener(24, this.validation);
        this.createTreeTable(control);
        this.createNoteControl(control);
        this.setPageComplete(false);
        this.setControl((Control)control);
    }

    private void createTreeTable(Composite control) {
        GridData spec = new GridData(4, 4, true, true);
        spec.widthHint = 320;
        spec.heightHint = 300;
        this.projectTableViewer = new TableViewer(control, 68352);
        this.projectTableViewer.getControl().setLayoutData((Object)spec);
        this.projectTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.projectTableViewer.setLabelProvider((IBaseLabelProvider)new ClassTableViewerLabelProvider());
        this.projectTableViewer.setInput(this.eGovProjects);
        this.projectTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)BatchJobTestSelectProjectPage.this.projectTableViewer.getSelection();
                if (selection.isEmpty()) {
                    return;
                }
                IProject selectProject = (IProject)selection.getFirstElement();
                BatchJobTestSelectProjectPage.this.containerNameField.setText(selectProject.getName());
                BatchJobTestSelectProjectPage.this.context.setSelection(selection);
            }
        });
    }

    private void createNoteControl(Composite control) {
        Composite noteControl = new Composite(control, 0);
        noteControl.setLayout((Layout)new GridLayout(2, false));
        noteControl.setLayoutData((Object)new GridData());
        this.noteName = new Label(noteControl, 129);
        this.noteName.setText(BatchTestMessages.BatchJobTestSelectProjectPage_NOTE);
        StringUtil.setLabelStringBold((Label)this.noteName);
        this.noteContent = new Label(noteControl, 129);
        this.noteContent.setText(BatchTestMessages.BatchJobTestSelectProjectPage_NOTE_CONTENTS);
    }

    private ArrayList<IProject> getBatchNatureProject() {
        IProject[] allProjects;
        ArrayList<IProject> result = new ArrayList<IProject>();
        IProject[] iProjectArray = allProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = allProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            try {
                if (EgovJavaElementUtil.isJavaProject((IProject)project) && EgovBatchNature.isEgovNatureEnabled((IProject)project)) {
                    result.add(project);
                }
            }
            catch (CoreException coreException) {}
            ++n2;
        }
        return result;
    }

    private IProject getElementFromPackageExplorer() {
        if (!this.selection.isEmpty()) {
            IProject selectedProject = null;
            Object object = this.selection.getFirstElement();
            if (object instanceof IJavaElement) {
                IJavaElement element = (IJavaElement)object;
                selectedProject = element.getJavaProject().getProject();
            } else if (object instanceof Folder) {
                Folder element = (Folder)object;
                selectedProject = element.getProject();
            } else {
                return null;
            }
            return selectedProject;
        }
        return null;
    }

    private void selectItemFromTreeViewer(IProject selectedProject) {
        TableItem[] items;
        if (!NullUtil.isNull((Object)selectedProject) && (items = this.projectTableViewer.getTable().getItems()).length > 0) {
            TableItem[] tableItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                IProject project = (IProject)item.getData();
                String projectName = project.getName();
                if (selectedProject.getName().equals(projectName)) {
                    this.projectTableViewer.setSelection((ISelection)new StructuredSelection((Object)selectedProject));
                    return;
                }
                ++n2;
            }
        }
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.resetContextWithoutSelectionAndProjectName();
            IProject selectedProject = this.getElementFromPackageExplorer();
            if (!NullUtil.isNull((Object)selectedProject)) {
                this.selectItemFromTreeViewer(selectedProject);
            }
        }
        super.setVisible(visible);
    }

    private void resetContextWithoutSelectionAndProjectName() {
        IStructuredSelection selection = this.context.getSelection();
        String projectName = this.context.getProjectName();
        this.context.clearValues();
        this.context.setSelection(selection);
        this.context.setProjectName(projectName);
    }
}

