/*
 * Decompiled with CFR 0.152.
 */
package egovframework.bdev.tst.wizards.pages;

import egovframework.bdev.tst.common.BatchTestMessages;
import egovframework.dev.imp.core.utils.NullUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.NewFolderDialog;
import org.eclipse.ui.views.navigator.ResourceComparator;

public class BatchTestFolderSelectionDialog
extends ElementTreeSelectionDialog
implements ISelectionChangedListener {
    private Button fNewFolderButton;
    private IContainer fSelectedContainer;

    public BatchTestFolderSelectionDialog(Shell parent, ILabelProvider labelProvider, ITreeContentProvider contentProvider) {
        super(parent, labelProvider, contentProvider);
        this.setComparator((ViewerComparator)new ResourceComparator(1));
    }

    protected Control createDialogArea(Composite parent) {
        Composite result = (Composite)super.createDialogArea(parent);
        this.getTreeViewer().addSelectionChangedListener((ISelectionChangedListener)this);
        Button button = new Button(result, 8);
        button.setText(BatchTestMessages.BatchTestFolderSelectionDialog_NEW_FOLDER_BUTTON);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                BatchTestFolderSelectionDialog.this.newFolderButtonPressed();
            }
        });
        button.setFont(parent.getFont());
        this.fNewFolderButton = button;
        BatchTestFolderSelectionDialog.applyDialogFont((Control)result);
        return result;
    }

    private void updateNewFolderButtonState() {
        Object first;
        IStructuredSelection selection = (IStructuredSelection)this.getTreeViewer().getSelection();
        this.fSelectedContainer = null;
        if (selection.size() == 1 && (first = selection.getFirstElement()) instanceof IContainer) {
            this.fSelectedContainer = (IContainer)first;
        }
        if (this.isPathIncludeResourceFolder(this.fSelectedContainer)) {
            this.fNewFolderButton.setEnabled(true);
        } else {
            this.fNewFolderButton.setEnabled(false);
        }
    }

    private boolean isPathIncludeResourceFolder(IContainer container) {
        Object[] splitedFolderPaths = this.getFoldersListFromPath(container);
        if (!NullUtil.isEmpty((Object[])splitedFolderPaths)) {
            Object[] objectArray = splitedFolderPaths;
            int n = splitedFolderPaths.length;
            int n2 = 0;
            while (n2 < n) {
                Object folder = objectArray[n2];
                if ("java".equals(folder)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private String[] getFoldersListFromPath(IContainer container) {
        if (NullUtil.isNull((Object)container)) {
            return new String[0];
        }
        String selectedPath = container.getFullPath().makeRelative().toString();
        String[] splitedPath = selectedPath.split("/", 2);
        if (splitedPath.length > 1) {
            String folderPath = splitedPath[1];
            return folderPath.split("/");
        }
        return new String[0];
    }

    protected void newFolderButtonPressed() {
        NewFolderDialog dialog = new NewFolderDialog(this.getShell(), this.fSelectedContainer);
        if (dialog.open() == 0) {
            TreeViewer treeViewer = this.getTreeViewer();
            treeViewer.refresh((Object)this.fSelectedContainer);
            Object createdFolder = dialog.getResult()[0];
            treeViewer.reveal(createdFolder);
            treeViewer.setSelection((ISelection)new StructuredSelection(createdFolder));
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.updateNewFolderButtonState();
    }
}

