/*
 * Decompiled with CFR 0.152.
 */
package egovframework.bdev.tst.wizards.pages;

import egovframework.bdev.tst.common.BatchTestMessages;
import egovframework.bdev.tst.wizards.pages.BatchTestFolderSelectionDialog;
import egovframework.bdev.tst.wizards.views.GenerateTestFileContentProvider;
import egovframework.dev.imp.core.utils.NullUtil;
import egovframework.dev.imp.core.utils.StringUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class GenerateFileDialog
extends StatusDialog {
    private final String defaultfolderPath;
    private IProject selectProject = null;
    private String folderPath = null;
    private String fileName = null;
    private Text folderPathText = null;
    private Text fileNameText = null;
    Listener browseListener = new Listener(){

        public void handleEvent(Event event) {
            Object object;
            ILabelProvider labelProvider = WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider();
            GenerateTestFileContentProvider contentProvider = new GenerateTestFileContentProvider();
            BatchTestFolderSelectionDialog dialog = new BatchTestFolderSelectionDialog(GenerateFileDialog.this.getShell(), labelProvider, contentProvider);
            dialog.setComparator(new ViewerComparator());
            dialog.setInput(new IProject[]{GenerateFileDialog.this.selectProject});
            dialog.setTitle(BatchTestMessages.GenerateFileDialog_BROWSE_BUTTON_DIALOG_TITLE);
            String selectFolderPathString = GenerateFileDialog.this.folderPathText.getText();
            IResource selectedElement = GenerateFileDialog.this.getSelectResource(selectFolderPathString);
            if (!NullUtil.isNull((Object)selectedElement)) {
                dialog.setInitialSelection(selectedElement);
            }
            if (dialog.open() == 0 && !NullUtil.isNull((Object)(object = dialog.getFirstResult()))) {
                IResource selection = (IResource)object;
                IPath selectionPath = selection.getFullPath();
                GenerateFileDialog.this.folderPathText.setText(selectionPath.makeRelative().toString());
            }
        }
    };
    Listener validate = new Listener(){

        public void handleEvent(Event event) {
            StatusInfo status = new StatusInfo();
            String folderPath = GenerateFileDialog.this.folderPathText.getText();
            if (NullUtil.isEmpty((String)folderPath)) {
                status.setError(BatchTestMessages.GenerateFileDialog_EMPTY_FOLDER_PATH);
                GenerateFileDialog.this.updateStatus((IStatus)status);
                return;
            }
            IResource selectedResource = GenerateFileDialog.this.getSelectResource(folderPath);
            if (NullUtil.isNull((Object)selectedResource)) {
                status.setError(BatchTestMessages.GenerateFileDialog_NOT_EXIST_FOLDER);
                GenerateFileDialog.this.updateStatus((IStatus)status);
                return;
            }
            if (!this.isFolderPathIncludeJavaFolder(folderPath)) {
                status.setError(BatchTestMessages.GenerateFileDialog_FOLDER_PATH_MUST_CONTAIN_JAVA);
                GenerateFileDialog.this.updateStatus((IStatus)status);
                return;
            }
            String inputFileName = GenerateFileDialog.this.fileNameText.getText();
            if (NullUtil.isEmpty((String)inputFileName)) {
                status.setError(BatchTestMessages.GenerateFileDialog_EMPTY_FILE_NAME);
                GenerateFileDialog.this.updateStatus((IStatus)status);
                return;
            }
            String fileNameWithoutDotJava = this.getFileNameWithoutDotJava(inputFileName);
            if (!GenerateFileDialog.this.isFileNameAvailable(fileNameWithoutDotJava)) {
                status.setError(BatchTestMessages.GenerateFileDialog_INVALID_FILE_NAME);
                GenerateFileDialog.this.updateStatus((IStatus)status);
                return;
            }
            GenerateFileDialog.this.fileName = String.valueOf(fileNameWithoutDotJava) + ".java";
            status.setOK();
            GenerateFileDialog.this.updateStatus((IStatus)status);
        }

        private String getFileNameWithoutDotJava(String fileName) {
            String dotJava = ".java";
            int lastIndexOfDotJava = fileName.lastIndexOf(dotJava);
            if (lastIndexOfDotJava > 0 && lastIndexOfDotJava + dotJava.length() == fileName.length()) {
                return fileName.substring(0, lastIndexOfDotJava);
            }
            return fileName;
        }

        private boolean isFolderPathIncludeJavaFolder(String folderPath) {
            Object[] folders = folderPath.split("/");
            if (!NullUtil.isEmpty((Object[])folders)) {
                Object[] objectArray = folders;
                int n = folders.length;
                int n2 = 0;
                while (n2 < n) {
                    Object folder = objectArray[n2];
                    if ("java".equals(folder)) {
                        return true;
                    }
                    ++n2;
                }
            }
            return false;
        }
    };

    public String getFolderPath() {
        return this.folderPath;
    }

    public String getFileName() {
        return this.fileName;
    }

    public GenerateFileDialog(Shell parent, String folderPath, String filePath, IProject selectProject) {
        super(parent);
        this.setTitle(BatchTestMessages.GenerateFileDialog_TITLE);
        this.folderPath = folderPath;
        this.fileName = filePath;
        this.selectProject = selectProject;
        this.defaultfolderPath = String.valueOf(selectProject.getProject().getName()) + "/src/test/java";
    }

    protected Point getInitialSize() {
        return new Point(370, 206);
    }

    protected Control createDialogArea(Composite parent) {
        Composite control = new Composite(parent, 0);
        control.setLayout((Layout)new GridLayout(3, false));
        control.setLayoutData((Object)new GridData(1808));
        this.createSelectFolderControl(control);
        this.createDescriptionControl(control);
        return control;
    }

    private void createDescriptionControl(Composite control) {
        GridData gData = new GridData(1808);
        gData.horizontalSpan = 3;
        Composite labelControl = new Composite(control, 0);
        labelControl.setLayout((Layout)new GridLayout(2, false));
        labelControl.setLayoutData((Object)gData);
        Label descriptionOne = new Label(labelControl, 0);
        descriptionOne.setText(BatchTestMessages.GenerateFileDialog_NOTE);
        StringUtil.setLabelStringBold((Label)descriptionOne);
        Label descriptionTwo = new Label(labelControl, 0);
        descriptionTwo.setText(BatchTestMessages.GenerateFileDialog_NOTE_CONTENTS);
    }

    private void createSelectFolderControl(Composite control) {
        Label selectFolderLabel = new Label(control, 0);
        selectFolderLabel.setText(BatchTestMessages.GenerateFileDialog_SELECT_FOLDER_LABEL);
        this.folderPathText = new Text(control, 2048);
        this.folderPathText.setLayoutData((Object)new GridData(768));
        this.folderPathText.setText(NullUtil.isEmpty((String)this.folderPath) ? this.defaultfolderPath : this.folderPath);
        this.folderPathText.addListener(24, this.validate);
        Button browseSelectButton = new Button(control, 8);
        browseSelectButton.setText(BatchTestMessages.GenerateFileDialog_BROWSE_BUTTON);
        browseSelectButton.addListener(13, this.browseListener);
        Label fileNameLabel = new Label(control, 0);
        fileNameLabel.setText(BatchTestMessages.GenerateFileDialog_FILE_NAME_LABEL);
        this.fileNameText = new Text(control, 2048);
        this.fileNameText.setLayoutData((Object)new GridData(768));
        this.fileNameText.setText(StringUtil.returnEmptyStringIfNull((String)this.fileName));
        this.fileNameText.addListener(24, this.validate);
        this.fileNameText.forceFocus();
        Label emptyLabel = new Label(control, 0);
        emptyLabel.setText("");
    }

    private IResource getSelectResource(String folderPath) {
        IResource resource = null;
        if (!NullUtil.isEmpty((String)folderPath)) {
            String[] splitedFolderPath = folderPath.split("/", 2);
            if (splitedFolderPath.length < 2) {
                if (splitedFolderPath[0].equals(this.selectProject.getProject().getName())) {
                    resource = this.selectProject;
                }
            } else {
                resource = this.selectProject.findMember(splitedFolderPath[1]);
            }
        }
        return resource;
    }

    protected void okPressed() {
        this.folderPath = this.folderPathText.getText();
        super.okPressed();
    }

    private boolean isFileNameAvailable(String fileName) {
        return !this.isFileNameHasInvalidCharacter(fileName) && !this.isInvalidFileName(fileName) && !StringUtil.isStringStartWithNumber((String)fileName);
    }

    private boolean isInvalidFileName(String fileName) {
        return "Autowired".equals(fileName) || "ContextConfiguration".equals(fileName) || "RunWith".equals(fileName) || "Test".equals(fileName);
    }

    private boolean isFileNameHasInvalidCharacter(String fileName) {
        return StringUtil.hasInvalidClassFileSignal((String)fileName) || StringUtil.hasKorean((String)fileName) || StringUtil.doesStringHasSignal((char)'.', (String)fileName) || StringUtil.hasEmptySpace((String)fileName);
    }
}

