/*
 * Decompiled with CFR 0.152.
 */
package egovframework.bdev.tst.wizards.pages;

import egovframework.bdev.imp.confmngt.preferences.parameter.JobParameterContents;
import egovframework.bdev.imp.confmngt.preferences.parameter.model.JobParameterInfo;
import egovframework.bdev.tst.common.BatchTestMessages;
import egovframework.dev.imp.core.utils.BatchTableColumn;
import egovframework.dev.imp.core.utils.StringUtil;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class JobParameterInfoToWizardDialog
extends StatusDialog {
    private ArrayList<JobParameterInfo> info;
    private JobParameterContents contents;
    private TableItem[] items;

    public ArrayList<JobParameterInfo> getInfo() {
        return this.info;
    }

    public JobParameterInfoToWizardDialog(Shell parent, TableItem[] items) {
        super(parent);
        this.items = items;
        this.setTitle(BatchTestMessages.JobParameterInfoToWizardDialog_TITLE);
    }

    protected Control createDialogArea(Composite parent) {
        GridData tableGData = new GridData(768);
        tableGData.heightHint = 400;
        Composite control = new Composite(parent, 0);
        control.setLayout((Layout)new GridLayout());
        control.setLayoutData((Object)tableGData);
        Label description = new Label(control, 0);
        description.setText(BatchTestMessages.JobParameterInfoToWizardDialog_DESCRIPTION);
        StringUtil.setLabelStringBold((Label)description);
        this.createLink(control);
        this.createJobParameterTableViewer(control);
        this.createButton(control);
        this.checkExistItems();
        return control;
    }

    private void createLink(Composite control) {
        Link link = new Link(control, 131072);
        link.setLayoutData((Object)new GridData(128));
        link.setText(BatchTestMessages.JobParameterInfoToWizardDialog_LINK);
        link.addListener(4, new Listener(){

            public void handleEvent(Event event) {
                PreferencesUtil.createPreferenceDialogOn((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"egovframework.bdev.imp.confmngt.preferences.jobparampreferencepage", (String[])new String[]{"egovframework.bdev.imp.confmngt.preferences.jobparampreferencepage"}, null).open();
                JobParameterInfoToWizardDialog.this.contents.refreshInputData();
            }
        });
    }

    private void createButton(Composite control) {
        Composite buttonControl = new Composite(control, 0);
        buttonControl.setLayout((Layout)new GridLayout(2, false));
        buttonControl.setLayoutData((Object)new GridData());
        Button selectAll = new Button(buttonControl, 8);
        selectAll.setText(BatchTestMessages.JobParameterInfoToWizardDialog_SELECT_ALL_BUTTON);
        selectAll.addListener(4, new Listener(){

            public void handleEvent(Event event) {
                ((CheckboxTableViewer)JobParameterInfoToWizardDialog.this.contents.getTableViewer()).setAllChecked(true);
            }
        });
        Button deselectAll = new Button(buttonControl, 8);
        deselectAll.setText(BatchTestMessages.JobParameterInfoToWizardDialog_DESELECT_ALL_BUTTON);
        deselectAll.addListener(4, new Listener(){

            public void handleEvent(Event event) {
                ((CheckboxTableViewer)JobParameterInfoToWizardDialog.this.contents.getTableViewer()).setAllChecked(false);
            }
        });
    }

    private void checkExistItems() {
        if (this.items != null && this.items.length > 0) {
            String[] wizardItems = new String[this.items.length];
            int i = 0;
            while (i < this.items.length) {
                wizardItems[i] = ((JobParameterInfo)this.items[i].getData()).getParameterName();
                ++i;
            }
            CheckboxTableViewer tableViewer = (CheckboxTableViewer)this.contents.getTableViewer();
            TableItem[] preferenceItems = tableViewer.getTable().getItems();
            if (preferenceItems != null && preferenceItems.length > 0) {
                int i2 = 0;
                while (i2 < wizardItems.length) {
                    int j = 0;
                    while (j < preferenceItems.length) {
                        JobParameterInfo info = (JobParameterInfo)preferenceItems[j].getData();
                        if (wizardItems[i2].equals(info.getParameterName())) {
                            tableViewer.setChecked((Object)info, true);
                            break;
                        }
                        ++j;
                    }
                    ++i2;
                }
            }
        }
    }

    private void createJobParameterTableViewer(Composite control) {
        BatchTableColumn[] columns = this.createColumns();
        this.contents = new JobParameterContents("Job Parameter", "JobParameter", true);
        this.contents.setTableColumnProperty(columns);
        this.contents.createTableViewerContents(control);
    }

    private BatchTableColumn[] createColumns() {
        ArrayList<BatchTableColumn> columns = new ArrayList<BatchTableColumn>();
        columns.add(new BatchTableColumn(BatchTestMessages.JobParameterInfoToWizardDialog_TABLE_COLUMN_PARAMETER_NAME, 175, 16384));
        columns.add(new BatchTableColumn(BatchTestMessages.JobParameterInfoToWizardDialog_TABLE_COLUMN_VALUE, 150, 16384));
        columns.add(new BatchTableColumn(BatchTestMessages.JobParameterInfoToWizardDialog_TABLE_COLUMN_DATA_TYPE, 122, 16384));
        return columns.toArray(new BatchTableColumn[0]);
    }

    protected void okPressed() {
        CheckboxTableViewer chTableViewer = (CheckboxTableViewer)this.contents.getTableViewer();
        Object[] object = chTableViewer.getCheckedElements();
        this.info = new ArrayList();
        int i = 0;
        while (i < object.length) {
            this.info.add((JobParameterInfo)object[i]);
            ++i;
        }
        super.okPressed();
    }
}

