/*
 * Decompiled with CFR 0.152.
 */
package egovframework.dev.imp.commngt;

import egovframework.dev.imp.commngt.common.ComMngtMessages;
import egovframework.dev.imp.commngt.common.CommngtLog;
import java.net.URL;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class EgovCommngtPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "egovframework.dev.imp.commngt";
    private static EgovCommngtPlugin plugin;
    private static final String ICONS_PATH = "icons/";
    public static final String IMG_COMMNGT_WIZ_BANNER = "commngt_wiz";
    public static final String IMG_COMMNGT_REMARKS = "remarks";

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static EgovCommngtPlugin getDefault() {
        return plugin;
    }

    public Image getImage(String key) {
        Image image = this.getImageRegistry().get(key);
        return image;
    }

    public ImageDescriptor getImageDescriptor(String key) {
        ImageDescriptor imageDescriptor = this.getImageRegistry().getDescriptor(key);
        return imageDescriptor;
    }

    private void registerImage(ImageRegistry registry, String key, String fileName) {
        try {
            Path path = new Path(ICONS_PATH + fileName);
            URL url = this.find((IPath)path);
            if (url != null) {
                ImageDescriptor desc = ImageDescriptor.createFromURL((URL)url);
                registry.put(key, desc);
            }
        }
        catch (Exception e) {
            CommngtLog.logError(e);
        }
    }

    protected void initializeImageRegistry(ImageRegistry registry) {
        super.initializeImageRegistry(registry);
        this.registerImage(registry, IMG_COMMNGT_WIZ_BANNER, "commngt_wiz.png");
        this.registerImage(registry, IMG_COMMNGT_REMARKS, ComMngtMessages.imgCommngtRemarks);
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        IWorkbenchWindow workbenchWindow = EgovCommngtPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        return workbenchWindow;
    }
}

