/*
 * Decompiled with CFR 0.152.
 */
package egovframework.dev.imp.commngt.util;

import egovframework.dev.imp.commngt.common.CommngtLog;
import egovframework.dev.imp.commngt.util.ComResourceUtilVO;
import egovframework.dev.imp.commngt.wizards.model.NewEgovCommngtContext;
import egovframework.dev.imp.core.utils.XmlUtil;
import egovframework.dev.imp.ide.common.ResourceUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class ComResourceUtils {
    static boolean asIsCommonExist = false;
    static boolean leaverTraceExist = false;
    static boolean modifyValidator = false;

    public static IFile copyFolderFile(IContainer container, String fname, InputStream content, IProgressMonitor monitor, String type) throws CoreException {
        int i;
        Path p = new Path(fname.replace('\\', '/'));
        IContainer fo = null;
        if (p.segmentCount() > 1) {
            i = p.segmentCount() - 1;
            while (i > 0) {
                IPath pt = p.removeLastSegments(i);
                fo = container.getFolder(pt);
                if (!fo.isAccessible()) {
                    ((IFolder)fo).create(true, true, monitor);
                }
                --i;
            }
        } else {
            fo = container;
        }
        IFile originf = fo.getFile((IPath)new Path(type));
        i = 0;
        if (originf.isAccessible()) {
            IFile copyf = fo.getFile((IPath)new Path(String.valueOf(type) + ComResourceUtils.getCurrentTime() + i));
            while (copyf.isAccessible()) {
                copyf = fo.getFile((IPath)new Path(String.valueOf(type) + ComResourceUtils.getCurrentTime() + i));
                ++i;
            }
            copyf.create(originf.getContents(), true, monitor);
            originf.setContents(content, true, false, monitor);
        } else {
            originf.create(content, true, monitor);
        }
        return originf;
    }

    public static IFile copyWebXmlFile(NewEgovCommngtContext context, IContainer container, String fname, InputStream content, IProgressMonitor monitor, String type) throws CoreException {
        int i;
        Path p = new Path(fname.replace('\\', '/'));
        IContainer fo = null;
        if (p.segmentCount() > 1) {
            i = p.segmentCount() - 1;
            while (i > 0) {
                IPath pt = p.removeLastSegments(i);
                fo = container.getFolder(pt);
                if (!fo.isAccessible()) {
                    ((IFolder)fo).create(true, true, monitor);
                }
                --i;
            }
        } else {
            fo = container;
        }
        IFile originf = fo.getFile((IPath)new Path(type));
        i = 0;
        if (originf.isAccessible()) {
            IFile copyf = fo.getFile((IPath)new Path(String.valueOf(type) + ComResourceUtils.getCurrentTime() + i));
            while (copyf.isAccessible()) {
                copyf = fo.getFile((IPath)new Path(String.valueOf(type) + ComResourceUtils.getCurrentTime() + i));
                ++i;
            }
            boolean fileExist = ComResourceUtils.checkOldWebXml(container, originf.getContents(), monitor);
            InputStream newContent = content;
            if (fileExist) {
                newContent = ComResourceUtils.modifyWebXml(container, fname, content, originf.getContents(), monitor);
            }
            if (context.isWebModify()) {
                copyf.create(originf.getContents(), true, monitor);
                originf.setContents(newContent, true, false, monitor);
            } else {
                copyf.create(newContent, true, monitor);
            }
        } else {
            originf.create(content, true, monitor);
        }
        return originf;
    }

    public static boolean checkOldWebXml(IContainer container, InputStream oriCon, IProgressMonitor monitor) {
        boolean check = false;
        try {
            DocumentBuilderFactory docBF = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBF.newDocumentBuilder();
            Document oriDoc = docBuilder.parse(new InputSource(oriCon));
            Element oriRootNode = oriDoc.getDocumentElement();
            boolean mappingExist = ComResourceUtils.checkServletMapping(oriRootNode);
            if (mappingExist) {
                check = true;
            }
        }
        catch (Exception e) {
            CommngtLog.logError(e);
        }
        return check;
    }

    public static Document makeDocument(InputStream xmlSource) {
        Document xmlDoc = null;
        try {
            DocumentBuilderFactory docBF = DocumentBuilderFactory.newInstance();
            docBF.setValidating(false);
            docBF.setNamespaceAware(false);
            docBF.setFeature("http://xml.org/sax/features/validation", false);
            docBF.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
            docBF.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            docBF.setFeature("http://xml.org/sax/features/external-general-entities", false);
            docBF.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            DocumentBuilder docBuilder = docBF.newDocumentBuilder();
            xmlDoc = docBuilder.parse(new InputSource(xmlSource));
        }
        catch (Exception e) {
            CommngtLog.logError(e);
        }
        return xmlDoc;
    }

    public static InputStream modifyWebXml(IContainer container, String fname, InputStream newCon, InputStream oriCon, IProgressMonitor monitor) {
        Element oriRootNode = null;
        try {
            DocumentBuilderFactory docBF = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBF.newDocumentBuilder();
            Document oriDoc = docBuilder.parse(new InputSource(oriCon));
            oriRootNode = oriDoc.getDocumentElement();
            Document newDoc = docBuilder.parse(new InputSource(newCon));
            Element newRootNode = newDoc.getDocumentElement();
            boolean mappingExist = ComResourceUtils.checkServletMapping(newRootNode);
            if (mappingExist) {
                NodeList listenerList;
                NodeList filterMappingList;
                NodeList filterList;
                String urlDoPattern = "*.do";
                Node doNode = ComResourceUtils.getServlet(newRootNode, urlDoPattern);
                Node doOldNode = ComResourceUtils.getServlet(oriRootNode, urlDoPattern);
                if (doOldNode != null) {
                    ComResourceUtils.mergeServlet(doOldNode, doNode);
                } else {
                    NodeList servletList = XmlUtil.getNodeList((Node)oriRootNode, (String)"/web-app/servlet");
                    if (servletList.getLength() > 0) {
                        ComResourceUtils.mergeServlet(servletList.item(0), doNode);
                        XmlUtil.addNode((Node)oriRootNode, (String)"/web-app", (String)ComResourceUtils.nodeToString(ComResourceUtils.getServletMapping(newRootNode, urlDoPattern, XmlUtil.getNode((Node)servletList.item(0), (String)"./servlet-name").getFirstChild().getNodeValue())), (String)"\t", (String)"\n");
                    }
                }
                if (doNode != null) {
                    Node doOldContextParam = ComResourceUtils.getContextParam(oriRootNode, doOldNode);
                    Node doContextParam = ComResourceUtils.getContextParam(newRootNode, doNode);
                    ComResourceUtils.mergeContext(doOldContextParam, doContextParam);
                }
                NodeList oriFilterNameList = XmlUtil.getNodeList((Node)oriRootNode, (String)"/web-app/filter/filter-name");
                String filterNameList = "";
                if (oriFilterNameList.getLength() > 0) {
                    int i = 0;
                    while (oriFilterNameList.getLength() > i) {
                        filterNameList = String.valueOf(filterNameList) + oriFilterNameList.item(i).getFirstChild().getNodeValue() + ";;;";
                        ++i;
                    }
                }
                if ((filterList = XmlUtil.getNodeList((Node)newRootNode, (String)"/web-app/filter")).getLength() > 0) {
                    int i = 0;
                    while (filterList.getLength() > i) {
                        if (filterNameList.indexOf(XmlUtil.getNode((Node)filterList.item(i), (String)"./filter-name").getFirstChild().getNodeValue()) <= -1) {
                            XmlUtil.addNode((Node)oriRootNode, (String)"/web-app", (String)ComResourceUtils.nodeToString(filterList.item(i)), (String)"\t", (String)"\n");
                            filterNameList = String.valueOf(filterNameList) + XmlUtil.getNode((Node)filterList.item(i), (String)"./filter-name").getFirstChild().getNodeValue() + ";;;";
                        }
                        ++i;
                    }
                }
                NodeList oriFilterMappingNameList = XmlUtil.getNodeList((Node)oriRootNode, (String)"/web-app/filter-mapping/filter-name");
                String filterMappingNameList = "";
                if (oriFilterMappingNameList.getLength() > 0) {
                    int i = 0;
                    while (oriFilterMappingNameList.getLength() > i) {
                        filterMappingNameList = String.valueOf(filterMappingNameList) + oriFilterMappingNameList.item(i).getFirstChild().getNodeValue() + ";;;";
                        ++i;
                    }
                }
                if ((filterMappingList = XmlUtil.getNodeList((Node)newRootNode, (String)"/web-app/filter-mapping")).getLength() > 0) {
                    int i = 0;
                    while (filterMappingList.getLength() > i) {
                        if (filterMappingNameList.indexOf(XmlUtil.getNode((Node)filterMappingList.item(i), (String)"./filter-name").getFirstChild().getNodeValue()) <= -1) {
                            XmlUtil.addNode((Node)oriRootNode, (String)"/web-app", (String)ComResourceUtils.nodeToString(filterMappingList.item(i)), (String)"\t", (String)"\n");
                            filterMappingNameList = String.valueOf(filterMappingNameList) + XmlUtil.getNode((Node)filterMappingList.item(i), (String)"./filter-name").getFirstChild().getNodeValue() + ";;;";
                        }
                        ++i;
                    }
                }
                NodeList oriListenerClassList = XmlUtil.getNodeList((Node)oriRootNode, (String)"/web-app/listener/listener-class");
                String listenerClassNameList = "";
                if (oriListenerClassList.getLength() > 0) {
                    int i = 0;
                    while (oriListenerClassList.getLength() > i) {
                        listenerClassNameList = String.valueOf(listenerClassNameList) + oriListenerClassList.item(i).getFirstChild().getNodeValue() + ";;;";
                        ++i;
                    }
                }
                if ((listenerList = XmlUtil.getNodeList((Node)newRootNode, (String)"/web-app/listener")).getLength() > 0) {
                    int i = 0;
                    while (listenerList.getLength() > i) {
                        if (listenerClassNameList.indexOf(XmlUtil.getNode((Node)listenerList.item(i), (String)"./listener-class").getFirstChild().getNodeValue()) <= -1) {
                            XmlUtil.addNode((Node)oriRootNode, (String)"/web-app", (String)ComResourceUtils.nodeToString(listenerList.item(i)), (String)"\t", (String)"\n");
                            listenerClassNameList = String.valueOf(listenerClassNameList) + XmlUtil.getNode((Node)listenerList.item(i), (String)"./listener-class").getFirstChild().getNodeValue() + ";;;";
                        }
                        ++i;
                    }
                }
            }
        }
        catch (Exception e) {
            CommngtLog.logError(e);
        }
        return ComResourceUtils.nodeToStream(oriRootNode);
    }

    public static InputStream nodeToStream(Node root) {
        ByteArrayInputStream is = null;
        try {
            String xmlStr = XmlUtil.getXmlString((Node)root, (String)"/");
            is = new ByteArrayInputStream(xmlStr.getBytes("UTF-8"));
        }
        catch (Exception e) {
            CommngtLog.logError(e);
        }
        return is;
    }

    public static void mergeServlet(Node oldNode, Node newNode) {
        try {
            if (oldNode != null && newNode != null && XmlUtil.existNode((Node)oldNode, (String)"./init-param") && XmlUtil.existNode((Node)oldNode, (String)"./init-param/param-value")) {
                String oldValue = XmlUtil.getNode((Node)oldNode, (String)"./init-param/param-value").getFirstChild().getNodeValue();
                String newValue = XmlUtil.getNode((Node)newNode, (String)"./init-param/param-value").getFirstChild().getNodeValue();
                if (oldValue == null) {
                    XmlUtil.getNode((Node)oldNode, (String)"./init-param/param-value").getFirstChild().setNodeValue(newValue);
                } else if (oldValue != null && newValue != null && oldValue.indexOf(ComResourceUtils.trimString(newValue)) <= -1) {
                    oldValue = String.valueOf(oldValue) + "," + newValue.replace("\n", "") + "\n";
                    XmlUtil.getNode((Node)oldNode, (String)"./init-param/param-value").getFirstChild().setNodeValue(oldValue);
                }
            }
        }
        catch (Exception e) {
            CommngtLog.logError(e);
        }
    }

    public static String trimString(String oriString) {
        String newString = "";
        if (oriString != null) {
            newString = oriString.replace("\n", "").replace("\t", "").replace(" ", "");
        }
        return newString;
    }

    public static void mergeContext(Node oldNode, Node newNode) {
        try {
            if (oldNode != null && newNode != null && XmlUtil.existNode((Node)oldNode, (String)"./param-value")) {
                String oldValue = XmlUtil.getNode((Node)oldNode, (String)"./param-value").getFirstChild().getNodeValue();
                String newValue = XmlUtil.getNode((Node)newNode, (String)"./param-value").getFirstChild().getNodeValue();
                if (oldValue == null) {
                    XmlUtil.getNode((Node)oldNode, (String)"./param-value").getFirstChild().setNodeValue(newValue);
                } else if (oldValue != null && newValue != null && oldValue.indexOf(ComResourceUtils.trimString(newValue)) <= -1) {
                    oldValue = String.valueOf(oldValue) + "," + newValue.replace("\n", "") + "\n";
                    XmlUtil.getNode((Node)oldNode, (String)"./param-value").getFirstChild().setNodeValue(oldValue);
                }
            }
        }
        catch (Exception e) {
            CommngtLog.logError(e);
        }
    }

    public static Node getServlet(Node rootNode, String pattern) {
        try {
            NodeList servletMappingList = XmlUtil.getNodeList((Node)rootNode, (String)"/web-app/servlet-mapping");
            if (servletMappingList != null) {
                int i = 0;
                while (servletMappingList.getLength() > i) {
                    Node servletMappingNode = servletMappingList.item(i);
                    Node urlPatternNode = XmlUtil.getNode((Node)servletMappingNode, (String)"./url-pattern");
                    if (urlPatternNode != null && pattern != null && pattern.indexOf(urlPatternNode.getFirstChild().getNodeValue()) > -1) {
                        String servletName = XmlUtil.getNode((Node)servletMappingNode, (String)"./servlet-name").getFirstChild().getNodeValue();
                        NodeList servletNodeList = XmlUtil.getNodeList((Node)rootNode, (String)"/web-app/servlet");
                        int j = 0;
                        while (servletNodeList.getLength() > j) {
                            Node servletNode = servletNodeList.item(j);
                            Node servletN = XmlUtil.getNode((Node)servletNode, (String)"./servlet-name");
                            if (servletName != null && servletName.equals(servletN.getFirstChild().getNodeValue())) {
                                return servletNode;
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            CommngtLog.logError(e);
        }
        return null;
    }

    public static Node getServletMapping(Node rootNode, String pattern) {
        try {
            NodeList servletMappingList = XmlUtil.getNodeList((Node)rootNode, (String)"/web-app/servlet-mapping");
            if (servletMappingList != null) {
                int i = 0;
                while (servletMappingList.getLength() > i) {
                    Node servletMappingNode = servletMappingList.item(i);
                    Node urlPatternNode = XmlUtil.getNode((Node)servletMappingNode, (String)"./url-pattern");
                    if (urlPatternNode != null && pattern != null && pattern.indexOf(urlPatternNode.getFirstChild().getNodeValue()) > -1) {
                        return servletMappingNode;
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            CommngtLog.logError(e);
        }
        return null;
    }

    public static Node getServletMapping(Node rootNode, String pattern, String servletName) {
        try {
            NodeList servletMappingList = XmlUtil.getNodeList((Node)rootNode, (String)"/web-app/servlet-mapping");
            if (servletMappingList != null) {
                int i = 0;
                while (servletMappingList.getLength() > i) {
                    Node servletMappingNode = servletMappingList.item(i);
                    Node urlPatternNode = XmlUtil.getNode((Node)servletMappingNode, (String)"./url-pattern");
                    if (urlPatternNode != null && pattern != null && pattern.indexOf(urlPatternNode.getFirstChild().getNodeValue()) > -1) {
                        XmlUtil.getNode((Node)servletMappingNode, (String)"./servlet-name").getFirstChild().setNodeValue(servletName);
                        return servletMappingNode;
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            CommngtLog.logError(e);
        }
        return null;
    }

    public static Node getContextParam(Node rootNode, Node servletNode) {
        try {
            if (servletNode != null) {
                NodeList contextParamList;
                String paramName = "";
                if (XmlUtil.existNode((Node)servletNode, (String)"./init-param") && XmlUtil.existNode((Node)servletNode, (String)"./init-param/param-name")) {
                    paramName = XmlUtil.getNode((Node)servletNode, (String)"./init-param/param-name").getFirstChild().getNodeValue();
                }
                if (!"".equals(paramName) && (contextParamList = XmlUtil.getNodeList((Node)rootNode, (String)"/web-app/context-param")) != null) {
                    int i = 0;
                    while (contextParamList.getLength() > i) {
                        Node context = contextParamList.item(i);
                        if (paramName.equals(XmlUtil.getNode((Node)context, (String)"./param-name").getFirstChild().getNodeValue())) {
                            return context;
                        }
                        ++i;
                    }
                }
            }
        }
        catch (Exception e) {
            CommngtLog.logError(e);
        }
        return null;
    }

    public static void modifyPom(IContainer container, String fname, InputStream content, IProgressMonitor monitor) {
        try {
            Node rootNode = XmlUtil.getRootNode((File)new File(container.getProject().getFile("pom.xml").getLocation().toOSString()));
            NodeList oriNodes = XmlUtil.getNodeList((Node)rootNode, (String)"/project/dependencies/dependency");
            File file = new File("pom.xml");
            FileOutputStream os = new FileOutputStream(file);
            byte[] buf = new byte[1024];
            int len = 0;
            while ((len = content.read(buf)) > 0) {
                ((OutputStream)os).write(buf, 0, len);
            }
            ((OutputStream)os).close();
            content.close();
            Node targetNode = XmlUtil.getRootNode((File)file);
            NodeList targetNodes = XmlUtil.getNodeList((Node)targetNode, (String)"/project/dependencies/dependency");
            String comment = "";
            if (targetNodes != null) {
                int i = 0;
                while (targetNodes.getLength() > i) {
                    Node targetDependency = targetNodes.item(i);
                    Node targetArtifactId = XmlUtil.getNode((Node)targetDependency, (String)"./artifactId");
                    Node targetVersion = XmlUtil.getNode((Node)targetDependency, (String)"./version");
                    boolean noExist = true;
                    int j = 0;
                    while (oriNodes.getLength() > j) {
                        Node oriDependency = oriNodes.item(j);
                        Node oriArtifactId = XmlUtil.getNode((Node)oriDependency, (String)"./artifactId");
                        if (oriArtifactId != null && targetArtifactId != null && oriArtifactId.getFirstChild().getNodeValue().equals(targetArtifactId.getFirstChild().getNodeValue())) {
                            noExist = false;
                            Node oriVersion = XmlUtil.getNode((Node)oriDependency, (String)"./version");
                            if (oriVersion != null && targetVersion != null && !oriVersion.getFirstChild().getNodeValue().equals(targetVersion.getFirstChild().getNodeValue())) {
                                StringWriter sw = new StringWriter();
                                TransformerFactory tfFac = TransformerFactory.newInstance();
                                Transformer tf = tfFac.newTransformer();
                                tf.setOutputProperty("omit-xml-declaration", "yes");
                                tf.transform(new DOMSource(targetDependency), new StreamResult(sw));
                                comment = String.valueOf(comment) + "\n" + sw.toString() + "\n\n";
                                XmlUtil.addComment((Node)rootNode, (String)"/project", (String)comment, (String)"\n\t", (String)"\n\t");
                                comment = "";
                            }
                        }
                        ++j;
                    }
                    if (noExist) {
                        StringWriter sw = new StringWriter();
                        TransformerFactory tfFac = TransformerFactory.newInstance();
                        Transformer tf = tfFac.newTransformer();
                        tf.setOutputProperty("omit-xml-declaration", "yes");
                        tf.transform(new DOMSource(targetDependency), new StreamResult(sw));
                        String newNode = "\n\n" + sw.toString() + "\n\n";
                        XmlUtil.addNode((Node)rootNode, (String)"/project/dependencies", (String)newNode, (String)"\n\t", (String)"\n\t");
                    }
                    ++i;
                }
                IFile originf = container.getFile((IPath)new Path("pom.xml"));
                String xmlStr = XmlUtil.getXmlString((Node)rootNode, (String)"/");
                ByteArrayInputStream inStream = new ByteArrayInputStream(xmlStr.getBytes("UTF-8"));
                originf.setContents((InputStream)inStream, true, false, monitor);
            }
        }
        catch (Exception e) {
            CommngtLog.logError(e);
        }
    }

    public static String nodeToString(Node node) {
        String newNode = "";
        try {
            StringWriter sw = new StringWriter();
            TransformerFactory tfFac = TransformerFactory.newInstance();
            Transformer tf = tfFac.newTransformer();
            tf.setOutputProperty("omit-xml-declaration", "yes");
            tf.transform(new DOMSource(node), new StreamResult(sw));
            newNode = String.valueOf(newNode) + "\n\n" + sw.toString() + "\n\n";
        }
        catch (TransformerException e) {
            CommngtLog.logError(e);
        }
        return newNode;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean checkMessageSource(InputStream xmlFile) {
        try {
            Document doc = ComResourceUtils.makeDocument(xmlFile);
            Element rootNode = doc.getDocumentElement();
            NodeList beans = XmlUtil.getNodeList((Node)rootNode, (String)"/beans/bean");
            if (beans.getLength() <= 0) return false;
            int i = 0;
            while (true) {
                if (beans.getLength() <= i) {
                    return false;
                }
                if (XmlUtil.existNode((Node)beans.item(i), (String)"./@id") && "messageSource".equals(XmlUtil.getNode((Node)beans.item(i), (String)"./@id").getNodeValue())) {
                    return true;
                }
                ++i;
            }
        }
        catch (Exception e) {
            CommngtLog.logError(e);
        }
        return false;
    }

    public static boolean modifyMessageSource(final IContainer container, final String fname, InputStream content, final IProgressMonitor monitor) throws CoreException {
        asIsCommonExist = false;
        boolean beanExist = false;
        final Document doc = ComResourceUtils.makeDocument(content);
        try {
            Element rootNode = doc.getDocumentElement();
            NodeList beans = XmlUtil.getNodeList((Node)rootNode, (String)"/beans/bean");
            if (beans.getLength() > 0) {
                int i = 0;
                while (beans.getLength() > i) {
                    if (XmlUtil.existNode((Node)beans.item(i), (String)"./@id") && "messageSource".equals(XmlUtil.getNode((Node)beans.item(i), (String)"./@id").getNodeValue())) {
                        beanExist = true;
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            CommngtLog.logError(e);
        }
        if (beanExist) {
            final IContainer realContainer = container.getProject().getParent();
            container.getProject().accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    boolean nextWork = true;
                    if (resource.getType() == 1 && resource.getName().endsWith(".xml") && resource.getName().toUpperCase().indexOf("SQL") == -1 && resource.getFullPath().toOSString().indexOf("\\classes\\") == -1) {
                        try {
                            DocumentBuilderFactory docBF = DocumentBuilderFactory.newInstance();
                            docBF.setValidating(false);
                            docBF.setNamespaceAware(false);
                            docBF.setFeature("http://xml.org/sax/features/validation", false);
                            docBF.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
                            docBF.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                            docBF.setFeature("http://xml.org/sax/features/external-general-entities", false);
                            docBF.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                            DocumentBuilder docBuilder = docBF.newDocumentBuilder();
                            IFile file = realContainer.getFile(resource.getFullPath());
                            Node messageNode = null;
                            if (file.isAccessible()) {
                                NodeList beanList;
                                Document targetDoc = docBuilder.parse(new InputSource(file.getContents()));
                                Element targetRootNode = targetDoc.getDocumentElement();
                                Document newDoc = doc;
                                Element newRootNode = newDoc.getDocumentElement();
                                if (XmlUtil.existNode((Node)targetRootNode, (String)"/beans/bean") && (beanList = XmlUtil.getNodeList((Node)targetRootNode, (String)"/beans/bean")).getLength() > 0 && (messageNode = ComResourceUtils.findNodeById(beanList, "messageSource")) != null) {
                                    String value;
                                    asIsCommonExist = true;
                                    if (XmlUtil.existNode((Node)messageNode, (String)"./property[@name='basenames']/list/value")) {
                                        NodeList values = XmlUtil.getNodeList((Node)messageNode, (String)"./property[@name='basenames']/list/value");
                                        if (values != null && values.getLength() > 0) {
                                            String valuesToString = "";
                                            int v = 0;
                                            while (values.getLength() > v) {
                                                valuesToString = String.valueOf(valuesToString) + values.item(v).getFirstChild().getNodeValue() + ";;;";
                                                ++v;
                                            }
                                            NodeList newNodes = XmlUtil.getNodeList((Node)newRootNode, (String)"/beans/bean[@id='messageSource']/property[@name='basenames']/list/value");
                                            if (newNodes != null && newNodes.getLength() > 0) {
                                                int n = 0;
                                                while (newNodes.getLength() > n) {
                                                    if (valuesToString.indexOf(newNodes.item(n).getFirstChild().getNodeValue()) == -1) {
                                                        XmlUtil.addNode((Node)messageNode, (String)"./property[@name='basenames']/list", (String)("<value>" + newNodes.item(n).getFirstChild().getNodeValue() + "</value>"), (String)"\t\t\t\t", (String)"\n");
                                                        valuesToString = String.valueOf(valuesToString) + newNodes.item(n).getFirstChild().getNodeValue() + ";;;";
                                                    }
                                                    ++n;
                                                }
                                            }
                                        }
                                        XmlUtil.removeNode((Node)newRootNode, (String)"/beans/bean[@id='messageSource']");
                                    } else if (XmlUtil.existNode((Node)messageNode, (String)"./property[@name='basename']/value") && !"".equals(value = XmlUtil.getNode((Node)messageNode, (String)"./property[@name='basename']/value").getFirstChild().getNodeValue())) {
                                        String newValues = XmlUtil.getXmlString((Node)newRootNode, (String)"/beans/bean[@id='messageSource']/property[@name='basenames']");
                                        if (newValues.indexOf(value) > -1) {
                                            XmlUtil.removeNode((Node)targetRootNode, (String)"/beans/bean[@id='messageSource']/property[@name='basename']");
                                            XmlUtil.addNode((Node)targetRootNode, (String)"/beans/bean[@id='messageSource']", (String)newValues, (String)"\t\t\t\t", (String)"\n");
                                        } else {
                                            XmlUtil.removeNode((Node)targetRootNode, (String)"/beans/bean[@id='messageSource']/property[@name='basename']");
                                            XmlUtil.addNode((Node)targetRootNode, (String)"/beans/bean[@id='messageSource']", (String)newValues, (String)"\t\t\t\t", (String)"\n");
                                            XmlUtil.addNode((Node)targetRootNode, (String)"/beans/bean[@id='messageSource']/property[@name='basenames']/list", (String)("<value>" + value + "</value>"), (String)"\t\t\t\t", (String)"\n");
                                        }
                                        XmlUtil.removeNode((Node)newRootNode, (String)"/beans/bean[@id='messageSource']");
                                    }
                                    file.getFullPath().toOSString();
                                    String xmlStr = XmlUtil.getXmlString((Node)targetRootNode, (String)"/");
                                    ByteArrayInputStream inStream = new ByteArrayInputStream(xmlStr.getBytes("UTF-8"));
                                    file.setContents((InputStream)inStream, true, false, monitor);
                                    if (resource.getFullPath().toString().indexOf(fname) <= -1) {
                                        String newXmlStr = XmlUtil.getXmlString((Node)newRootNode, (String)"/");
                                        ByteArrayInputStream newInStream = new ByteArrayInputStream(newXmlStr.getBytes("UTF-8"));
                                        ResourceUtils.createFolderFile((IContainer)container, (String)fname, (InputStream)newInStream, (IProgressMonitor)monitor);
                                    }
                                    nextWork = false;
                                }
                            }
                        }
                        catch (Exception e) {
                            CommngtLog.logError(e);
                        }
                    }
                    return nextWork;
                }
            });
        }
        return asIsCommonExist;
    }

    public static boolean modifyLeaverTraceSource(final IContainer container, final String fname, InputStream content, final IProgressMonitor monitor, final boolean newComp) throws CoreException {
        leaverTraceExist = false;
        boolean beanExist = false;
        final Document doc = ComResourceUtils.makeDocument(content);
        try {
            Element rootNode = doc.getDocumentElement();
            NodeList beans = XmlUtil.getNodeList((Node)rootNode, (String)"/beans/bean");
            if (beans.getLength() > 0) {
                int i = 0;
                while (beans.getLength() > i) {
                    if (XmlUtil.existNode((Node)beans.item(i), (String)"./@id") && "leaveaTrace".equals(XmlUtil.getNode((Node)beans.item(i), (String)"./@id").getNodeValue())) {
                        beanExist = true;
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            CommngtLog.logError(e);
        }
        if (beanExist) {
            final IContainer realContainer = container.getProject().getParent();
            container.getProject().accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    boolean nextWork = true;
                    if (resource.getType() == 1 && resource.getName().endsWith(".xml") && resource.getName().toUpperCase().indexOf("SQL") == -1 && resource.getFullPath().toOSString().indexOf("\\classes\\") == -1) {
                        try {
                            DocumentBuilderFactory docBF = DocumentBuilderFactory.newInstance();
                            docBF.setValidating(false);
                            docBF.setNamespaceAware(false);
                            docBF.setFeature("http://xml.org/sax/features/validation", false);
                            docBF.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
                            docBF.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                            docBF.setFeature("http://xml.org/sax/features/external-general-entities", false);
                            docBF.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                            DocumentBuilder docBuilder = docBF.newDocumentBuilder();
                            IFile file = realContainer.getFile(resource.getFullPath());
                            Node leaveaNode = null;
                            if (file.isAccessible()) {
                                NodeList beanList;
                                Document targetDoc = docBuilder.parse(new InputSource(file.getContents()));
                                Element targetRootNode = targetDoc.getDocumentElement();
                                Document newDoc = doc;
                                Element newRootNode = newDoc.getDocumentElement();
                                if (XmlUtil.existNode((Node)targetRootNode, (String)"/beans/bean") && (beanList = XmlUtil.getNodeList((Node)targetRootNode, (String)"/beans/bean")).getLength() > 0 && (leaveaNode = ComResourceUtils.findNodeById(beanList, "leaveaTrace")) != null) {
                                    leaverTraceExist = true;
                                    if (XmlUtil.existNode((Node)targetRootNode, (String)"/beans/bean[@id='leaveaTrace']/property/list/ref")) {
                                        NodeList values = XmlUtil.getNodeList((Node)targetRootNode, (String)"/beans/bean[@id='leaveaTrace']/property/list/ref");
                                        if (values != null && values.getLength() > 0) {
                                            String valuesToString = "";
                                            int v = 0;
                                            while (values.getLength() > v) {
                                                valuesToString = String.valueOf(valuesToString) + XmlUtil.getNode((Node)values.item(v), (String)"./@bean").getNodeValue() + ";;;";
                                                ++v;
                                            }
                                            NodeList newNodes = XmlUtil.getNodeList((Node)newRootNode, (String)"/beans/bean[@id='leaveaTrace']/property/list/ref");
                                            if (newNodes != null && newNodes.getLength() > 0) {
                                                int n = 0;
                                                while (newNodes.getLength() > n) {
                                                    if (valuesToString.indexOf(XmlUtil.getNode((Node)newNodes.item(n), (String)"./@bean").getNodeValue()) == -1) {
                                                        XmlUtil.addNode((Node)targetRootNode, (String)"/beans/bean[@id='leaveaTrace']/property/list", (String)("<ref bean=\"" + XmlUtil.getNode((Node)newNodes.item(n), (String)"./@bean").getNodeValue() + "\"/>"), (String)"\t\t\t\t", (String)"\n");
                                                        valuesToString = String.valueOf(valuesToString) + XmlUtil.getNode((Node)newNodes.item(n), (String)"./@bean").getNodeValue() + ";;;";
                                                    }
                                                    ++n;
                                                }
                                            }
                                        }
                                        XmlUtil.removeNode((Node)newRootNode, (String)"/beans/bean[@id='leaveaTrace']");
                                    }
                                    if (newComp) {
                                        XmlUtil.removeNode((Node)newRootNode, (String)"/beans/bean[@id='messageSource']");
                                    }
                                    String xmlStr = XmlUtil.getXmlString((Node)targetRootNode, (String)"/");
                                    ByteArrayInputStream inStream = new ByteArrayInputStream(xmlStr.getBytes("UTF-8"));
                                    file.setContents((InputStream)inStream, true, false, monitor);
                                    if (resource.getFullPath().toString().indexOf(fname) <= -1) {
                                        String newXmlStr = XmlUtil.getXmlString((Node)newRootNode, (String)"/");
                                        ByteArrayInputStream newInStream = new ByteArrayInputStream(newXmlStr.getBytes("UTF-8"));
                                        ResourceUtils.createFolderFile((IContainer)container, (String)fname, (InputStream)newInStream, (IProgressMonitor)monitor);
                                    }
                                    nextWork = false;
                                }
                            }
                        }
                        catch (Exception e) {
                            CommngtLog.logError(e);
                        }
                    }
                    return nextWork;
                }
            });
        }
        return leaverTraceExist;
    }

    public static boolean copyValidator(final IContainer container, final String fname, InputStream content, final IProgressMonitor monitor, ComResourceUtilVO comVo) throws CoreException {
        boolean beanExist = false;
        final Document doc = ComResourceUtils.makeDocument(content);
        try {
            Element rootNode = doc.getDocumentElement();
            NodeList beans = XmlUtil.getNodeList((Node)rootNode, (String)"/beans/bean");
            if (beans.getLength() > 0) {
                int i = 0;
                while (beans.getLength() > i) {
                    if (XmlUtil.existNode((Node)beans.item(i), (String)"./@id") && "validatorFactory".equals(XmlUtil.getNode((Node)beans.item(i), (String)"./@id").getNodeValue())) {
                        beanExist = true;
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            CommngtLog.logError(e);
        }
        final ComResourceUtilVO vo = comVo;
        if (beanExist) {
            final IContainer realContainer = container.getProject().getParent();
            container.getProject().accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    boolean nextWork = true;
                    String contextLocation = vo.getContextUrlLocation();
                    boolean isLocation = false;
                    if (contextLocation != null) {
                        contextLocation = contextLocation.replaceAll(" ", "");
                        contextLocation = contextLocation.replaceAll("\\*", "");
                        contextLocation = contextLocation.replaceAll(".xml", "");
                        contextLocation = contextLocation.replaceAll("\t", "");
                        contextLocation = contextLocation.replaceAll("\n", "");
                        contextLocation = contextLocation.replaceAll("/", "\\\\");
                        contextLocation = contextLocation.replaceAll("classpath:", "");
                        String[] context = contextLocation.split(",");
                        int i = 0;
                        while (context.length > i) {
                            if (resource.getFullPath().toOSString().indexOf(context[i]) > -1) {
                                isLocation = true;
                            }
                            ++i;
                        }
                    }
                    if (resource.getType() == 1 && resource.getName().endsWith(".xml") && resource.getName().toUpperCase().indexOf("SQL") == -1 && resource.getFullPath().toOSString().indexOf("\\classes\\") == -1 && isLocation) {
                        try {
                            DocumentBuilderFactory docBF = DocumentBuilderFactory.newInstance();
                            docBF.setValidating(false);
                            docBF.setNamespaceAware(false);
                            docBF.setFeature("http://xml.org/sax/features/validation", false);
                            docBF.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
                            docBF.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                            docBF.setFeature("http://xml.org/sax/features/external-general-entities", false);
                            docBF.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                            DocumentBuilder docBuilder = docBF.newDocumentBuilder();
                            IFile file = realContainer.getFile(resource.getFullPath());
                            Node leaveaNode = null;
                            if (file.isAccessible()) {
                                NodeList beanList;
                                Document targetDoc = docBuilder.parse(new InputSource(file.getContents()));
                                Element targetRootNode = targetDoc.getDocumentElement();
                                Document newDoc = doc;
                                Element newRootNode = newDoc.getDocumentElement();
                                if (XmlUtil.existNode((Node)targetRootNode, (String)"/beans/bean") && (beanList = XmlUtil.getNodeList((Node)targetRootNode, (String)"/beans/bean")).getLength() > 0 && (leaveaNode = ComResourceUtils.findNodeById(beanList, "validatorFactory")) != null) {
                                    if (XmlUtil.existNode((Node)targetRootNode, (String)"/beans/bean[@id='validatorFactory']/property/list/value")) {
                                        NodeList values = XmlUtil.getNodeList((Node)targetRootNode, (String)"/beans/bean[@id='validatorFactory']/property/list/value");
                                        if (values != null && values.getLength() > 0) {
                                            String valuesToString = "";
                                            int v = 0;
                                            while (values.getLength() > v) {
                                                valuesToString = String.valueOf(valuesToString) + values.item(v).getFirstChild().getNodeValue() + ";;;";
                                                ++v;
                                            }
                                            NodeList newNodes = XmlUtil.getNodeList((Node)newRootNode, (String)"/beans/bean[@id='validatorFactory']/property/list/value");
                                            if (newNodes != null && newNodes.getLength() > 0) {
                                                int n = 0;
                                                while (newNodes.getLength() > n) {
                                                    if (valuesToString.indexOf(newNodes.item(n).getFirstChild().getNodeValue()) == -1) {
                                                        XmlUtil.addNode((Node)targetRootNode, (String)"/beans/bean[@id='validatorFactory']/property/list", (String)("<value>" + newNodes.item(n).getFirstChild().getNodeValue() + "</value>"), (String)"\t\t\t\t", (String)"\n");
                                                        valuesToString = String.valueOf(valuesToString) + newNodes.item(n).getFirstChild().getNodeValue() + ";;;";
                                                    }
                                                    ++n;
                                                }
                                            }
                                        }
                                        XmlUtil.removeNode((Node)newRootNode, (String)"/beans/bean[@id='validatorFactory']");
                                        XmlUtil.removeNode((Node)newRootNode, (String)"/beans/bean[@id='beanValidator']");
                                    }
                                    modifyValidator = true;
                                    String xmlStr = XmlUtil.getXmlString((Node)targetRootNode, (String)"/");
                                    ByteArrayInputStream inStream = new ByteArrayInputStream(xmlStr.getBytes("UTF-8"));
                                    file.setContents((InputStream)inStream, true, false, monitor);
                                    if (resource.getFullPath().toString().indexOf(fname) <= -1) {
                                        String newXmlStr = XmlUtil.getXmlString((Node)newRootNode, (String)"/");
                                        ByteArrayInputStream newInStream = new ByteArrayInputStream(newXmlStr.getBytes("UTF-8"));
                                        ResourceUtils.createFolderFile((IContainer)container, (String)fname, (InputStream)newInStream, (IProgressMonitor)monitor);
                                    }
                                    nextWork = false;
                                }
                            }
                        }
                        catch (Exception e) {
                            CommngtLog.logError(e);
                        }
                    }
                    return nextWork;
                }
            });
        }
        return modifyValidator;
    }

    public static Node findNodeById(NodeList nodeList, String id) throws Exception {
        Node node = null;
        if (nodeList.getLength() > 0) {
            int i = 0;
            while (nodeList.getLength() > i) {
                node = nodeList.item(i);
                if (XmlUtil.existNode((Node)node, (String)"./@id") && id.equals(XmlUtil.getNode((Node)node, (String)"./@id").getNodeValue())) {
                    return node;
                }
                ++i;
            }
        }
        return null;
    }

    public static boolean checkServletMapping(Node rootNode) {
        boolean servletExist = false;
        try {
            if (XmlUtil.existNode((Node)rootNode, (String)"/web-app") && XmlUtil.existNode((Node)rootNode, (String)"/web-app/servlet") && XmlUtil.existNode((Node)rootNode, (String)"/web-app/servlet-mapping")) {
                servletExist = true;
            }
        }
        catch (Exception e) {
            CommngtLog.logError(e);
        }
        return servletExist;
    }

    public static String getCurrentTime() {
        String curT = "";
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd", new Locale(System.getProperty("user.language")));
        Calendar cal = Calendar.getInstance();
        curT = format.format(cal.getTime());
        return curT;
    }

    public static Node changeDuplicateServletNode(Node rootNode, Node servletNode) {
        try {
            String existedServlet = "";
            NodeList servletList = XmlUtil.getNodeList((Node)rootNode, (String)"/web-app/servlet/servlet-name");
            if (servletList.getLength() > 0) {
                int i = 0;
                while (servletList.getLength() > i) {
                    existedServlet = String.valueOf(existedServlet) + servletList.item(i).getFirstChild().getNodeValue() + ";;;";
                    ++i;
                }
            }
            String servletName = XmlUtil.getNode((Node)servletNode, (String)"./servlet-name").getFirstChild().getNodeValue();
            boolean servletExist = false;
            while (!servletExist) {
                if (existedServlet != null && existedServlet.indexOf(servletName) > -1) {
                    servletName = String.valueOf(servletName) + "_1";
                    continue;
                }
                XmlUtil.getNode((Node)servletNode, (String)"./servlet-name").getFirstChild().setNodeValue(servletName);
                servletExist = true;
            }
        }
        catch (Exception e) {
            CommngtLog.logError(e);
        }
        return servletNode;
    }

    public static Node changeDuplicateServletMappingNode(Node rootNode, Node servletMappingNode) {
        try {
            String existedServlet = "";
            NodeList servletList = XmlUtil.getNodeList((Node)rootNode, (String)"/web-app/servlet-mapping/servlet-name");
            if (servletList.getLength() > 0) {
                int i = 0;
                while (servletList.getLength() > i) {
                    existedServlet = String.valueOf(existedServlet) + servletList.item(i).getFirstChild().getNodeValue() + ";;;";
                    ++i;
                }
            }
            String servletName = XmlUtil.getNode((Node)servletMappingNode, (String)"./servlet-name").getFirstChild().getNodeValue();
            boolean servletExist = false;
            while (!servletExist) {
                if (existedServlet != null && existedServlet.indexOf(servletName) > -1) {
                    servletName = String.valueOf(servletName) + "_1";
                    continue;
                }
                XmlUtil.getNode((Node)servletMappingNode, (String)"./servlet-name").getFirstChild().setNodeValue(servletName);
                servletExist = true;
            }
        }
        catch (Exception e) {
            CommngtLog.logError(e);
        }
        return servletMappingNode;
    }

    public static ComResourceUtilVO getDispatcherAndContextLocation(IJavaProject project) {
        final IContainer realContainer = project.getProject().getParent();
        final ComResourceUtilVO comVo = new ComResourceUtilVO();
        try {
            project.getProject().accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    boolean nextWork = true;
                    if (resource.getType() == 1 && resource.getName().equals("web.xml")) {
                        try {
                            DocumentBuilderFactory docBF = DocumentBuilderFactory.newInstance();
                            docBF.setValidating(false);
                            docBF.setNamespaceAware(false);
                            docBF.setFeature("http://xml.org/sax/features/validation", false);
                            docBF.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
                            docBF.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                            docBF.setFeature("http://xml.org/sax/features/external-general-entities", false);
                            docBF.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                            DocumentBuilder docBuilder = docBF.newDocumentBuilder();
                            IFile file = realContainer.getFile(resource.getFullPath());
                            if (file.isAccessible()) {
                                String doPattern;
                                Document targetDoc = docBuilder.parse(new InputSource(file.getContents()));
                                Element targetRootNode = targetDoc.getDocumentElement();
                                Node servletNode = ComResourceUtils.getServlet(targetRootNode, doPattern = "*.do");
                                if (servletNode != null) {
                                    String dispaterUrlPattern = XmlUtil.getNode((Node)servletNode, (String)"./init-param/param-value").getFirstChild().getNodeValue();
                                    comVo.setUrlLocation(dispaterUrlPattern);
                                }
                                String contextUrlPattern = null;
                                if (XmlUtil.existNode((Node)targetRootNode, (String)"/web-app/context-param/param-value")) {
                                    contextUrlPattern = XmlUtil.getNode((Node)targetRootNode, (String)"/web-app/context-param/param-value").getFirstChild().getNodeValue();
                                }
                                comVo.setContextUrlLocation(contextUrlPattern);
                                nextWork = false;
                            }
                        }
                        catch (Exception e) {
                            CommngtLog.logError(e);
                        }
                    }
                    return nextWork;
                }
            });
        }
        catch (CoreException e) {
            CommngtLog.logError(e);
        }
        return comVo;
    }

    public static ComResourceUtilVO getDispatcherPrefixLocation(IJavaProject project, ComResourceUtilVO vo) {
        final IContainer realContainer = project.getProject().getParent();
        final ComResourceUtilVO comVo = new ComResourceUtilVO();
        String dispatcherLocation = null;
        if (vo != null && vo.getUrlLocation() != null) {
            dispatcherLocation = vo.getUrlLocation().replaceAll(" ", "");
            dispatcherLocation = dispatcherLocation.replaceAll("\\*", "");
            dispatcherLocation = dispatcherLocation.replaceAll(".xml", "");
            dispatcherLocation = dispatcherLocation.replaceAll("\t", "");
            dispatcherLocation = dispatcherLocation.replaceAll("\n", "");
            dispatcherLocation = dispatcherLocation.replaceAll("/", "\\\\");
            comVo.setLocationPattern(dispatcherLocation.split(","));
            try {
                project.getProject().accept(new IResourceVisitor(){

                    public boolean visit(IResource resource) throws CoreException {
                        boolean nextWork;
                        block10: {
                            nextWork = true;
                            String[] dispatcherLocationPattern = comVo.getLocationPattern();
                            if (resource.getType() == 1 && resource.getName().endsWith(".xml")) {
                                boolean isDiapatcher = false;
                                int i = 0;
                                while (dispatcherLocationPattern.length > i) {
                                    if (resource.getFullPath().toOSString().indexOf(dispatcherLocationPattern[i]) > -1) {
                                        isDiapatcher = true;
                                    }
                                    ++i;
                                }
                                if (isDiapatcher) {
                                    try {
                                        DocumentBuilderFactory docBF = DocumentBuilderFactory.newInstance();
                                        docBF.setValidating(false);
                                        docBF.setNamespaceAware(false);
                                        docBF.setFeature("http://xml.org/sax/features/validation", false);
                                        docBF.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
                                        docBF.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                                        docBF.setFeature("http://xml.org/sax/features/external-general-entities", false);
                                        docBF.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                                        DocumentBuilder docBuilder = docBF.newDocumentBuilder();
                                        IFile file = realContainer.getFile(resource.getFullPath());
                                        if (!file.isAccessible()) break block10;
                                        Document targetDoc = docBuilder.parse(new InputSource(file.getContents()));
                                        Element targetRootNode = targetDoc.getDocumentElement();
                                        String propertyPattern = "prefix";
                                        NodeList beanNodes = XmlUtil.getNodeList((Node)targetRootNode, (String)"/beans/bean");
                                        if (beanNodes != null && beanNodes.getLength() > 0) {
                                            int j = 0;
                                            while (beanNodes.getLength() > j) {
                                                if (XmlUtil.existNode((Node)beanNodes.item(j), (String)("./@" + propertyPattern))) {
                                                    comVo.setPrefixPattern(XmlUtil.getNode((Node)beanNodes.item(j), (String)("./@" + propertyPattern)).getNodeValue());
                                                    nextWork = false;
                                                }
                                                ++j;
                                            }
                                        }
                                    }
                                    catch (Exception e) {
                                        CommngtLog.logError(e);
                                    }
                                } else {
                                    return nextWork;
                                }
                            }
                        }
                        return nextWork;
                    }
                });
            }
            catch (CoreException e) {
                CommngtLog.logError(e);
            }
        }
        return comVo;
    }

    public static ComResourceUtilVO checkExistBean(IJavaProject project, ComResourceUtilVO vo) {
        final IContainer realContainer = project.getProject().getParent();
        final ComResourceUtilVO comVo = vo;
        comVo.setExistBean(false);
        String urlLocation = null;
        if (vo != null && vo.getUrlLocation() != null) {
            urlLocation = vo.getUrlLocation().replaceAll(" ", "");
            urlLocation = urlLocation.replaceAll("\\*", "");
            urlLocation = urlLocation.replaceAll(".xml", "");
            urlLocation = urlLocation.replaceAll("\t", "");
            urlLocation = urlLocation.replaceAll("\n", "");
            urlLocation = urlLocation.replaceAll("/", "\\\\");
            urlLocation = urlLocation.replaceAll("classpath:", "");
            comVo.setLocationPattern(urlLocation.split(","));
            try {
                project.getProject().accept(new IResourceVisitor(){

                    public boolean visit(IResource resource) throws CoreException {
                        boolean nextWork = true;
                        String[] dispatcherLocationPattern = comVo.getLocationPattern();
                        if (resource.getType() == 1 && resource.getName().endsWith(".xml")) {
                            boolean isLocation = false;
                            int i = 0;
                            while (dispatcherLocationPattern.length > i) {
                                if (resource.getFullPath().toOSString().indexOf(dispatcherLocationPattern[i]) > -1) {
                                    isLocation = true;
                                }
                                ++i;
                            }
                            if (isLocation) {
                                try {
                                    Document targetDoc;
                                    Element targetRootNode;
                                    DocumentBuilderFactory docBF = DocumentBuilderFactory.newInstance();
                                    docBF.setValidating(false);
                                    docBF.setNamespaceAware(false);
                                    docBF.setFeature("http://xml.org/sax/features/validation", false);
                                    docBF.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
                                    docBF.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                                    docBF.setFeature("http://xml.org/sax/features/external-general-entities", false);
                                    docBF.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                                    DocumentBuilder docBuilder = docBF.newDocumentBuilder();
                                    IFile file = realContainer.getFile(resource.getFullPath());
                                    if (file.isAccessible() && XmlUtil.existNode((Node)(targetRootNode = (targetDoc = docBuilder.parse(new InputSource(file.getContents()))).getDocumentElement()), (String)comVo.getNodeXpath())) {
                                        comVo.setExistBean(true);
                                        comVo.setAsIsRootNode(targetRootNode);
                                        nextWork = false;
                                    }
                                }
                                catch (Exception e) {
                                    CommngtLog.logError(e);
                                }
                            } else {
                                return nextWork;
                            }
                        }
                        return nextWork;
                    }
                });
            }
            catch (CoreException e) {
                CommngtLog.logError(e);
            }
        }
        return comVo;
    }

    public static void copyDispatcherServletFile(NewEgovCommngtContext context, IContainer container, String fname, InputStream content, IProgressMonitor monitor, ComResourceUtilVO comVo) throws CoreException {
        try {
            Node node;
            int i;
            Document doc = ComResourceUtils.makeDocument(content);
            Element rootNode = doc.getDocumentElement();
            comVo.setNodeXpath("/beans/bean/property[@name='exceptionMappings']");
            ComResourceUtilVO vo = ComResourceUtils.checkExistBean(context.getJavaProject(), comVo);
            NodeList nodeList = XmlUtil.getNodeList((Node)rootNode, (String)"/beans/bean");
            if (vo.isExistBean() && nodeList.getLength() > 0) {
                i = 0;
                while (nodeList.getLength() > i) {
                    node = nodeList.item(i);
                    if (XmlUtil.existNode((Node)node, (String)"./property[@name='exceptionMappings']")) {
                        XmlUtil.removeNode((Node)node, (String)".");
                    }
                    ++i;
                }
            }
            comVo.setNodeXpath("/beans/bean/property[@name='webBindingInitializer']");
            vo = ComResourceUtils.checkExistBean(context.getJavaProject(), comVo);
            nodeList = XmlUtil.getNodeList((Node)rootNode, (String)"/beans/bean");
            if (vo.isExistBean() && nodeList.getLength() > 0) {
                i = 0;
                while (nodeList.getLength() > i) {
                    node = nodeList.item(i);
                    if (XmlUtil.existNode((Node)node, (String)"./property[@name='webBindingInitializer']")) {
                        XmlUtil.removeNode((Node)node, (String)".");
                    }
                    ++i;
                }
            }
            comVo.setNodeXpath("/beans/bean/@prefix");
            vo = ComResourceUtils.checkExistBean(context.getJavaProject(), comVo);
            nodeList = XmlUtil.getNodeList((Node)rootNode, (String)"/beans/bean");
            if (vo.isExistBean() && nodeList.getLength() > 0) {
                i = 0;
                while (nodeList.getLength() > i) {
                    node = nodeList.item(i);
                    if (XmlUtil.existNode((Node)node, (String)"./@prefix")) {
                        XmlUtil.removeNode((Node)node, (String)".");
                    }
                    ++i;
                }
            }
            String newXmlStr = XmlUtil.getXmlString((Node)rootNode, (String)"/");
            ByteArrayInputStream newInStream = new ByteArrayInputStream(newXmlStr.getBytes("UTF-8"));
            ResourceUtils.createFolderFile((IContainer)container, (String)fname, (InputStream)newInStream, (IProgressMonitor)monitor);
        }
        catch (Exception e) {
            CommngtLog.logError(e);
        }
    }
}

