/*
 * Decompiled with CFR 0.152.
 */
package egovframework.dev.imp.commngt.util;

import egovframework.dev.imp.commngt.EgovCommngtPlugin;
import egovframework.dev.imp.commngt.common.CommngtLog;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import org.apache.commons.io.IOUtils;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;

public class FindingScriptinZipUtil {
    public static HashMap<String, String> getScriptFileinZip(IProgressMonitor monitor, String fileName, String dbType) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        URL insetUrl = EgovCommngtPlugin.getDefault().getBundle().getEntry(fileName);
        try {
            URL url = FileLocator.toFileURL((URL)insetUrl);
            URL resolvedUrl = FileLocator.resolve((URL)url);
            File inputZipFile = new File(resolvedUrl.getFile());
            ZipFile zipFile = new ZipFile(inputZipFile);
            Enumeration enumeration = zipFile.getEntries();
            while (enumeration.hasMoreElements()) {
                InputStream inputStream;
                ZipEntry entry = (ZipEntry)enumeration.nextElement();
                String name = entry.getName();
                if (entry.isDirectory()) continue;
                if (name.indexOf("_insert_") > -1 && name.endsWith(".sql") && name.indexOf(dbType) > -1) {
                    inputStream = zipFile.getInputStream(entry);
                    String insertInputStream = IOUtils.toString((InputStream)inputStream, (String)"UTF-8");
                    hashMap.put("insert", insertInputStream);
                    continue;
                }
                if (name.indexOf("_create_") <= -1 || !name.endsWith(".sql") || name.indexOf(dbType) <= -1) continue;
                inputStream = zipFile.getInputStream(entry);
                String createInputStream = IOUtils.toString((InputStream)inputStream, (String)"UTF-8");
                hashMap.put("create", createInputStream);
            }
        }
        catch (IOException ie) {
            CommngtLog.logError(ie);
        }
        catch (Exception e) {
            CommngtLog.logError(e);
        }
        return hashMap;
    }

    public static InputStream createPropertiesFileinZip(IProgressMonitor monitor, String fileName) {
        InputStream inputStream = null;
        URL insetUrl = EgovCommngtPlugin.getDefault().getBundle().getEntry(fileName);
        try {
            URL url = FileLocator.toFileURL((URL)insetUrl);
            URL resolvedUrl = FileLocator.resolve((URL)url);
            File inputZipFile = new File(resolvedUrl.getFile());
            ZipFile zipFile = new ZipFile(inputZipFile, "UTF-8");
            Enumeration enumeration = zipFile.getEntries();
            while (enumeration.hasMoreElements()) {
                ZipEntry entry = (ZipEntry)enumeration.nextElement();
                String name = entry.getName();
                if (entry.isDirectory() || name.indexOf("globals.properties") <= -1) continue;
                inputStream = zipFile.getInputStream(entry);
            }
        }
        catch (IOException e) {
            CommngtLog.logError(e);
        }
        return inputStream;
    }
}

