/*
 * Decompiled with CFR 0.152.
 */
package egovframework.dev.imp.commngt.wizards.model;

import egovframework.dev.imp.commngt.EgovCommngtPlugin;
import egovframework.dev.imp.commngt.common.ComMngtMessages;
import egovframework.dev.imp.commngt.common.CommngtLog;
import egovframework.dev.imp.commngt.common.EgovComponentsInfo;
import egovframework.dev.imp.commngt.wizards.model.Category;
import egovframework.dev.imp.commngt.wizards.model.Component;
import egovframework.dev.imp.commngt.wizards.model.IComponentElement;
import egovframework.dev.imp.core.utils.EgovJavaElementUtil;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaModelException;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public final class ComponentElementFactory {
    private List<IComponentElement> factory;
    private static ComponentElementFactory instance;

    private ComponentElementFactory() {
        try {
            this.initializeFactory();
        }
        catch (SecurityException e) {
            CommngtLog.logError(e);
        }
        catch (NoSuchFieldException e) {
            CommngtLog.logError(e);
        }
        catch (MalformedURLException e) {
            CommngtLog.logError(e);
        }
        catch (JDOMException e) {
            CommngtLog.logError(e);
        }
        catch (IOException e) {
            CommngtLog.logError(e);
        }
        catch (InstantiationException e) {
            CommngtLog.logError(e);
        }
        catch (IllegalAccessException e) {
            CommngtLog.logError(e);
        }
    }

    public static ComponentElementFactory getInstance() {
        if (instance == null) {
            instance = new ComponentElementFactory();
        }
        return instance;
    }

    private void initializeFactory() throws MalformedURLException, JDOMException, IOException, SecurityException, NoSuchFieldException, InstantiationException, IllegalAccessException {
        SAXBuilder builder = new SAXBuilder();
        Document doc = builder.build(FileLocator.toFileURL((URL)EgovCommngtPlugin.getDefault().getBundle().getEntry(ComMngtMessages.componentElementFactoryPath)));
        Element components = doc.getRootElement();
        List clist = components.getChildren("category");
        Class<EgovComponentsInfo> cls = EgovComponentsInfo.class;
        if (clist != null) {
            this.factory = new ArrayList<IComponentElement>();
            ArrayList<Component> totalComponent = new ArrayList<Component>();
            int idx = 0;
            while (idx < clist.size()) {
                Object curr = clist.get(idx);
                if (curr instanceof Element) {
                    Category cCategory = new Category();
                    Element category = (Element)curr;
                    cCategory.setName(this.getFieldValue(cls, category, "name", "attribute"));
                    cCategory.setDesc(this.getFieldValue(cls, category, "description", "attribute"));
                    cCategory.setChildren(this.getComponent(cls, category, totalComponent, this.getFieldValue(cls, category, "name", "attribute")));
                    this.factory.add(cCategory);
                }
                ++idx;
            }
        }
    }

    private String getFieldValue(Class<EgovComponentsInfo> c, Element e, String a, String flag) {
        try {
            Field f = this.getFieldInfo(c, e, a, flag);
            if (f != null) {
                return f.get(f).toString();
            }
        }
        catch (IllegalArgumentException e1) {
            CommngtLog.logError(e1);
        }
        catch (IllegalAccessException e1) {
            CommngtLog.logError(e1);
        }
        return "";
    }

    private Field getFieldInfo(Class<EgovComponentsInfo> c, Element e, String a, String flag) {
        try {
            if (flag.equals("attribute")) {
                if (e.getAttributeValue(a) != null && e.getAttributeValue(a) != "") {
                    return c.getField(e.getAttributeValue(a).replace("#", "").toString());
                }
            } else if (e.getChildText(a) != null && e.getChildText(a) != "") {
                return c.getField(e.getChildText(a).replace("#", "").toString());
            }
        }
        catch (SecurityException e1) {
            CommngtLog.logError(e1);
        }
        catch (NoSuchFieldException e1) {
            CommngtLog.logError(e1);
        }
        return null;
    }

    private String getFieldValueString(Class<EgovComponentsInfo> c, String a) {
        try {
            if (a != null && a != "") {
                return c.getField(a.replace("#", "").toString()).get(c.getField(a.replace("#", "").toString())).toString();
            }
        }
        catch (IllegalArgumentException e1) {
            CommngtLog.logError(e1);
        }
        catch (IllegalAccessException e1) {
            CommngtLog.logError(e1);
        }
        catch (SecurityException e1) {
            CommngtLog.logError(e1);
        }
        catch (NoSuchFieldException e1) {
            CommngtLog.logError(e1);
        }
        return "";
    }

    protected List<IComponentElement> getComponent(Class<EgovComponentsInfo> cls, Element category, List<Component> totalComponent, String catName) {
        ArrayList<IComponentElement> components = new ArrayList<IComponentElement>();
        List children = category.getChildren("component");
        if (children == null) {
            return null;
        }
        int idx = 0;
        while (idx < children.size()) {
            Element child = null;
            if (children.get(idx) instanceof Element) {
                child = (Element)children.get(idx);
                Component component = new Component();
                component.setPackageName(this.getFieldValue(cls, child, "packageName", "childText"));
                if (totalComponent.contains(component)) {
                    component = totalComponent.get(totalComponent.indexOf(component));
                } else {
                    totalComponent.add(component);
                }
                component.setName(this.getFieldValue(cls, child, "name", "attribute"));
                component.setDesc(this.getFieldValue(cls, child, "description", "childText"));
                component.setUseTable(this.getFieldValue(cls, child, "useTable", "childText"));
                component.setDependencyPackage(this.computeDependency(cls, child, totalComponent));
                component.setVersion(this.getFieldValue(cls, child, "version", "childText"));
                component.setParentName(catName);
                component.setWebExist(this.getFieldValue(cls, child, "webexist", "childText").equals("true"));
                component.setAddedOptions(this.getFieldValue(cls, child, "addedOptions", "childText").equals("true"));
                component.setFileName(String.valueOf(this.getFieldValue(cls, child, "packageName", "childText")) + "." + this.getFieldValue(cls, child, "version", "childText") + ".zip");
                components.add(component);
            }
            ++idx;
        }
        return components;
    }

    private List<Component> computeDependency(Class<EgovComponentsInfo> cls, Element element, List<Component> totalComponent) {
        ArrayList<Component> dependencyList = new ArrayList<Component>();
        List dependencyinfo = element.getChildren("dependencyPackage");
        if (dependencyinfo == null) {
            return null;
        }
        for (Object o : dependencyinfo) {
            if (!(o instanceof Element)) continue;
            Element dependency = (Element)o;
            String componentName = this.getFieldValueString(cls, dependency.getText());
            Component temp = new Component();
            temp.setPackageName(componentName);
            if (totalComponent.contains(temp)) {
                temp = totalComponent.get(totalComponent.indexOf(temp));
            }
            totalComponent.add(temp);
            dependencyList.add(temp);
        }
        return dependencyList;
    }

    public boolean isCreatedComponent(IJavaProject javaProject, String locationPath) {
        block5: {
            IPackageFragment compackage = EgovJavaElementUtil.findPackage((IJavaProject)javaProject, null, (String)locationPath.replace('.', '/'));
            if (compackage != null && compackage.exists()) break block5;
            return false;
        }
        try {
            IFile file;
            if (locationPath.contains("com.cmm") && !(file = javaProject.getProject().getFile((IPath)new Path("src/main/resources/egovframework/spring/com/context-common.xml"))).isAccessible()) {
                return false;
            }
        }
        catch (JavaModelException e) {
            CommngtLog.logError(e);
        }
        catch (CoreException e) {
            CommngtLog.logCoreError(e);
        }
        return true;
    }

    public void addElement(IComponentElement element) {
        this.factory.add(element);
    }

    public List<IComponentElement> getComponentElements() {
        return this.factory;
    }

    public void containsComponent(IJavaProject javaProject) {
        if (this.factory == null) {
            return;
        }
        for (IComponentElement element : this.factory) {
            List<IComponentElement> components;
            if (!(element instanceof Category) || (components = ((Category)element).getChildren()) == null) continue;
            for (IComponentElement component : components) {
                if (!(component instanceof Component)) continue;
                ((Component)component).setCreatedComponent(this.isCreatedComponent(javaProject, component.getPackageName()));
            }
        }
    }
}

