/*
 * Decompiled with CFR 0.152.
 */
package egovframework.dev.imp.commngt.wizards.pages;

import egovframework.dev.imp.commngt.common.ComMngtMessages;
import egovframework.dev.imp.commngt.common.CommngtLog;
import egovframework.dev.imp.commngt.wizards.model.NewEgovCommngtContext;
import egovframework.dev.imp.core.utils.EgovJavaElementUtil;
import egovframework.dev.imp.ide.natures.EgovNature;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class SelectTargetProjectPage
extends WizardPage
implements ModifyListener,
Listener {
    private Text containerText = null;
    private final NewEgovCommngtContext context;
    private ListViewer projectListViewer = null;
    private List<IProject> jpj = null;
    private final IJavaProject selectionProject;
    private final Listener projectNameModifyListener = new Listener(){

        public void handleEvent(Event e) {
            int i = SelectTargetProjectPage.this.projectListViewer.getList().indexOf(SelectTargetProjectPage.this.containerText.getText());
            if (i >= 0) {
                SelectTargetProjectPage.this.projectListViewer.getList().setSelection(i);
                SelectTargetProjectPage.this.setPageComplete(true);
                SelectTargetProjectPage.this.setErrorMessage(null);
                SelectTargetProjectPage.this.setMessage(null);
            } else {
                SelectTargetProjectPage.this.projectListViewer.getList().deselectAll();
                SelectTargetProjectPage.this.setPageComplete(false);
                SelectTargetProjectPage.this.setErrorMessage(ComMngtMessages.selectProjectPageerror2);
            }
        }
    };

    public SelectTargetProjectPage(String pageName, IJavaProject selectionProject, NewEgovCommngtContext context) {
        super(pageName);
        this.context = context;
        this.setTitle(ComMngtMessages.selectProjectPagepageTitle);
        this.setDescription(ComMngtMessages.selectProjectPagepageDescription);
        this.selectionProject = selectionProject;
    }

    public boolean isPageComplete() {
        return this.projectListViewer.getList().getSelectionIndex() >= 0;
    }

    public void modifyText(ModifyEvent e) {
        this.getWizard().getContainer().updateButtons();
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 2;
        layout.verticalSpacing = 6;
        this.createSelectProjectControls(container);
        this.containerText.addModifyListener((ModifyListener)this);
        this.setControl((Control)container);
        this.updatePageComplete();
    }

    public void createSelectProjectControls(Composite container) {
        GridData gridData1 = new GridData(768);
        gridData1.horizontalSpan = 2;
        Label label = new Label(container, 0);
        label.setText(ComMngtMessages.selectProjectPage0);
        label.setLayoutData((Object)gridData1);
        GridData gridData2 = new GridData(768);
        gridData2.horizontalSpan = 2;
        this.containerText = new Text(container, 2048);
        this.containerText.setLayoutData((Object)gridData2);
        this.containerText.addListener(24, this.projectNameModifyListener);
        GridData gridData3 = new GridData(768);
        gridData3.horizontalSpan = 2;
        gridData3.heightHint = 180;
        this.projectListViewer = new ListViewer(container, 2820);
        this.projectListViewer.setContentProvider((IContentProvider)new projectContentProvider());
        this.projectListViewer.setLabelProvider((IBaseLabelProvider)new projectLabelProvider());
        this.projectListViewer.addSelectionChangedListener((ISelectionChangedListener)new projectSelectionChangedListener());
        Object o = this.getProjectList();
        Label note = new Label(container, 129);
        note.setAlignment(128);
        note.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont"));
        GridData gd = new GridData();
        note.setText("Note:\n ");
        note.setLayoutData((Object)gd);
        Label label2 = new Label(container, 128);
        label2.setAlignment(128);
        if (o == null) {
            label2.setText(ComMngtMessages.selectProjectPage1);
            this.setPageComplete(false);
            this.setErrorMessage(ComMngtMessages.selectProjectPageerror1);
        } else {
            this.projectListViewer.setInput(o);
            this.setCurrentSelection(this.selectionProject);
            label2.setText(ComMngtMessages.selectProjectPage2);
        }
        this.projectListViewer.getList().setLayoutData((Object)gridData3);
        GridData gd2 = new GridData();
        label2.setLayoutData((Object)gd2);
    }

    private Object getProjectList() {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] projects = root.getProjects();
        this.jpj = new ArrayList<IProject>();
        int i = 0;
        while (i < projects.length) {
            try {
                if (EgovJavaElementUtil.isJavaProject((IProject)projects[i]) && EgovNature.isEgovNatureEnabled((IProject)projects[i])) {
                    this.jpj.add(projects[i].getProject());
                }
            }
            catch (CoreException e) {
                CommngtLog.logCoreError(e);
            }
            ++i;
        }
        if (this.jpj.size() > 0) {
            return this.jpj.toArray();
        }
        return null;
    }

    public void setCurrentSelection(IJavaProject selectionProject) {
        StructuredSelection sel = null;
        if (selectionProject != null) {
            for (IProject project : this.jpj) {
                if (!project.equals((Object)selectionProject.getProject())) continue;
                sel = new StructuredSelection((Object)selectionProject.getProject());
                this.projectListViewer.setSelection((ISelection)sel);
            }
        }
    }

    private void updatePageComplete() {
        this.setPageComplete(false);
        if (this.isPageComplete()) {
            return;
        }
        this.setPageComplete(true);
        this.setMessage(null);
        this.setErrorMessage(null);
    }

    public void handleEvent(Event event) {
    }

    private class projectContentProvider
    implements IStructuredContentProvider {
        private projectContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            return (Object[])inputElement;
        }
    }

    private class projectLabelProvider
    extends LabelProvider {
        private projectLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof IProject) {
                return ((IProject)element).getName();
            }
            return null;
        }
    }

    private class projectSelectionChangedListener
    implements ISelectionChangedListener {
        private projectSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            Object selected = selection.getFirstElement();
            if (selected != null) {
                IProject pj = (IProject)selected;
                SelectTargetProjectPage.this.context.setJavaProject(JavaCore.create((IProject)pj.getProject()));
                SelectTargetProjectPage.this.containerText.setText(pj.getName());
                if (SelectTargetProjectPage.this.containerText.getText() != null || !"".equals(SelectTargetProjectPage.this.containerText.getText())) {
                    SelectTargetProjectPage.this.setPageComplete(true);
                    SelectTargetProjectPage.this.setErrorMessage(null);
                    SelectTargetProjectPage.this.setMessage(null);
                }
            }
        }
    }
}

