/*
 * Decompiled with CFR 0.152.
 */
package egovframework.dev.imp.confmngt.preferences;

import egovframework.dev.imp.confmngt.EgovConfMngtPlugin;
import egovframework.dev.imp.confmngt.common.ConfMngtMessages;
import egovframework.dev.imp.confmngt.preferences.dialog.NexusDialog;
import egovframework.dev.imp.confmngt.preferences.model.NexusInfo;
import egovframework.dev.imp.confmngt.preferences.model.NexusTableLabelProvider;
import egovframework.dev.imp.core.utils.NullUtil;
import egovframework.dev.imp.core.utils.PrefrencePropertyUtil;
import java.util.ArrayList;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class NexusPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private TableViewer tableViewer;
    private Button editButton;
    private Button removeButton;
    private NexusInfo nexusInfo;
    private int nexusCount;
    private ArrayList<NexusInfo> nexusInfoList;

    public NexusPreferencePage() {
        this.setPreferenceStore(EgovConfMngtPlugin.getDefault().getPreferenceStore());
        this.setDescription(ConfMngtMessages.nexusPreferencePageDESC);
    }

    public void init(IWorkbench workbench) {
        this.nexusInfoList = new ArrayList();
        int nexusCnt = EgovConfMngtPlugin.getDefault().getPreferenceStore().getInt("nexusCount");
        if (nexusCnt > 0) {
            int i = 0;
            while (i < nexusCnt) {
                NexusInfo nexusInfo = new NexusInfo();
                nexusInfo.setId(String.valueOf(i));
                NexusInfo nexusInfo11 = (NexusInfo)PrefrencePropertyUtil.loadPreferences((AbstractUIPlugin)EgovConfMngtPlugin.getDefault(), (Object)nexusInfo);
                this.nexusInfoList.add(nexusInfo11);
                ++i;
            }
        }
    }

    private void handleRemoveButtonPressed() {
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
        if (!NullUtil.isNull((Object)selection) && selection.size() > 0) {
            this.tableViewer.remove(selection.toArray());
        }
    }

    public boolean performOk() {
        this.nexusCount = this.tableViewer.getTable().getItemCount();
        EgovConfMngtPlugin.getDefault().getPreferenceStore().setValue("nexusCount", 0);
        EgovConfMngtPlugin.getDefault().getPreferenceStore().setValue("nexusCount", this.nexusCount);
        if (this.nexusCount > 0) {
            int i = 0;
            while (i < this.nexusCount) {
                NexusInfo nexusInfo = new NexusInfo();
                nexusInfo = (NexusInfo)this.tableViewer.getTable().getItem(i).getData();
                nexusInfo.setId(String.valueOf(i));
                PrefrencePropertyUtil.savePreferences((AbstractUIPlugin)EgovConfMngtPlugin.getDefault(), (Object)nexusInfo);
                ++i;
            }
        } else {
            PrefrencePropertyUtil.savePreferences((AbstractUIPlugin)EgovConfMngtPlugin.getDefault(), (Object)new NexusInfo());
        }
        super.performOk();
        return true;
    }

    protected Control createContents(Composite composite) {
        this.noDefaultAndApplyButton();
        GridData gData = new GridData(1808);
        gData.heightHint = 650;
        gData.widthHint = 460;
        GridLayout layout = new GridLayout();
        Composite innerContainer = new Composite(composite, 0);
        GridLayout innerLayout = new GridLayout();
        innerLayout.numColumns = 2;
        innerContainer.setLayout((Layout)innerLayout);
        this.tableViewer = new TableViewer(innerContainer, 68354);
        Table table = this.tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.tableViewer.getControl().setLayoutData((Object)gData);
        String[] columnNames = new String[]{ConfMngtMessages.nexusPreferencePageID, ConfMngtMessages.nexusPreferencePageURL, ConfMngtMessages.nexusPreferencePageRELEASE, ConfMngtMessages.nexusPreferencePageSNAPSHOTS};
        int[] columnWidth = new int[]{70, 250, 73, 75};
        int[] columnAlignments = new int[]{16384, 16384, 0x1000000, 0x1000000};
        int i = 0;
        while (i < columnNames.length) {
            TableColumn tableColumn = new TableColumn(table, columnAlignments[i]);
            tableColumn.setText(columnNames[i]);
            tableColumn.setWidth(columnWidth[i]);
            ++i;
        }
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new NexusTableLabelProvider());
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableViewer.setInput(this.nexusInfoList);
        Composite buttons = new Composite(innerContainer, 0);
        buttons.setLayoutData((Object)new GridData(2));
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttons.setLayout((Layout)layout);
        Button addButton = new Button(buttons, 8);
        addButton.setText(ConfMngtMessages.nexusPreferencePageNEW);
        addButton.setLayoutData((Object)new GridData(768));
        addButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                NexusDialog nexusInfoDialog;
                int itemCnt = NexusPreferencePage.this.tableViewer.getTable().getItemCount();
                ArrayList<String> nexusIdList = new ArrayList<String>();
                if (itemCnt > 0) {
                    int i = 0;
                    while (i < itemCnt) {
                        NexusInfo nexusInfo = (NexusInfo)NexusPreferencePage.this.tableViewer.getTable().getItem(i).getData();
                        nexusIdList.add(nexusInfo.getNexusId());
                        ++i;
                    }
                }
                if ((nexusInfoDialog = new NexusDialog(NexusPreferencePage.this.getControl().getShell(), null, null, true, true, true, nexusIdList)).open() == 0) {
                    NexusPreferencePage.this.nexusInfo = new NexusInfo(nexusInfoDialog.getNexusId(), nexusInfoDialog.getNexusUrl(), nexusInfoDialog.isReleaseButtonPressed(), nexusInfoDialog.isSnapshotsButtonPressed());
                    NexusPreferencePage.this.tableViewer.add((Object)NexusPreferencePage.this.nexusInfo);
                }
            }
        });
        this.editButton = new Button(buttons, 8);
        this.editButton.setText(ConfMngtMessages.nexusPreferencePageEDIT);
        this.editButton.setEnabled(false);
        this.editButton.setLayoutData((Object)new GridData(768));
        this.editButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Object object;
                IStructuredSelection selection;
                int itemCnt = NexusPreferencePage.this.tableViewer.getTable().getItemCount();
                ArrayList<String> nexusIdList = new ArrayList<String>();
                if (itemCnt > 0) {
                    int i = 0;
                    while (i < itemCnt) {
                        NexusInfo nexusInfo = (NexusInfo)NexusPreferencePage.this.tableViewer.getTable().getItem(i).getData();
                        nexusIdList.add(nexusInfo.getNexusId());
                        ++i;
                    }
                }
                if (!NullUtil.isNull((Object)(selection = (IStructuredSelection)NexusPreferencePage.this.tableViewer.getSelection())) && selection.size() > 0 && (object = selection.getFirstElement()) instanceof NexusInfo) {
                    NexusInfo nexusInfo = (NexusInfo)object;
                    NexusDialog nexusInfoDialog = new NexusDialog(NexusPreferencePage.this.getControl().getShell(), nexusInfo.getNexusId(), nexusInfo.getNexusUrl(), nexusInfo.getIsRealeaseSelected(), nexusInfo.getIsSnapshotsSelected(), false, nexusIdList);
                    if (nexusInfoDialog.open() == 0) {
                        nexusInfo.setNexusId(nexusInfoDialog.getNexusId());
                        nexusInfo.setNexusUrl(nexusInfoDialog.getNexusUrl());
                        nexusInfo.setIsRealeaseSelected(nexusInfoDialog.isReleaseButtonPressed());
                        nexusInfo.setIsSnapshotsSelected(nexusInfoDialog.isSnapshotsButtonPressed());
                        NexusPreferencePage.this.tableViewer.update((Object)nexusInfo, null);
                    }
                }
            }
        });
        this.removeButton = new Button(buttons, 8);
        this.removeButton.setText(ConfMngtMessages.nexusPreferencePageREMOVE);
        this.removeButton.setEnabled(false);
        this.removeButton.setLayoutData((Object)new GridData(768));
        this.removeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                NexusPreferencePage.this.handleRemoveButtonPressed();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                IStructuredSelection selection = (IStructuredSelection)NexusPreferencePage.this.tableViewer.getSelection();
                if (!NullUtil.isNull((Object)selection) && selection.size() > 0) {
                    NexusPreferencePage.this.editButton.setEnabled(true);
                    NexusPreferencePage.this.removeButton.setEnabled(true);
                } else {
                    NexusPreferencePage.this.editButton.setEnabled(false);
                    NexusPreferencePage.this.removeButton.setEnabled(false);
                }
            }
        });
        innerContainer.layout();
        return composite;
    }
}

