/*
 * Decompiled with CFR 0.152.
 */
package egovframework.dev.imp.confmngt.preferences.dialog;

import egovframework.dev.imp.confmngt.common.ConfMngtMessages;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class NexusDialog
extends StatusDialog {
    private String nexusId;
    private String nexusUrl;
    private StringDialogField nexusIdField;
    private StringDialogField nexusUrlField;
    private Button releaseButton;
    private Button snapshotsButton;
    private boolean isReleaseButtonPressed;
    private boolean isSnapshotsButtonPressed;
    private final boolean isAddButton;
    private final List<String> existingNexusIdList;

    public NexusDialog(Shell parentShell, String nexusId, String nexusUrl, boolean isReleaseButtonPressed, boolean isSnapshotsButtonPressed, boolean isAddButton, List<String> nexusIdList) {
        super(parentShell);
        this.nexusId = nexusId;
        this.nexusUrl = nexusUrl;
        this.isReleaseButtonPressed = isReleaseButtonPressed;
        this.isSnapshotsButtonPressed = isSnapshotsButtonPressed;
        this.isAddButton = isAddButton;
        this.existingNexusIdList = nexusIdList;
    }

    protected Point getInitialSize() {
        Point point = this.isAddButton ? new Point(380, 225) : new Point(380, 200);
        return point;
    }

    public boolean isReleaseButtonPressed() {
        return this.isReleaseButtonPressed;
    }

    public void setReleaseButtonPressed(boolean isReleaseButtonPressed) {
        this.isReleaseButtonPressed = isReleaseButtonPressed;
    }

    public boolean isSnapshotsButtonPressed() {
        return this.isSnapshotsButtonPressed;
    }

    public void setSnapshotsButtonPressed(boolean isSnapshotsButtonPressed) {
        this.isSnapshotsButtonPressed = isSnapshotsButtonPressed;
    }

    public String getNexusId() {
        return this.nexusId;
    }

    public String getNexusUrl() {
        return this.nexusUrl;
    }

    protected Control createDialogArea(Composite parent) {
        if (this.isAddButton) {
            this.getShell().setText(ConfMngtMessages.nexusDialogNEWTITLE);
        } else {
            this.getShell().setText(ConfMngtMessages.nexusDialogEDITTITLE);
        }
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite inner = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        inner.setLayout((Layout)layout);
        NexusInputAdapter adapter = new NexusInputAdapter();
        this.nexusIdField = new StringDialogField();
        this.nexusIdField.setLabelText(ConfMngtMessages.nexusDialogID);
        this.nexusIdField.setDialogFieldListener((IDialogFieldListener)adapter);
        this.nexusIdField.setText(this.nexusId != null ? this.nexusId : "");
        this.nexusUrlField = new StringDialogField();
        this.nexusUrlField.setLabelText(ConfMngtMessages.nexusDialogURL);
        this.nexusUrlField.setText(this.nexusUrl != null ? this.nexusUrl : "");
        this.releaseButton = new Button(composite, 32);
        this.releaseButton.setText(ConfMngtMessages.nexusDialogRELEASE);
        this.releaseButton.setSelection(this.isReleaseButtonPressed);
        this.snapshotsButton = new Button(composite, 32);
        this.snapshotsButton.setText(ConfMngtMessages.nexusDialogSNAPSHOTS);
        this.snapshotsButton.setSelection(this.isSnapshotsButtonPressed);
        if (this.isAddButton) {
            this.nexusIdField.doFillIntoGrid(inner, 2);
            this.nexusUrlField.doFillIntoGrid(inner, 2);
            LayoutUtil.setHorizontalGrabbing((Control)this.nexusIdField.getTextControl(null));
            LayoutUtil.setWidthHint((Control)this.nexusIdField.getTextControl(null), (int)this.convertWidthInCharsToPixels(45));
            this.nexusIdField.postSetFocusOnDialogField(parent.getDisplay());
        } else {
            this.nexusUrlField.doFillIntoGrid(inner, 2);
            LayoutUtil.setHorizontalGrabbing((Control)this.nexusUrlField.getTextControl(null));
            LayoutUtil.setWidthHint((Control)this.nexusUrlField.getTextControl(null), (int)this.convertWidthInCharsToPixels(45));
        }
        return composite;
    }

    protected void okPressed() {
        this.nexusId = this.nexusIdField.getText();
        this.nexusUrl = this.nexusUrlField.getText();
        this.isReleaseButtonPressed = this.releaseButton.getSelection();
        this.isSnapshotsButtonPressed = this.snapshotsButton.getSelection();
        super.okPressed();
    }

    private void doValidation() {
        StatusInfo status = new StatusInfo();
        status = new StatusInfo();
        if (this.isAddButton) {
            String nexusId = this.nexusIdField.getText();
            if (nexusId.length() == 0) {
                status.setError(ConfMngtMessages.nexusDialogNODATA);
            } else if (this.existingNexusIdList.contains(nexusId)) {
                status.setError(ConfMngtMessages.nexusDialogEXISTDATA);
            }
        }
        this.updateStatus((IStatus)status);
    }

    private class NexusInputAdapter
    implements IDialogFieldListener {
        private NexusInputAdapter() {
        }

        public void dialogFieldChanged(DialogField field) {
            NexusDialog.this.doValidation();
        }
    }
}

