/*
 * Decompiled with CFR 0.152.
 */
package egovframework.dev.imp.confmngt.properties;

import egovframework.dev.imp.confmngt.EgovConfMngtPlugin;
import egovframework.dev.imp.confmngt.common.ConfMngtLog;
import egovframework.dev.imp.confmngt.common.ConfMngtMessages;
import egovframework.dev.imp.confmngt.preferences.model.NexusInfo;
import egovframework.dev.imp.confmngt.preferences.model.NexusTableLabelProvider;
import egovframework.dev.imp.core.utils.NullUtil;
import egovframework.dev.imp.core.utils.PrefrencePropertyUtil;
import egovframework.dev.imp.core.utils.XmlUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public class NexusPropertyPage
extends PropertyPage
implements IWorkbenchPropertyPage {
    private CheckboxTableViewer tableViewer;
    private Node rootNode;
    private NodeList nodeList;
    private List<NexusInfo> nexusInfoList;

    public NexusPropertyPage() {
        this.setDescription(ConfMngtMessages.nexusPropertyPageDESC);
    }

    private IProject getSelectedProject() {
        IAdaptable element = this.getElement();
        if (element instanceof IProject) {
            return (IProject)element;
        }
        Object resource = element.getAdapter(IResource.class);
        if (resource instanceof IProject) {
            return (IProject)resource;
        }
        return null;
    }

    private void loadNexusPreference() {
        this.nexusInfoList = new ArrayList<NexusInfo>();
        int nexusCnt = EgovConfMngtPlugin.getDefault().getPreferenceStore().getInt("nexusCount");
        if (nexusCnt > 0) {
            int i = 0;
            while (i < nexusCnt) {
                NexusInfo nexusInfo = new NexusInfo();
                nexusInfo.setId(String.valueOf(i));
                NexusInfo nexusInfoForEach = (NexusInfo)PrefrencePropertyUtil.loadPreferences((AbstractUIPlugin)EgovConfMngtPlugin.getDefault(), (Object)nexusInfo);
                this.nexusInfoList.add(nexusInfoForEach);
                ++i;
            }
        }
    }

    private void createLink(Composite parent, String message, final String pageId) {
        Link preferencesLink = new Link(parent, 131072);
        preferencesLink.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        preferencesLink.setText(message);
        preferencesLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencesUtil.createPreferenceDialogOn((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)pageId, (String[])new String[]{"egovframework.dev.imp.confmngt.preferences.nexuspreferencepage"}, null).open();
                ArrayList<String> checkedList = new ArrayList<String>();
                int jnx = 0;
                while (jnx < NexusPropertyPage.this.nexusInfoList.size()) {
                    if (NexusPropertyPage.this.tableViewer.getChecked(NexusPropertyPage.this.nexusInfoList.get(jnx))) {
                        checkedList.add(((NexusInfo)NexusPropertyPage.this.nexusInfoList.get(jnx)).getNexusId());
                    }
                    ++jnx;
                }
                NexusPropertyPage.this.loadNexusPreference();
                NexusPropertyPage.this.tableViewer.setInput((Object)NexusPropertyPage.this.nexusInfoList);
                jnx = 0;
                while (jnx < NexusPropertyPage.this.nexusInfoList.size()) {
                    if (checkedList.contains(((NexusInfo)NexusPropertyPage.this.nexusInfoList.get(jnx)).getNexusId())) {
                        NexusPropertyPage.this.tableViewer.setChecked((Object)((NexusInfo)NexusPropertyPage.this.nexusInfoList.get(jnx)), true);
                    }
                    ++jnx;
                }
            }
        });
    }

    public Control createContents(Composite parent) {
        this.noDefaultAndApplyButton();
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        GridData gridData = new GridData(1808);
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)gridData);
        this.createLink(container, ConfMngtMessages.nexusPropertyPageLINK, "egovframework.dev.imp.confmngt.preferences.nexuspreferencepage");
        this.tableViewer = CheckboxTableViewer.newCheckList((Composite)container, (int)2176);
        Table table = this.tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setLayoutData((Object)new GridData(1808));
        String[] columnNames = new String[]{ConfMngtMessages.nexusPropertyPageID, ConfMngtMessages.nexusPropertyPageURL, ConfMngtMessages.nexusPropertyPageRELEASE, ConfMngtMessages.nexusPropertyPageSNAPSHOTS};
        int[] columnWidth = new int[]{80, 360, 75, 75};
        int[] columnAlignments = new int[]{16384, 16384, 0x1000000, 0x1000000};
        int i = 0;
        while (i < columnNames.length) {
            TableColumn tableColumn = new TableColumn(table, columnAlignments[i]);
            tableColumn.setText(columnNames[i]);
            tableColumn.setWidth(columnWidth[i]);
            ++i;
        }
        this.loadNexusPreference();
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new NexusTableLabelProvider());
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableViewer.setInput(this.nexusInfoList);
        try {
            if (!this.getSelectedProject().getFile("pom.xml").exists()) {
                this.setMessage(ConfMngtMessages.nexusPropertyPageNOTEXIST, 2);
            } else {
                this.rootNode = XmlUtil.getRootNode((File)new File(this.getSelectedProject().getFile("pom.xml").getLocation().toOSString()));
                this.nodeList = XmlUtil.getNodeList((Node)this.rootNode, (String)"/project/repositories/repository");
            }
        }
        catch (Exception e) {
            ConfMngtLog.logError(e);
        }
        if (NullUtil.isNull((Object)this.nodeList)) {
            this.tableViewer.setInput(this.nexusInfoList);
        } else {
            int inx = 0;
            while (inx < this.nodeList.getLength()) {
                try {
                    Node targetRepository = this.nodeList.item(inx);
                    Node nexusIdInXml = XmlUtil.getNode((Node)targetRepository, (String)"./id");
                    int jnx = 0;
                    while (jnx < this.nexusInfoList.size()) {
                        if (this.nexusInfoList.get(jnx).getNexusId().equals(nexusIdInXml.getTextContent())) {
                            this.tableViewer.setChecked((Object)this.nexusInfoList.get(jnx), true);
                        }
                        ++jnx;
                    }
                }
                catch (Exception e) {
                    ConfMngtLog.logError(e);
                }
                ++inx;
            }
        }
        return container;
    }

    private void createXmlFile(Node node) {
        try {
            IFile originf = this.getSelectedProject().getFile((IPath)new Path("pom.xml"));
            ByteArrayInputStream inStream = new ByteArrayInputStream(XmlUtil.getXmlString((Node)node, (String)"/").getBytes("UTF-8"));
            originf.setContents((InputStream)inStream, true, false, null);
        }
        catch (CoreException e) {
            ConfMngtLog.logCoreError(e);
        }
        catch (UnsupportedEncodingException e) {
            ConfMngtLog.logError(e);
        }
        catch (Exception e) {
            ConfMngtLog.logError(e);
        }
    }

    private void addNexusToXml(Node rootNode, NodeList nodeList) {
        Object[] checkedItems = this.tableViewer.getCheckedElements();
        try {
            if (!NullUtil.isNull((Object)checkedItems)) {
                Object[] objectArray = checkedItems;
                int n = checkedItems.length;
                int n2 = 0;
                while (n2 < n) {
                    Object item = objectArray[n2];
                    String nexusIdInTable = ((NexusInfo)item).getNexusId();
                    String nexusUrlInTable = ((NexusInfo)item).getNexusUrl();
                    boolean releaseInTable = ((NexusInfo)item).getIsRealeaseSelected();
                    boolean snapshotsInTable = ((NexusInfo)item).getIsSnapshotsSelected();
                    boolean isEqual = false;
                    int inx = 0;
                    while (inx < (NullUtil.isNull((Object)nodeList) ? 0 : nodeList.getLength())) {
                        Node nexusIdInXml = XmlUtil.getNode((Node)nodeList.item(inx), (String)"./id");
                        if (nexusIdInTable.equals(nexusIdInXml.getTextContent())) {
                            isEqual = true;
                            XmlUtil.modifyNodeValue((Node)rootNode, (String)("/project/repositories/repository[id = '" + nexusIdInXml.getTextContent() + "']/url"), (String)nexusUrlInTable);
                            XmlUtil.modifyNodeValue((Node)rootNode, (String)("/project/repositories/repository[id = '" + nexusIdInXml.getTextContent() + "']/releases/enabled"), (String)String.valueOf(releaseInTable));
                            XmlUtil.modifyNodeValue((Node)rootNode, (String)("/project/repositories/repository[id = '" + nexusIdInXml.getTextContent() + "']/snapshots/enabled"), (String)String.valueOf(snapshotsInTable));
                            break;
                        }
                        ++inx;
                    }
                    if (!isEqual) {
                        String xmlStr = "<repository>\n\t\t\t<id>" + nexusIdInTable + "</id>" + "\n\t\t\t<url>" + nexusUrlInTable + "</url>" + "\n\t\t\t<releases>\n\t\t\t\t<enabled>" + releaseInTable + "</enabled>\n\t\t\t</releases>" + "\n\t\t\t<snapshots>\n\t\t\t\t<enabled>" + snapshotsInTable + "</enabled>\n\t\t\t</snapshots>" + "\n\t\t</repository>" + "\n ";
                        XmlUtil.addFirstNode((Node)rootNode, (String)"/project/repositories", (String)xmlStr, (String)"\n\t\t", (String)"\t");
                    }
                    ++n2;
                }
                this.createXmlFile(rootNode);
            }
        }
        catch (TransformerConfigurationException e) {
            ConfMngtLog.logError(e);
        }
        catch (TransformerFactoryConfigurationError e) {
            ConfMngtLog.logError(e);
        }
        catch (TransformerException e) {
            ConfMngtLog.logError(e);
        }
        catch (Exception e) {
            ConfMngtLog.logError(e);
        }
    }

    private void removeNexusFromXml(Node rootNode, NodeList nodeList) {
        try {
            int itemCnt = this.tableViewer.getTable().getItemCount();
            int inx = 0;
            while (inx < itemCnt) {
                boolean isEqual = false;
                Node nexusIdInXml = null;
                if (!this.tableViewer.getChecked(this.tableViewer.getElementAt(inx))) {
                    String nexusIdInTable = ((NexusInfo)this.tableViewer.getElementAt(inx)).getNexusId();
                    int jnx = 0;
                    while (jnx < (NullUtil.isNull((Object)nodeList) ? 0 : nodeList.getLength())) {
                        nexusIdInXml = XmlUtil.getNode((Node)nodeList.item(jnx), (String)"./id");
                        if (nexusIdInTable.equals(nexusIdInXml.getTextContent())) {
                            isEqual = true;
                            break;
                        }
                        ++jnx;
                    }
                }
                if (isEqual) {
                    XmlUtil.removeNode((Node)rootNode, (String)("/project/repositories/repository[id = '" + nexusIdInXml.getTextContent() + "']"));
                }
                ++inx;
            }
            this.createXmlFile(rootNode);
        }
        catch (Exception e) {
            ConfMngtLog.logError(e);
        }
    }

    public boolean performOk() {
        try {
            this.rootNode = XmlUtil.getRootNode((File)new File(this.getSelectedProject().getFile("pom.xml").getLocation().toOSString()));
            if (!XmlUtil.existNode((Node)this.rootNode, (String)"/project/repositories")) {
                String xmlStr = "<repositories>\n\t</repositories>";
                Node findNode = XmlUtil.getNode((Node)this.rootNode, (String)"/project/dependencies");
                if (findNode == null) {
                    XmlUtil.addNode((Node)this.rootNode, (String)"/project", (String)xmlStr, (String)"\t", (String)"\n");
                } else {
                    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder builder = factory.newDocumentBuilder();
                    Document doc = builder.parse(new InputSource(new StringReader(xmlStr)));
                    Element node = doc.getDocumentElement();
                    Document ownerDoc = this.rootNode.getOwnerDocument();
                    Node importedNode = ownerDoc.importNode(node, true);
                    Text postValueText = ownerDoc.createTextNode("\n\t");
                    this.rootNode.insertBefore(importedNode, findNode);
                    this.rootNode.insertBefore(postValueText, findNode);
                }
                this.createXmlFile(this.rootNode);
            }
            this.nodeList = XmlUtil.getNodeList((Node)this.rootNode, (String)"/project/repositories/repository");
            this.addNexusToXml(this.rootNode, this.nodeList);
            this.removeNexusFromXml(this.rootNode, this.nodeList);
        }
        catch (Exception e) {
            ConfMngtLog.logError(e);
        }
        return true;
    }
}

