/*
 * Decompiled with CFR 0.152.
 */
package egovframework.dev.imp.core.common;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.SQLDevToolsConfiguration;
import org.eclipse.datatools.sqltools.core.SQLToolsFacade;
import org.eclipse.datatools.sqltools.core.profile.NoSuchProfileException;
import org.eclipse.datatools.sqltools.core.profile.ProfileUtil;
import org.eclipse.datatools.sqltools.core.services.ConnectionService;
import org.eclipse.datatools.sqltools.editor.core.connection.ISQLEditorConnectionInfo;
import org.eclipse.datatools.sqltools.internal.sqlscrapbook.util.SQLUtility;

public final class DataToolsPlatformUtil {
    private DataToolsPlatformUtil() {
    }

    public static DatabaseIdentifier getDatabaseIdentifier(ISQLEditorConnectionInfo connectionInfo) {
        String profileName = connectionInfo.getConnectionProfileName();
        String dbName = connectionInfo.getDatabaseName();
        return new DatabaseIdentifier(profileName, dbName);
    }

    public static Connection getConnection(DatabaseIdentifier databaseIdentifier) throws SQLException, NoSuchProfileException {
        SQLDevToolsConfiguration f = SQLToolsFacade.getConfigurationByProfileName((String)databaseIdentifier.getProfileName());
        ConnectionService conService = f.getConnectionService();
        return conService.createConnection(databaseIdentifier, true);
    }

    public static IConnectionProfile[] getProfiles() {
        return ProfileUtil.getProfiles();
    }

    public static String[] getProfileNames() {
        IConnectionProfile[] profiles = ProfileUtil.getProfiles();
        String[] profileNames = new String[profiles.length];
        int i = 0;
        while (i < profiles.length) {
            profileNames[i] = profiles[i].getName();
            ++i;
        }
        return profileNames;
    }

    public static ISQLEditorConnectionInfo getConnectionInfo(String profileName) {
        return SQLUtility.getConnectionInfo((String)profileName);
    }

    public static Map<String, String> getProperty(String dbType) {
        HashMap<String, String> property = new HashMap<String, String>();
        IConnectionProfile p = DataToolsPlatformUtil.getConnectionInfo(dbType).getConnectionProfile();
        property.put("username", p.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.db.username"));
        property.put("password", p.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.db.password"));
        property.put("driverClass", p.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.db.driverClass"));
        property.put("url", p.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.db.URL"));
        return property;
    }
}

